/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class DamagingProjectileEntity
extends Entity {
    public LivingEntity field_70235_a;
    private int field_70236_j;
    private int field_70234_an;
    public double field_70232_b;
    public double field_70233_c;
    public double field_70230_d;

    protected DamagingProjectileEntity(EntityType<? extends DamagingProjectileEntity> p_i50173_1_, World p_i50173_2_) {
        super(p_i50173_1_, p_i50173_2_);
    }

    public DamagingProjectileEntity(EntityType<? extends DamagingProjectileEntity> p_i50174_1_, double p_i50174_2_, double p_i50174_4_, double p_i50174_6_, double p_i50174_8_, double p_i50174_10_, double p_i50174_12_, World p_i50174_14_) {
        this(p_i50174_1_, p_i50174_14_);
        this.func_70012_b(p_i50174_2_, p_i50174_4_, p_i50174_6_, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(p_i50174_2_, p_i50174_4_, p_i50174_6_);
        double d0 = MathHelper.func_76133_a((double)(p_i50174_8_ * p_i50174_8_ + p_i50174_10_ * p_i50174_10_ + p_i50174_12_ * p_i50174_12_));
        this.field_70232_b = p_i50174_8_ / d0 * 0.1;
        this.field_70233_c = p_i50174_10_ / d0 * 0.1;
        this.field_70230_d = p_i50174_12_ / d0 * 0.1;
    }

    public DamagingProjectileEntity(EntityType<? extends DamagingProjectileEntity> p_i50175_1_, LivingEntity p_i50175_2_, double p_i50175_3_, double p_i50175_5_, double p_i50175_7_, World p_i50175_9_) {
        this(p_i50175_1_, p_i50175_9_);
        this.field_70235_a = p_i50175_2_;
        this.func_70012_b(p_i50175_2_.func_226277_ct_(), p_i50175_2_.func_226278_cu_(), p_i50175_2_.func_226281_cx_(), p_i50175_2_.field_70177_z, p_i50175_2_.field_70125_A);
        this.func_226264_Z_();
        this.func_213317_d(Vec3d.field_186680_a);
        double d0 = MathHelper.func_76133_a((double)((p_i50175_3_ += this.field_70146_Z.nextGaussian() * 0.4) * p_i50175_3_ + (p_i50175_5_ += this.field_70146_Z.nextGaussian() * 0.4) * p_i50175_5_ + (p_i50175_7_ += this.field_70146_Z.nextGaussian() * 0.4) * p_i50175_7_));
        this.field_70232_b = p_i50175_3_ / d0 * 0.1;
        this.field_70233_c = p_i50175_5_ / d0 * 0.1;
        this.field_70230_d = p_i50175_7_ / d0 * 0.1;
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K || (this.field_70235_a == null || !this.field_70235_a.field_70128_L) && this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
            super.func_70071_h_();
            if (this.func_184564_k()) {
                this.func_70015_d(1);
            }
            ++this.field_70234_an;
            RayTraceResult raytraceresult = ProjectileHelper.func_221266_a(this, true, this.field_70234_an >= 25, this.field_70235_a, RayTraceContext.BlockMode.COLLIDER);
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((DamagingProjectileEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a(raytraceresult);
            }
            Vec3d vec3d = this.func_213322_ci();
            double d0 = this.func_226277_ct_() + vec3d.field_72450_a;
            double d1 = this.func_226278_cu_() + vec3d.field_72448_b;
            double d2 = this.func_226281_cx_() + vec3d.field_72449_c;
            ProjectileHelper.func_188803_a(this, 0.2f);
            float f = this.func_82341_c();
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    float f1 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d0 - vec3d.field_72450_a * 0.25, d1 - vec3d.field_72448_b * 0.25, d2 - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                }
                f = 0.8f;
            }
            this.func_213317_d(vec3d.func_72441_c(this.field_70232_b, this.field_70233_c, this.field_70230_d).func_186678_a(f));
            this.field_70170_p.func_195594_a(this.func_195057_f(), d0, d1 + 0.5, d2, 0.0, 0.0, 0.0);
            this.func_70107_b(d0, d1, d2);
        } else {
            this.func_70106_y();
        }
    }

    protected boolean func_184564_k() {
        return true;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197601_L;
    }

    protected float func_82341_c() {
        return 0.95f;
    }

    protected void func_70227_a(RayTraceResult result) {
        RayTraceResult.Type raytraceresult$type = result.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)result;
            BlockState blockstate = this.field_70170_p.func_180495_p(blockraytraceresult.func_216350_a());
            blockstate.func_215690_a(this.field_70170_p, blockstate, blockraytraceresult, this);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        Vec3d vec3d = this.func_213322_ci();
        compound.func_218657_a("direction", (INBT)this.func_70087_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c));
        compound.func_218657_a("power", (INBT)this.func_70087_a(this.field_70232_b, this.field_70233_c, this.field_70230_d));
        compound.func_74768_a("life", this.field_70236_j);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        ListNBT listnbt;
        if (compound.func_150297_b("power", 9) && (listnbt = compound.func_150295_c("power", 6)).size() == 3) {
            this.field_70232_b = listnbt.func_150309_d(0);
            this.field_70233_c = listnbt.func_150309_d(1);
            this.field_70230_d = listnbt.func_150309_d(2);
        }
        this.field_70236_j = compound.func_74762_e("life");
        if (compound.func_150297_b("direction", 9) && compound.func_150295_c("direction", 6).size() == 3) {
            ListNBT listnbt1 = compound.func_150295_c("direction", 6);
            this.func_213293_j(listnbt1.func_150309_d(0), listnbt1.func_150309_d(1), listnbt1.func_150309_d(2));
        } else {
            this.func_70106_y();
        }
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public float func_70111_Y() {
        return 1.0f;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        if (source.func_76346_g() != null) {
            Vec3d vec3d = source.func_76346_g().func_70040_Z();
            this.func_213317_d(vec3d);
            this.field_70232_b = vec3d.field_72450_a * 0.1;
            this.field_70233_c = vec3d.field_72448_b * 0.1;
            this.field_70230_d = vec3d.field_72449_c * 0.1;
            if (source.func_76346_g() instanceof LivingEntity) {
                this.field_70235_a = (LivingEntity)source.func_76346_g();
            }
            return true;
        }
        return false;
    }

    @Override
    public float func_70013_c() {
        return 1.0f;
    }

    @Override
    public IPacket<?> func_213297_N() {
        int i = this.field_70235_a == null ? 0 : this.field_70235_a.func_145782_y();
        return new SSpawnObjectPacket(this.func_145782_y(), this.func_110124_au(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70125_A, this.field_70177_z, this.func_200600_R(), i, new Vec3d(this.field_70232_b, this.field_70233_c, this.field_70230_d));
    }
}

