/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class WitherSkullEntity
extends DamagingProjectileEntity {
    private static final DataParameter<Boolean> field_184565_e = EntityDataManager.func_187226_a(WitherSkullEntity.class, DataSerializers.field_187198_h);

    public WitherSkullEntity(EntityType<? extends WitherSkullEntity> p_i50147_1_, World p_i50147_2_) {
        super((EntityType<? extends DamagingProjectileEntity>)p_i50147_1_, p_i50147_2_);
    }

    public WitherSkullEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(EntityType.field_200723_aB, shooter, accelX, accelY, accelZ, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public WitherSkullEntity(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(EntityType.field_200723_aB, x, y, z, accelX, accelY, accelZ, worldIn);
    }

    @Override
    protected float func_82341_c() {
        return this.func_82342_d() ? 0.73f : super.func_82341_c();
    }

    @Override
    public boolean func_70027_ad() {
        return false;
    }

    @Override
    public float func_180428_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, BlockState blockStateIn, IFluidState p_180428_5_, float p_180428_6_) {
        return this.func_82342_d() && blockStateIn.canEntityDestroy(worldIn, pos, this) ? Math.min(0.8f, p_180428_6_) : p_180428_6_;
    }

    @Override
    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        if (!this.field_70170_p.field_72995_K) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)result).func_216348_a();
                if (this.field_70235_a != null) {
                    if (entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.field_70235_a), 8.0f)) {
                        if (entity.func_70089_S()) {
                            this.func_174815_a(this.field_70235_a, entity);
                        } else {
                            this.field_70235_a.func_70691_i(5.0f);
                        }
                    }
                } else {
                    entity.func_70097_a(DamageSource.field_76376_m, 5.0f);
                }
                if (entity instanceof LivingEntity) {
                    int i = 0;
                    if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                        i = 10;
                    } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                        i = 40;
                    }
                    if (i > 0) {
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_82731_v, 20 * i, 1));
                    }
                }
            }
            Explosion.Mode explosion$mode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.field_70235_a) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
            this.field_70170_p.func_217398_a(this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0f, false, explosion$mode);
            this.func_70106_y();
        }
    }

    @Override
    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184565_e, false);
    }

    public boolean func_82342_d() {
        return this.field_70180_af.func_187225_a(field_184565_e);
    }

    public void func_82343_e(boolean invulnerable) {
        this.field_70180_af.func_187227_b(field_184565_e, invulnerable);
    }

    @Override
    protected boolean func_184564_k() {
        return false;
    }
}

