/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootPredicateManager;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.ForgeHooks;

public class LootContext {
    private final Random field_216035_a;
    private final float field_186498_a;
    private final ServerWorld field_186499_b;
    private final Function<ResourceLocation, LootTable> field_186500_c;
    private final Set<LootTable> field_186504_g = Sets.newLinkedHashSet();
    private final Function<ResourceLocation, ILootCondition> field_227499_f_;
    private final Set<ILootCondition> field_227500_g_ = Sets.newLinkedHashSet();
    private final Map<LootParameter<?>, Object> field_216036_f;
    private final Map<ResourceLocation, IDynamicDropProvider> field_216037_g;

    private LootContext(Random rand, float luckIn, ServerWorld worldIn, Function<ResourceLocation, LootTable> lootTableManagerIn, Function<ResourceLocation, ILootCondition> p_i225885_5_, Map<LootParameter<?>, Object> parametersIn, Map<ResourceLocation, IDynamicDropProvider> conditionsIn) {
        this.field_216035_a = rand;
        this.field_186498_a = luckIn;
        this.field_186499_b = worldIn;
        this.field_186500_c = lootTableManagerIn;
        this.field_227499_f_ = p_i225885_5_;
        this.field_216036_f = ImmutableMap.copyOf(parametersIn);
        this.field_216037_g = ImmutableMap.copyOf(conditionsIn);
    }

    public boolean func_216033_a(LootParameter<?> parameter) {
        return this.field_216036_f.containsKey(parameter);
    }

    public void func_216034_a(ResourceLocation name, Consumer<ItemStack> consumer) {
        IDynamicDropProvider lootcontext$idynamicdropprovider = this.field_216037_g.get(name);
        if (lootcontext$idynamicdropprovider != null) {
            lootcontext$idynamicdropprovider.add(this, consumer);
        }
    }

    @Nullable
    public <T> T func_216031_c(LootParameter<T> parameter) {
        return (T)this.field_216036_f.get(parameter);
    }

    public boolean func_186496_a(LootTable lootTableIn) {
        return this.field_186504_g.add(lootTableIn);
    }

    public void func_186490_b(LootTable lootTableIn) {
        this.field_186504_g.remove(lootTableIn);
    }

    public boolean func_227501_a_(ILootCondition conditionIn) {
        return this.field_227500_g_.add(conditionIn);
    }

    public void func_227503_b_(ILootCondition conditionIn) {
        this.field_227500_g_.remove(conditionIn);
    }

    public LootTable func_227502_a_(ResourceLocation tableId) {
        return this.field_186500_c.apply(tableId);
    }

    public ILootCondition func_227504_b_(ResourceLocation conditionId) {
        return this.field_227499_f_.apply(conditionId);
    }

    public Random func_216032_b() {
        return this.field_216035_a;
    }

    public float func_186491_f() {
        return this.field_186498_a;
    }

    public ServerWorld func_202879_g() {
        return this.field_186499_b;
    }

    public int getLootingModifier() {
        return ForgeHooks.getLootingLevel((Entity)((Entity)((Object)this.func_216031_c(LootParameters.field_216281_a))), (Entity)((Entity)((Object)this.func_216031_c(LootParameters.field_216284_d))), (DamageSource)((DamageSource)this.func_216031_c(LootParameters.field_216283_c)));
    }

    @FunctionalInterface
    public static interface IDynamicDropProvider {
        public void add(LootContext var1, Consumer<ItemStack> var2);
    }

    public static enum EntityTarget {
        THIS("this", (LootParameter<? extends Entity>)LootParameters.field_216281_a),
        KILLER("killer", (LootParameter<? extends Entity>)LootParameters.field_216284_d),
        DIRECT_KILLER("direct_killer", (LootParameter<? extends Entity>)LootParameters.field_216285_e),
        KILLER_PLAYER("killer_player", (LootParameter<? extends Entity>)LootParameters.field_216282_b);

        private final String field_186488_d;
        private final LootParameter<? extends Entity> field_216030_f;

        private EntityTarget(String targetTypeIn, LootParameter<? extends Entity> parameterIn) {
            this.field_186488_d = targetTypeIn;
            this.field_216030_f = parameterIn;
        }

        public LootParameter<? extends Entity> func_216029_a() {
            return this.field_216030_f;
        }

        public static EntityTarget func_186482_a(String type) {
            for (EntityTarget lootcontext$entitytarget : EntityTarget.values()) {
                if (!lootcontext$entitytarget.field_186488_d.equals(type)) continue;
                return lootcontext$entitytarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + type);
        }

        public static class Serializer
        extends TypeAdapter<EntityTarget> {
            public void write(JsonWriter p_write_1_, EntityTarget p_write_2_) throws IOException {
                p_write_1_.value(p_write_2_.field_186488_d);
            }

            public EntityTarget read(JsonReader p_read_1_) throws IOException {
                return EntityTarget.func_186482_a(p_read_1_.nextString());
            }
        }
    }

    public static class Builder {
        private final ServerWorld field_186474_a;
        private final Map<LootParameter<?>, Object> field_216025_b = Maps.newIdentityHashMap();
        private final Map<ResourceLocation, IDynamicDropProvider> field_216026_c = Maps.newHashMap();
        private Random field_216027_d;
        private float field_186475_b;

        public Builder(ServerWorld worldIn) {
            this.field_186474_a = worldIn;
        }

        public Builder(LootContext context) {
            this.field_186474_a = context.field_186499_b;
            this.field_216025_b.putAll(context.field_216036_f);
            this.field_216026_c.putAll(context.field_216037_g);
            this.field_216027_d = context.field_216035_a;
            this.field_186475_b = context.field_186498_a;
        }

        public Builder func_216023_a(Random randomIn) {
            this.field_216027_d = randomIn;
            return this;
        }

        public Builder func_216016_a(long seed) {
            if (seed != 0L) {
                this.field_216027_d = new Random(seed);
            }
            return this;
        }

        public Builder func_216020_a(long seed, Random p_216020_3_) {
            this.field_216027_d = seed == 0L ? p_216020_3_ : new Random(seed);
            return this;
        }

        public Builder func_186469_a(float luckIn) {
            this.field_186475_b = luckIn;
            return this;
        }

        public <T> Builder func_216015_a(LootParameter<T> parameter, T value) {
            this.field_216025_b.put(parameter, value);
            return this;
        }

        public <T> Builder func_216021_b(LootParameter<T> parameter, @Nullable T value) {
            if (value == null) {
                this.field_216025_b.remove(parameter);
            } else {
                this.field_216025_b.put(parameter, value);
            }
            return this;
        }

        public Builder func_216017_a(ResourceLocation p_216017_1_, IDynamicDropProvider p_216017_2_) {
            IDynamicDropProvider lootcontext$idynamicdropprovider = this.field_216026_c.put(p_216017_1_, p_216017_2_);
            if (lootcontext$idynamicdropprovider != null) {
                throw new IllegalStateException("Duplicated dynamic drop '" + this.field_216026_c + "'");
            }
            return this;
        }

        public ServerWorld func_216018_a() {
            return this.field_186474_a;
        }

        public <T> T func_216024_a(LootParameter<T> parameter) {
            Object t = this.field_216025_b.get(parameter);
            if (t == null) {
                throw new IllegalArgumentException("No parameter " + parameter);
            }
            return (T)t;
        }

        @Nullable
        public <T> T func_216019_b(LootParameter<T> parameter) {
            return (T)this.field_216025_b.get(parameter);
        }

        public LootContext func_216022_a(LootParameterSet parameterSet) {
            Sets.SetView set = Sets.difference(this.field_216025_b.keySet(), (Set)parameterSet.func_216276_b());
            if (!set.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + set);
            }
            Sets.SetView set1 = Sets.difference((Set)parameterSet.func_216277_a(), this.field_216025_b.keySet());
            if (!set1.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + set1);
            }
            Random random = this.field_216027_d;
            if (random == null) {
                random = new Random();
            }
            MinecraftServer minecraftserver = this.field_186474_a.func_73046_m();
            return new LootContext(random, this.field_186475_b, this.field_186474_a, minecraftserver.func_200249_aQ()::func_186521_a, arg_0 -> ((LootPredicateManager)minecraftserver.func_229736_aP_()).func_227517_a_(arg_0), this.field_216025_b, this.field_216026_c);
        }
    }
}

