/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.BedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BedBlock
extends HorizontalBlock
implements ITileEntityProvider {
    public static final EnumProperty<BedPart> field_176472_a = BlockStateProperties.field_208139_an;
    public static final BooleanProperty field_176471_b = BlockStateProperties.field_208192_s;
    protected static final VoxelShape field_220176_c = Block.func_208617_a(0.0, 3.0, 0.0, 16.0, 9.0, 16.0);
    protected static final VoxelShape field_220177_d = Block.func_208617_a(0.0, 0.0, 0.0, 3.0, 3.0, 3.0);
    protected static final VoxelShape field_220178_e = Block.func_208617_a(0.0, 0.0, 13.0, 3.0, 3.0, 16.0);
    protected static final VoxelShape field_220179_f = Block.func_208617_a(13.0, 0.0, 0.0, 16.0, 3.0, 3.0);
    protected static final VoxelShape field_220180_g = Block.func_208617_a(13.0, 0.0, 13.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape field_220181_h = VoxelShapes.func_216384_a(field_220176_c, field_220177_d, field_220179_f);
    protected static final VoxelShape field_220182_i = VoxelShapes.func_216384_a(field_220176_c, field_220178_e, field_220180_g);
    protected static final VoxelShape field_220183_j = VoxelShapes.func_216384_a(field_220176_c, field_220177_d, field_220178_e);
    protected static final VoxelShape field_220184_k = VoxelShapes.func_216384_a(field_220176_c, field_220179_f, field_220180_g);
    private final DyeColor field_196352_y;

    public BedBlock(DyeColor dyeColor, AbstractBlock.Properties properties) {
        super(properties);
        this.field_196352_y = dyeColor;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176472_a, BedPart.FOOT)).func_206870_a(field_176471_b, false));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState2, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        BlockState blockState2;
        if (world.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (blockState2.func_177229_b(field_176472_a) != BedPart.HEAD && !(blockState2 = world.func_180495_p(blockPos = blockPos.func_177972_a(blockState2.func_177229_b(field_185512_D)))).func_203425_a(this)) {
            return ActionResultType.CONSUME;
        }
        if (!BedBlock.func_235330_a_(world)) {
            world.func_217377_a(blockPos, false);
            BlockPos blockPos2 = blockPos.func_177972_a(blockState2.func_177229_b(field_185512_D).func_176734_d());
            if (world.func_180495_p(blockPos2).func_203425_a(this)) {
                world.func_217377_a(blockPos2, false);
            }
            world.func_230546_a_(null, DamageSource.func_233546_a_(), null, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
            return ActionResultType.SUCCESS;
        }
        if (blockState2.func_177229_b(field_176471_b).booleanValue()) {
            if (!this.func_226861_a_(world, blockPos)) {
                playerEntity.func_146105_b(new TranslationTextComponent("block.minecraft.bed.occupied"), true);
            }
            return ActionResultType.SUCCESS;
        }
        playerEntity.func_213819_a(blockPos).ifLeft(sleepResult -> {
            if (sleepResult != null) {
                playerEntity.func_146105_b(sleepResult.func_221259_a(), true);
            }
        });
        return ActionResultType.SUCCESS;
    }

    public static boolean func_235330_a_(World world) {
        return world.func_230315_m_().func_241510_j_();
    }

    private boolean func_226861_a_(World world, BlockPos blockPos) {
        List<VillagerEntity> list = world.func_175647_a(VillagerEntity.class, new AxisAlignedBB(blockPos), LivingEntity::func_70608_bn);
        if (list.isEmpty()) {
            return false;
        }
        list.get(0).func_213366_dy();
        return true;
    }

    @Override
    public void func_180658_a(World world, BlockPos blockPos, Entity entity, float f) {
        super.func_180658_a(world, blockPos, entity, f * 0.5f);
    }

    @Override
    public void func_176216_a(IBlockReader iBlockReader, Entity entity) {
        if (entity.func_226272_bl_()) {
            super.func_176216_a(iBlockReader, entity);
        } else {
            this.func_226860_a_(entity);
        }
    }

    private void func_226860_a_(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        if (vector3d.field_72448_b < 0.0) {
            double d = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(vector3d.field_72450_a, -vector3d.field_72448_b * (double)0.66f * d, vector3d.field_72449_c);
        }
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == BedBlock.func_208070_a(blockState.func_177229_b(field_176472_a), blockState.func_177229_b(field_185512_D))) {
            if (blockState2.func_203425_a(this) && blockState2.func_177229_b(field_176472_a) != blockState.func_177229_b(field_176472_a)) {
                return (BlockState)blockState.func_206870_a(field_176471_b, blockState2.func_177229_b(field_176471_b));
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    private static Direction func_208070_a(BedPart bedPart, Direction direction) {
        return bedPart == BedPart.FOOT ? direction : direction.func_176734_d();
    }

    @Override
    public void func_176208_a(World world, BlockPos blockPos, BlockState blockState, PlayerEntity playerEntity) {
        if (!world.field_72995_K && playerEntity.func_184812_l_() && (\u2603 = blockState.func_177229_b(field_176472_a)) == BedPart.FOOT && (\u2603 = world.func_180495_p(\u2603 = blockPos.func_177972_a(BedBlock.func_208070_a(\u2603, blockState.func_177229_b(field_185512_D))))).func_177230_c() == this && \u2603.func_177229_b(field_176472_a) == BedPart.HEAD) {
            world.func_180501_a(\u2603, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(playerEntity, 2001, \u2603, Block.func_196246_j(\u2603));
        }
        super.func_176208_a(world, blockPos, blockState, playerEntity);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        Direction direction = blockItemUseContext.func_195992_f();
        BlockPos \u26032 = blockItemUseContext.func_195995_a();
        BlockPos \u26033 = \u26032.func_177972_a(direction);
        if (blockItemUseContext.func_195991_k().func_180495_p(\u26033).func_196953_a(blockItemUseContext)) {
            return (BlockState)this.func_176223_P().func_206870_a(field_185512_D, direction);
        }
        return null;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        Direction direction = BedBlock.func_226862_h_(blockState).func_176734_d();
        switch (direction) {
            case NORTH: {
                return field_220181_h;
            }
            case SOUTH: {
                return field_220182_i;
            }
            case WEST: {
                return field_220183_j;
            }
        }
        return field_220184_k;
    }

    public static Direction func_226862_h_(BlockState blockState) {
        Direction direction = blockState.func_177229_b(field_185512_D);
        return blockState.func_177229_b(field_176472_a) == BedPart.HEAD ? direction.func_176734_d() : direction;
    }

    public static Optional<Vector3d> func_220172_a(EntityType<?> entityType, IWorldReader iWorldReader, BlockPos blockPos, int n) {
        Direction direction = iWorldReader.func_180495_p(blockPos).func_177229_b(field_185512_D);
        int \u26032 = blockPos.func_177958_n();
        int \u26033 = blockPos.func_177956_o();
        int \u26034 = blockPos.func_177952_p();
        for (int i = 0; i <= 1; ++i) {
            \u2603 = \u26032 - direction.func_82601_c() * i - 1;
            \u2603 = \u26034 - direction.func_82599_e() * i - 1;
            \u2603 = \u2603 + 2;
            \u2603 = \u2603 + 2;
            for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                    BlockPos blockPos2 = new BlockPos(\u2603, \u26033, \u2603);
                    Optional<Vector3d> \u26035 = BedBlock.func_220175_a(entityType, iWorldReader, blockPos2);
                    if (!\u26035.isPresent()) continue;
                    if (n > 0) {
                        --n;
                        continue;
                    }
                    return \u26035;
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<Vector3d> func_220175_a(EntityType<?> entityType, IWorldReader iWorldReader, BlockPos blockPos) {
        VoxelShape voxelShape = iWorldReader.func_180495_p(blockPos).func_196952_d(iWorldReader, blockPos);
        if (voxelShape.func_197758_c(Direction.Axis.Y) > 0.4375) {
            return Optional.empty();
        }
        BlockPos.Mutable \u26032 = blockPos.func_239590_i_();
        while (\u26032.func_177956_o() >= 0 && blockPos.func_177956_o() - \u26032.func_177956_o() <= 2 && iWorldReader.func_180495_p(\u26032).func_196952_d(iWorldReader, \u26032).func_197766_b()) {
            \u26032.func_189536_c(Direction.DOWN);
        }
        \u2603 = iWorldReader.func_180495_p(\u26032).func_196952_d(iWorldReader, \u26032);
        if (\u2603.func_197766_b()) {
            return Optional.empty();
        }
        double \u26033 = (double)\u26032.func_177956_o() + \u2603.func_197758_c(Direction.Axis.Y) + 2.0E-7;
        if ((double)blockPos.func_177956_o() - \u26033 > 2.0) {
            return Optional.empty();
        }
        Vector3d \u26034 = new Vector3d((double)\u26032.func_177958_n() + 0.5, \u26033, (double)\u26032.func_177952_p() + 0.5);
        AxisAlignedBB \u26035 = entityType.func_220328_a(\u26034.field_72450_a, \u26034.field_72448_b, \u26034.field_72449_c);
        if (iWorldReader.func_226664_a_(\u26035)) {
            if (iWorldReader.func_234853_a_(\u26035.func_72321_a(0.0, -0.2f, 0.0)).noneMatch(entityType::func_233597_a_)) {
                return Optional.of(\u26034);
            }
        }
        return Optional.empty();
    }

    @Override
    public PushReaction func_149656_h(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_185512_D, field_176472_a, field_176471_b);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new BedTileEntity(this.field_196352_y);
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.func_180633_a(world, blockPos, blockState, livingEntity, itemStack);
        if (!world.field_72995_K) {
            BlockPos blockPos2 = blockPos.func_177972_a(blockState.func_177229_b(field_185512_D));
            world.func_180501_a(blockPos2, (BlockState)blockState.func_206870_a(field_176472_a, BedPart.HEAD), 3);
            world.func_230547_a_(blockPos, Blocks.field_150350_a);
            blockState.func_235734_a_(world, blockPos, 3);
        }
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

