/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Block
extends AbstractBlock
implements IItemProvider {
    protected static final Logger field_196273_d = LogManager.getLogger();
    public static final ObjectIntIdentityMap<BlockState> field_176229_d = new ObjectIntIdentityMap();
    private static final LoadingCache<VoxelShape, Boolean> field_223006_b = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean load(VoxelShape voxelShape) {
            return !VoxelShapes.func_197879_c(VoxelShapes.func_197868_b(), voxelShape, IBooleanFunction.field_223236_g_);
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((VoxelShape)object);
        }
    });
    private static final VoxelShape field_220083_b = VoxelShapes.func_197878_a(VoxelShapes.func_197868_b(), Block.func_208617_a(2.0, 0.0, 2.0, 14.0, 16.0, 14.0), IBooleanFunction.field_223234_e_);
    private static final VoxelShape field_220084_c = Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 10.0, 9.0);
    protected final StateContainer<Block, BlockState> field_176227_L;
    private BlockState field_196275_y;
    @Nullable
    private String field_149770_b;
    @Nullable
    private Item field_220086_i;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> field_210300_r = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2ByteLinkedOpenHashMap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(2048, 0.25f){

            protected void rehash(int n) {
            }
        };
        object2ByteLinkedOpenHashMap.defaultReturnValue((byte)127);
        return object2ByteLinkedOpenHashMap;
    });

    public static int func_196246_j(@Nullable BlockState blockState) {
        if (blockState == null) {
            return 0;
        }
        int n = field_176229_d.func_148747_b(blockState);
        return n == -1 ? 0 : n;
    }

    public static BlockState func_196257_b(int n) {
        BlockState blockState = field_176229_d.func_148745_a(n);
        return blockState == null ? Blocks.field_150350_a.func_176223_P() : blockState;
    }

    public static Block func_149634_a(@Nullable Item item) {
        if (item instanceof BlockItem) {
            return ((BlockItem)item).func_179223_d();
        }
        return Blocks.field_150350_a;
    }

    public static BlockState func_199601_a(BlockState blockState, BlockState blockState22, World world, BlockPos blockPos) {
        BlockState blockState22;
        VoxelShape voxelShape = VoxelShapes.func_197882_b(blockState.func_196952_d(world, blockPos), blockState22.func_196952_d(world, blockPos), IBooleanFunction.field_223232_c_).func_197751_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        List<Entity> \u26032 = world.func_72839_b(null, voxelShape.func_197752_a());
        for (Entity entity : \u26032) {
            double d = VoxelShapes.func_212437_a(Direction.Axis.Y, entity.func_174813_aQ().func_72317_d(0.0, 1.0, 0.0), Stream.of(voxelShape), -1.0);
            entity.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0 + d, entity.func_226281_cx_());
        }
        return blockState22;
    }

    public static VoxelShape func_208617_a(double d, double d2, double d3, double d4, double d5, double d6) {
        return VoxelShapes.func_197873_a(d / 16.0, d2 / 16.0, d3 / 16.0, d4 / 16.0, d5 / 16.0, d6 / 16.0);
    }

    public boolean func_203417_a(ITag<Block> iTag) {
        return iTag.func_230235_a_(this);
    }

    public boolean func_235332_a_(Block block) {
        return this == block;
    }

    public static BlockState func_199770_b(BlockState blockState, IWorld iWorld, BlockPos blockPos) {
        BlockState blockState2 = blockState;
        BlockPos.Mutable \u26032 = new BlockPos.Mutable();
        for (Direction direction : field_212556_a) {
            \u26032.func_239622_a_(blockPos, direction);
            blockState2 = blockState2.func_196956_a(direction, iWorld.func_180495_p(\u26032), iWorld, blockPos, \u26032);
        }
        return blockState2;
    }

    public static void func_196263_a(BlockState blockState, BlockState blockState2, IWorld iWorld, BlockPos blockPos, int n) {
        Block.func_241468_a_(blockState, blockState2, iWorld, blockPos, n, 512);
    }

    public static void func_241468_a_(BlockState blockState, BlockState blockState2, IWorld iWorld, BlockPos blockPos, int n, int n2) {
        if (blockState2 != blockState) {
            if (blockState2.func_196958_f()) {
                if (!iWorld.func_201670_d()) {
                    iWorld.func_241212_a_(blockPos, (n & 0x20) == 0, null, n2);
                }
            } else {
                iWorld.func_241211_a_(blockPos, blockState2, n & 0xFFFFFFDF, n2);
            }
        }
    }

    public Block(AbstractBlock.Properties properties) {
        super(properties);
        StateContainer.Builder<Block, BlockState> builder = new StateContainer.Builder<Block, BlockState>(this);
        this.func_206840_a(builder);
        this.field_176227_L = builder.func_235882_a_(Block::func_176223_P, BlockState::new);
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public static boolean func_220073_a(Block block) {
        return block instanceof LeavesBlock || block == Blocks.field_180401_cv || block == Blocks.field_196625_cS || block == Blocks.field_196628_cT || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK || block.func_203417_a(BlockTags.field_226150_J_);
    }

    public boolean func_149653_t(BlockState blockState) {
        return this.field_149789_z;
    }

    public static boolean func_220064_c(IBlockReader iBlockReader, BlockPos blockPos) {
        BlockState blockState = iBlockReader.func_180495_p(blockPos);
        return blockState.func_235785_r_(iBlockReader, blockPos) && blockState.func_224755_d(iBlockReader, blockPos, Direction.UP) || !VoxelShapes.func_197879_c(blockState.func_196951_e(iBlockReader, blockPos).func_212434_a(Direction.UP), field_220083_b, IBooleanFunction.field_223232_c_);
    }

    public static boolean func_220055_a(IWorldReader iWorldReader, BlockPos blockPos, Direction direction) {
        BlockState blockState = iWorldReader.func_180495_p(blockPos);
        if (direction == Direction.DOWN && blockState.func_235714_a_(BlockTags.field_232869_aB_)) {
            return false;
        }
        return !VoxelShapes.func_197879_c(blockState.func_196951_e(iWorldReader, blockPos).func_212434_a(direction), field_220084_c, IBooleanFunction.field_223232_c_);
    }

    public static boolean func_220056_d(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return Block.func_208061_a(blockState.func_196951_e(iBlockReader, blockPos), direction);
    }

    public static boolean func_208061_a(VoxelShape voxelShape, Direction direction) {
        VoxelShape voxelShape2 = voxelShape.func_212434_a(direction);
        return Block.func_208062_a(voxelShape2);
    }

    public static boolean func_208062_a(VoxelShape voxelShape) {
        return (Boolean)field_223006_b.getUnchecked((Object)voxelShape);
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return !Block.func_208062_a(blockState.func_196954_c(iBlockReader, blockPos)) && blockState.func_204520_s().func_206888_e();
    }

    public void func_176206_d(IWorld iWorld, BlockPos blockPos, BlockState blockState) {
    }

    public static List<ItemStack> func_220070_a(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, @Nullable TileEntity tileEntity) {
        LootContext.Builder builder = new LootContext.Builder(serverWorld).func_216023_a(serverWorld.field_73012_v).func_216015_a(LootParameters.field_216286_f, blockPos).func_216015_a(LootParameters.field_216289_i, ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, tileEntity);
        return blockState.func_215693_a(builder);
    }

    public static List<ItemStack> func_220077_a(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, @Nullable TileEntity tileEntity, @Nullable Entity entity, ItemStack itemStack) {
        LootContext.Builder builder = new LootContext.Builder(serverWorld).func_216023_a(serverWorld.field_73012_v).func_216015_a(LootParameters.field_216286_f, blockPos).func_216015_a(LootParameters.field_216289_i, itemStack).func_216021_b(LootParameters.field_216281_a, entity).func_216021_b(LootParameters.field_216288_h, tileEntity);
        return blockState.func_215693_a(builder);
    }

    public static void func_220075_c(BlockState blockState, World world, BlockPos blockPos) {
        if (world instanceof ServerWorld) {
            Block.func_220070_a(blockState, (ServerWorld)world, blockPos, null).forEach(itemStack -> Block.func_180635_a(world, blockPos, itemStack));
        }
        blockState.func_215706_a(world, blockPos, ItemStack.field_190927_a);
    }

    public static void func_220059_a(BlockState blockState, World world, BlockPos blockPos, @Nullable TileEntity tileEntity) {
        if (world instanceof ServerWorld) {
            Block.func_220070_a(blockState, (ServerWorld)world, blockPos, tileEntity).forEach(itemStack -> Block.func_180635_a(world, blockPos, itemStack));
        }
        blockState.func_215706_a(world, blockPos, ItemStack.field_190927_a);
    }

    public static void func_220054_a(BlockState blockState, World world, BlockPos blockPos, @Nullable TileEntity tileEntity, Entity entity, ItemStack itemStack2) {
        if (world instanceof ServerWorld) {
            Block.func_220077_a(blockState, (ServerWorld)world, blockPos, tileEntity, entity, itemStack2).forEach(itemStack -> Block.func_180635_a(world, blockPos, itemStack));
        }
        blockState.func_215706_a(world, blockPos, itemStack2);
    }

    public static void func_180635_a(World world, BlockPos blockPos, ItemStack itemStack) {
        if (world.field_72995_K || itemStack.func_190926_b() || !world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            return;
        }
        float f = 0.5f;
        double \u26032 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double \u26033 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double \u26034 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        ItemEntity \u26035 = new ItemEntity(world, (double)blockPos.func_177958_n() + \u26032, (double)blockPos.func_177956_o() + \u26033, (double)blockPos.func_177952_p() + \u26034, itemStack);
        \u26035.func_174869_p();
        world.func_217376_c(\u26035);
    }

    protected void func_180637_b(World world, BlockPos blockPos, int n) {
        if (!world.field_72995_K && world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            while (n > 0) {
                \u2603 = ExperienceOrbEntity.func_70527_a(n);
                n -= \u2603;
                world.func_217376_c(new ExperienceOrbEntity(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, \u2603));
            }
        }
    }

    public float func_149638_a() {
        return this.field_235689_au_;
    }

    public void func_180652_a(World world, BlockPos blockPos, Explosion explosion) {
    }

    public void func_176199_a(World world, BlockPos blockPos, Entity entity) {
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return this.func_176223_P();
    }

    public void func_180657_a(World world, PlayerEntity playerEntity, BlockPos blockPos, BlockState blockState, @Nullable TileEntity tileEntity, ItemStack itemStack) {
        playerEntity.func_71029_a(Stats.field_188065_ae.func_199076_b(this));
        playerEntity.func_71020_j(0.005f);
        Block.func_220054_a(blockState, world, blockPos, tileEntity, playerEntity, itemStack);
    }

    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
    }

    public boolean func_181623_g() {
        return !this.field_149764_J.func_76220_a() && !this.field_149764_J.func_76224_d();
    }

    public String func_149739_a() {
        if (this.field_149770_b == null) {
            this.field_149770_b = Util.func_200697_a("block", Registry.field_212618_g.func_177774_c(this));
        }
        return this.field_149770_b;
    }

    public void func_180658_a(World world, BlockPos blockPos, Entity entity, float f) {
        entity.func_225503_b_(f, 1.0f);
    }

    public void func_176216_a(IBlockReader iBlockReader, Entity entity) {
        entity.func_213317_d(entity.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
    }

    public void func_149666_a(ItemGroup itemGroup, NonNullList<ItemStack> nonNullList) {
        nonNullList.add(new ItemStack(this));
    }

    public float func_208618_m() {
        return this.field_149765_K;
    }

    public float func_226891_m_() {
        return this.field_226886_f_;
    }

    public float func_226892_n_() {
        return this.field_226887_g_;
    }

    public void func_176208_a(World world, BlockPos blockPos, BlockState blockState, PlayerEntity playerEntity) {
        world.func_217378_a(playerEntity, 2001, blockPos, Block.func_196246_j(blockState));
        if (this.func_203417_a(BlockTags.field_232883_ay_)) {
            PiglinTasks.func_234478_a_(playerEntity, false);
        }
    }

    public void func_176224_k(World world, BlockPos blockPos) {
    }

    public boolean func_149659_a(Explosion explosion) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
    }

    public StateContainer<Block, BlockState> func_176194_O() {
        return this.field_176227_L;
    }

    protected final void func_180632_j(BlockState blockState) {
        this.field_196275_y = blockState;
    }

    public final BlockState func_176223_P() {
        return this.field_196275_y;
    }

    public SoundType func_220072_p(BlockState blockState) {
        return this.field_149762_H;
    }

    @Override
    public Item func_199767_j() {
        if (this.field_220086_i == null) {
            this.field_220086_i = Item.func_150898_a(this);
        }
        return this.field_220086_i;
    }

    public boolean func_208619_r() {
        return this.field_208621_p;
    }

    public String toString() {
        return "Block{" + Registry.field_212618_g.func_177774_c(this) + "}";
    }

    @Override
    protected Block func_230328_p_() {
        return this;
    }

    public static final class RenderSideCacheKey {
        private final BlockState field_212164_a;
        private final BlockState field_212165_b;
        private final Direction field_212166_c;

        public RenderSideCacheKey(BlockState blockState, BlockState blockState2, Direction direction) {
            this.field_212164_a = blockState;
            this.field_212165_b = blockState2;
            this.field_212166_c = direction;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey renderSideCacheKey = (RenderSideCacheKey)object;
            return this.field_212164_a == renderSideCacheKey.field_212164_a && this.field_212165_b == renderSideCacheKey.field_212165_b && this.field_212166_c == renderSideCacheKey.field_212166_c;
        }

        public int hashCode() {
            int n = this.field_212164_a.hashCode();
            n = 31 * n + this.field_212165_b.hashCode();
            n = 31 * n + this.field_212166_c.hashCode();
            return n;
        }
    }
}

