/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class BlockPredicateArgument
implements ArgumentType<IResult> {
    private static final Collection<String> field_201331_a = Arrays.asList("stone", "minecraft:stone", "stone[foo=bar]", "#stone", "#stone[foo=bar]{baz=nbt}");
    private static final DynamicCommandExceptionType field_199826_a = new DynamicCommandExceptionType(object -> new TranslationTextComponent("arguments.block.tag.unknown", object));

    public static BlockPredicateArgument func_199824_a() {
        return new BlockPredicateArgument();
    }

    public IResult parse(StringReader stringReader) throws CommandSyntaxException {
        BlockStateParser blockStateParser = new BlockStateParser(stringReader, true).func_197243_a(true);
        if (blockStateParser.func_197249_b() != null) {
            BlockPredicate blockPredicate = new BlockPredicate(blockStateParser.func_197249_b(), blockStateParser.func_197254_a().keySet(), blockStateParser.func_197241_c());
            return networkTagManager -> blockPredicate;
        }
        ResourceLocation \u26032 = blockStateParser.func_199829_d();
        return networkTagManager -> {
            ITag iTag = networkTagManager.func_199717_a().func_199910_a(\u26032);
            if (iTag == null) {
                throw field_199826_a.create((Object)\u26032.toString());
            }
            return new TagPredicate(iTag, blockStateParser.func_200139_j(), blockStateParser.func_197241_c());
        };
    }

    public static Predicate<CachedBlockInfo> func_199825_a(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return ((IResult)commandContext.getArgument(string, IResult.class)).create(((CommandSource)commandContext.getSource()).func_197028_i().func_199731_aO());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        StringReader stringReader = new StringReader(suggestionsBuilder.getInput());
        stringReader.setCursor(suggestionsBuilder.getStart());
        BlockStateParser \u26032 = new BlockStateParser(stringReader, true);
        try {
            \u26032.func_197243_a(true);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return \u26032.func_197245_a(suggestionsBuilder, BlockTags.func_199896_a());
    }

    public Collection<String> getExamples() {
        return field_201331_a;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static class TagPredicate
    implements Predicate<CachedBlockInfo> {
        private final ITag<Block> field_199820_a;
        @Nullable
        private final CompoundNBT field_199821_b;
        private final Map<String, String> field_200133_c;

        private TagPredicate(ITag<Block> iTag, Map<String, String> map, @Nullable CompoundNBT compoundNBT) {
            this.field_199820_a = iTag;
            this.field_200133_c = map;
            this.field_199821_b = compoundNBT;
        }

        @Override
        public boolean test(CachedBlockInfo cachedBlockInfo) {
            BlockState blockState = cachedBlockInfo.func_177509_a();
            if (!blockState.func_235714_a_(this.field_199820_a)) {
                return false;
            }
            for (Map.Entry<String, String> entry : this.field_200133_c.entrySet()) {
                Property<?> property = blockState.func_177230_c().func_176194_O().func_185920_a(entry.getKey());
                if (property == null) {
                    return false;
                }
                Comparable \u26032 = property.func_185929_b(entry.getValue()).orElse(null);
                if (\u26032 == null) {
                    return false;
                }
                if (blockState.func_177229_b(property) == \u26032) continue;
                return false;
            }
            if (this.field_199821_b != null) {
                TileEntity tileEntity = cachedBlockInfo.func_177507_b();
                return tileEntity != null && NBTUtil.func_181123_a(this.field_199821_b, tileEntity.func_189515_b(new CompoundNBT()), true);
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((CachedBlockInfo)object);
        }
    }

    static class BlockPredicate
    implements Predicate<CachedBlockInfo> {
        private final BlockState field_199817_a;
        private final Set<Property<?>> field_199818_b;
        @Nullable
        private final CompoundNBT field_199819_c;

        public BlockPredicate(BlockState blockState, Set<Property<?>> set, @Nullable CompoundNBT compoundNBT) {
            this.field_199817_a = blockState;
            this.field_199818_b = set;
            this.field_199819_c = compoundNBT;
        }

        @Override
        public boolean test(CachedBlockInfo cachedBlockInfo2) {
            BlockState blockState = cachedBlockInfo2.func_177509_a();
            if (!blockState.func_203425_a(this.field_199817_a.func_177230_c())) {
                return false;
            }
            for (Property<?> property : this.field_199818_b) {
                if (blockState.func_177229_b(property) == this.field_199817_a.func_177229_b(property)) continue;
                return false;
            }
            if (this.field_199819_c != null) {
                CachedBlockInfo cachedBlockInfo2;
                TileEntity \u26032 = cachedBlockInfo2.func_177507_b();
                return \u26032 != null && NBTUtil.func_181123_a(this.field_199819_c, \u26032.func_189515_b(new CompoundNBT()), true);
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((CachedBlockInfo)object);
        }
    }

    public static interface IResult {
        public Predicate<CachedBlockInfo> create(NetworkTagManager var1) throws CommandSyntaxException;
    }
}

