/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.advancements.AdventureAdvancements;
import net.minecraft.data.advancements.EndAdvancements;
import net.minecraft.data.advancements.HusbandryAdvancements;
import net.minecraft.data.advancements.NetherAdvancements;
import net.minecraft.data.advancements.StoryAdvancements;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementProvider
implements IDataProvider {
    private static final Logger field_204023_a = LogManager.getLogger();
    private static final Gson field_204024_b = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator field_204025_c;
    private final List<Consumer<Consumer<Advancement>>> field_204283_d = ImmutableList.of((Object)new EndAdvancements(), (Object)new HusbandryAdvancements(), (Object)new AdventureAdvancements(), (Object)new NetherAdvancements(), (Object)new StoryAdvancements());

    public AdvancementProvider(DataGenerator dataGenerator) {
        this.field_204025_c = dataGenerator;
    }

    @Override
    public void func_200398_a(DirectoryCache directoryCache) throws IOException {
        Path path = this.field_204025_c.func_200391_b();
        HashSet \u26032 = Sets.newHashSet();
        Consumer<Advancement> \u26033 = advancement -> {
            if (!\u26032.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path path2 = AdvancementProvider.func_218428_a(path, advancement);
            try {
                IDataProvider.func_218426_a(field_204024_b, directoryCache, (JsonElement)advancement.func_192075_a().func_200273_b(), path2);
            }
            catch (IOException \u26032) {
                field_204023_a.error("Couldn't save advancement {}", (Object)path2, (Object)\u26032);
            }
        };
        for (Consumer<Consumer<Advancement>> consumer : this.field_204283_d) {
            consumer.accept(\u26033);
        }
    }

    private static Path func_218428_a(Path path, Advancement advancement) {
        return path.resolve("data/" + advancement.func_192067_g().func_110624_b() + "/advancements/" + advancement.func_192067_g().func_110623_a() + ".json");
    }

    @Override
    public String func_200397_b() {
        return "Advancements";
    }
}

