/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.data.BlockModelProvider;
import net.minecraft.data.BlockModelWriter;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedBlockState;
import net.minecraft.data.ItemModelProvider;
import net.minecraft.data.ModelsResourceUtil;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockStateProvider
implements IDataProvider {
    private static final Logger field_240078_b_ = LogManager.getLogger();
    private static final Gson field_240079_c_ = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator field_240080_d_;

    public BlockStateProvider(DataGenerator dataGenerator) {
        this.field_240080_d_ = dataGenerator;
    }

    @Override
    public void func_200398_a(DirectoryCache directoryCache) {
        Path path = this.field_240080_d_.func_200391_b();
        HashMap \u26032 = Maps.newHashMap();
        Consumer<IFinishedBlockState> \u26033 = iFinishedBlockState -> {
            Block block = iFinishedBlockState.func_230524_a_();
            IFinishedBlockState \u26032 = \u26032.put(block, iFinishedBlockState);
            if (\u26032 != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
        };
        HashMap \u26034 = Maps.newHashMap();
        HashSet \u26035 = Sets.newHashSet();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> \u26036 = (resourceLocation, supplier) -> {
            \u2603 = \u26034.put(resourceLocation, supplier);
            if (\u2603 != null) {
                throw new IllegalStateException("Duplicate model definition for " + resourceLocation);
            }
        };
        Consumer<Item> \u26037 = \u26035::add;
        new BlockModelProvider(\u26033, \u26036, \u26037).func_239863_a_();
        new ItemModelProvider(\u26036).func_240074_a_();
        List \u26038 = Registry.field_212618_g.func_201756_e().filter(block -> !\u26032.containsKey(block)).collect(Collectors.toList());
        if (!\u26038.isEmpty()) {
            throw new IllegalStateException("Missing blockstate definitions for: " + \u26038);
        }
        Registry.field_212618_g.forEach(block -> {
            Item item = Item.field_179220_a.get(block);
            if (item != null) {
                if (\u26035.contains(item)) {
                    return;
                }
                ResourceLocation resourceLocation = ModelsResourceUtil.func_240219_a_(item);
                if (!\u26034.containsKey(resourceLocation)) {
                    \u26034.put(resourceLocation, new BlockModelWriter(ModelsResourceUtil.func_240221_a_(block)));
                }
            }
        });
        this.func_240081_a_(directoryCache, path, \u26032, BlockStateProvider::func_240082_a_);
        this.func_240081_a_(directoryCache, path, \u26034, BlockStateProvider::func_240083_a_);
    }

    private <T> void func_240081_a_(DirectoryCache directoryCache, Path path, Map<T, ? extends Supplier<JsonElement>> map, BiFunction<Path, T, Path> biFunction) {
        map.forEach((object, supplier) -> {
            Path path2 = (Path)biFunction.apply(path, object);
            try {
                IDataProvider.func_218426_a(field_240079_c_, directoryCache, (JsonElement)supplier.get(), path2);
            }
            catch (Exception \u26032) {
                field_240078_b_.error("Couldn't save {}", (Object)path2, (Object)\u26032);
            }
        });
    }

    private static Path func_240082_a_(Path path, Block block) {
        ResourceLocation resourceLocation = Registry.field_212618_g.func_177774_c(block);
        return path.resolve("assets/" + resourceLocation.func_110624_b() + "/blockstates/" + resourceLocation.func_110623_a() + ".json");
    }

    private static Path func_240083_a_(Path path, ResourceLocation resourceLocation) {
        return path.resolve("assets/" + resourceLocation.func_110624_b() + "/models/" + resourceLocation.func_110623_a() + ".json");
    }

    @Override
    public String func_200397_b() {
        return "Block State Definitions";
    }
}

