/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.PushReaction;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SEntityPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Entity
implements INameable,
ICommandSource {
    protected static final Logger field_184243_a = LogManager.getLogger();
    private static final AtomicInteger field_213331_b = new AtomicInteger();
    private static final List<ItemStack> field_190535_b = Collections.emptyList();
    private static final AxisAlignedBB field_174836_a = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static double field_70155_l = 1.0;
    private final EntityType<?> field_200606_g;
    private int field_145783_c = field_213331_b.incrementAndGet();
    public boolean field_70156_m;
    private final List<Entity> field_184244_h = Lists.newArrayList();
    protected int field_184245_j;
    @Nullable
    private Entity field_184239_as;
    public boolean field_98038_p;
    public World field_70170_p;
    public double field_70169_q;
    public double field_70167_r;
    public double field_70166_s;
    private Vector3d field_233557_ao_;
    private BlockPos field_233558_ap_;
    private Vector3d field_213327_at = Vector3d.field_186680_a;
    public float field_70177_z;
    public float field_70125_A;
    public float field_70126_B;
    public float field_70127_C;
    private AxisAlignedBB field_70121_D = field_174836_a;
    protected boolean field_70122_E;
    public boolean field_70123_F;
    public boolean field_70124_G;
    public boolean field_70133_I;
    protected Vector3d field_213328_B = Vector3d.field_186680_a;
    public boolean field_70128_L;
    public float field_70141_P;
    public float field_70140_Q;
    public float field_82151_R;
    public float field_70143_R;
    private float field_70150_b = 1.0f;
    private float field_191959_ay = 1.0f;
    public double field_70142_S;
    public double field_70137_T;
    public double field_70136_U;
    public float field_70138_W;
    public boolean field_70145_X;
    public float field_70144_Y;
    protected final Random field_70146_Z = new Random();
    public int field_70173_aa;
    private int field_190534_ay = -this.func_190531_bD();
    protected boolean field_70171_ac;
    protected Object2DoubleMap<ITag<Fluid>> field_233554_M_ = new Object2DoubleArrayMap(2);
    protected boolean field_205013_W;
    @Nullable
    protected ITag<Fluid> field_241335_O_;
    protected boolean field_213329_S;
    public int field_70172_ad;
    protected boolean field_70148_d = true;
    protected final EntityDataManager field_70180_af;
    protected static final DataParameter<Byte> field_184240_ax = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Integer> field_184241_ay = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Optional<ITextComponent>> field_184242_az = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_200544_f);
    private static final DataParameter<Boolean> field_184233_aA = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_184234_aB = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_189655_aD = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187198_h);
    protected static final DataParameter<Pose> field_213330_X = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_218815_s);
    public boolean field_70175_ag;
    public int field_70176_ah;
    public int field_70162_ai;
    public int field_70164_aj;
    private boolean field_233555_aA_;
    public long field_70118_ct;
    public long field_70117_cu;
    public long field_70116_cv;
    public boolean field_70158_ak;
    public boolean field_70160_al;
    public int field_71088_bW;
    protected boolean field_71087_bX;
    protected int field_82153_h;
    protected BlockPos field_181016_an;
    protected Vector3d field_181017_ao;
    protected Direction field_181018_ap;
    private boolean field_83001_bt;
    protected UUID field_96093_i = MathHelper.func_180182_a(this.field_70146_Z);
    protected String field_189513_ar = this.field_96093_i.toString();
    protected boolean field_184238_ar;
    private final Set<String> field_184236_aF = Sets.newHashSet();
    private boolean field_184237_aG;
    private final double[] field_191505_aI = new double[]{0.0, 0.0, 0.0};
    private long field_191506_aJ;
    private EntitySize field_213325_aI;
    private float field_213326_aJ;

    public Entity(EntityType<?> entityType, World world) {
        this.field_200606_g = entityType;
        this.field_70170_p = world;
        this.field_213325_aI = entityType.func_220334_j();
        this.field_233557_ao_ = Vector3d.field_186680_a;
        this.field_233558_ap_ = BlockPos.field_177992_a;
        this.func_70107_b(0.0, 0.0, 0.0);
        this.field_70180_af = new EntityDataManager(this);
        this.field_70180_af.func_187214_a(field_184240_ax, (byte)0);
        this.field_70180_af.func_187214_a(field_184241_ay, this.func_205010_bg());
        this.field_70180_af.func_187214_a(field_184233_aA, false);
        this.field_70180_af.func_187214_a(field_184242_az, Optional.empty());
        this.field_70180_af.func_187214_a(field_184234_aB, false);
        this.field_70180_af.func_187214_a(field_189655_aD, false);
        this.field_70180_af.func_187214_a(field_213330_X, Pose.STANDING);
        this.func_70088_a();
        this.field_213326_aJ = this.func_213316_a(Pose.STANDING, this.field_213325_aI);
    }

    public boolean func_175149_v() {
        return false;
    }

    public final void func_213319_R() {
        if (this.func_184207_aI()) {
            this.func_184226_ay();
        }
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
    }

    public void func_213312_b(double d, double d2, double d3) {
        this.field_70118_ct = SEntityPacket.func_218743_a(d);
        this.field_70117_cu = SEntityPacket.func_218743_a(d2);
        this.field_70116_cv = SEntityPacket.func_218743_a(d3);
    }

    public EntityType<?> func_200600_R() {
        return this.field_200606_g;
    }

    public int func_145782_y() {
        return this.field_145783_c;
    }

    public void func_145769_d(int n) {
        this.field_145783_c = n;
    }

    public Set<String> func_184216_O() {
        return this.field_184236_aF;
    }

    public boolean func_184211_a(String string) {
        if (this.field_184236_aF.size() >= 1024) {
            return false;
        }
        return this.field_184236_aF.add(string);
    }

    public boolean func_184197_b(String string) {
        return this.field_184236_aF.remove(string);
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    protected abstract void func_70088_a();

    public EntityDataManager func_184212_Q() {
        return this.field_70180_af;
    }

    public boolean equals(Object object) {
        if (object instanceof Entity) {
            return ((Entity)object).field_145783_c == this.field_145783_c;
        }
        return false;
    }

    public int hashCode() {
        return this.field_145783_c;
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    public void func_213301_b(Pose pose) {
        this.field_70180_af.func_187227_b(field_213330_X, pose);
    }

    public Pose func_213283_Z() {
        return this.field_70180_af.func_187225_a(field_213330_X);
    }

    public boolean func_233562_a_(Entity entity, double d) {
        \u2603 = entity.field_233557_ao_.field_72450_a - this.field_233557_ao_.field_72450_a;
        \u2603 = entity.field_233557_ao_.field_72448_b - this.field_233557_ao_.field_72448_b;
        \u2603 = entity.field_233557_ao_.field_72449_c - this.field_233557_ao_.field_72449_c;
        return \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603 < d * d;
    }

    protected void func_70101_b(float f, float f2) {
        this.field_70177_z = f % 360.0f;
        this.field_70125_A = f2 % 360.0f;
    }

    public void func_70107_b(double d, double d2, double d3) {
        this.func_226288_n_(d, d2, d3);
        float f = this.field_213325_aI.field_220315_a / 2.0f;
        \u2603 = this.field_213325_aI.field_220316_b;
        this.func_174826_a(new AxisAlignedBB(d - (double)f, d2, d3 - (double)f, d + (double)f, d2 + (double)\u2603, d3 + (double)f));
    }

    protected void func_226264_Z_() {
        this.func_70107_b(this.field_233557_ao_.field_72450_a, this.field_233557_ao_.field_72448_b, this.field_233557_ao_.field_72449_c);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
    }

    public void func_70030_z() {
        this.field_70170_p.func_217381_Z().func_76320_a("entityBaseTick");
        if (this.func_184218_aH() && this.func_184187_bx().field_70128_L) {
            this.func_184210_p();
        }
        if (this.field_184245_j > 0) {
            --this.field_184245_j;
        }
        this.field_70141_P = this.field_70140_Q;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.func_213284_aV();
        if (this.func_230269_aK_()) {
            this.func_233569_aL_();
        }
        this.func_233566_aG_();
        this.func_205012_q();
        this.func_205343_av();
        if (this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        } else if (this.field_190534_ay > 0) {
            if (this.func_230279_az_()) {
                this.func_241209_g_(this.field_190534_ay - 4);
                if (this.field_190534_ay < 0) {
                    this.func_70066_B();
                }
            } else {
                if (this.field_190534_ay % 20 == 0) {
                    this.func_70097_a(DamageSource.field_76370_b, 1.0f);
                }
                this.func_241209_g_(this.field_190534_ay - 1);
            }
        }
        if (this.func_180799_ab()) {
            this.func_70044_A();
            this.field_70143_R *= 0.5f;
        }
        if (this.func_226278_cu_() < -64.0) {
            this.func_70076_C();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(0, this.field_190534_ay > 0);
        }
        this.field_70148_d = false;
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    protected void func_184173_H() {
        if (this.field_71088_bW > 0) {
            --this.field_71088_bW;
        }
    }

    public int func_82145_z() {
        return 1;
    }

    protected void func_70044_A() {
        if (this.func_230279_az_()) {
            return;
        }
        this.func_70015_d(15);
        this.func_70097_a(DamageSource.field_76371_c, 4.0f);
    }

    public void func_70015_d(int n) {
        \u2603 = n * 20;
        if (this instanceof LivingEntity) {
            \u2603 = ProtectionEnchantment.func_92093_a((LivingEntity)this, \u2603);
        }
        if (this.field_190534_ay < \u2603) {
            this.func_241209_g_(\u2603);
        }
    }

    public void func_241209_g_(int n) {
        this.field_190534_ay = n;
    }

    public int func_223314_ad() {
        return this.field_190534_ay;
    }

    public void func_70066_B() {
        this.func_241209_g_(0);
    }

    protected void func_70076_C() {
        this.func_70106_y();
    }

    public boolean func_70038_c(double d, double d2, double d3) {
        return this.func_174809_b(this.func_174813_aQ().func_72317_d(d, d2, d3));
    }

    private boolean func_174809_b(AxisAlignedBB axisAlignedBB) {
        return this.field_70170_p.func_226665_a__(this, axisAlignedBB) && !this.field_70170_p.func_72953_d(axisAlignedBB);
    }

    public void func_230245_c_(boolean bl) {
        this.field_70122_E = bl;
    }

    public boolean func_233570_aj_() {
        return this.field_70122_E;
    }

    public void func_213315_a(MoverType moverType, Vector3d vector3d) {
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_191194_a(vector3d));
            this.func_174829_m();
            return;
        }
        if (moverType == MoverType.PISTON && (vector3d = this.func_213308_a(vector3d)).equals(Vector3d.field_186680_a)) {
            return;
        }
        this.field_70170_p.func_217381_Z().func_76320_a("move");
        if (this.field_213328_B.func_189985_c() > 1.0E-7) {
            vector3d = vector3d.func_216369_h(this.field_213328_B);
            this.field_213328_B = Vector3d.field_186680_a;
            this.func_213317_d(Vector3d.field_186680_a);
        }
        if ((\u2603 = this.func_213306_e(vector3d = this.func_225514_a_(vector3d, moverType))).func_189985_c() > 1.0E-7) {
            this.func_174826_a(this.func_174813_aQ().func_191194_a(\u2603));
            this.func_174829_m();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("rest");
        this.field_70123_F = !MathHelper.func_219806_b(vector3d.field_72450_a, \u2603.field_72450_a) || !MathHelper.func_219806_b(vector3d.field_72449_c, \u2603.field_72449_c);
        this.field_70124_G = vector3d.field_72448_b != \u2603.field_72448_b;
        this.field_70122_E = this.field_70124_G && vector3d.field_72448_b < 0.0;
        BlockPos blockPos = this.func_226268_ag_();
        BlockState \u26032 = this.field_70170_p.func_180495_p(blockPos);
        this.func_184231_a(\u2603.field_72448_b, this.field_70122_E, \u26032, blockPos);
        Vector3d \u26033 = this.func_213322_ci();
        if (vector3d.field_72450_a != \u2603.field_72450_a) {
            this.func_213293_j(0.0, \u26033.field_72448_b, \u26033.field_72449_c);
        }
        if (vector3d.field_72449_c != \u2603.field_72449_c) {
            this.func_213293_j(\u26033.field_72450_a, \u26033.field_72448_b, 0.0);
        }
        Block \u26034 = \u26032.func_177230_c();
        if (vector3d.field_72448_b != \u2603.field_72448_b) {
            \u26034.func_176216_a(this.field_70170_p, this);
        }
        if (this.field_70122_E && !this.func_226271_bk_()) {
            \u26034.func_176199_a(this.field_70170_p, blockPos, this);
        }
        if (this.func_225502_at_() && !this.func_184218_aH()) {
            double d = \u2603.field_72450_a;
            \u2603 = \u2603.field_72448_b;
            \u2603 = \u2603.field_72449_c;
            if (!\u26034.func_203417_a(BlockTags.field_232878_as_)) {
                \u2603 = 0.0;
            }
            this.field_70140_Q = (float)((double)this.field_70140_Q + (double)MathHelper.func_76133_a(Entity.func_213296_b(\u2603)) * 0.6);
            this.field_82151_R = (float)((double)this.field_82151_R + (double)MathHelper.func_76133_a(d * d + \u2603 * \u2603 + \u2603 * \u2603) * 0.6);
            if (this.field_82151_R > this.field_70150_b && !\u26032.func_196958_f()) {
                this.field_70150_b = this.func_203009_ad();
                if (this.func_70090_H()) {
                    Entity entity = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
                    float \u26035 = entity == this ? 0.35f : 0.4f;
                    Vector3d \u26036 = entity.func_213322_ci();
                    float \u26037 = MathHelper.func_76133_a(\u26036.field_72450_a * \u26036.field_72450_a * (double)0.2f + \u26036.field_72448_b * \u26036.field_72448_b + \u26036.field_72449_c * \u26036.field_72449_c * (double)0.2f) * \u26035;
                    if (\u26037 > 1.0f) {
                        \u26037 = 1.0f;
                    }
                    this.func_203006_d(\u26037);
                } else {
                    this.func_180429_a(blockPos, \u26032);
                }
            } else if (this.field_82151_R > this.field_191959_ay && this.func_191957_ae() && \u26032.func_196958_f()) {
                this.field_191959_ay = this.func_191954_d(this.field_82151_R);
            }
        }
        try {
            this.field_213329_S = false;
            this.func_145775_I();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Checking entity block collision");
            CrashReportCategory \u26038 = crashReport.func_85058_a("Entity being checked for collision");
            this.func_85029_a(\u26038);
            throw new ReportedException(crashReport);
        }
        float f = this.func_225515_ai_();
        this.func_213317_d(this.func_213322_ci().func_216372_d(f, 1.0, f));
        if (this.field_70170_p.func_234939_c_(this.func_174813_aQ().func_186664_h(0.001)).noneMatch(blockState -> blockState.func_235714_a_(BlockTags.field_232872_am_) || blockState.func_203425_a(Blocks.field_150353_l)) && this.field_190534_ay <= 0) {
            this.func_241209_g_(-this.func_190531_bD());
        }
        if (this.func_203008_ap() && this.func_70027_ad()) {
            this.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
            this.func_241209_g_(-this.func_190531_bD());
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    protected BlockPos func_226268_ag_() {
        int n = MathHelper.func_76128_c(this.field_233557_ao_.field_72450_a);
        BlockPos \u26032 = new BlockPos(n, \u2603 = MathHelper.func_76128_c(this.field_233557_ao_.field_72448_b - (double)0.2f), \u2603 = MathHelper.func_76128_c(this.field_233557_ao_.field_72449_c));
        if (this.field_70170_p.func_180495_p(\u26032).func_196958_f() && ((\u2603 = (\u2603 = this.field_70170_p.func_180495_p(\u2603 = \u26032.func_177977_b())).func_177230_c()).func_203417_a(BlockTags.field_219748_G) || \u2603.func_203417_a(BlockTags.field_219757_z) || \u2603 instanceof FenceGateBlock)) {
            return \u2603;
        }
        return \u26032;
    }

    protected float func_226269_ah_() {
        float f = this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c().func_226892_n_();
        \u2603 = this.field_70170_p.func_180495_p(this.func_226270_aj_()).func_177230_c().func_226892_n_();
        return (double)f == 1.0 ? \u2603 : f;
    }

    protected float func_225515_ai_() {
        Block block = this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c();
        float \u26032 = block.func_226891_m_();
        if (block == Blocks.field_150355_j || block == Blocks.field_203203_C) {
            return \u26032;
        }
        return (double)\u26032 == 1.0 ? this.field_70170_p.func_180495_p(this.func_226270_aj_()).func_177230_c().func_226891_m_() : \u26032;
    }

    protected BlockPos func_226270_aj_() {
        return new BlockPos(this.field_233557_ao_.field_72450_a, this.func_174813_aQ().field_72338_b - 0.5000001, this.field_233557_ao_.field_72449_c);
    }

    protected Vector3d func_225514_a_(Vector3d vector3d, MoverType moverType) {
        return vector3d;
    }

    protected Vector3d func_213308_a(Vector3d vector3d2) {
        Vector3d vector3d2;
        if (vector3d2.func_189985_c() <= 1.0E-7) {
            return vector3d2;
        }
        long l = this.field_70170_p.func_82737_E();
        if (l != this.field_191506_aJ) {
            Arrays.fill(this.field_191505_aI, 0.0);
            this.field_191506_aJ = l;
        }
        if (vector3d2.field_72450_a != 0.0) {
            double d = this.func_213304_a(Direction.Axis.X, vector3d2.field_72450_a);
            return Math.abs(d) <= (double)1.0E-5f ? Vector3d.field_186680_a : new Vector3d(d, 0.0, 0.0);
        }
        if (vector3d2.field_72448_b != 0.0) {
            double d = this.func_213304_a(Direction.Axis.Y, vector3d2.field_72448_b);
            return Math.abs(d) <= (double)1.0E-5f ? Vector3d.field_186680_a : new Vector3d(0.0, d, 0.0);
        }
        if (vector3d2.field_72449_c != 0.0) {
            double d = this.func_213304_a(Direction.Axis.Z, vector3d2.field_72449_c);
            return Math.abs(d) <= (double)1.0E-5f ? Vector3d.field_186680_a : new Vector3d(0.0, 0.0, d);
        }
        return Vector3d.field_186680_a;
    }

    private double func_213304_a(Direction.Axis axis, double \u260332) {
        int n = axis.ordinal();
        double \u26032 = MathHelper.func_151237_a(\u260332 + this.field_191505_aI[n], -0.51, 0.51);
        double \u260332 = \u26032 - this.field_191505_aI[n];
        this.field_191505_aI[n] = \u26032;
        return \u260332;
    }

    private Vector3d func_213306_e(Vector3d vector3d) {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        ISelectionContext \u26032 = ISelectionContext.func_216374_a(this);
        VoxelShape \u26033 = this.field_70170_p.func_175723_af().func_222521_a();
        Stream<Object> \u26034 = VoxelShapes.func_197879_c(\u26033, VoxelShapes.func_197881_a(axisAlignedBB.func_186664_h(1.0E-7)), IBooleanFunction.field_223238_i_) ? Stream.empty() : Stream.of(\u26033);
        Stream<VoxelShape> \u26035 = this.field_70170_p.func_230318_c_(this, axisAlignedBB.func_216361_a(vector3d), entity -> true);
        ReuseableStream<VoxelShape> \u26036 = new ReuseableStream<VoxelShape>(Stream.concat(\u26035, \u26034));
        Vector3d \u26037 = vector3d.func_189985_c() == 0.0 ? vector3d : Entity.func_223307_a(this, vector3d, axisAlignedBB, this.field_70170_p, \u26032, \u26036);
        boolean \u26038 = vector3d.field_72450_a != \u26037.field_72450_a;
        boolean \u26039 = vector3d.field_72448_b != \u26037.field_72448_b;
        boolean \u260310 = vector3d.field_72449_c != \u26037.field_72449_c;
        boolean bl = \u2603 = this.field_70122_E || \u26039 && vector3d.field_72448_b < 0.0;
        if (this.field_70138_W > 0.0f && \u2603 && (\u26038 || \u260310)) {
            Vector3d vector3d2 = Entity.func_223307_a(this, new Vector3d(vector3d.field_72450_a, this.field_70138_W, vector3d.field_72449_c), axisAlignedBB, this.field_70170_p, \u26032, \u26036);
            \u2603 = Entity.func_223307_a(this, new Vector3d(0.0, this.field_70138_W, 0.0), axisAlignedBB.func_72321_a(vector3d.field_72450_a, 0.0, vector3d.field_72449_c), this.field_70170_p, \u26032, \u26036);
            if (\u2603.field_72448_b < (double)this.field_70138_W && Entity.func_213296_b(\u2603 = Entity.func_223307_a(this, new Vector3d(vector3d.field_72450_a, 0.0, vector3d.field_72449_c), axisAlignedBB.func_191194_a(\u2603), this.field_70170_p, \u26032, \u26036).func_178787_e(\u2603)) > Entity.func_213296_b(vector3d2)) {
                vector3d2 = \u2603;
            }
            if (Entity.func_213296_b(vector3d2) > Entity.func_213296_b(\u26037)) {
                return vector3d2.func_178787_e(Entity.func_223307_a(this, new Vector3d(0.0, -vector3d2.field_72448_b + vector3d.field_72448_b, 0.0), axisAlignedBB.func_191194_a(vector3d2), this.field_70170_p, \u26032, \u26036));
            }
        }
        return \u26037;
    }

    public static double func_213296_b(Vector3d vector3d) {
        return vector3d.field_72450_a * vector3d.field_72450_a + vector3d.field_72449_c * vector3d.field_72449_c;
    }

    public static Vector3d func_223307_a(@Nullable Entity entity, Vector3d vector3d, AxisAlignedBB axisAlignedBB, World world, ISelectionContext iSelectionContext, ReuseableStream<VoxelShape> reuseableStream) {
        boolean bl = vector3d.field_72450_a == 0.0;
        \u2603 = vector3d.field_72448_b == 0.0;
        boolean bl2 = \u2603 = vector3d.field_72449_c == 0.0;
        if (bl && \u2603 || bl && \u2603 || \u2603 && \u2603) {
            return Entity.func_213313_a(vector3d, axisAlignedBB, world, iSelectionContext, reuseableStream);
        }
        ReuseableStream<VoxelShape> \u26032 = new ReuseableStream<VoxelShape>(Stream.concat(reuseableStream.func_212761_a(), world.func_226666_b_(entity, axisAlignedBB.func_216361_a(vector3d))));
        return Entity.func_223310_a(vector3d, axisAlignedBB, \u26032);
    }

    public static Vector3d func_223310_a(Vector3d vector3d, AxisAlignedBB axisAlignedBB2, ReuseableStream<VoxelShape> reuseableStream) {
        boolean bl;
        AxisAlignedBB axisAlignedBB2;
        double d = vector3d.field_72450_a;
        \u2603 = vector3d.field_72448_b;
        d2 = vector3d.field_72449_c;
        if (\u2603 != 0.0 && (\u2603 = VoxelShapes.func_212437_a(Direction.Axis.Y, axisAlignedBB2, reuseableStream.func_212761_a(), \u2603)) != 0.0) {
            axisAlignedBB2 = axisAlignedBB2.func_72317_d(0.0, \u2603, 0.0);
        }
        boolean bl2 = bl = Math.abs(d) < Math.abs(d2);
        if (bl && d2 != 0.0 && (d2 = VoxelShapes.func_212437_a(Direction.Axis.Z, axisAlignedBB2, reuseableStream.func_212761_a(), d2)) != 0.0) {
            axisAlignedBB2 = axisAlignedBB2.func_72317_d(0.0, 0.0, d2);
        }
        if (d != 0.0) {
            d = VoxelShapes.func_212437_a(Direction.Axis.X, axisAlignedBB2, reuseableStream.func_212761_a(), d);
            if (!bl && d != 0.0) {
                axisAlignedBB2 = axisAlignedBB2.func_72317_d(d, 0.0, 0.0);
            }
        }
        if (!bl && d2 != 0.0) {
            double d2 = VoxelShapes.func_212437_a(Direction.Axis.Z, axisAlignedBB2, reuseableStream.func_212761_a(), d2);
        }
        return new Vector3d(d, \u2603, d2);
    }

    public static Vector3d func_213313_a(Vector3d vector3d, AxisAlignedBB axisAlignedBB2, IWorldReader iWorldReader, ISelectionContext iSelectionContext, ReuseableStream<VoxelShape> reuseableStream) {
        boolean bl;
        AxisAlignedBB axisAlignedBB2;
        double d = vector3d.field_72450_a;
        \u2603 = vector3d.field_72448_b;
        d2 = vector3d.field_72449_c;
        if (\u2603 != 0.0 && (\u2603 = VoxelShapes.func_216383_a(Direction.Axis.Y, axisAlignedBB2, iWorldReader, \u2603, iSelectionContext, reuseableStream.func_212761_a())) != 0.0) {
            axisAlignedBB2 = axisAlignedBB2.func_72317_d(0.0, \u2603, 0.0);
        }
        boolean bl2 = bl = Math.abs(d) < Math.abs(d2);
        if (bl && d2 != 0.0 && (d2 = VoxelShapes.func_216383_a(Direction.Axis.Z, axisAlignedBB2, iWorldReader, d2, iSelectionContext, reuseableStream.func_212761_a())) != 0.0) {
            axisAlignedBB2 = axisAlignedBB2.func_72317_d(0.0, 0.0, d2);
        }
        if (d != 0.0) {
            d = VoxelShapes.func_216383_a(Direction.Axis.X, axisAlignedBB2, iWorldReader, d, iSelectionContext, reuseableStream.func_212761_a());
            if (!bl && d != 0.0) {
                axisAlignedBB2 = axisAlignedBB2.func_72317_d(d, 0.0, 0.0);
            }
        }
        if (!bl && d2 != 0.0) {
            double d2 = VoxelShapes.func_216383_a(Direction.Axis.Z, axisAlignedBB2, iWorldReader, d2, iSelectionContext, reuseableStream.func_212761_a());
        }
        return new Vector3d(d, \u2603, d2);
    }

    protected float func_203009_ad() {
        return (int)this.field_82151_R + 1;
    }

    public void func_174829_m() {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        this.func_226288_n_((axisAlignedBB.field_72340_a + axisAlignedBB.field_72336_d) / 2.0, axisAlignedBB.field_72338_b, (axisAlignedBB.field_72339_c + axisAlignedBB.field_72334_f) / 2.0);
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187549_bG;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187547_bF;
    }

    protected SoundEvent func_204208_ah() {
        return SoundEvents.field_187547_bF;
    }

    protected void func_145775_I() {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        BlockPos \u26032 = new BlockPos(axisAlignedBB.field_72340_a + 0.001, axisAlignedBB.field_72338_b + 0.001, axisAlignedBB.field_72339_c + 0.001);
        BlockPos \u26033 = new BlockPos(axisAlignedBB.field_72336_d - 0.001, axisAlignedBB.field_72337_e - 0.001, axisAlignedBB.field_72334_f - 0.001);
        BlockPos.Mutable \u26034 = new BlockPos.Mutable();
        if (this.field_70170_p.func_175707_a(\u26032, \u26033)) {
            for (int i = \u26032.func_177958_n(); i <= \u26033.func_177958_n(); ++i) {
                for (\u2603 = \u26032.func_177956_o(); \u2603 <= \u26033.func_177956_o(); ++\u2603) {
                    for (\u2603 = \u26032.func_177952_p(); \u2603 <= \u26033.func_177952_p(); ++\u2603) {
                        \u26034.func_181079_c(i, \u2603, \u2603);
                        BlockState blockState = this.field_70170_p.func_180495_p(\u26034);
                        try {
                            blockState.func_196950_a(this.field_70170_p, \u26034, this);
                            this.func_191955_a(blockState);
                            continue;
                        }
                        catch (Throwable \u26035) {
                            CrashReport crashReport = CrashReport.func_85055_a(\u26035, "Colliding entity with block");
                            CrashReportCategory \u26036 = crashReport.func_85058_a("Block being collided with");
                            CrashReportCategory.func_175750_a(\u26036, \u26034, blockState);
                            throw new ReportedException(crashReport);
                        }
                    }
                }
            }
        }
    }

    protected void func_191955_a(BlockState blockState) {
    }

    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        if (blockState.func_185904_a().func_76224_d()) {
            return;
        }
        \u2603 = this.field_70170_p.func_180495_p(blockPos.func_177984_a());
        SoundType soundType = \u2603.func_203425_a(Blocks.field_150433_aE) ? \u2603.func_215695_r() : blockState.func_215695_r();
        this.func_184185_a(soundType.func_185844_d(), soundType.func_185843_a() * 0.15f, soundType.func_185847_b());
    }

    protected void func_203006_d(float f) {
        this.func_184185_a(this.func_184184_Z(), f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
    }

    protected float func_191954_d(float f) {
        return 0.0f;
    }

    protected boolean func_191957_ae() {
        return false;
    }

    public void func_184185_a(SoundEvent soundEvent, float f, float f2) {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundEvent, this.func_184176_by(), f, f2);
        }
    }

    public boolean func_174814_R() {
        return this.field_70180_af.func_187225_a(field_184234_aB);
    }

    public void func_174810_b(boolean bl) {
        this.field_70180_af.func_187227_b(field_184234_aB, bl);
    }

    public boolean func_189652_ae() {
        return this.field_70180_af.func_187225_a(field_189655_aD);
    }

    public void func_189654_d(boolean bl) {
        this.field_70180_af.func_187227_b(field_189655_aD, bl);
    }

    protected boolean func_225502_at_() {
        return true;
    }

    protected void func_184231_a(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
        if (bl) {
            if (this.field_70143_R > 0.0f) {
                blockState.func_177230_c().func_180658_a(this.field_70170_p, blockPos, this, this.field_70143_R);
            }
            this.field_70143_R = 0.0f;
        } else if (d < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - d);
        }
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_230279_az_() {
        return this.func_200600_R().func_220338_c();
    }

    public boolean func_225503_b_(float f, float f2) {
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184188_bt()) {
                entity.func_225503_b_(f, f2);
            }
        }
        return false;
    }

    public boolean func_70090_H() {
        return this.field_70171_ac;
    }

    private boolean func_209511_p() {
        BlockPos blockPos = this.func_233580_cy_();
        return this.field_70170_p.func_175727_C(blockPos) || this.field_70170_p.func_175727_C(blockPos.func_177963_a(0.0, this.field_213325_aI.field_220316_b, 0.0));
    }

    private boolean func_209512_q() {
        return this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_203425_a(Blocks.field_203203_C);
    }

    public boolean func_70026_G() {
        return this.func_70090_H() || this.func_209511_p();
    }

    public boolean func_203008_ap() {
        return this.func_70090_H() || this.func_209511_p() || this.func_209512_q();
    }

    public boolean func_203005_aq() {
        return this.func_70090_H() || this.func_209512_q();
    }

    public boolean func_204231_K() {
        return this.field_205013_W && this.func_70090_H();
    }

    public void func_205343_av() {
        if (this.func_203007_ba()) {
            this.func_204711_a(this.func_70051_ag() && this.func_70090_H() && !this.func_184218_aH());
        } else {
            this.func_204711_a(this.func_70051_ag() && this.func_204231_K() && !this.func_184218_aH());
        }
    }

    protected boolean func_233566_aG_() {
        this.field_233554_M_.clear();
        this.func_233567_aH_();
        if (this.func_70090_H()) {
            return true;
        }
        double d = this.field_70170_p.func_230315_m_().func_236040_e_() ? 0.007 : 0.0023333333333333335;
        return this.func_210500_b(FluidTags.field_206960_b, d);
    }

    void func_233567_aH_() {
        if (this.func_184187_bx() instanceof BoatEntity) {
            this.field_70171_ac = false;
        } else if (this.func_210500_b(FluidTags.field_206959_a, 0.014)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
    }

    private void func_205012_q() {
        BoatEntity \u26034;
        this.field_205013_W = this.func_208600_a(FluidTags.field_206959_a);
        this.field_241335_O_ = null;
        double d = this.func_226280_cw_() - 0.1111111119389534;
        Vector3d \u26032 = new Vector3d(this.func_226277_ct_(), d, this.func_226281_cx_());
        Entity \u26033 = this.func_184187_bx();
        if (\u26033 instanceof BoatEntity && !(\u26034 = (BoatEntity)\u26033).func_204231_K() && \u26034.func_174813_aQ().func_72318_a(\u26032)) {
            return;
        }
        BlockPos blockPos = new BlockPos(\u26032);
        FluidState \u26035 = this.field_70170_p.func_204610_c(blockPos);
        for (ITag iTag : FluidTags.func_241280_c_()) {
            if (!\u26035.func_206884_a(iTag)) continue;
            double d2 = (float)blockPos.func_177956_o() + \u26035.func_215679_a(this.field_70170_p, blockPos);
            if (d2 > d) {
                this.field_241335_O_ = iTag;
            }
            return;
        }
    }

    protected void func_71061_d_() {
        double d;
        Entity entity = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
        float \u26032 = entity == this ? 0.2f : 0.9f;
        Vector3d \u26033 = entity.func_213322_ci();
        float \u26034 = MathHelper.func_76133_a(\u26033.field_72450_a * \u26033.field_72450_a * (double)0.2f + \u26033.field_72448_b * \u26033.field_72448_b + \u26033.field_72449_c * \u26033.field_72449_c * (double)0.2f) * \u26032;
        if (\u26034 > 1.0f) {
            \u26034 = 1.0f;
        }
        if ((double)\u26034 < 0.25) {
            this.func_184185_a(this.func_184181_aa(), \u26034, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
        } else {
            this.func_184185_a(this.func_204208_ah(), \u26034, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
        }
        float \u26035 = MathHelper.func_76128_c(this.func_226278_cu_());
        int \u26036 = 0;
        while ((float)\u26036 < 1.0f + this.field_213325_aI.field_220315_a * 20.0f) {
            d = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_213325_aI.field_220315_a;
            \u2603 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_213325_aI.field_220315_a;
            this.field_70170_p.func_195594_a(ParticleTypes.field_197612_e, this.func_226277_ct_() + d, \u26035 + 1.0f, this.func_226281_cx_() + \u2603, \u26033.field_72450_a, \u26033.field_72448_b - this.field_70146_Z.nextDouble() * (double)0.2f, \u26033.field_72449_c);
            ++\u26036;
        }
        \u26036 = 0;
        while ((float)\u26036 < 1.0f + this.field_213325_aI.field_220315_a * 20.0f) {
            d = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_213325_aI.field_220315_a;
            \u2603 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.field_213325_aI.field_220315_a;
            this.field_70170_p.func_195594_a(ParticleTypes.field_218422_X, this.func_226277_ct_() + d, \u26035 + 1.0f, this.func_226281_cx_() + \u2603, \u26033.field_72450_a, \u26033.field_72448_b, \u26033.field_72449_c);
            ++\u26036;
        }
    }

    protected BlockState func_233568_aJ_() {
        return this.field_70170_p.func_180495_p(this.func_226268_ag_());
    }

    public boolean func_230269_aK_() {
        return this.func_70051_ag() && !this.func_70090_H() && !this.func_175149_v() && !this.func_213453_ef() && !this.func_180799_ab() && this.func_70089_S();
    }

    protected void func_233569_aL_() {
        int n = MathHelper.func_76128_c(this.func_226277_ct_());
        BlockPos \u26032 = new BlockPos(n, \u2603 = MathHelper.func_76128_c(this.func_226278_cu_() - (double)0.2f), \u2603 = MathHelper.func_76128_c(this.func_226281_cx_()));
        BlockState \u26033 = this.field_70170_p.func_180495_p(\u26032);
        if (\u26033.func_185901_i() != BlockRenderType.INVISIBLE) {
            Vector3d vector3d = this.func_213322_ci();
            this.field_70170_p.func_195594_a(new BlockParticleData(ParticleTypes.field_197611_d, \u26033), this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_213325_aI.field_220315_a, this.func_226278_cu_() + 0.1, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_213325_aI.field_220315_a, vector3d.field_72450_a * -4.0, 1.5, vector3d.field_72449_c * -4.0);
        }
    }

    public boolean func_208600_a(ITag<Fluid> iTag) {
        return this.field_241335_O_ == iTag;
    }

    public void func_213292_aB() {
        this.field_213329_S = true;
    }

    public boolean func_180799_ab() {
        return this.field_213329_S;
    }

    public void func_213309_a(float f, Vector3d vector3d) {
        \u2603 = Entity.func_213299_a(vector3d, f, this.field_70177_z);
        this.func_213317_d(this.func_213322_ci().func_178787_e(\u2603));
    }

    private static Vector3d func_213299_a(Vector3d vector3d, float f, float f2) {
        double d = vector3d.func_189985_c();
        if (d < 1.0E-7) {
            return Vector3d.field_186680_a;
        }
        Vector3d \u26032 = (d > 1.0 ? vector3d.func_72432_b() : vector3d).func_186678_a(f);
        float \u26033 = MathHelper.func_76126_a(f2 * ((float)Math.PI / 180));
        float \u26034 = MathHelper.func_76134_b(f2 * ((float)Math.PI / 180));
        return new Vector3d(\u26032.field_72450_a * (double)\u26034 - \u26032.field_72449_c * (double)\u26033, \u26032.field_72448_b, \u26032.field_72449_c * (double)\u26034 + \u26032.field_72450_a * (double)\u26033);
    }

    public float func_70013_c() {
        BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_226277_ct_(), 0.0, this.func_226281_cx_());
        if (this.field_70170_p.func_175667_e(mutable)) {
            mutable.func_185336_p(MathHelper.func_76128_c(this.func_226280_cw_()));
            return this.field_70170_p.func_205052_D(mutable);
        }
        return 0.0f;
    }

    public void func_70029_a(World world) {
        this.field_70170_p = world;
    }

    public void func_70080_a(double d, double d2, double d3, float f, float f2) {
        double d4 = MathHelper.func_151237_a(d, -3.0E7, 3.0E7);
        \u2603 = MathHelper.func_151237_a(d3, -3.0E7, 3.0E7);
        this.field_70169_q = d4;
        this.field_70167_r = d2;
        this.field_70166_s = \u2603;
        this.func_70107_b(d4, d2, \u2603);
        this.field_70177_z = f % 360.0f;
        this.field_70125_A = MathHelper.func_76131_a(f2, -90.0f, 90.0f) % 360.0f;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_233576_c_(Vector3d vector3d) {
        this.func_225653_b_(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    public void func_225653_b_(double d, double d2, double d3) {
        this.func_70012_b(d, d2, d3, this.field_70177_z, this.field_70125_A);
    }

    public void func_174828_a(BlockPos blockPos, float f, float f2) {
        this.func_70012_b((double)blockPos.func_177958_n() + 0.5, blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, f, f2);
    }

    public void func_70012_b(double d, double d2, double d3, float f, float f2) {
        this.func_226286_f_(d, d2, d3);
        this.field_70177_z = f;
        this.field_70125_A = f2;
        this.func_226264_Z_();
    }

    public void func_226286_f_(double d, double d2, double d3) {
        this.func_226288_n_(d, d2, d3);
        this.field_70169_q = d;
        this.field_70167_r = d2;
        this.field_70166_s = d3;
        this.field_70142_S = d;
        this.field_70137_T = d2;
        this.field_70136_U = d3;
    }

    public float func_70032_d(Entity entity) {
        float f = (float)(this.func_226277_ct_() - entity.func_226277_ct_());
        \u2603 = (float)(this.func_226278_cu_() - entity.func_226278_cu_());
        \u2603 = (float)(this.func_226281_cx_() - entity.func_226281_cx_());
        return MathHelper.func_76129_c(f * f + \u2603 * \u2603 + \u2603 * \u2603);
    }

    public double func_70092_e(double d, double d2, double d3) {
        \u2603 = this.func_226277_ct_() - d;
        \u2603 = this.func_226278_cu_() - d2;
        \u2603 = this.func_226281_cx_() - d3;
        return \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
    }

    public double func_70068_e(Entity entity) {
        return this.func_195048_a(entity.func_213303_ch());
    }

    public double func_195048_a(Vector3d vector3d) {
        double d = this.func_226277_ct_() - vector3d.field_72450_a;
        \u2603 = this.func_226278_cu_() - vector3d.field_72448_b;
        \u2603 = this.func_226281_cx_() - vector3d.field_72449_c;
        return d * d + \u2603 * \u2603 + \u2603 * \u2603;
    }

    public void func_70100_b_(PlayerEntity playerEntity) {
    }

    public void func_70108_f(Entity entity) {
        if (this.func_184223_x(entity)) {
            return;
        }
        if (entity.field_70145_X || this.field_70145_X) {
            return;
        }
        double d = entity.func_226277_ct_() - this.func_226277_ct_();
        \u2603 = MathHelper.func_76132_a(d, \u2603 = entity.func_226281_cx_() - this.func_226281_cx_());
        if (\u2603 >= (double)0.01f) {
            \u2603 = MathHelper.func_76133_a(\u2603);
            d /= \u2603;
            \u2603 /= \u2603;
            \u2603 = 1.0 / \u2603;
            if (\u2603 > 1.0) {
                \u2603 = 1.0;
            }
            d *= \u2603;
            \u2603 *= \u2603;
            d *= (double)0.05f;
            \u2603 *= (double)0.05f;
            d *= (double)(1.0f - this.field_70144_Y);
            \u2603 *= (double)(1.0f - this.field_70144_Y);
            if (!this.func_184207_aI()) {
                this.func_70024_g(-d, 0.0, -\u2603);
            }
            if (!entity.func_184207_aI()) {
                entity.func_70024_g(d, 0.0, \u2603);
            }
        }
    }

    public void func_70024_g(double d, double d2, double d3) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(d, d2, d3));
        this.field_70160_al = true;
    }

    protected void func_70018_K() {
        this.field_70133_I = true;
    }

    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        this.func_70018_K();
        return false;
    }

    public final Vector3d func_70676_i(float f) {
        return this.func_174806_f(this.func_195050_f(f), this.func_195046_g(f));
    }

    public float func_195050_f(float f) {
        if (f == 1.0f) {
            return this.field_70125_A;
        }
        return MathHelper.func_219799_g(f, this.field_70127_C, this.field_70125_A);
    }

    public float func_195046_g(float f) {
        if (f == 1.0f) {
            return this.field_70177_z;
        }
        return MathHelper.func_219799_g(f, this.field_70126_B, this.field_70177_z);
    }

    protected final Vector3d func_174806_f(float f, float f2) {
        \u2603 = f * ((float)Math.PI / 180);
        \u2603 = -f2 * ((float)Math.PI / 180);
        \u2603 = MathHelper.func_76134_b(\u2603);
        \u2603 = MathHelper.func_76126_a(\u2603);
        \u2603 = MathHelper.func_76134_b(\u2603);
        \u2603 = MathHelper.func_76126_a(\u2603);
        return new Vector3d(\u2603 * \u2603, -\u2603, \u2603 * \u2603);
    }

    public final Vector3d func_213286_i(float f) {
        return this.func_213320_d(this.func_195050_f(f), this.func_195046_g(f));
    }

    protected final Vector3d func_213320_d(float f, float f2) {
        return this.func_174806_f(f - 90.0f, f2);
    }

    public final Vector3d func_174824_e(float f) {
        if (f == 1.0f) {
            return new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        }
        double d = MathHelper.func_219803_d(f, this.field_70169_q, this.func_226277_ct_());
        \u2603 = MathHelper.func_219803_d(f, this.field_70167_r, this.func_226278_cu_()) + (double)this.func_70047_e();
        \u2603 = MathHelper.func_219803_d(f, this.field_70166_s, this.func_226281_cx_());
        return new Vector3d(d, \u2603, \u2603);
    }

    public RayTraceResult func_213324_a(double d, float f, boolean bl) {
        Vector3d vector3d = this.func_174824_e(f);
        \u2603 = this.func_70676_i(f);
        \u2603 = vector3d.func_72441_c(\u2603.field_72450_a * d, \u2603.field_72448_b * d, \u2603.field_72449_c * d);
        return this.field_70170_p.func_217299_a(new RayTraceContext(vector3d, \u2603, RayTraceContext.BlockMode.OUTLINE, bl ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, this));
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_191956_a(Entity entity, int n, DamageSource damageSource) {
        if (entity instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192123_c.func_192211_a((ServerPlayerEntity)entity, this, damageSource);
        }
    }

    public boolean func_184198_c(CompoundNBT compoundNBT) {
        String string = this.func_70022_Q();
        if (this.field_70128_L || string == null) {
            return false;
        }
        compoundNBT.func_74778_a("id", string);
        this.func_189511_e(compoundNBT);
        return true;
    }

    public boolean func_70039_c(CompoundNBT compoundNBT) {
        if (this.func_184218_aH()) {
            return false;
        }
        return this.func_184198_c(compoundNBT);
    }

    public CompoundNBT func_189511_e(CompoundNBT compoundNBT2) {
        try {
            if (this.field_184239_as != null) {
                compoundNBT2.func_218657_a("Pos", this.func_70087_a(this.field_184239_as.func_226277_ct_(), this.field_184239_as.func_226278_cu_(), this.field_184239_as.func_226281_cx_()));
            } else {
                compoundNBT2.func_218657_a("Pos", this.func_70087_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
            }
            Vector3d vector3d = this.func_213322_ci();
            compoundNBT2.func_218657_a("Motion", this.func_70087_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c));
            compoundNBT2.func_218657_a("Rotation", this.func_70049_a(this.field_70177_z, this.field_70125_A));
            compoundNBT2.func_74776_a("FallDistance", this.field_70143_R);
            compoundNBT2.func_74777_a("Fire", (short)this.field_190534_ay);
            compoundNBT2.func_74777_a("Air", (short)this.func_70086_ai());
            compoundNBT2.func_74757_a("OnGround", this.field_70122_E);
            compoundNBT2.func_74757_a("Invulnerable", this.field_83001_bt);
            compoundNBT2.func_74768_a("PortalCooldown", this.field_71088_bW);
            compoundNBT2.func_186854_a("UUID", this.func_110124_au());
            ITextComponent \u26032 = this.func_200201_e();
            if (\u26032 != null) {
                compoundNBT2.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a(\u26032));
            }
            if (this.func_174833_aM()) {
                compoundNBT2.func_74757_a("CustomNameVisible", this.func_174833_aM());
            }
            if (this.func_174814_R()) {
                compoundNBT2.func_74757_a("Silent", this.func_174814_R());
            }
            if (this.func_189652_ae()) {
                compoundNBT2.func_74757_a("NoGravity", this.func_189652_ae());
            }
            if (this.field_184238_ar) {
                compoundNBT2.func_74757_a("Glowing", this.field_184238_ar);
            }
            if (!this.field_184236_aF.isEmpty()) {
                ListNBT listNBT = new ListNBT();
                for (String string : this.field_184236_aF) {
                    listNBT.add(StringNBT.func_229705_a_(string));
                }
                compoundNBT2.func_218657_a("Tags", listNBT);
            }
            this.func_213281_b(compoundNBT2);
            if (this.func_184207_aI()) {
                ListNBT listNBT = new ListNBT();
                for (Entity entity : this.func_184188_bt()) {
                    if (!entity.func_184198_c(\u2603 = new CompoundNBT())) continue;
                    listNBT.add(\u2603);
                }
                if (!listNBT.isEmpty()) {
                    compoundNBT2.func_218657_a("Passengers", listNBT);
                }
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Saving entity NBT");
            CrashReportCategory \u26033 = crashReport.func_85058_a("Entity being saved");
            this.func_85029_a(\u26033);
            throw new ReportedException(crashReport);
        }
        return compoundNBT2;
    }

    public void func_70020_e(CompoundNBT compoundNBT2) {
        try {
            CompoundNBT compoundNBT2;
            ListNBT listNBT = compoundNBT2.func_150295_c("Pos", 6);
            \u2603 = compoundNBT2.func_150295_c("Motion", 6);
            \u2603 = compoundNBT2.func_150295_c("Rotation", 5);
            double \u26032 = \u2603.func_150309_d(0);
            double \u26033 = \u2603.func_150309_d(1);
            double \u26034 = \u2603.func_150309_d(2);
            this.func_213293_j(Math.abs(\u26032) > 10.0 ? 0.0 : \u26032, Math.abs(\u26033) > 10.0 ? 0.0 : \u26033, Math.abs(\u26034) > 10.0 ? 0.0 : \u26034);
            this.func_226286_f_(listNBT.func_150309_d(0), listNBT.func_150309_d(1), listNBT.func_150309_d(2));
            this.field_70177_z = \u2603.func_150308_e(0);
            this.field_70125_A = \u2603.func_150308_e(1);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
            this.func_70034_d(this.field_70177_z);
            this.func_181013_g(this.field_70177_z);
            this.field_70143_R = compoundNBT2.func_74760_g("FallDistance");
            this.field_190534_ay = compoundNBT2.func_74765_d("Fire");
            this.func_70050_g(compoundNBT2.func_74765_d("Air"));
            this.field_70122_E = compoundNBT2.func_74767_n("OnGround");
            this.field_83001_bt = compoundNBT2.func_74767_n("Invulnerable");
            this.field_71088_bW = compoundNBT2.func_74762_e("PortalCooldown");
            if (compoundNBT2.func_186855_b("UUID")) {
                this.field_96093_i = compoundNBT2.func_186857_a("UUID");
                this.field_189513_ar = this.field_96093_i.toString();
            }
            if (!(Double.isFinite(this.func_226277_ct_()) && Double.isFinite(this.func_226278_cu_()) && Double.isFinite(this.func_226281_cx_()))) {
                throw new IllegalStateException("Entity has invalid position");
            }
            if (!Double.isFinite(this.field_70177_z) || !Double.isFinite(this.field_70125_A)) {
                throw new IllegalStateException("Entity has invalid rotation");
            }
            this.func_226264_Z_();
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (compoundNBT2.func_150297_b("CustomName", 8)) {
                Object object = compoundNBT2.func_74779_i("CustomName");
                try {
                    this.func_200203_b(ITextComponent.Serializer.func_240643_a_((String)object));
                }
                catch (Exception \u26035) {
                    field_184243_a.warn("Failed to parse entity custom name {}", object, (Object)\u26035);
                }
            }
            this.func_174805_g(compoundNBT2.func_74767_n("CustomNameVisible"));
            this.func_174810_b(compoundNBT2.func_74767_n("Silent"));
            this.func_189654_d(compoundNBT2.func_74767_n("NoGravity"));
            this.func_184195_f(compoundNBT2.func_74767_n("Glowing"));
            if (compoundNBT2.func_150297_b("Tags", 9)) {
                this.field_184236_aF.clear();
                object = compoundNBT2.func_150295_c("Tags", 8);
                int \u26036 = Math.min(((ListNBT)object).size(), 1024);
                for (int i = 0; i < \u26036; ++i) {
                    this.field_184236_aF.add(((ListNBT)object).func_150307_f(i));
                }
            }
            this.func_70037_a(compoundNBT2);
            if (this.func_142008_O()) {
                this.func_226264_Z_();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Loading entity NBT");
            CrashReportCategory \u26037 = crashReport.func_85058_a("Entity being loaded");
            this.func_85029_a(\u26037);
            throw new ReportedException(crashReport);
        }
    }

    protected boolean func_142008_O() {
        return true;
    }

    @Nullable
    protected final String func_70022_Q() {
        EntityType<?> entityType = this.func_200600_R();
        ResourceLocation \u26032 = EntityType.func_200718_a(entityType);
        return !entityType.func_200715_a() || \u26032 == null ? null : \u26032.toString();
    }

    protected abstract void func_70037_a(CompoundNBT var1);

    protected abstract void func_213281_b(CompoundNBT var1);

    protected ListNBT func_70087_a(double ... dArray) {
        ListNBT listNBT = new ListNBT();
        for (double d : dArray) {
            listNBT.add(DoubleNBT.func_229684_a_(d));
        }
        return listNBT;
    }

    protected ListNBT func_70049_a(float ... fArray) {
        ListNBT listNBT = new ListNBT();
        for (float f : fArray) {
            listNBT.add(FloatNBT.func_229689_a_(f));
        }
        return listNBT;
    }

    @Nullable
    public ItemEntity func_199703_a(IItemProvider iItemProvider) {
        return this.func_199702_a(iItemProvider, 0);
    }

    @Nullable
    public ItemEntity func_199702_a(IItemProvider iItemProvider, int n) {
        return this.func_70099_a(new ItemStack(iItemProvider), n);
    }

    @Nullable
    public ItemEntity func_199701_a_(ItemStack itemStack) {
        return this.func_70099_a(itemStack, 0.0f);
    }

    @Nullable
    public ItemEntity func_70099_a(ItemStack itemStack, float f) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + (double)f, this.func_226281_cx_(), itemStack);
        itemEntity.func_174869_p();
        this.field_70170_p.func_217376_c(itemEntity);
        return itemEntity;
    }

    public boolean func_70089_S() {
        return !this.field_70128_L;
    }

    public boolean func_70094_T() {
        if (this.field_70145_X) {
            return false;
        }
        float f = 0.1f;
        \u2603 = this.field_213325_aI.field_220315_a * 0.8f;
        AxisAlignedBB \u26032 = AxisAlignedBB.func_241550_g_(\u2603, 0.1f, \u2603).func_72317_d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_241457_a_(this, \u26032, (blockState, blockPos) -> blockState.func_229980_m_(this.field_70170_p, (BlockPos)blockPos)).findAny().isPresent();
    }

    public ActionResultType func_184230_a(PlayerEntity playerEntity, Hand hand) {
        return ActionResultType.PASS;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    public void func_70098_U() {
        this.func_213317_d(Vector3d.field_186680_a);
        this.func_70071_h_();
        if (!this.func_184218_aH()) {
            return;
        }
        this.func_184187_bx().func_184232_k(this);
    }

    public void func_184232_k(Entity entity) {
        this.func_226266_a_(entity, Entity::func_70107_b);
    }

    private void func_226266_a_(Entity entity, IMoveCallback iMoveCallback) {
        if (!this.func_184196_w(entity)) {
            return;
        }
        double d = this.func_226278_cu_() + this.func_70042_X() + entity.func_70033_W();
        iMoveCallback.accept(entity, this.func_226277_ct_(), d, this.func_226281_cx_());
    }

    public double func_70033_W() {
        return 0.0;
    }

    public double func_70042_X() {
        return (double)this.field_213325_aI.field_220316_b * 0.75;
    }

    public boolean func_184220_m(Entity entity) {
        return this.func_184205_a(entity, false);
    }

    public boolean func_184205_a(Entity entity, boolean bl) {
        Entity entity2 = entity;
        while (entity2.field_184239_as != null) {
            if (entity2.field_184239_as == this) {
                return false;
            }
            entity2 = entity2.field_184239_as;
        }
        if (!(bl || this.func_184228_n(entity) && entity.func_184219_q(this))) {
            return false;
        }
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
        this.func_213301_b(Pose.STANDING);
        this.field_184239_as = entity;
        this.field_184239_as.func_184200_o(this);
        return true;
    }

    protected boolean func_184228_n(Entity entity) {
        return !this.func_225608_bj_() && this.field_184245_j <= 0;
    }

    protected boolean func_213298_c(Pose pose) {
        return this.field_70170_p.func_226665_a__(this, this.func_213321_d(pose).func_186664_h(1.0E-7));
    }

    public void func_184226_ay() {
        for (int i = this.field_184244_h.size() - 1; i >= 0; --i) {
            this.field_184244_h.get(i).func_184210_p();
        }
    }

    public void func_233575_bb_() {
        if (this.field_184239_as != null) {
            Entity entity = this.field_184239_as;
            this.field_184239_as = null;
            entity.func_184225_p(this);
        }
    }

    public void func_184210_p() {
        this.func_233575_bb_();
    }

    protected void func_184200_o(Entity entity) {
        if (entity.func_184187_bx() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (!this.field_70170_p.field_72995_K && entity instanceof PlayerEntity && !(this.func_184179_bs() instanceof PlayerEntity)) {
            this.field_184244_h.add(0, entity);
        } else {
            this.field_184244_h.add(entity);
        }
    }

    protected void func_184225_p(Entity entity) {
        if (entity.func_184187_bx() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        this.field_184244_h.remove(entity);
        entity.field_184245_j = 60;
    }

    protected boolean func_184219_q(Entity entity) {
        return this.func_184188_bt().size() < 1;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public Vector3d func_70040_Z() {
        return this.func_174806_f(this.field_70125_A, this.field_70177_z);
    }

    public Vector2f func_189653_aC() {
        return new Vector2f(this.field_70125_A, this.field_70177_z);
    }

    public void func_181015_d(BlockPos blockPos) {
        if (this.field_71088_bW > 0) {
            this.field_71088_bW = this.func_82147_ab();
            return;
        }
        if (!this.field_70170_p.field_72995_K && !blockPos.equals(this.field_181016_an)) {
            this.field_181016_an = new BlockPos(blockPos);
            NetherPortalBlock cfr_ignored_0 = (NetherPortalBlock)Blocks.field_150427_aO;
            BlockPattern.PatternHelper patternHelper = NetherPortalBlock.func_181089_f(this.field_70170_p, this.field_181016_an);
            double \u26032 = patternHelper.func_177669_b().func_176740_k() == Direction.Axis.X ? (double)patternHelper.func_181117_a().func_177952_p() : (double)patternHelper.func_181117_a().func_177958_n();
            double \u26033 = MathHelper.func_151237_a(Math.abs(MathHelper.func_233020_c_((patternHelper.func_177669_b().func_176740_k() == Direction.Axis.X ? this.func_226281_cx_() : this.func_226277_ct_()) - (double)(patternHelper.func_177669_b().func_176746_e().func_176743_c() == Direction.AxisDirection.NEGATIVE ? 1 : 0), \u26032, \u26032 - (double)patternHelper.func_181118_d())), 0.0, 1.0);
            double \u26034 = MathHelper.func_151237_a(MathHelper.func_233020_c_(this.func_226278_cu_() - 1.0, patternHelper.func_181117_a().func_177956_o(), patternHelper.func_181117_a().func_177956_o() - patternHelper.func_181119_e()), 0.0, 1.0);
            this.field_181017_ao = new Vector3d(\u26033, \u26034, 0.0);
            this.field_181018_ap = patternHelper.func_177669_b();
        }
        this.field_71087_bX = true;
    }

    protected void func_213284_aV() {
        if (!(this.field_70170_p instanceof ServerWorld)) {
            return;
        }
        int n = this.func_82145_z();
        ServerWorld \u26032 = (ServerWorld)this.field_70170_p;
        if (this.field_71087_bX) {
            MinecraftServer minecraftServer = \u26032.func_73046_m();
            ServerWorld \u26033 = minecraftServer.func_71218_a(\u2603 = this.field_70170_p.func_234923_W_() == World.field_234919_h_ ? World.field_234918_g_ : World.field_234919_h_);
            if (\u26033 != null && minecraftServer.func_71255_r() && !this.func_184218_aH() && this.field_82153_h++ >= n) {
                this.field_70170_p.func_217381_Z().func_76320_a("portal");
                this.field_82153_h = n;
                this.field_71088_bW = this.func_82147_ab();
                this.func_241206_a_(\u26033);
                this.field_70170_p.func_217381_Z().func_76319_b();
            }
            this.field_71087_bX = false;
        } else {
            if (this.field_82153_h > 0) {
                this.field_82153_h -= 4;
            }
            if (this.field_82153_h < 0) {
                this.field_82153_h = 0;
            }
        }
        this.func_184173_H();
    }

    public int func_82147_ab() {
        return 300;
    }

    public Iterable<ItemStack> func_184214_aD() {
        return field_190535_b;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return field_190535_b;
    }

    public Iterable<ItemStack> func_184209_aF() {
        return Iterables.concat(this.func_184214_aD(), this.func_184193_aE());
    }

    public void func_184201_a(EquipmentSlotType equipmentSlotType, ItemStack itemStack) {
    }

    public boolean func_70027_ad() {
        boolean bl = this.field_70170_p != null && this.field_70170_p.field_72995_K;
        return !this.func_230279_az_() && (this.field_190534_ay > 0 || bl && this.func_70083_f(0));
    }

    public boolean func_184218_aH() {
        return this.func_184187_bx() != null;
    }

    public boolean func_184207_aI() {
        return !this.func_184188_bt().isEmpty();
    }

    public boolean func_205710_ba() {
        return true;
    }

    public void func_226284_e_(boolean bl) {
        this.func_70052_a(1, bl);
    }

    public boolean func_225608_bj_() {
        return this.func_70083_f(1);
    }

    public boolean func_226271_bk_() {
        return this.func_225608_bj_();
    }

    public boolean func_226272_bl_() {
        return this.func_225608_bj_();
    }

    public boolean func_226273_bm_() {
        return this.func_225608_bj_();
    }

    public boolean func_226274_bn_() {
        return this.func_225608_bj_();
    }

    public boolean func_213453_ef() {
        return this.func_213283_Z() == Pose.CROUCHING;
    }

    public boolean func_70051_ag() {
        return this.func_70083_f(3);
    }

    public void func_70031_b(boolean bl) {
        this.func_70052_a(3, bl);
    }

    public boolean func_203007_ba() {
        return this.func_70083_f(4);
    }

    public boolean func_213314_bj() {
        return this.func_213283_Z() == Pose.SWIMMING;
    }

    public void func_204711_a(boolean bl) {
        this.func_70052_a(4, bl);
    }

    public boolean func_225510_bt_() {
        return this.field_184238_ar || this.field_70170_p.field_72995_K && this.func_70083_f(6);
    }

    public void func_184195_f(boolean bl) {
        this.field_184238_ar = bl;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.field_184238_ar);
        }
    }

    public boolean func_82150_aj() {
        return this.func_70083_f(5);
    }

    @Nullable
    public Team func_96124_cp() {
        return this.field_70170_p.func_96441_U().func_96509_i(this.func_195047_I_());
    }

    public boolean func_184191_r(Entity entity) {
        return this.func_184194_a(entity.func_96124_cp());
    }

    public boolean func_184194_a(Team team) {
        if (this.func_96124_cp() != null) {
            return this.func_96124_cp().func_142054_a(team);
        }
        return false;
    }

    public void func_82142_c(boolean bl) {
        this.func_70052_a(5, bl);
    }

    protected boolean func_70083_f(int n) {
        return (this.field_70180_af.func_187225_a(field_184240_ax) & 1 << n) != 0;
    }

    protected void func_70052_a(int n, boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184240_ax);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184240_ax, (byte)(by | 1 << n));
        } else {
            this.field_70180_af.func_187227_b(field_184240_ax, (byte)(by & ~(1 << n)));
        }
    }

    public int func_205010_bg() {
        return 300;
    }

    public int func_70086_ai() {
        return this.field_70180_af.func_187225_a(field_184241_ay);
    }

    public void func_70050_g(int n) {
        this.field_70180_af.func_187227_b(field_184241_ay, n);
    }

    public void func_70077_a(LightningBoltEntity lightningBoltEntity) {
        this.func_241209_g_(this.field_190534_ay + 1);
        if (this.field_190534_ay == 0) {
            this.func_70015_d(8);
        }
        this.func_70097_a(DamageSource.field_180137_b, 5.0f);
    }

    public void func_203002_i(boolean bl) {
        Vector3d vector3d = this.func_213322_ci();
        double \u26032 = bl ? Math.max(-0.9, vector3d.field_72448_b - 0.03) : Math.min(1.8, vector3d.field_72448_b + 0.1);
        this.func_213293_j(vector3d.field_72450_a, \u26032, vector3d.field_72449_c);
    }

    public void func_203004_j(boolean bl) {
        Vector3d vector3d = this.func_213322_ci();
        double \u26032 = bl ? Math.max(-0.3, vector3d.field_72448_b - 0.03) : Math.min(0.7, vector3d.field_72448_b + 0.06);
        this.func_213293_j(vector3d.field_72450_a, \u26032, vector3d.field_72449_c);
        this.field_70143_R = 0.0f;
    }

    public void func_70074_a(LivingEntity livingEntity) {
    }

    protected void func_213282_i(double d, double d2, double d3) {
        BlockPos blockPos = new BlockPos(d, d2, d3);
        Vector3d \u26032 = new Vector3d(d - (double)blockPos.func_177958_n(), d2 - (double)blockPos.func_177956_o(), d3 - (double)blockPos.func_177952_p());
        BlockPos.Mutable \u26033 = new BlockPos.Mutable();
        Direction \u26034 = Direction.UP;
        double \u26035 = Double.MAX_VALUE;
        for (Direction direction : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            \u26033.func_239622_a_(blockPos, direction);
            if (this.field_70170_p.func_180495_p(\u26033).func_235785_r_(this.field_70170_p, \u26033)) continue;
            double d4 = \u26032.func_216370_a(direction.func_176740_k());
            double d5 = \u2603 = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1.0 - d4 : d4;
            if (!(\u2603 < \u26035)) continue;
            \u26035 = \u2603;
            \u26034 = direction;
        }
        float f = this.field_70146_Z.nextFloat() * 0.2f + 0.1f;
        \u2603 = \u26034.func_176743_c().func_179524_a();
        Vector3d \u26036 = this.func_213322_ci().func_186678_a(0.75);
        if (\u26034.func_176740_k() == Direction.Axis.X) {
            this.func_213293_j(\u2603 * f, \u26036.field_72448_b, \u26036.field_72449_c);
        } else if (\u26034.func_176740_k() == Direction.Axis.Y) {
            this.func_213293_j(\u26036.field_72450_a, \u2603 * f, \u26036.field_72449_c);
        } else if (\u26034.func_176740_k() == Direction.Axis.Z) {
            this.func_213293_j(\u26036.field_72450_a, \u26036.field_72448_b, \u2603 * f);
        }
    }

    public void func_213295_a(BlockState blockState, Vector3d vector3d) {
        this.field_70143_R = 0.0f;
        this.field_213328_B = vector3d;
    }

    private static ITextComponent func_233573_b_(ITextComponent iTextComponent) {
        IFormattableTextComponent iFormattableTextComponent = iTextComponent.func_230531_f_().func_230530_a_(iTextComponent.func_150256_b().func_240715_a_(null));
        for (ITextComponent iTextComponent2 : iTextComponent.func_150253_a()) {
            iFormattableTextComponent.func_230529_a_(Entity.func_233573_b_(iTextComponent2));
        }
        return iFormattableTextComponent;
    }

    @Override
    public ITextComponent func_200200_C_() {
        ITextComponent iTextComponent = this.func_200201_e();
        if (iTextComponent != null) {
            return Entity.func_233573_b_(iTextComponent);
        }
        return this.func_225513_by_();
    }

    protected ITextComponent func_225513_by_() {
        return this.field_200606_g.func_212546_e();
    }

    public boolean func_70028_i(Entity entity) {
        return this == entity;
    }

    public float func_70079_am() {
        return 0.0f;
    }

    public void func_70034_d(float f) {
    }

    public void func_181013_g(float f) {
    }

    public boolean func_70075_an() {
        return true;
    }

    public boolean func_85031_j(Entity entity) {
        return false;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.func_200200_C_().getString(), this.field_145783_c, this.field_70170_p == null ? "~NULL~" : this.field_70170_p.toString(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public boolean func_180431_b(DamageSource damageSource) {
        return this.field_83001_bt && damageSource != DamageSource.field_76380_i && !damageSource.func_180136_u();
    }

    public boolean func_190530_aW() {
        return this.field_83001_bt;
    }

    public void func_184224_h(boolean bl) {
        this.field_83001_bt = bl;
    }

    public void func_82149_j(Entity entity) {
        this.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
    }

    public void func_180432_n(Entity entity) {
        CompoundNBT compoundNBT = entity.func_189511_e(new CompoundNBT());
        compoundNBT.func_82580_o("Dimension");
        this.func_70020_e(compoundNBT);
        this.field_71088_bW = entity.field_71088_bW;
        this.field_181016_an = entity.field_181016_an;
        this.field_181017_ao = entity.field_181017_ao;
        this.field_181018_ap = entity.field_181018_ap;
    }

    @Nullable
    public Entity func_241206_a_(ServerWorld serverWorld2) {
        ServerWorld serverWorld2;
        BlockPos \u26036;
        if (!(this.field_70170_p instanceof ServerWorld) || this.field_70128_L) {
            return null;
        }
        this.field_70170_p.func_217381_Z().func_76320_a("changeDimension");
        this.func_213319_R();
        this.field_70170_p.func_217381_Z().func_76320_a("reposition");
        Vector3d \u26038 = this.func_213322_ci();
        float \u26032 = 0.0f;
        if (this.field_70170_p.func_234923_W_() == World.field_234920_i_ && serverWorld2.func_234923_W_() == World.field_234918_g_) {
            \u26036 = serverWorld2.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, serverWorld2.func_241135_u_());
        } else if (serverWorld2.func_234923_W_() == World.field_234920_i_) {
            \u26036 = ServerWorld.field_241108_a_;
        } else {
            double d = this.func_226277_ct_();
            \u2603 = this.func_226281_cx_();
            DimensionType \u26033 = this.field_70170_p.func_230315_m_();
            DimensionType \u26034 = serverWorld2.func_230315_m_();
            \u2603 = 8.0;
            if (!\u26033.func_236045_g_() && \u26034.func_236045_g_()) {
                d /= 8.0;
                \u2603 /= 8.0;
            } else if (\u26033.func_236045_g_() && !\u26034.func_236045_g_()) {
                d *= 8.0;
                \u2603 *= 8.0;
            }
            \u2603 = Math.min(-2.9999872E7, serverWorld2.func_175723_af().func_177726_b() + 16.0);
            \u2603 = Math.min(-2.9999872E7, serverWorld2.func_175723_af().func_177736_c() + 16.0);
            \u2603 = Math.min(2.9999872E7, serverWorld2.func_175723_af().func_177728_d() - 16.0);
            \u2603 = Math.min(2.9999872E7, serverWorld2.func_175723_af().func_177733_e() - 16.0);
            d = MathHelper.func_151237_a(d, \u2603, \u2603);
            \u2603 = MathHelper.func_151237_a(\u2603, \u2603, \u2603);
            Vector3d \u26035 = this.func_181014_aG();
            \u26036 = new BlockPos(d, this.func_226278_cu_(), \u2603);
            BlockPattern.PortalInfo \u26037 = serverWorld2.func_85176_s().func_222272_a(\u26036, \u26038, this.func_181012_aH(), \u26035.field_72450_a, \u26035.field_72448_b, this instanceof PlayerEntity);
            if (\u26037 == null) {
                return null;
            }
            \u26036 = new BlockPos(\u26037.field_222505_a);
            \u26038 = \u26037.field_222506_b;
            \u26032 = \u26037.field_222507_c;
        }
        this.field_70170_p.func_217381_Z().func_219895_b("reloading");
        Object obj = this.func_200600_R().func_200721_a(serverWorld2);
        if (obj != null) {
            ((Entity)obj).func_180432_n(this);
            ((Entity)obj).func_174828_a(\u26036, ((Entity)obj).field_70177_z + \u26032, ((Entity)obj).field_70125_A);
            ((Entity)obj).func_213317_d(\u26038);
            serverWorld2.func_217460_e((Entity)obj);
            if (serverWorld2.func_234923_W_() == World.field_234920_i_) {
                ServerWorld.func_241121_a_(serverWorld2);
            }
        }
        this.func_241204_bJ_();
        this.field_70170_p.func_217381_Z().func_76319_b();
        ((ServerWorld)this.field_70170_p).func_82742_i();
        serverWorld2.func_82742_i();
        this.field_70170_p.func_217381_Z().func_76319_b();
        return obj;
    }

    protected void func_241204_bJ_() {
        this.field_70128_L = true;
    }

    public boolean func_184222_aU() {
        return true;
    }

    public float func_180428_a(Explosion explosion, IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, FluidState fluidState, float f) {
        return f;
    }

    public boolean func_174816_a(Explosion explosion, IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, float f) {
        return true;
    }

    public int func_82143_as() {
        return 3;
    }

    public Vector3d func_181014_aG() {
        return this.field_181017_ao;
    }

    public Direction func_181012_aH() {
        return this.field_181018_ap;
    }

    public boolean func_145773_az() {
        return false;
    }

    public void func_85029_a(CrashReportCategory crashReportCategory) {
        crashReportCategory.func_189529_a("Entity Type", () -> EntityType.func_200718_a(this.func_200600_R()) + " (" + this.getClass().getCanonicalName() + ")");
        crashReportCategory.func_71507_a("Entity ID", this.field_145783_c);
        crashReportCategory.func_189529_a("Entity Name", () -> this.func_200200_C_().getString());
        crashReportCategory.func_71507_a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
        crashReportCategory.func_71507_a("Entity's Block location", CrashReportCategory.func_184876_a(MathHelper.func_76128_c(this.func_226277_ct_()), MathHelper.func_76128_c(this.func_226278_cu_()), MathHelper.func_76128_c(this.func_226281_cx_())));
        Vector3d vector3d = this.func_213322_ci();
        crashReportCategory.func_71507_a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c));
        crashReportCategory.func_189529_a("Entity's Passengers", () -> this.func_184188_bt().toString());
        crashReportCategory.func_189529_a("Entity's Vehicle", () -> this.func_184187_bx().toString());
    }

    public void func_184221_a(UUID uUID) {
        this.field_96093_i = uUID;
        this.field_189513_ar = this.field_96093_i.toString();
    }

    public UUID func_110124_au() {
        return this.field_96093_i;
    }

    public String func_189512_bd() {
        return this.field_189513_ar;
    }

    public String func_195047_I_() {
        return this.field_189513_ar;
    }

    public boolean func_96092_aw() {
        return true;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return ScorePlayerTeam.func_237500_a_(this.func_96124_cp(), this.func_200200_C_()).func_240700_a_(style -> style.func_240716_a_(this.func_174823_aP()).func_240714_a_(this.func_189512_bd()));
    }

    public void func_200203_b(@Nullable ITextComponent iTextComponent) {
        this.field_70180_af.func_187227_b(field_184242_az, Optional.ofNullable(iTextComponent));
    }

    @Override
    @Nullable
    public ITextComponent func_200201_e() {
        return this.field_70180_af.func_187225_a(field_184242_az).orElse(null);
    }

    @Override
    public boolean func_145818_k_() {
        return this.field_70180_af.func_187225_a(field_184242_az).isPresent();
    }

    public void func_174805_g(boolean bl) {
        this.field_70180_af.func_187227_b(field_184233_aA, bl);
    }

    public boolean func_174833_aM() {
        return this.field_70180_af.func_187225_a(field_184233_aA);
    }

    public final void func_223102_j(double d, double d2, double d3) {
        if (!(this.field_70170_p instanceof ServerWorld)) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos(d, d2, d3));
        ((ServerWorld)this.field_70170_p).func_72863_F().func_217228_a(TicketType.field_223185_g, chunkPos, 0, this.func_145782_y());
        this.field_70170_p.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
        this.func_70634_a(d, d2, d3);
    }

    public void func_70634_a(double d, double d2, double d3) {
        if (!(this.field_70170_p instanceof ServerWorld)) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
        this.func_70012_b(d, d2, d3, this.field_70177_z, this.field_70125_A);
        this.func_226276_cg_().forEach(entity -> {
            serverWorld.func_217464_b((Entity)entity);
            entity.field_184237_aG = true;
            for (Entity entity2 : entity.field_184244_h) {
                entity.func_226266_a_(entity2, Entity::func_225653_b_);
            }
        });
    }

    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_213330_X.equals(dataParameter)) {
            this.func_213323_x_();
        }
    }

    public void func_213323_x_() {
        EntitySize entitySize = this.field_213325_aI;
        Pose \u26032 = this.func_213283_Z();
        this.field_213325_aI = \u2603 = this.func_213305_a(\u26032);
        this.field_213326_aJ = this.func_213316_a(\u26032, \u2603);
        if (\u2603.field_220315_a < entitySize.field_220315_a) {
            double d = (double)\u2603.field_220315_a / 2.0;
            this.func_174826_a(new AxisAlignedBB(this.func_226277_ct_() - d, this.func_226278_cu_(), this.func_226281_cx_() - d, this.func_226277_ct_() + d, this.func_226278_cu_() + (double)\u2603.field_220316_b, this.func_226281_cx_() + d));
            return;
        }
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        this.func_174826_a(new AxisAlignedBB(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c, axisAlignedBB.field_72340_a + (double)\u2603.field_220315_a, axisAlignedBB.field_72338_b + (double)\u2603.field_220316_b, axisAlignedBB.field_72339_c + (double)\u2603.field_220315_a));
        if (\u2603.field_220315_a > entitySize.field_220315_a && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
            float f = entitySize.field_220315_a - \u2603.field_220315_a;
            this.func_213315_a(MoverType.SELF, new Vector3d(f, 0.0, f));
        }
    }

    public Direction func_174811_aO() {
        return Direction.func_176733_a(this.field_70177_z);
    }

    public Direction func_184172_bi() {
        return this.func_174811_aO();
    }

    protected HoverEvent func_174823_aP() {
        return new HoverEvent(HoverEvent.Action.field_230552_c_, new HoverEvent.EntityHover(this.func_200600_R(), this.func_110124_au(), this.func_200200_C_()));
    }

    public boolean func_174827_a(ServerPlayerEntity serverPlayerEntity) {
        return true;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.field_70121_D;
    }

    protected AxisAlignedBB func_213321_d(Pose pose) {
        EntitySize entitySize = this.func_213305_a(pose);
        float \u26032 = entitySize.field_220315_a / 2.0f;
        Vector3d \u26033 = new Vector3d(this.func_226277_ct_() - (double)\u26032, this.func_226278_cu_(), this.func_226281_cx_() - (double)\u26032);
        Vector3d \u26034 = new Vector3d(this.func_226277_ct_() + (double)\u26032, this.func_226278_cu_() + (double)entitySize.field_220316_b, this.func_226281_cx_() + (double)\u26032);
        return new AxisAlignedBB(\u26033, \u26034);
    }

    public void func_174826_a(AxisAlignedBB axisAlignedBB) {
        this.field_70121_D = axisAlignedBB;
    }

    protected float func_213316_a(Pose pose, EntitySize entitySize) {
        return entitySize.field_220316_b * 0.85f;
    }

    public final float func_70047_e() {
        return this.field_213326_aJ;
    }

    public boolean func_174820_d(int n, ItemStack itemStack) {
        return false;
    }

    @Override
    public void func_145747_a(ITextComponent iTextComponent, UUID uUID) {
    }

    public World func_130014_f_() {
        return this.field_70170_p;
    }

    @Nullable
    public MinecraftServer func_184102_h() {
        return this.field_70170_p.func_73046_m();
    }

    public ActionResultType func_184199_a(PlayerEntity playerEntity, Vector3d vector3d, Hand hand) {
        return ActionResultType.PASS;
    }

    public boolean func_180427_aV() {
        return false;
    }

    public void func_174815_a(LivingEntity livingEntity, Entity entity) {
        if (entity instanceof LivingEntity) {
            EnchantmentHelper.func_151384_a((LivingEntity)entity, livingEntity);
        }
        EnchantmentHelper.func_151385_b(livingEntity, entity);
    }

    public void func_184178_b(ServerPlayerEntity serverPlayerEntity) {
    }

    public void func_184203_c(ServerPlayerEntity serverPlayerEntity) {
    }

    public float func_184229_a(Rotation rotation) {
        float f = MathHelper.func_76142_g(this.field_70177_z);
        switch (rotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 270.0f;
            }
            case CLOCKWISE_90: {
                return f + 90.0f;
            }
        }
        return f;
    }

    public float func_184217_a(Mirror mirror) {
        float f = MathHelper.func_76142_g(this.field_70177_z);
        switch (mirror) {
            case LEFT_RIGHT: {
                return -f;
            }
            case FRONT_BACK: {
                return 180.0f - f;
            }
        }
        return f;
    }

    public boolean func_184213_bq() {
        return false;
    }

    public boolean func_233577_ch_() {
        boolean bl = this.field_184237_aG;
        this.field_184237_aG = false;
        return bl;
    }

    public boolean func_233578_ci_() {
        boolean bl = this.field_233555_aA_;
        this.field_233555_aA_ = false;
        return bl;
    }

    @Nullable
    public Entity func_184179_bs() {
        return null;
    }

    public List<Entity> func_184188_bt() {
        if (this.field_184244_h.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(this.field_184244_h);
    }

    public boolean func_184196_w(Entity entity) {
        for (Entity entity2 : this.func_184188_bt()) {
            if (!entity2.equals(entity)) continue;
            return true;
        }
        return false;
    }

    public boolean func_205708_a(Class<? extends Entity> clazz) {
        for (Entity entity : this.func_184188_bt()) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }

    public Collection<Entity> func_184182_bu() {
        HashSet hashSet = Sets.newHashSet();
        for (Entity entity : this.func_184188_bt()) {
            hashSet.add(entity);
            entity.func_200604_a(false, hashSet);
        }
        return hashSet;
    }

    public Stream<Entity> func_226276_cg_() {
        return Stream.concat(Stream.of(this), this.field_184244_h.stream().flatMap(Entity::func_226276_cg_));
    }

    public boolean func_200601_bK() {
        HashSet hashSet = Sets.newHashSet();
        this.func_200604_a(true, hashSet);
        return hashSet.size() == 1;
    }

    private void func_200604_a(boolean bl, Set<Entity> set) {
        for (Entity entity : this.func_184188_bt()) {
            if (!bl || ServerPlayerEntity.class.isAssignableFrom(entity.getClass())) {
                set.add(entity);
            }
            entity.func_200604_a(bl, set);
        }
    }

    public Entity func_184208_bv() {
        Entity entity = this;
        while (entity.func_184218_aH()) {
            entity = entity.func_184187_bx();
        }
        return entity;
    }

    public boolean func_184223_x(Entity entity) {
        return this.func_184208_bv() == entity.func_184208_bv();
    }

    public boolean func_184186_bw() {
        Entity entity = this.func_184179_bs();
        if (entity instanceof PlayerEntity) {
            return ((PlayerEntity)entity).func_175144_cb();
        }
        return !this.field_70170_p.field_72995_K;
    }

    protected static Vector3d func_233559_a_(double d, double d2, float f) {
        double d3 = (d + d2 + (double)1.0E-5f) / 2.0;
        float \u26032 = -MathHelper.func_76126_a(f * ((float)Math.PI / 180));
        float \u26033 = MathHelper.func_76134_b(f * ((float)Math.PI / 180));
        float \u26034 = Math.max(Math.abs(\u26032), Math.abs(\u26033));
        return new Vector3d((double)\u26032 * d3 / (double)\u26034, 0.0, (double)\u26033 * d3 / (double)\u26034);
    }

    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        return new Vector3d(this.func_226277_ct_(), this.func_174813_aQ().field_72337_e, this.func_226281_cx_());
    }

    @Nullable
    public Entity func_184187_bx() {
        return this.field_184239_as;
    }

    public PushReaction func_184192_z() {
        return PushReaction.NORMAL;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    protected int func_190531_bD() {
        return 1;
    }

    public CommandSource func_195051_bN() {
        return new CommandSource(this, this.func_213303_ch(), this.func_189653_aC(), this.field_70170_p instanceof ServerWorld ? (ServerWorld)this.field_70170_p : null, this.func_184840_I(), this.func_200200_C_().getString(), this.func_145748_c_(), this.field_70170_p.func_73046_m(), this);
    }

    protected int func_184840_I() {
        return 0;
    }

    public boolean func_211513_k(int n) {
        return this.func_184840_I() >= n;
    }

    @Override
    public boolean func_195039_a() {
        return this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223611_n);
    }

    @Override
    public boolean func_195040_b() {
        return true;
    }

    @Override
    public boolean func_195041_r_() {
        return true;
    }

    public void func_200602_a(EntityAnchorArgument.Type type, Vector3d vector3d) {
        \u2603 = type.func_201017_a(this);
        double d = vector3d.field_72450_a - \u2603.field_72450_a;
        \u2603 = vector3d.field_72448_b - \u2603.field_72448_b;
        \u2603 = vector3d.field_72449_c - \u2603.field_72449_c;
        \u2603 = MathHelper.func_76133_a(d * d + \u2603 * \u2603);
        this.field_70125_A = MathHelper.func_76142_g((float)(-(MathHelper.func_181159_b(\u2603, \u2603) * 57.2957763671875)));
        this.field_70177_z = MathHelper.func_76142_g((float)(MathHelper.func_181159_b(\u2603, d) * 57.2957763671875) - 90.0f);
        this.func_70034_d(this.field_70177_z);
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
    }

    public boolean func_210500_b(ITag<Fluid> iTag, double d) {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ().func_186664_h(0.001);
        int \u26032 = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        int \u26033 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        int \u26034 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        int \u26035 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e);
        int \u26036 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        if (!this.field_70170_p.func_217344_a(\u26032, \u26034, \u26036, \u26033, \u26035, \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f))) {
            return false;
        }
        double \u26037 = 0.0;
        boolean \u26038 = this.func_96092_aw();
        boolean \u26039 = false;
        Vector3d \u260310 = Vector3d.field_186680_a;
        int \u260311 = 0;
        BlockPos.Mutable \u260312 = new BlockPos.Mutable();
        for (int i = \u26032; i < \u26033; ++i) {
            for (\u2603 = \u26034; \u2603 < \u26035; ++\u2603) {
                for (\u2603 = \u26036; \u2603 < \u2603; ++\u2603) {
                    \u260312.func_181079_c(i, \u2603, \u2603);
                    FluidState fluidState = this.field_70170_p.func_204610_c(\u260312);
                    if (!fluidState.func_206884_a(iTag) || !((\u2603 = (double)((float)\u2603 + fluidState.func_215679_a(this.field_70170_p, \u260312))) >= axisAlignedBB.field_72338_b)) continue;
                    \u26039 = true;
                    \u26037 = Math.max(\u2603 - axisAlignedBB.field_72338_b, \u26037);
                    if (!\u26038) continue;
                    Vector3d \u260313 = fluidState.func_215673_c(this.field_70170_p, \u260312);
                    if (\u26037 < 0.4) {
                        \u260313 = \u260313.func_186678_a(\u26037);
                    }
                    \u260310 = \u260310.func_178787_e(\u260313);
                    ++\u260311;
                }
            }
        }
        if (\u260310.func_72433_c() > 0.0) {
            if (\u260311 > 0) {
                \u260310 = \u260310.func_186678_a(1.0 / (double)\u260311);
            }
            if (!(this instanceof PlayerEntity)) {
                \u260310 = \u260310.func_72432_b();
            }
            Vector3d vector3d = this.func_213322_ci();
            \u260310 = \u260310.func_186678_a(d * 1.0);
            double \u260314 = 0.003;
            if (Math.abs(vector3d.field_72450_a) < 0.003 && Math.abs(vector3d.field_72449_c) < 0.003 && \u260310.func_72433_c() < 0.0045000000000000005) {
                \u260310 = \u260310.func_72432_b().func_186678_a(0.0045000000000000005);
            }
            this.func_213317_d(this.func_213322_ci().func_178787_e(\u260310));
        }
        this.field_233554_M_.put(iTag, \u26037);
        return \u26039;
    }

    public double func_233571_b_(ITag<Fluid> iTag) {
        return this.field_233554_M_.getDouble(iTag);
    }

    public double func_233579_cu_() {
        return (double)this.func_70047_e() < 0.4 ? 0.0 : 0.4;
    }

    public final float func_213311_cf() {
        return this.field_213325_aI.field_220315_a;
    }

    public final float func_213302_cg() {
        return this.field_213325_aI.field_220316_b;
    }

    public abstract IPacket<?> func_213297_N();

    public EntitySize func_213305_a(Pose pose) {
        return this.field_200606_g.func_220334_j();
    }

    public Vector3d func_213303_ch() {
        return this.field_233557_ao_;
    }

    public BlockPos func_233580_cy_() {
        return this.field_233558_ap_;
    }

    public Vector3d func_213322_ci() {
        return this.field_213327_at;
    }

    public void func_213317_d(Vector3d vector3d) {
        this.field_213327_at = vector3d;
    }

    public void func_213293_j(double d, double d2, double d3) {
        this.func_213317_d(new Vector3d(d, d2, d3));
    }

    public final double func_226277_ct_() {
        return this.field_233557_ao_.field_72450_a;
    }

    public double func_226275_c_(double d) {
        return this.field_233557_ao_.field_72450_a + (double)this.func_213311_cf() * d;
    }

    public double func_226282_d_(double d) {
        return this.func_226275_c_((2.0 * this.field_70146_Z.nextDouble() - 1.0) * d);
    }

    public final double func_226278_cu_() {
        return this.field_233557_ao_.field_72448_b;
    }

    public double func_226283_e_(double d) {
        return this.field_233557_ao_.field_72448_b + (double)this.func_213302_cg() * d;
    }

    public double func_226279_cv_() {
        return this.func_226283_e_(this.field_70146_Z.nextDouble());
    }

    public double func_226280_cw_() {
        return this.field_233557_ao_.field_72448_b + (double)this.field_213326_aJ;
    }

    public final double func_226281_cx_() {
        return this.field_233557_ao_.field_72449_c;
    }

    public double func_226285_f_(double d) {
        return this.field_233557_ao_.field_72449_c + (double)this.func_213311_cf() * d;
    }

    public double func_226287_g_(double d) {
        return this.func_226285_f_((2.0 * this.field_70146_Z.nextDouble() - 1.0) * d);
    }

    public void func_226288_n_(double d, double d2, double d3) {
        if (this.field_233557_ao_.field_72450_a != d || this.field_233557_ao_.field_72448_b != d2 || this.field_233557_ao_.field_72449_c != d3) {
            this.field_233557_ao_ = new Vector3d(d, d2, d3);
            int n = MathHelper.func_76128_c(d);
            \u2603 = MathHelper.func_76128_c(d2);
            \u2603 = MathHelper.func_76128_c(d3);
            if (n != this.field_233558_ap_.func_177958_n() || \u2603 != this.field_233558_ap_.func_177956_o() || \u2603 != this.field_233558_ap_.func_177952_p()) {
                this.field_233558_ap_ = new BlockPos(n, \u2603, \u2603);
            }
            this.field_233555_aA_ = true;
        }
    }

    public void func_70623_bb() {
    }

    @FunctionalInterface
    public static interface IMoveCallback {
        public void accept(Entity var1, double var2, double var4, double var6);
    }
}

