/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ItemEntity
extends Entity {
    private static final DataParameter<ItemStack> field_184533_c = EntityDataManager.func_187226_a(ItemEntity.class, DataSerializers.field_187196_f);
    private int field_70292_b;
    private int field_145804_b;
    private int field_70291_e = 5;
    private UUID field_145801_f;
    private UUID field_145802_g;
    public final float field_70290_d = (float)(Math.random() * Math.PI * 2.0);

    public ItemEntity(EntityType<? extends ItemEntity> entityType, World world) {
        super(entityType, world);
    }

    public ItemEntity(World world, double d, double d2, double d3) {
        this((EntityType<? extends ItemEntity>)EntityType.field_200765_E, world);
        this.func_70107_b(d, d2, d3);
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
        this.func_213293_j(this.field_70146_Z.nextDouble() * 0.2 - 0.1, 0.2, this.field_70146_Z.nextDouble() * 0.2 - 0.1);
    }

    public ItemEntity(World world, double d, double d2, double d3, ItemStack itemStack) {
        this(world, d, d2, d3);
        this.func_92058_a(itemStack);
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184533_c, ItemStack.field_190927_a);
    }

    @Override
    public void func_70071_h_() {
        if (this.func_92059_d().func_190926_b()) {
            this.func_70106_y();
            return;
        }
        super.func_70071_h_();
        if (this.field_145804_b > 0 && this.field_145804_b != Short.MAX_VALUE) {
            --this.field_145804_b;
        }
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        Vector3d vector3d = this.func_213322_ci();
        if (this.func_208600_a(FluidTags.field_206959_a)) {
            this.func_203043_v();
        } else if (this.func_208600_a(FluidTags.field_206960_b)) {
            this.func_234274_v_();
        } else if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70145_X = false;
        } else {
            boolean bl = this.field_70145_X = !this.field_70170_p.func_226669_j_(this);
            if (this.field_70145_X) {
                this.func_213282_i(this.func_226277_ct_(), (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.func_226281_cx_());
            }
        }
        if (!this.field_70122_E || ItemEntity.func_213296_b(this.func_213322_ci()) > (double)1.0E-5f || (this.field_70173_aa + this.func_145782_y()) % 4 == 0) {
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            float f = 0.98f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_())).func_177230_c().func_208618_m() * 0.98f;
            }
            this.func_213317_d(this.func_213322_ci().func_216372_d(f, 0.98, f));
            if (this.field_70122_E) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, -0.5, 1.0));
            }
        }
        boolean bl = MathHelper.func_76128_c(this.field_70169_q) != MathHelper.func_76128_c(this.func_226277_ct_()) || MathHelper.func_76128_c(this.field_70167_r) != MathHelper.func_76128_c(this.func_226278_cu_()) || MathHelper.func_76128_c(this.field_70166_s) != MathHelper.func_76128_c(this.func_226281_cx_());
        int n = \u2603 = bl ? 2 : 40;
        if (this.field_70173_aa % \u2603 == 0) {
            if (this.field_70170_p.func_204610_c(this.func_233580_cy_()).func_206884_a(FluidTags.field_206960_b) && !this.func_230279_az_()) {
                this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
            }
            if (!this.field_70170_p.field_72995_K && this.func_213857_z()) {
                this.func_85054_d();
            }
        }
        if (this.field_70292_b != Short.MIN_VALUE) {
            ++this.field_70292_b;
        }
        this.field_70160_al |= this.func_233566_aG_();
        if (!this.field_70170_p.field_72995_K && (\u2603 = this.func_213322_ci().func_178788_d(vector3d).func_189985_c()) > 0.01) {
            this.field_70160_al = true;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70292_b >= 6000) {
            this.func_70106_y();
        }
    }

    private void func_203043_v() {
        Vector3d vector3d = this.func_213322_ci();
        this.func_213293_j(vector3d.field_72450_a * (double)0.99f, vector3d.field_72448_b + (double)(vector3d.field_72448_b < (double)0.06f ? 5.0E-4f : 0.0f), vector3d.field_72449_c * (double)0.99f);
    }

    private void func_234274_v_() {
        Vector3d vector3d = this.func_213322_ci();
        this.func_213293_j(vector3d.field_72450_a * (double)0.95f, vector3d.field_72448_b + (double)(vector3d.field_72448_b < (double)0.06f ? 5.0E-4f : 0.0f), vector3d.field_72449_c * (double)0.95f);
    }

    private void func_85054_d() {
        if (!this.func_213857_z()) {
            return;
        }
        List<ItemEntity> list = this.field_70170_p.func_175647_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(0.5, 0.0, 0.5), itemEntity -> itemEntity != this && itemEntity.func_213857_z());
        for (ItemEntity itemEntity2 : list) {
            if (!itemEntity2.func_213857_z()) continue;
            this.func_226530_a_(itemEntity2);
            if (!this.field_70128_L) continue;
            break;
        }
    }

    private boolean func_213857_z() {
        ItemStack itemStack = this.func_92059_d();
        return this.func_70089_S() && this.field_145804_b != Short.MAX_VALUE && this.field_70292_b != Short.MIN_VALUE && this.field_70292_b < 6000 && itemStack.func_190916_E() < itemStack.func_77976_d();
    }

    private void func_226530_a_(ItemEntity itemEntity) {
        ItemStack itemStack = this.func_92059_d();
        \u2603 = itemEntity.func_92059_d();
        if (!Objects.equals(this.func_200215_l(), itemEntity.func_200215_l()) || !ItemEntity.func_226532_a_(itemStack, \u2603)) {
            return;
        }
        if (\u2603.func_190916_E() < itemStack.func_190916_E()) {
            ItemEntity.func_213858_a(this, itemStack, itemEntity, \u2603);
        } else {
            ItemEntity.func_213858_a(itemEntity, \u2603, this, itemStack);
        }
    }

    public static boolean func_226532_a_(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack2.func_77973_b() != itemStack.func_77973_b()) {
            return false;
        }
        if (itemStack2.func_190916_E() + itemStack.func_190916_E() > itemStack2.func_77976_d()) {
            return false;
        }
        if (itemStack2.func_77942_o() ^ itemStack.func_77942_o()) {
            return false;
        }
        return !itemStack2.func_77942_o() || itemStack2.func_77978_p().equals(itemStack.func_77978_p());
    }

    public static ItemStack func_226533_a_(ItemStack itemStack, ItemStack itemStack2, int n) {
        \u2603 = Math.min(Math.min(itemStack.func_77976_d(), n) - itemStack.func_190916_E(), itemStack2.func_190916_E());
        ItemStack itemStack3 = itemStack.func_77946_l();
        itemStack3.func_190917_f(\u2603);
        itemStack2.func_190918_g(\u2603);
        return itemStack3;
    }

    private static void func_226531_a_(ItemEntity itemEntity, ItemStack itemStack, ItemStack itemStack2) {
        \u2603 = ItemEntity.func_226533_a_(itemStack, itemStack2, 64);
        itemEntity.func_92058_a(\u2603);
    }

    private static void func_213858_a(ItemEntity itemEntity, ItemStack itemStack, ItemEntity itemEntity2, ItemStack itemStack2) {
        ItemEntity.func_226531_a_(itemEntity, itemStack, itemStack2);
        itemEntity.field_145804_b = Math.max(itemEntity.field_145804_b, itemEntity2.field_145804_b);
        itemEntity.field_70292_b = Math.min(itemEntity.field_70292_b, itemEntity2.field_70292_b);
        if (itemStack2.func_190926_b()) {
            itemEntity2.func_70106_y();
        }
    }

    @Override
    public boolean func_230279_az_() {
        return this.func_92059_d().func_77973_b().func_234687_u_() || super.func_230279_az_();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (!this.func_92059_d().func_190926_b() && this.func_92059_d().func_77973_b() == Items.field_151156_bN && damageSource.func_94541_c()) {
            return false;
        }
        if (!this.func_92059_d().func_77973_b().func_234685_a_(damageSource)) {
            return false;
        }
        this.func_70018_K();
        this.field_70291_e = (int)((float)this.field_70291_e - f);
        if (this.field_70291_e <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        compoundNBT.func_74777_a("Health", (short)this.field_70291_e);
        compoundNBT.func_74777_a("Age", (short)this.field_70292_b);
        compoundNBT.func_74777_a("PickupDelay", (short)this.field_145804_b);
        if (this.func_200214_m() != null) {
            compoundNBT.func_186854_a("Thrower", this.func_200214_m());
        }
        if (this.func_200215_l() != null) {
            compoundNBT.func_186854_a("Owner", this.func_200215_l());
        }
        if (!this.func_92059_d().func_190926_b()) {
            compoundNBT.func_218657_a("Item", this.func_92059_d().func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        this.field_70291_e = compoundNBT.func_74765_d("Health");
        this.field_70292_b = compoundNBT.func_74765_d("Age");
        if (compoundNBT.func_74764_b("PickupDelay")) {
            this.field_145804_b = compoundNBT.func_74765_d("PickupDelay");
        }
        if (compoundNBT.func_186855_b("Owner")) {
            this.field_145802_g = compoundNBT.func_186857_a("Owner");
        }
        if (compoundNBT.func_186855_b("Thrower")) {
            this.field_145801_f = compoundNBT.func_186857_a("Thrower");
        }
        \u2603 = compoundNBT.func_74775_l("Item");
        this.func_92058_a(ItemStack.func_199557_a(\u2603));
        if (this.func_92059_d().func_190926_b()) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70100_b_(PlayerEntity playerEntity) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack itemStack = this.func_92059_d();
        Item \u26032 = itemStack.func_77973_b();
        int \u26033 = itemStack.func_190916_E();
        if (this.field_145804_b == 0 && (this.field_145802_g == null || this.field_145802_g.equals(playerEntity.func_110124_au())) && playerEntity.field_71071_by.func_70441_a(itemStack)) {
            playerEntity.func_71001_a(this, \u26033);
            if (itemStack.func_190926_b()) {
                this.func_70106_y();
                itemStack.func_190920_e(\u26033);
            }
            playerEntity.func_71064_a(Stats.field_199089_f.func_199076_b(\u26032), \u26033);
            playerEntity.func_233630_a_(this);
        }
    }

    @Override
    public ITextComponent func_200200_C_() {
        ITextComponent iTextComponent = this.func_200201_e();
        if (iTextComponent != null) {
            return iTextComponent;
        }
        return new TranslationTextComponent(this.func_92059_d().func_77977_a());
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    @Nullable
    public Entity func_241206_a_(ServerWorld serverWorld) {
        Entity entity = super.func_241206_a_(serverWorld);
        if (!this.field_70170_p.field_72995_K && entity instanceof ItemEntity) {
            ((ItemEntity)entity).func_85054_d();
        }
        return entity;
    }

    public ItemStack func_92059_d() {
        return this.func_184212_Q().func_187225_a(field_184533_c);
    }

    public void func_92058_a(ItemStack itemStack) {
        this.func_184212_Q().func_187227_b(field_184533_c, itemStack);
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        super.func_184206_a(dataParameter);
        if (field_184533_c.equals(dataParameter)) {
            this.func_92059_d().func_234695_a_(this);
        }
    }

    @Nullable
    public UUID func_200215_l() {
        return this.field_145802_g;
    }

    public void func_200217_b(@Nullable UUID uUID) {
        this.field_145802_g = uUID;
    }

    @Nullable
    public UUID func_200214_m() {
        return this.field_145801_f;
    }

    public void func_200216_c(@Nullable UUID uUID) {
        this.field_145801_f = uUID;
    }

    public void func_174869_p() {
        this.field_145804_b = 10;
    }

    public void func_174868_q() {
        this.field_145804_b = 0;
    }

    public void func_174871_r() {
        this.field_145804_b = Short.MAX_VALUE;
    }

    public void func_174867_a(int n) {
        this.field_145804_b = n;
    }

    public boolean func_174874_s() {
        return this.field_145804_b > 0;
    }

    public void func_174873_u() {
        this.field_70292_b = -6000;
    }

    public void func_174870_v() {
        this.func_174871_r();
        this.field_70292_b = 5999;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket(this);
    }
}

