/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AnimalBreedTask;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.ChildFollowNearestAdultTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.MoveToTargetTask;
import net.minecraft.entity.ai.brain.task.PredicateTask;
import net.minecraft.entity.ai.brain.task.RandomlyStopAttackingTask;
import net.minecraft.entity.ai.brain.task.RunAwayTask;
import net.minecraft.entity.ai.brain.task.RunSometimesTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;

public class HoglinTasks {
    private static final RangedInteger field_234372_a_ = TickRangeConverter.func_233037_a_(5, 20);
    private static final RangedInteger field_234373_b_ = RangedInteger.func_233017_a_(5, 16);

    protected static Brain<?> func_234376_a_(Brain<HoglinEntity> brain) {
        HoglinTasks.func_234382_b_(brain);
        HoglinTasks.func_234385_c_(brain);
        HoglinTasks.func_234388_d_(brain);
        HoglinTasks.func_234391_e_(brain);
        brain.func_218199_a((Set<Activity>)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_233714_e_();
        return brain;
    }

    private static void func_234382_b_(Brain<HoglinEntity> brain) {
        brain.func_233698_a_(Activity.field_221365_a, 0, (ImmutableList<Task<HoglinEntity>>)ImmutableList.of((Object)new LookTask(45, 90), (Object)new WalkToTargetTask(200)));
    }

    private static void func_234385_c_(Brain<HoglinEntity> brain) {
        brain.func_233698_a_(Activity.field_221366_b, 10, (ImmutableList<Task<HoglinEntity>>)ImmutableList.of((Object)new RandomlyStopAttackingTask(MemoryModuleType.field_234098_af_, 200), (Object)new AnimalBreedTask(EntityType.field_233588_G_, 0.6f), RunAwayTask.func_233963_a_(MemoryModuleType.field_234098_af_, 1.0f, 8, true), new ForgetAttackTargetTask<HoglinEntity>(HoglinTasks::func_234392_e_), new SupplementedTask<CreatureEntity>(HoglinEntity::func_234363_eJ_, RunAwayTask.func_233965_b_(MemoryModuleType.field_234092_Z_, 0.4f, 8, false)), new RunSometimesTask<LivingEntity>(new LookAtEntityTask(8.0f), RangedInteger.func_233017_a_(30, 60)), new ChildFollowNearestAdultTask(field_234373_b_, 0.6f), HoglinTasks.func_234374_a_()));
    }

    private static void func_234388_d_(Brain<HoglinEntity> brain) {
        brain.func_233699_a_(Activity.field_234621_k_, 10, (ImmutableList<Task<HoglinEntity>>)ImmutableList.of((Object)new RandomlyStopAttackingTask(MemoryModuleType.field_234098_af_, 200), (Object)new AnimalBreedTask(EntityType.field_233588_G_, 0.6f), (Object)new MoveToTargetTask(1.0f), new SupplementedTask<MobEntity>(HoglinEntity::func_234363_eJ_, new AttackTargetTask(40)), new SupplementedTask<MobEntity>(AgeableEntity::func_70631_g_, new AttackTargetTask(15)), new FindNewAttackTargetTask(), new PredicateTask<HoglinEntity>(HoglinTasks::func_234402_j_, MemoryModuleType.field_234103_o_)), MemoryModuleType.field_234103_o_);
    }

    private static void func_234391_e_(Brain<HoglinEntity> brain) {
        brain.func_233699_a_(Activity.field_234624_n_, 10, (ImmutableList<Task<HoglinEntity>>)ImmutableList.of(RunAwayTask.func_233965_b_(MemoryModuleType.field_234106_z_, 1.3f, 15, false), HoglinTasks.func_234374_a_(), new RunSometimesTask<LivingEntity>(new LookAtEntityTask(8.0f), RangedInteger.func_233017_a_(30, 60)), new PredicateTask<HoglinEntity>(HoglinTasks::func_234394_f_, MemoryModuleType.field_234106_z_)), MemoryModuleType.field_234106_z_);
    }

    private static FirstShuffledTask<HoglinEntity> func_234374_a_() {
        return new FirstShuffledTask<HoglinEntity>((List<Pair<Task<HoglinEntity>, Integer>>)ImmutableList.of((Object)Pair.of((Object)new WalkRandomlyTask(0.4f), (Object)2), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(0.4f, 3), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)));
    }

    protected static void func_234377_a_(HoglinEntity hoglinEntity) {
        Brain<HoglinEntity> brain = hoglinEntity.func_213375_cj();
        Activity \u26032 = brain.func_233716_f_().orElse(null);
        brain.func_233706_a_((List<Activity>)ImmutableList.of((Object)Activity.field_234621_k_, (Object)Activity.field_234624_n_, (Object)Activity.field_221366_b));
        Activity \u26033 = brain.func_233716_f_().orElse(null);
        if (\u26032 != \u26033) {
            HoglinTasks.func_234398_h_(hoglinEntity).ifPresent(hoglinEntity::func_241412_a_);
        }
        hoglinEntity.func_213395_q(brain.func_218191_a(MemoryModuleType.field_234103_o_));
    }

    protected static void func_234378_a_(HoglinEntity hoglinEntity, LivingEntity livingEntity) {
        if (hoglinEntity.func_70631_g_()) {
            return;
        }
        if (livingEntity.func_200600_R() == EntityType.field_233591_ai_ && HoglinTasks.func_234396_g_(hoglinEntity)) {
            HoglinTasks.func_234393_e_(hoglinEntity, livingEntity);
            HoglinTasks.func_234387_c_(hoglinEntity, livingEntity);
            return;
        }
        HoglinTasks.func_234399_h_(hoglinEntity, livingEntity);
    }

    private static void func_234387_c_(HoglinEntity hoglinEntity2, LivingEntity livingEntity) {
        HoglinTasks.func_234400_i_(hoglinEntity2).forEach(hoglinEntity -> HoglinTasks.func_234390_d_(hoglinEntity, livingEntity));
    }

    private static void func_234390_d_(HoglinEntity hoglinEntity, LivingEntity livingEntity) {
        \u26032 = livingEntity;
        Brain<HoglinEntity> brain = hoglinEntity.func_213375_cj();
        LivingEntity \u26032 = BrainUtil.func_233867_a_(hoglinEntity, brain.func_218207_c(MemoryModuleType.field_234106_z_), \u26032);
        \u26032 = BrainUtil.func_233867_a_(hoglinEntity, brain.func_218207_c(MemoryModuleType.field_234103_o_), \u26032);
        HoglinTasks.func_234393_e_(hoglinEntity, \u26032);
    }

    private static void func_234393_e_(HoglinEntity hoglinEntity, LivingEntity livingEntity) {
        hoglinEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_234103_o_);
        hoglinEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        hoglinEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234106_z_, livingEntity, field_234372_a_.func_233018_a_(hoglinEntity.field_70170_p.field_73012_v));
    }

    private static Optional<? extends LivingEntity> func_234392_e_(HoglinEntity hoglinEntity) {
        if (HoglinTasks.func_234386_c_(hoglinEntity) || HoglinTasks.func_234402_j_(hoglinEntity)) {
            return Optional.empty();
        }
        return hoglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234102_l_);
    }

    static boolean func_234380_a_(HoglinEntity hoglinEntity, BlockPos blockPos) {
        Optional<BlockPos> optional = hoglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234098_af_);
        return optional.isPresent() && optional.get().func_218141_a(blockPos, 8.0);
    }

    private static boolean func_234394_f_(HoglinEntity hoglinEntity) {
        return hoglinEntity.func_234363_eJ_() && !HoglinTasks.func_234396_g_(hoglinEntity);
    }

    private static boolean func_234396_g_(HoglinEntity hoglinEntity) {
        if (hoglinEntity.func_70631_g_()) {
            return false;
        }
        int n = hoglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234094_ab_).orElse(0);
        return n > (\u2603 = hoglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234095_ac_).orElse(0) + 1);
    }

    protected static void func_234384_b_(HoglinEntity hoglinEntity, LivingEntity livingEntity) {
        Brain<HoglinEntity> brain = hoglinEntity.func_213375_cj();
        brain.func_218189_b(MemoryModuleType.field_234099_ag_);
        brain.func_218189_b(MemoryModuleType.field_220953_n);
        if (hoglinEntity.func_70631_g_()) {
            HoglinTasks.func_234390_d_(hoglinEntity, livingEntity);
            return;
        }
        HoglinTasks.func_234395_f_(hoglinEntity, livingEntity);
    }

    private static void func_234395_f_(HoglinEntity hoglinEntity, LivingEntity livingEntity) {
        if (hoglinEntity.func_213375_cj().func_218214_c(Activity.field_234624_n_) && livingEntity.func_200600_R() == EntityType.field_233591_ai_) {
            return;
        }
        if (!EntityPredicates.field_233583_f_.test(livingEntity)) {
            return;
        }
        if (livingEntity.func_200600_R() == EntityType.field_233588_G_) {
            return;
        }
        if (BrainUtil.func_233861_a_(hoglinEntity, livingEntity, 4.0)) {
            return;
        }
        HoglinTasks.func_234397_g_(hoglinEntity, livingEntity);
        HoglinTasks.func_234399_h_(hoglinEntity, livingEntity);
    }

    private static void func_234397_g_(HoglinEntity hoglinEntity, LivingEntity livingEntity) {
        Brain<HoglinEntity> brain = hoglinEntity.func_213375_cj();
        brain.func_218189_b(MemoryModuleType.field_223021_x);
        brain.func_218189_b(MemoryModuleType.field_220953_n);
        brain.func_233696_a_(MemoryModuleType.field_234103_o_, livingEntity, 200L);
    }

    private static void func_234399_h_(HoglinEntity hoglinEntity2, LivingEntity livingEntity) {
        HoglinTasks.func_234400_i_(hoglinEntity2).forEach(hoglinEntity -> HoglinTasks.func_234401_i_(hoglinEntity, livingEntity));
    }

    private static void func_234401_i_(HoglinEntity hoglinEntity, LivingEntity livingEntity) {
        if (HoglinTasks.func_234386_c_(hoglinEntity)) {
            return;
        }
        Optional<LivingEntity> optional = hoglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
        LivingEntity \u26032 = BrainUtil.func_233867_a_(hoglinEntity, optional, livingEntity);
        HoglinTasks.func_234397_g_(hoglinEntity, \u26032);
    }

    public static Optional<SoundEvent> func_234398_h_(HoglinEntity hoglinEntity) {
        return hoglinEntity.func_213375_cj().func_233716_f_().map(activity -> HoglinTasks.func_241413_a_(hoglinEntity, activity));
    }

    private static SoundEvent func_241413_a_(HoglinEntity hoglinEntity, Activity activity) {
        if (activity == Activity.field_234624_n_ || hoglinEntity.func_234364_eK_()) {
            return SoundEvents.field_232718_fH_;
        }
        if (activity == Activity.field_234621_k_) {
            return SoundEvents.field_232713_fC_;
        }
        if (HoglinTasks.func_241416_h_(hoglinEntity)) {
            return SoundEvents.field_232718_fH_;
        }
        return SoundEvents.field_232712_fB_;
    }

    private static List<HoglinEntity> func_234400_i_(HoglinEntity hoglinEntity) {
        return hoglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234091_Y_).orElse((List<HoglinEntity>)ImmutableList.of());
    }

    private static boolean func_241416_h_(HoglinEntity hoglinEntity) {
        return hoglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234098_af_);
    }

    private static boolean func_234402_j_(HoglinEntity hoglinEntity) {
        return hoglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_220953_n);
    }

    protected static boolean func_234386_c_(HoglinEntity hoglinEntity) {
        return hoglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234099_ag_);
    }
}

