/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BannerItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;

public class PillagerEntity
extends AbstractIllagerEntity
implements ICrossbowUser {
    private static final DataParameter<Boolean> field_213676_b = EntityDataManager.func_187226_a(PillagerEntity.class, DataSerializers.field_187198_h);
    private final Inventory field_213677_bz = new Inventory(5);

    public PillagerEntity(EntityType<? extends PillagerEntity> entityType, World world) {
        super((EntityType<? extends AbstractIllagerEntity>)entityType, world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(2, new AbstractRaiderEntity.FindTargetGoal(this, this, 10.0f));
        this.field_70714_bg.func_75776_a(3, new RangedCrossbowAttackGoal<PillagerEntity>(this, 1.0, 8.0f));
        this.field_70714_bg.func_75776_a(8, new RandomWalkingGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(9, new LookAtGoal(this, PlayerEntity.class, 15.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, new LookAtGoal(this, MobEntity.class, 15.0f));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, AbstractRaiderEntity.class).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<AbstractVillagerEntity>((MobEntity)this, AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<IronGolemEntity>((MobEntity)this, IronGolemEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute func_234296_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.35f).func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213676_b, false);
    }

    @Override
    public boolean func_230280_a_(ShootableItem shootableItem) {
        return shootableItem == Items.field_222114_py;
    }

    @Override
    public void func_213671_a(boolean bl) {
        this.field_70180_af.func_187227_b(field_213676_b, bl);
    }

    @Override
    public void func_230283_U__() {
        this.field_70708_bq = 0;
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        super.func_213281_b(compoundNBT2);
        ListNBT listNBT = new ListNBT();
        for (int i = 0; i < this.field_213677_bz.func_70302_i_(); ++i) {
            ItemStack itemStack = this.field_213677_bz.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            listNBT.add(itemStack.func_77955_b(new CompoundNBT()));
        }
        compoundNBT2.func_218657_a("Inventory", listNBT);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        ListNBT listNBT = compoundNBT.func_150295_c("Inventory", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            ItemStack itemStack = ItemStack.func_199557_a(listNBT.func_150305_b(i));
            if (itemStack.func_190926_b()) continue;
            this.field_213677_bz.func_174894_a(itemStack);
        }
        this.func_98053_h(true);
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReader iWorldReader) {
        BlockState blockState = iWorldReader.func_180495_p(blockPos.func_177977_b());
        if (blockState.func_203425_a(Blocks.field_196658_i) || blockState.func_203425_a(Blocks.field_150354_m)) {
            return 10.0f;
        }
        return 0.5f - iWorldReader.func_205052_D(blockPos);
    }

    @Override
    public int func_70641_bl() {
        return 1;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        this.func_180481_a(difficultyInstance);
        this.func_180483_b(difficultyInstance);
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        ItemStack itemStack = new ItemStack(Items.field_222114_py);
        if (this.field_70146_Z.nextInt(300) == 0) {
            HashMap hashMap = Maps.newHashMap();
            hashMap.put(Enchantments.field_222194_I, 1);
            EnchantmentHelper.func_82782_a(hashMap, itemStack);
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, itemStack);
    }

    @Override
    public boolean func_184191_r(Entity entity) {
        if (super.func_184191_r(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entity.func_96124_cp() == null;
        }
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_219686_is;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219688_iu;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_219689_iv;
    }

    @Override
    public void func_82196_d(LivingEntity livingEntity, float f) {
        this.func_234281_b_(this, 1.6f);
    }

    @Override
    public void func_230284_a_(LivingEntity livingEntity, ItemStack itemStack, ProjectileEntity projectileEntity, float f) {
        this.func_234279_a_(this, livingEntity, projectileEntity, f, 1.6f);
    }

    @Override
    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.func_92059_d();
        if (itemStack.func_77973_b() instanceof BannerItem) {
            super.func_175445_a(itemEntity);
        } else {
            Item item = itemStack.func_77973_b();
            if (this.func_213672_b(item)) {
                this.func_233630_a_(itemEntity);
                ItemStack itemStack2 = this.field_213677_bz.func_174894_a(itemStack);
                if (itemStack2.func_190926_b()) {
                    itemEntity.func_70106_y();
                } else {
                    itemStack.func_190920_e(itemStack2.func_190916_E());
                }
            }
        }
    }

    private boolean func_213672_b(Item item) {
        return this.func_213657_el() && item == Items.field_196191_eg;
    }

    @Override
    public boolean func_174820_d(int n, ItemStack itemStack) {
        if (super.func_174820_d(n, itemStack)) {
            return true;
        }
        int n2 = n - 300;
        if (n2 >= 0 && n2 < this.field_213677_bz.func_70302_i_()) {
            this.field_213677_bz.func_70299_a(n2, itemStack);
            return true;
        }
        return false;
    }

    @Override
    public void func_213660_a(int n, boolean bl) {
        Raid raid = this.func_213663_ek();
        boolean bl2 = \u2603 = this.field_70146_Z.nextFloat() <= raid.func_221308_w();
        if (\u2603) {
            ItemStack itemStack = new ItemStack(Items.field_222114_py);
            HashMap \u26032 = Maps.newHashMap();
            if (n > raid.func_221306_a(Difficulty.NORMAL)) {
                \u26032.put(Enchantments.field_222193_H, 2);
            } else if (n > raid.func_221306_a(Difficulty.EASY)) {
                \u26032.put(Enchantments.field_222193_H, 1);
            }
            \u26032.put(Enchantments.field_222192_G, 1);
            EnchantmentHelper.func_82782_a(\u26032, itemStack);
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemStack);
        }
    }

    @Override
    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219687_it;
    }
}

