/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.BoostHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRideable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class StriderEntity
extends AnimalEntity
implements IRideable,
IEquipable {
    private static final Ingredient field_234308_bu_ = Ingredient.func_199804_a(Items.field_234723_bx_);
    private static final Ingredient field_234309_bv_ = Ingredient.func_199804_a(Items.field_234723_bx_, Items.field_234774_pk_);
    private static final DataParameter<Integer> field_234310_bw_ = EntityDataManager.func_187226_a(StriderEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_234311_bx_ = EntityDataManager.func_187226_a(StriderEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_234312_by_ = EntityDataManager.func_187226_a(StriderEntity.class, DataSerializers.field_187198_h);
    private final BoostHelper field_234313_bz_;
    private TemptGoal field_234306_bA_;
    private PanicGoal field_234307_bB_;

    public StriderEntity(EntityType<? extends StriderEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
        this.field_234313_bz_ = new BoostHelper(this.field_70180_af, field_234310_bw_, field_234312_by_);
        this.field_70156_m = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
    }

    public static boolean func_234314_c_(EntityType<StriderEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        BlockPos.Mutable mutable = blockPos.func_239590_i_();
        do {
            mutable.func_189536_c(Direction.UP);
        } while (iWorld.func_204610_c(mutable).func_206884_a(FluidTags.field_206960_b));
        return iWorld.func_180495_p(mutable).func_196958_f();
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_234310_bw_.equals(dataParameter) && this.field_70170_p.field_72995_K) {
            this.field_234313_bz_.func_233616_a_();
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_234310_bw_, 0);
        this.field_70180_af.func_187214_a(field_234311_bx_, false);
        this.field_70180_af.func_187214_a(field_234312_by_, false);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        this.field_234313_bz_.func_233618_a_(compoundNBT);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.field_234313_bz_.func_233621_b_(compoundNBT);
    }

    @Override
    public boolean func_110257_ck() {
        return this.field_234313_bz_.func_233620_b_();
    }

    @Override
    public boolean func_230264_L__() {
        return this.func_70089_S() && !this.func_70631_g_();
    }

    @Override
    public void func_230266_a_(@Nullable SoundCategory soundCategory) {
        this.field_234313_bz_.func_233619_a_(true);
        if (soundCategory != null) {
            this.field_70170_p.func_217384_a(null, this, SoundEvents.field_232841_ob_, soundCategory, 0.5f, 1.0f);
        }
    }

    @Override
    protected void func_184651_r() {
        this.field_234307_bB_ = new PanicGoal(this, 1.65);
        this.field_70714_bg.func_75776_a(1, this.field_234307_bB_);
        this.field_70714_bg.func_75776_a(3, new BreedGoal(this, 1.0));
        this.field_234306_bA_ = new TemptGoal((CreatureEntity)this, 1.4, false, field_234309_bv_);
        this.field_70714_bg.func_75776_a(4, this.field_234306_bA_);
        this.field_70714_bg.func_75776_a(5, new FollowParentGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(7, new RandomWalkingGoal(this, 1.0, 60));
        this.field_70714_bg.func_75776_a(8, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
        this.field_70714_bg.func_75776_a(9, new LookAtGoal(this, StriderEntity.class, 8.0f));
    }

    public void func_234319_t_(boolean bl) {
        this.field_70180_af.func_187227_b(field_234311_bx_, bl);
    }

    public boolean func_234315_eI_() {
        if (this.func_184187_bx() instanceof StriderEntity) {
            return ((StriderEntity)this.func_184187_bx()).func_234315_eI_();
        }
        return this.field_70180_af.func_187225_a(field_234311_bx_);
    }

    @Override
    public boolean func_230285_a_(Fluid fluid) {
        return fluid.func_207185_a(FluidTags.field_206960_b);
    }

    @Override
    @Nullable
    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity.func_70104_M()) {
            return entity.func_174813_aQ();
        }
        return null;
    }

    @Override
    public boolean func_70104_M() {
        return true;
    }

    @Override
    public double func_70042_X() {
        float f = Math.min(0.25f, this.field_70721_aZ);
        \u2603 = this.field_184619_aG;
        return (double)this.func_213302_cg() - 0.2 + (double)(0.12f * MathHelper.func_76134_b(\u2603 * 1.5f) * 2.0f * f);
    }

    @Override
    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity \u26032 = (PlayerEntity)entity;
        return \u26032.func_184614_ca().func_77973_b() == Items.field_234774_pk_ || \u26032.func_184592_cb().func_77973_b() == Items.field_234774_pk_;
    }

    @Override
    public boolean func_205019_a(IWorldReader iWorldReader) {
        return iWorldReader.func_226668_i_(this);
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        if (this.func_184188_bt().isEmpty()) {
            return null;
        }
        return this.func_184188_bt().get(0);
    }

    @Override
    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        double d;
        Vector3d[] vector3dArray = new Vector3d[]{StriderEntity.func_233559_a_(this.func_213311_cf(), livingEntity.func_213311_cf(), livingEntity.field_70177_z), StriderEntity.func_233559_a_(this.func_213311_cf(), livingEntity.func_213311_cf(), livingEntity.field_70177_z - 22.5f), StriderEntity.func_233559_a_(this.func_213311_cf(), livingEntity.func_213311_cf(), livingEntity.field_70177_z + 22.5f), StriderEntity.func_233559_a_(this.func_213311_cf(), livingEntity.func_213311_cf(), livingEntity.field_70177_z - 45.0f), StriderEntity.func_233559_a_(this.func_213311_cf(), livingEntity.func_213311_cf(), livingEntity.field_70177_z + 45.0f)};
        LinkedHashSet \u26032 = Sets.newLinkedHashSet();
        double \u26033 = this.func_174813_aQ().field_72337_e;
        double \u26034 = this.func_174813_aQ().field_72338_b - 0.5;
        BlockPos.Mutable \u26035 = new BlockPos.Mutable();
        for (Object object : vector3dArray) {
            \u26035.func_189532_c(this.func_226277_ct_() + object.field_72450_a, \u26033, this.func_226281_cx_() + object.field_72449_c);
            for (d = \u26033; d > \u26034; d -= 1.0) {
                \u26032.add(\u26035.func_185334_h());
                \u26035.func_189536_c(Direction.DOWN);
            }
        }
        for (BlockPos blockPos : \u26032) {
            if (this.field_70170_p.func_204610_c(blockPos).func_206884_a(FluidTags.field_206960_b)) continue;
            for (Object object : livingEntity.func_230297_ef_()) {
                d = this.field_70170_p.func_234936_m_(blockPos);
                if (!TransportationHelper.func_234630_a_(d) || !TransportationHelper.func_234631_a_(this.field_70170_p, livingEntity, (\u2603 = livingEntity.func_233648_f_((Pose)((Object)object))).func_191194_a(\u2603 = Vector3d.func_237490_a_(blockPos, d)))) continue;
                livingEntity.func_213301_b((Pose)((Object)object));
                return \u2603;
            }
        }
        return new Vector3d(this.func_226277_ct_(), this.func_174813_aQ().field_72337_e, this.func_226281_cx_());
    }

    @Override
    public void func_213352_e(Vector3d vector3d) {
        this.func_70659_e(this.func_234316_eJ_());
        this.func_233622_a_(this, this.field_234313_bz_, vector3d);
    }

    public float func_234316_eJ_() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_) * (this.func_234315_eI_() ? 0.66f : 1.0f);
    }

    @Override
    public float func_230265_N__() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_) * (this.func_234315_eI_() ? 0.23f : 0.55f);
    }

    @Override
    public void func_230267_a__(Vector3d vector3d) {
        super.func_213352_e(vector3d);
    }

    @Override
    protected float func_203009_ad() {
        return this.field_82151_R + 0.6f;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(this.func_180799_ab() ? SoundEvents.field_232838_nZ_ : SoundEvents.field_232837_nY_, 1.0f, 1.0f);
    }

    @Override
    public boolean func_184762_da() {
        return this.field_234313_bz_.func_233617_a_(this.func_70681_au());
    }

    @Override
    protected void func_184231_a(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
        this.func_145775_I();
        if (this.func_180799_ab()) {
            this.field_70143_R = 0.0f;
            return;
        }
        super.func_184231_a(d, bl, blockState, blockPos);
    }

    @Override
    public void func_70071_h_() {
        if (this.func_241398_eP_() && this.field_70146_Z.nextInt(140) == 0) {
            this.func_184185_a(SoundEvents.field_232833_nU_, 1.0f, this.func_70647_i());
        } else if (this.func_241397_eO_() && this.field_70146_Z.nextInt(60) == 0) {
            this.func_184185_a(SoundEvents.field_232834_nV_, 1.0f, this.func_70647_i());
        }
        BlockState blockState = this.field_70170_p.func_180495_p(this.func_233580_cy_());
        \u2603 = this.func_233568_aJ_();
        boolean \u26032 = blockState.func_235714_a_(BlockTags.field_232881_aw_) || \u2603.func_235714_a_(BlockTags.field_232881_aw_) || this.func_233571_b_(FluidTags.field_206960_b) > 0.0;
        this.func_234319_t_(!\u26032);
        super.func_70071_h_();
        this.func_234318_eL_();
        this.func_145775_I();
    }

    private boolean func_241397_eO_() {
        return this.field_234307_bB_ != null && this.field_234307_bB_.func_234044_h_();
    }

    private boolean func_241398_eP_() {
        return this.field_234306_bA_ != null && this.field_234306_bA_.func_75277_f();
    }

    @Override
    protected boolean func_230286_q_() {
        return true;
    }

    private void func_234318_eL_() {
        if (this.func_180799_ab()) {
            ISelectionContext iSelectionContext = ISelectionContext.func_216374_a(this);
            if (!iSelectionContext.func_216378_a(FlowingFluidBlock.field_235510_c_, this.func_233580_cy_(), true) || this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177984_a()).func_206884_a(FluidTags.field_206960_b)) {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, 0.05, 0.0));
            } else {
                this.field_70122_E = true;
            }
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234317_eK_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.175f).func_233815_a_(Attributes.field_233819_b_, 16.0);
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.func_241397_eO_() || this.func_241398_eP_()) {
            return null;
        }
        return SoundEvents.field_232832_nT_;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_232836_nX_;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232835_nW_;
    }

    @Override
    protected boolean func_184219_q(Entity entity) {
        return this.func_184188_bt().isEmpty() && !this.func_208600_a(FluidTags.field_206960_b);
    }

    @Override
    public boolean func_230270_dK_() {
        return true;
    }

    @Override
    public boolean func_70027_ad() {
        return false;
    }

    @Override
    protected PathNavigator func_175447_b(World world) {
        return new LavaPathNavigator(this, world);
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReader iWorldReader) {
        if (iWorldReader.func_180495_p(blockPos).func_204520_s().func_206884_a(FluidTags.field_206960_b)) {
            return 10.0f;
        }
        return 0.0f;
    }

    @Override
    public StriderEntity func_90011_a(AgeableEntity ageableEntity) {
        return EntityType.field_233589_aE_.func_200721_a(this.field_70170_p);
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return field_234308_bu_.test(itemStack);
    }

    @Override
    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.func_110257_ck()) {
            this.func_199703_a(Items.field_151141_av);
        }
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand hand) {
        boolean bl = this.func_70877_b(playerEntity.func_184586_b(hand));
        if (!bl && this.func_110257_ck() && !this.func_184207_aI()) {
            if (!this.field_70170_p.field_72995_K) {
                playerEntity.func_184220_m(this);
            }
            return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
        }
        ActionResultType \u26032 = super.func_230254_b_(playerEntity, hand);
        if (!\u26032.func_226246_a_()) {
            ItemStack itemStack = playerEntity.func_184586_b(hand);
            if (itemStack.func_77973_b() == Items.field_151141_av) {
                return itemStack.func_111282_a_(playerEntity, this, hand);
            }
            return ActionResultType.PASS;
        }
        if (bl && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_232840_oa_, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        return \u26032;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        AgeData.RiderType riderType;
        ZombieEntity.GroupData \u26032 = null;
        if (iLivingEntityData2 instanceof AgeData) {
            riderType = ((AgeData)iLivingEntityData2).field_234320_a_;
        } else if (!this.func_70631_g_()) {
            if (this.field_70146_Z.nextInt(30) == 0) {
                riderType = AgeData.RiderType.PIGLIN_RIDER;
                \u26032 = new ZombieEntity.GroupData(ZombieEntity.func_241399_a_(this.field_70146_Z), false);
            } else {
                riderType = this.field_70146_Z.nextInt(10) == 0 ? AgeData.RiderType.BABY_RIDER : AgeData.RiderType.NO_RIDER;
            }
            ILivingEntityData iLivingEntityData2 = new AgeData(riderType);
            ((AgeableEntity.AgeableData)iLivingEntityData2).func_226258_a_(riderType == AgeData.RiderType.NO_RIDER ? 0.5f : 0.0f);
        } else {
            riderType = AgeData.RiderType.NO_RIDER;
        }
        CreatureEntity creatureEntity = null;
        if (riderType == AgeData.RiderType.BABY_RIDER) {
            StriderEntity striderEntity = EntityType.field_233589_aE_.func_200721_a(iWorld.func_201672_e());
            if (striderEntity != null) {
                creatureEntity = striderEntity;
                striderEntity.func_70873_a(-24000);
            }
        } else if (riderType == AgeData.RiderType.PIGLIN_RIDER && (\u2603 = EntityType.field_233592_ba_.func_200721_a(iWorld.func_201672_e())) != null) {
            creatureEntity = \u2603;
            this.func_230266_a_(null);
        }
        if (creatureEntity != null) {
            creatureEntity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
            creatureEntity.func_213386_a(iWorld, difficultyInstance, SpawnReason.JOCKEY, \u26032, null);
            creatureEntity.func_184205_a(this, true);
            iWorld.func_217376_c(creatureEntity);
        }
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData2, compoundNBT);
    }

    @Override
    public /* synthetic */ AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return this.func_90011_a(ageableEntity);
    }

    static class LavaPathNavigator
    extends GroundPathNavigator {
        LavaPathNavigator(StriderEntity striderEntity, World world) {
            super(striderEntity, world);
        }

        @Override
        protected PathFinder func_179679_a(int n) {
            this.field_179695_a = new WalkNodeProcessor();
            return new PathFinder(this.field_179695_a, n);
        }

        @Override
        protected boolean func_230287_a_(PathNodeType pathNodeType) {
            if (pathNodeType == PathNodeType.LAVA || pathNodeType == PathNodeType.DAMAGE_FIRE || pathNodeType == PathNodeType.DANGER_FIRE) {
                return true;
            }
            return super.func_230287_a_(pathNodeType);
        }

        @Override
        public boolean func_188555_b(BlockPos blockPos) {
            return this.field_75513_b.func_180495_p(blockPos).func_203425_a(Blocks.field_150353_l) || super.func_188555_b(blockPos);
        }
    }

    public static class AgeData
    extends AgeableEntity.AgeableData {
        public final RiderType field_234320_a_;

        public AgeData(RiderType riderType) {
            this.field_234320_a_ = riderType;
        }

        public static enum RiderType {
            NO_RIDER,
            BABY_RIDER,
            PIGLIN_RIDER;

        }
    }
}

