/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.fluid;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class FlowingFluid
extends Fluid {
    public static final BooleanProperty field_207209_a = BlockStateProperties.field_208183_j;
    public static final IntegerProperty field_207210_b = BlockStateProperties.field_208131_af;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>> field_212756_e = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> object2ByteLinkedOpenHashMap = new Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>(200){

            protected void rehash(int n) {
            }
        };
        object2ByteLinkedOpenHashMap.defaultReturnValue((byte)127);
        return object2ByteLinkedOpenHashMap;
    });
    private final Map<FluidState, VoxelShape> field_215669_f = Maps.newIdentityHashMap();

    @Override
    protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
        builder.func_206894_a(field_207209_a);
    }

    @Override
    public Vector3d func_215663_a(IBlockReader iBlockReader, BlockPos blockPos, FluidState fluidState) {
        double d = 0.0;
        \u2603 = 0.0;
        BlockPos.Mutable \u26032 = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            \u26032.func_239622_a_(blockPos, direction);
            Object object = iBlockReader.func_204610_c(\u26032);
            if (!this.func_212189_g((FluidState)object)) continue;
            float \u26033 = ((FluidState)object).func_223408_f();
            float \u26034 = 0.0f;
            if (\u26033 == 0.0f) {
                if (!iBlockReader.func_180495_p(\u26032).func_185904_a().func_76230_c() && this.func_212189_g(\u2603 = iBlockReader.func_204610_c((BlockPos)(\u2603 = \u26032.func_177977_b()))) && (\u26033 = \u2603.func_223408_f()) > 0.0f) {
                    \u26034 = fluidState.func_223408_f() - (\u26033 - 0.8888889f);
                }
            } else if (\u26033 > 0.0f) {
                \u26034 = fluidState.func_223408_f() - \u26033;
            }
            if (\u26034 == 0.0f) continue;
            d += (double)((float)direction.func_82601_c() * \u26034);
            \u2603 += (double)((float)direction.func_82599_e() * \u26034);
        }
        Vector3d vector3d = new Vector3d(d, 0.0, \u2603);
        if (fluidState.func_177229_b(field_207209_a).booleanValue()) {
            for (Object object : Direction.Plane.HORIZONTAL) {
                \u26032.func_239622_a_(blockPos, (Direction)object);
                if (!this.func_205573_a(iBlockReader, \u26032, (Direction)object) && !this.func_205573_a(iBlockReader, \u26032.func_177984_a(), (Direction)object)) continue;
                vector3d = vector3d.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
                break;
            }
        }
        return vector3d.func_72432_b();
    }

    private boolean func_212189_g(FluidState fluidState) {
        return fluidState.func_206888_e() || fluidState.func_206886_c().func_207187_a(this);
    }

    protected boolean func_205573_a(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        BlockState blockState = iBlockReader.func_180495_p(blockPos);
        FluidState \u26032 = iBlockReader.func_204610_c(blockPos);
        if (\u26032.func_206886_c().func_207187_a(this)) {
            return false;
        }
        if (direction == Direction.UP) {
            return true;
        }
        if (blockState.func_185904_a() == Material.field_151588_w) {
            return false;
        }
        return blockState.func_224755_d(iBlockReader, blockPos, direction);
    }

    protected void func_205575_a(IWorld iWorld, BlockPos blockPos, FluidState fluidState) {
        if (fluidState.func_206888_e()) {
            return;
        }
        BlockState blockState = iWorld.func_180495_p(blockPos);
        BlockPos \u26032 = blockPos.func_177977_b();
        \u2603 = iWorld.func_180495_p(\u26032);
        FluidState \u26033 = this.func_205576_a(iWorld, \u26032, \u2603);
        if (this.func_205570_b(iWorld, blockPos, blockState, Direction.DOWN, \u26032, \u2603, iWorld.func_204610_c(\u26032), \u26033.func_206886_c())) {
            this.func_205574_a(iWorld, \u26032, \u2603, Direction.DOWN, \u26033);
            if (this.func_207936_a(iWorld, blockPos) >= 3) {
                this.func_207937_a(iWorld, blockPos, fluidState, blockState);
            }
        } else if (fluidState.func_206889_d() || !this.func_211759_a(iWorld, \u26033.func_206886_c(), blockPos, blockState, \u26032, \u2603)) {
            this.func_207937_a(iWorld, blockPos, fluidState, blockState);
        }
    }

    private void func_207937_a(IWorld iWorld, BlockPos blockPos, FluidState fluidState, BlockState blockState) {
        int n = fluidState.func_206882_g() - this.func_204528_b(iWorld);
        if (fluidState.func_177229_b(field_207209_a).booleanValue()) {
            n = 7;
        }
        if (n <= 0) {
            return;
        }
        Map<Direction, FluidState> \u26032 = this.func_205572_b(iWorld, blockPos, blockState);
        for (Map.Entry<Direction, FluidState> entry : \u26032.entrySet()) {
            Direction direction = entry.getKey();
            FluidState \u26033 = entry.getValue();
            BlockPos \u26034 = blockPos.func_177972_a(direction);
            if (!this.func_205570_b(iWorld, blockPos, blockState, direction, \u26034, \u2603 = iWorld.func_180495_p(\u26034), iWorld.func_204610_c(\u26034), \u26033.func_206886_c())) continue;
            this.func_205574_a(iWorld, \u26034, \u2603, direction, \u26033);
        }
    }

    protected FluidState func_205576_a(IWorldReader iWorldReader, BlockPos blockPos, BlockState blockState) {
        Object object;
        int \u26033 = 0;
        \u2603 = 0;
        for (Object object2 : Direction.Plane.HORIZONTAL) {
            object = blockPos.func_177972_a((Direction)object2);
            BlockState blockState2 = iWorldReader.func_180495_p((BlockPos)object);
            FluidState \u26032 = blockState2.func_204520_s();
            if (!\u26032.func_206886_c().func_207187_a(this) || !this.func_212751_a((Direction)object2, iWorldReader, blockPos, blockState, (BlockPos)object, blockState2)) continue;
            if (\u26032.func_206889_d()) {
                ++\u2603;
            }
            \u26033 = Math.max(\u26033, \u26032.func_206882_g());
        }
        if (this.func_205579_d() && \u2603 >= 2) {
            Object object3 = iWorldReader.func_180495_p(blockPos.func_177977_b());
            object2 = ((AbstractBlock.AbstractBlockState)object3).func_204520_s();
            if (((AbstractBlock.AbstractBlockState)object3).func_185904_a().func_76220_a() || this.func_211758_g((FluidState)object2)) {
                return this.func_207204_a(false);
            }
        }
        if (!((FluidState)(object = ((AbstractBlock.AbstractBlockState)(object2 = iWorldReader.func_180495_p((BlockPos)(object3 = blockPos.func_177984_a())))).func_204520_s())).func_206888_e() && ((FluidState)object).func_206886_c().func_207187_a(this) && this.func_212751_a(Direction.UP, iWorldReader, blockPos, blockState, (BlockPos)object3, (BlockState)object2)) {
            return this.func_207207_a(8, true);
        }
        int \u26034 = \u26033 - this.func_204528_b(iWorldReader);
        if (\u26034 <= 0) {
            return Fluids.field_204541_a.func_207188_f();
        }
        return this.func_207207_a(\u26034, false);
    }

    private boolean func_212751_a(Direction direction, IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, BlockPos blockPos2, BlockState blockState2) {
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> object2ByteLinkedOpenHashMap = blockState.func_177230_c().func_208619_r() || blockState2.func_177230_c().func_208619_r() ? null : field_212756_e.get();
        if (object2ByteLinkedOpenHashMap != null) {
            Block.RenderSideCacheKey renderSideCacheKey = new Block.RenderSideCacheKey(blockState, blockState2, direction);
            byte \u26032 = object2ByteLinkedOpenHashMap.getAndMoveToFirst((Object)renderSideCacheKey);
            if (\u26032 != 127) {
                return \u26032 != 0;
            }
        } else {
            renderSideCacheKey = null;
        }
        boolean bl = \u2603 = !VoxelShapes.func_204642_b(\u2603 = blockState.func_196952_d(iBlockReader, blockPos), \u2603 = blockState2.func_196952_d(iBlockReader, blockPos2), direction);
        if (object2ByteLinkedOpenHashMap != null) {
            if (object2ByteLinkedOpenHashMap.size() == 200) {
                object2ByteLinkedOpenHashMap.removeLastByte();
            }
            object2ByteLinkedOpenHashMap.putAndMoveToFirst((Object)renderSideCacheKey, (byte)(\u2603 ? 1 : 0));
        }
        return \u2603;
    }

    public abstract Fluid func_210197_e();

    public FluidState func_207207_a(int n, boolean bl) {
        return (FluidState)((FluidState)this.func_210197_e().func_207188_f().func_206870_a(field_207210_b, n)).func_206870_a(field_207209_a, bl);
    }

    public abstract Fluid func_210198_f();

    public FluidState func_207204_a(boolean bl) {
        return (FluidState)this.func_210198_f().func_207188_f().func_206870_a(field_207209_a, bl);
    }

    protected abstract boolean func_205579_d();

    protected void func_205574_a(IWorld iWorld, BlockPos blockPos, BlockState blockState, Direction direction, FluidState fluidState) {
        if (blockState.func_177230_c() instanceof ILiquidContainer) {
            ((ILiquidContainer)((Object)blockState.func_177230_c())).func_204509_a(iWorld, blockPos, blockState, fluidState);
        } else {
            if (!blockState.func_196958_f()) {
                this.func_205580_a(iWorld, blockPos, blockState);
            }
            iWorld.func_180501_a(blockPos, fluidState.func_206883_i(), 3);
        }
    }

    protected abstract void func_205580_a(IWorld var1, BlockPos var2, BlockState var3);

    private static short func_212752_a(BlockPos blockPos, BlockPos blockPos2) {
        int n = blockPos2.func_177958_n() - blockPos.func_177958_n();
        \u2603 = blockPos2.func_177952_p() - blockPos.func_177952_p();
        return (short)((n + 128 & 0xFF) << 8 | \u2603 + 128 & 0xFF);
    }

    protected int func_205571_a(IWorldReader iWorldReader, BlockPos blockPos, int n2, Direction direction, BlockState blockState, BlockPos blockPos2, Short2ObjectMap<Pair<BlockState, FluidState>> short2ObjectMap, Short2BooleanMap short2BooleanMap) {
        int \u26037 = 1000;
        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
            if (direction2 == direction) continue;
            BlockPos blockPos3 = blockPos.func_177972_a(direction2);
            short \u26032 = FlowingFluid.func_212752_a(blockPos2, blockPos3);
            Pair \u26033 = (Pair)short2ObjectMap.computeIfAbsent(\u26032, n -> {
                BlockState blockState = iWorldReader.func_180495_p(blockPos3);
                return Pair.of((Object)blockState, (Object)blockState.func_204520_s());
            });
            BlockState \u26034 = (BlockState)\u26033.getFirst();
            FluidState \u26035 = (FluidState)\u26033.getSecond();
            if (!this.func_211760_a(iWorldReader, this.func_210197_e(), blockPos, blockState, direction2, blockPos3, \u26034, \u26035)) continue;
            boolean \u26036 = short2BooleanMap.computeIfAbsent(\u26032, n -> {
                BlockPos blockPos2 = blockPos3.func_177977_b();
                BlockState \u26032 = iWorldReader.func_180495_p(blockPos2);
                return this.func_211759_a(iWorldReader, this.func_210197_e(), blockPos3, \u26034, blockPos2, \u26032);
            });
            if (\u26036) {
                return n2;
            }
            if (n2 >= this.func_185698_b(iWorldReader) || (\u2603 = this.func_205571_a(iWorldReader, blockPos3, n2 + 1, direction2.func_176734_d(), \u26034, blockPos2, short2ObjectMap, short2BooleanMap)) >= \u26037) continue;
            \u26037 = \u2603;
        }
        return \u26037;
    }

    private boolean func_211759_a(IBlockReader iBlockReader, Fluid fluid, BlockPos blockPos, BlockState blockState, BlockPos blockPos2, BlockState blockState2) {
        if (!this.func_212751_a(Direction.DOWN, iBlockReader, blockPos, blockState, blockPos2, blockState2)) {
            return false;
        }
        if (blockState2.func_204520_s().func_206886_c().func_207187_a(this)) {
            return true;
        }
        return this.func_211761_a(iBlockReader, blockPos2, blockState2, fluid);
    }

    private boolean func_211760_a(IBlockReader iBlockReader, Fluid fluid, BlockPos blockPos, BlockState blockState, Direction direction, BlockPos blockPos2, BlockState blockState2, FluidState fluidState) {
        return !this.func_211758_g(fluidState) && this.func_212751_a(direction, iBlockReader, blockPos, blockState, blockPos2, blockState2) && this.func_211761_a(iBlockReader, blockPos2, blockState2, fluid);
    }

    private boolean func_211758_g(FluidState fluidState) {
        return fluidState.func_206886_c().func_207187_a(this) && fluidState.func_206889_d();
    }

    protected abstract int func_185698_b(IWorldReader var1);

    private int func_207936_a(IWorldReader iWorldReader, BlockPos blockPos) {
        int n = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(direction);
            FluidState \u26032 = iWorldReader.func_204610_c(blockPos2);
            if (!this.func_211758_g(\u26032)) continue;
            ++n;
        }
        return n;
    }

    protected Map<Direction, FluidState> func_205572_b(IWorldReader iWorldReader, BlockPos blockPos, BlockState blockState) {
        int \u260312 = 1000;
        EnumMap \u26032 = Maps.newEnumMap(Direction.class);
        Short2ObjectOpenHashMap \u26033 = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap \u26034 = new Short2BooleanOpenHashMap();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(direction);
            short \u26035 = FlowingFluid.func_212752_a(blockPos, blockPos2);
            Pair \u26036 = (Pair)\u26033.computeIfAbsent(\u26035, n -> {
                BlockState blockState = iWorldReader.func_180495_p(blockPos2);
                return Pair.of((Object)blockState, (Object)blockState.func_204520_s());
            });
            BlockState \u26037 = (BlockState)\u26036.getFirst();
            FluidState \u26038 = (FluidState)\u26036.getSecond();
            FluidState \u26039 = this.func_205576_a(iWorldReader, blockPos2, \u26037);
            if (!this.func_211760_a(iWorldReader, \u26039.func_206886_c(), blockPos, blockState, direction, blockPos2, \u26037, \u26038)) continue;
            \u2603 = blockPos2.func_177977_b();
            boolean \u260310 = \u26034.computeIfAbsent(\u26035, n -> {
                BlockState blockState2 = iWorldReader.func_180495_p(\u2603);
                return this.func_211759_a(iWorldReader, this.func_210197_e(), blockPos2, \u26037, \u2603, blockState2);
            });
            int \u260311 = \u260310 ? 0 : this.func_205571_a(iWorldReader, blockPos2, 1, direction.func_176734_d(), \u26037, blockPos, (Short2ObjectMap<Pair<BlockState, FluidState>>)\u26033, (Short2BooleanMap)\u26034);
            if (\u260311 < \u260312) {
                \u26032.clear();
            }
            if (\u260311 > \u260312) continue;
            \u26032.put(direction, \u26039);
            \u260312 = \u260311;
        }
        return \u26032;
    }

    private boolean func_211761_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        Block block = blockState.func_177230_c();
        if (block instanceof ILiquidContainer) {
            return ((ILiquidContainer)((Object)block)).func_204510_a(iBlockReader, blockPos, blockState, fluid);
        }
        if (block instanceof DoorBlock || block.func_203417_a(BlockTags.field_219753_V) || block == Blocks.field_150468_ap || block == Blocks.field_196608_cF || block == Blocks.field_203203_C) {
            return false;
        }
        Material \u26032 = blockState.func_185904_a();
        if (\u26032 == Material.field_151567_E || \u26032 == Material.field_189963_J || \u26032 == Material.field_203243_f || \u26032 == Material.field_204868_h) {
            return false;
        }
        return !\u26032.func_76230_c();
    }

    protected boolean func_205570_b(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, Direction direction, BlockPos blockPos2, BlockState blockState2, FluidState fluidState, Fluid fluid) {
        return fluidState.func_215677_a(iBlockReader, blockPos2, fluid, direction) && this.func_212751_a(direction, iBlockReader, blockPos, blockState, blockPos2, blockState2) && this.func_211761_a(iBlockReader, blockPos2, blockState2, fluid);
    }

    protected abstract int func_204528_b(IWorldReader var1);

    protected int func_215667_a(World world, BlockPos blockPos, FluidState fluidState, FluidState fluidState2) {
        return this.func_205569_a(world);
    }

    @Override
    public void func_207191_a(World world2, BlockPos blockPos, FluidState fluidState3) {
        World world2;
        if (!fluidState3.func_206889_d()) {
            FluidState fluidState2;
            fluidState2 = this.func_205576_a(world2, blockPos, world2.func_180495_p(blockPos));
            int n = this.func_215667_a(world2, blockPos, fluidState3, fluidState2);
            if (fluidState2.func_206888_e()) {
                FluidState fluidState3 = fluidState2;
                world2.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
            } else if (!fluidState2.equals(fluidState3)) {
                fluidState3 = fluidState2;
                BlockState blockState = fluidState3.func_206883_i();
                world2.func_180501_a(blockPos, blockState, 2);
                world2.func_205219_F_().func_205360_a(blockPos, fluidState3.func_206886_c(), n);
                world2.func_195593_d(blockPos, blockState.func_177230_c());
            }
        }
        this.func_205575_a(world2, blockPos, fluidState3);
    }

    protected static int func_207205_e(FluidState fluidState) {
        if (fluidState.func_206889_d()) {
            return 0;
        }
        return 8 - Math.min(fluidState.func_206882_g(), 8) + (fluidState.func_177229_b(field_207209_a) != false ? 8 : 0);
    }

    private static boolean func_215666_c(FluidState fluidState, IBlockReader iBlockReader, BlockPos blockPos) {
        return fluidState.func_206886_c().func_207187_a(iBlockReader.func_204610_c(blockPos.func_177984_a()).func_206886_c());
    }

    @Override
    public float func_215662_a(FluidState fluidState, IBlockReader iBlockReader, BlockPos blockPos) {
        if (FlowingFluid.func_215666_c(fluidState, iBlockReader, blockPos)) {
            return 1.0f;
        }
        return fluidState.func_223408_f();
    }

    @Override
    public float func_223407_a(FluidState fluidState) {
        return (float)fluidState.func_206882_g() / 9.0f;
    }

    @Override
    public VoxelShape func_215664_b(FluidState fluidState2, IBlockReader iBlockReader, BlockPos blockPos) {
        if (fluidState2.func_206882_g() == 9 && FlowingFluid.func_215666_c(fluidState2, iBlockReader, blockPos)) {
            return VoxelShapes.func_197868_b();
        }
        return this.field_215669_f.computeIfAbsent(fluidState2, fluidState -> VoxelShapes.func_197873_a(0.0, 0.0, 0.0, 1.0, fluidState.func_215679_a(iBlockReader, blockPos), 1.0));
    }
}

