/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.play.server.SRecipeBookPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerRecipeBook
extends RecipeBook {
    private static final Logger field_192828_d = LogManager.getLogger();

    public int func_197926_a(Collection<IRecipe<?>> collection, ServerPlayerEntity serverPlayerEntity2) {
        ServerPlayerEntity serverPlayerEntity2;
        ArrayList arrayList = Lists.newArrayList();
        int \u26032 = 0;
        for (IRecipe<?> iRecipe : collection) {
            ResourceLocation resourceLocation = iRecipe.func_199560_c();
            if (this.field_194077_a.contains(resourceLocation) || iRecipe.func_192399_d()) continue;
            this.func_209118_a(resourceLocation);
            this.func_209120_c(resourceLocation);
            arrayList.add(resourceLocation);
            CriteriaTriggers.field_192126_f.func_192225_a(serverPlayerEntity2, iRecipe);
            ++\u26032;
        }
        this.func_194081_a(SRecipeBookPacket.State.ADD, serverPlayerEntity2, arrayList);
        return \u26032;
    }

    public int func_197925_b(Collection<IRecipe<?>> collection, ServerPlayerEntity serverPlayerEntity2) {
        ServerPlayerEntity serverPlayerEntity2;
        ArrayList arrayList = Lists.newArrayList();
        int \u26032 = 0;
        for (IRecipe<?> iRecipe : collection) {
            ResourceLocation resourceLocation = iRecipe.func_199560_c();
            if (!this.field_194077_a.contains(resourceLocation)) continue;
            this.func_209119_b(resourceLocation);
            arrayList.add(resourceLocation);
            ++\u26032;
        }
        this.func_194081_a(SRecipeBookPacket.State.REMOVE, serverPlayerEntity2, arrayList);
        return \u26032;
    }

    private void func_194081_a(SRecipeBookPacket.State state, ServerPlayerEntity serverPlayerEntity, List<ResourceLocation> list) {
        serverPlayerEntity.field_71135_a.func_147359_a(new SRecipeBookPacket(state, list, Collections.emptyList(), this.field_192818_b, this.field_192819_c, this.field_202885_e, this.field_202886_f));
    }

    public CompoundNBT func_192824_e() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74757_a("isGuiOpen", this.field_192818_b);
        compoundNBT.func_74757_a("isFilteringCraftable", this.field_192819_c);
        compoundNBT.func_74757_a("isFurnaceGuiOpen", this.field_202885_e);
        compoundNBT.func_74757_a("isFurnaceFilteringCraftable", this.field_202886_f);
        compoundNBT.func_74757_a("isBlastingFurnaceGuiOpen", this.field_216763_g);
        compoundNBT.func_74757_a("isBlastingFurnaceFilteringCraftable", this.field_216764_h);
        compoundNBT.func_74757_a("isSmokerGuiOpen", this.field_216765_i);
        compoundNBT.func_74757_a("isSmokerFilteringCraftable", this.field_216766_j);
        ListNBT \u26032 = new ListNBT();
        for (ResourceLocation resourceLocation : this.field_194077_a) {
            \u26032.add(StringNBT.func_229705_a_(resourceLocation.toString()));
        }
        compoundNBT.func_218657_a("recipes", \u26032);
        ListNBT \u26033 = new ListNBT();
        for (ResourceLocation resourceLocation : this.field_194078_b) {
            \u26033.add(StringNBT.func_229705_a_(resourceLocation.toString()));
        }
        compoundNBT.func_218657_a("toBeDisplayed", \u26033);
        return compoundNBT;
    }

    public void func_192825_a(CompoundNBT compoundNBT, RecipeManager recipeManager) {
        this.field_192818_b = compoundNBT.func_74767_n("isGuiOpen");
        this.field_192819_c = compoundNBT.func_74767_n("isFilteringCraftable");
        this.field_202885_e = compoundNBT.func_74767_n("isFurnaceGuiOpen");
        this.field_202886_f = compoundNBT.func_74767_n("isFurnaceFilteringCraftable");
        this.field_216763_g = compoundNBT.func_74767_n("isBlastingFurnaceGuiOpen");
        this.field_216764_h = compoundNBT.func_74767_n("isBlastingFurnaceFilteringCraftable");
        this.field_216765_i = compoundNBT.func_74767_n("isSmokerGuiOpen");
        this.field_216766_j = compoundNBT.func_74767_n("isSmokerFilteringCraftable");
        ListNBT listNBT = compoundNBT.func_150295_c("recipes", 8);
        this.func_223417_a_(listNBT, this::func_194073_a, recipeManager);
        \u2603 = compoundNBT.func_150295_c("toBeDisplayed", 8);
        this.func_223417_a_(\u2603, this::func_193825_e, recipeManager);
    }

    private void func_223417_a_(ListNBT listNBT, Consumer<IRecipe<?>> consumer, RecipeManager recipeManager) {
        for (int i = 0; i < listNBT.size(); ++i) {
            String string = listNBT.func_150307_f(i);
            try {
                ResourceLocation resourceLocation = new ResourceLocation(string);
                Optional<IRecipe<?>> \u26032 = recipeManager.func_215367_a(resourceLocation);
                if (!\u26032.isPresent()) {
                    field_192828_d.error("Tried to load unrecognized recipe: {} removed now.", (Object)resourceLocation);
                    continue;
                }
                consumer.accept(\u26032.get());
                continue;
            }
            catch (ResourceLocationException resourceLocationException) {
                field_192828_d.error("Tried to load improperly formatted recipe: {} removed now.", (Object)string);
            }
        }
    }

    public void func_192826_c(ServerPlayerEntity serverPlayerEntity) {
        serverPlayerEntity.field_71135_a.func_147359_a(new SRecipeBookPacket(SRecipeBookPacket.State.INIT, this.field_194077_a, this.field_194078_b, this.field_192818_b, this.field_192819_c, this.field_202885_e, this.field_202886_f));
    }
}

