/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnchantRandomly
extends LootFunction {
    private static final Logger field_186557_a = LogManager.getLogger();
    private final List<Enchantment> field_186558_b;

    private EnchantRandomly(ILootCondition[] iLootConditionArray, Collection<Enchantment> collection) {
        super(iLootConditionArray);
        this.field_186558_b = ImmutableList.copyOf(collection);
    }

    @Override
    public LootFunctionType func_230425_b_() {
        return LootFunctionManager.field_237431_d_;
    }

    @Override
    public ItemStack func_215859_a(ItemStack itemStack, LootContext lootContext) {
        Enchantment \u26033;
        Random random = lootContext.func_216032_b();
        if (this.field_186558_b.isEmpty()) {
            boolean bl = itemStack.func_77973_b() == Items.field_151122_aG;
            List \u26032 = Registry.field_212628_q.func_201756_e().filter(Enchantment::func_230310_i_).filter(enchantment -> bl || enchantment.func_92089_a(itemStack)).collect(Collectors.toList());
            if (\u26032.isEmpty()) {
                field_186557_a.warn("Couldn't find a compatible enchantment for {}", (Object)itemStack);
                return itemStack;
            }
            \u26033 = (Enchantment)\u26032.get(random.nextInt(\u26032.size()));
        } else {
            \u26033 = this.field_186558_b.get(random.nextInt(this.field_186558_b.size()));
        }
        return EnchantRandomly.func_237420_a_(itemStack, \u26033, random);
    }

    private static ItemStack func_237420_a_(ItemStack itemStack2, Enchantment enchantment, Random random) {
        ItemStack itemStack2;
        int n = MathHelper.func_76136_a(random, enchantment.func_77319_d(), enchantment.func_77325_b());
        if (itemStack2.func_77973_b() == Items.field_151122_aG) {
            itemStack2 = new ItemStack(Items.field_151134_bR);
            EnchantedBookItem.func_92115_a(itemStack2, new EnchantmentData(enchantment, n));
        } else {
            itemStack2.func_77966_a(enchantment, n);
        }
        return itemStack2;
    }

    public static LootFunction.Builder<?> func_215900_c() {
        return EnchantRandomly.func_215860_a(iLootConditionArray -> new EnchantRandomly((ILootCondition[])iLootConditionArray, (Collection<Enchantment>)ImmutableList.of()));
    }

    public static class Serializer
    extends LootFunction.Serializer<EnchantRandomly> {
        @Override
        public void func_230424_a_(JsonObject jsonObject2, EnchantRandomly enchantRandomly, JsonSerializationContext jsonSerializationContext) {
            super.func_230424_a_(jsonObject2, enchantRandomly, jsonSerializationContext);
            if (!enchantRandomly.field_186558_b.isEmpty()) {
                JsonObject jsonObject2;
                JsonArray jsonArray = new JsonArray();
                for (Enchantment enchantment : enchantRandomly.field_186558_b) {
                    ResourceLocation resourceLocation = Registry.field_212628_q.func_177774_c(enchantment);
                    if (resourceLocation == null) {
                        throw new IllegalArgumentException("Don't know how to serialize enchantment " + enchantment);
                    }
                    jsonArray.add((JsonElement)new JsonPrimitive(resourceLocation.toString()));
                }
                jsonObject2.add("enchantments", (JsonElement)jsonArray);
            }
        }

        @Override
        public EnchantRandomly func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            ArrayList arrayList = Lists.newArrayList();
            if (jsonObject.has("enchantments")) {
                JsonArray jsonArray = JSONUtils.func_151214_t(jsonObject, "enchantments");
                for (JsonElement jsonElement : jsonArray) {
                    String string = JSONUtils.func_151206_a(jsonElement, "enchantment");
                    Enchantment \u26032 = Registry.field_212628_q.func_218349_b(new ResourceLocation(string)).orElseThrow(() -> new JsonSyntaxException("Unknown enchantment '" + string + "'"));
                    arrayList.add(\u26032);
                }
            }
            return new EnchantRandomly(iLootConditionArray, arrayList);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final Set<Enchantment> field_237423_a_ = Sets.newHashSet();

        @Override
        protected Builder func_212826_d_() {
            return this;
        }

        public Builder func_237424_a_(Enchantment enchantment) {
            this.field_237423_a_.add(enchantment);
            return this;
        }

        @Override
        public ILootFunction func_216052_b() {
            return new EnchantRandomly(this.func_216053_g(), this.field_237423_a_);
        }

        @Override
        protected /* synthetic */ LootFunction.Builder func_212826_d_() {
            return this.func_212826_d_();
        }
    }
}

