/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerEula;
import net.minecraft.server.ServerPropertiesProvider;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.WorldOptimizer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.listener.LoggingChunkStatusListener;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger field_240759_a_ = LogManager.getLogger();

    public static void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u26032 = optionParser.accepts("nogui");
        OptionSpecBuilder \u26033 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u26034 = optionParser.accepts("demo");
        OptionSpecBuilder \u26035 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u26036 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u26037 = optionParser.accepts("eraseCache");
        OptionSpecBuilder \u26038 = optionParser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec \u26039 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260314 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u260315 = optionParser.nonOptions();
        try {
            Object \u260337;
            Object \u260335;
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u26039)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            CrashReport.func_230188_h_();
            Bootstrap.func_151354_b();
            Bootstrap.func_218821_c();
            Util.func_240994_l_();
            Path \u260316 = Paths.get("server.properties", new String[0]);
            ServerPropertiesProvider \u260317 = new ServerPropertiesProvider(\u260316);
            \u260317.func_219035_b();
            Path \u260318 = Paths.get("eula.txt", new String[0]);
            ServerEula \u260319 = new ServerEula(\u260318);
            if (optionSet.has((OptionSpec)\u26033)) {
                field_240759_a_.info("Initialized '{}' and '{}'", (Object)\u260316.toAbsolutePath(), (Object)\u260318.toAbsolutePath());
                return;
            }
            if (!\u260319.func_154346_a()) {
                field_240759_a_.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File \u260320 = new File((String)optionSet.valueOf((OptionSpec)\u260311));
            YggdrasilAuthenticationService \u260321 = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService \u260322 = \u260321.createMinecraftSessionService();
            GameProfileRepository \u260323 = \u260321.createProfileRepository();
            PlayerProfileCache \u260324 = new PlayerProfileCache(\u260323, new File(\u260320, MinecraftServer.field_152367_a.getName()));
            String \u260325 = (String)Optional.ofNullable(optionSet.valueOf((OptionSpec)\u260312)).orElse(\u260317.func_219034_a().field_219021_o);
            SaveFormat \u260326 = SaveFormat.func_237269_a_(\u260320.toPath());
            SaveFormat.LevelSave \u260327 = \u260326.func_237274_c_(\u260325);
            MinecraftServer.func_240777_a_(\u260327);
            DatapackCodec \u260328 = \u260327.func_237297_e_();
            boolean \u260329 = optionSet.has((OptionSpec)\u26038);
            if (\u260329) {
                field_240759_a_.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            ResourcePackList<ResourcePackInfo> \u260330 = new ResourcePackList<ResourcePackInfo>(ResourcePackInfo::new, new ServerPackFinder(), new FolderPackFinder(\u260327.func_237285_a_(FolderName.field_237251_g_).toFile(), IPackNameDecorator.field_232627_c_));
            DatapackCodec \u260331 = MinecraftServer.func_240772_a_(\u260330, \u260328 == null ? DatapackCodec.field_234880_a_ : \u260328, \u260329);
            CompletableFuture<DataPackRegistries> \u260332 = DataPackRegistries.func_240961_a_(\u260330.func_232623_f_(), Commands.EnvironmentType.DEDICATED, \u260317.func_219034_a().field_225395_K, Util.func_215072_e(), Runnable::run);
            try {
                DataPackRegistries dataPackRegistries = \u260332.get();
            }
            catch (Exception exception) {
                field_240759_a_.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                \u260330.close();
                return;
            }
            dataPackRegistries.func_240971_i_();
            IDynamicRegistries.Impl impl = IDynamicRegistries.func_239770_b_();
            WorldSettingsImport<INBT> \u260333 = WorldSettingsImport.func_240876_a_(NBTDynamicOps.field_210820_a, dataPackRegistries.func_240970_h_(), impl);
            IServerConfiguration \u260334 = \u260327.func_237284_a_(\u260333, \u260331);
            if (\u260334 == null) {
                if (optionSet.has((OptionSpec)\u26034)) {
                    \u260335 = MinecraftServer.field_213219_c;
                    \u260336 = DimensionGeneratorSettings.field_236202_b_;
                } else {
                    \u260337 = \u260317.func_219034_a();
                    \u260335 = new WorldSettings(((ServerProperties)\u260337).field_219021_o, ((ServerProperties)\u260337).field_219020_n, ((ServerProperties)\u260337).field_218990_C, ((ServerProperties)\u260337).field_219019_m, false, new GameRules(), \u260331);
                    \u260336 = optionSet.has((OptionSpec)\u26035) ? ((ServerProperties)\u260337).field_241082_U_.func_236230_k_() : ((ServerProperties)\u260337).field_241082_U_;
                }
                \u260334 = new ServerWorldInfo((WorldSettings)\u260335, (DimensionGeneratorSettings)\u260336, Lifecycle.stable());
            }
            if (optionSet.has((OptionSpec)\u26036)) {
                Main.func_240761_a_(\u260327, DataFixesManager.func_210901_a(), optionSet.has((OptionSpec)\u26037), () -> true, \u260334.func_230418_z_().func_236226_g_());
            }
            \u260327.func_237287_a_(impl, \u260334);
            \u260335 = \u260334;
            Object \u260336 = MinecraftServer.func_240784_a_(arg_0 -> Main.func_240762_a_(impl, \u260327, \u260330, dataPackRegistries, (IServerConfiguration)\u260335, \u260317, \u260322, \u260323, \u260324, optionSet, (OptionSpec)\u260310, (OptionSpec)\u260313, (OptionSpec)\u26034, (OptionSpec)\u260314, (OptionSpec)\u26032, (OptionSpec)\u260315, arg_0));
            \u260337 = new Thread("Server Shutdown Thread", (DedicatedServer)\u260336){
                final /* synthetic */ DedicatedServer field_240763_a_;
                {
                    this.field_240763_a_ = dedicatedServer;
                    super(string);
                }

                @Override
                public void run() {
                    this.field_240763_a_.func_71263_m(true);
                }
            };
            ((Thread)\u260337).setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_240759_a_));
            Runtime.getRuntime().addShutdownHook((Thread)\u260337);
        }
        catch (Exception exception) {
            field_240759_a_.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    private static void func_240761_a_(SaveFormat.LevelSave levelSave, DataFixer dataFixer, boolean bl, BooleanSupplier booleanSupplier2, ImmutableSet<RegistryKey<World>> immutableSet) {
        field_240759_a_.info("Forcing world upgrade!");
        WorldOptimizer worldOptimizer = new WorldOptimizer(levelSave, dataFixer, immutableSet, bl);
        ITextComponent \u26032 = null;
        while (!worldOptimizer.func_212218_b()) {
            BooleanSupplier booleanSupplier2;
            ITextComponent iTextComponent = worldOptimizer.func_212215_m();
            if (\u26032 != iTextComponent) {
                \u26032 = iTextComponent;
                field_240759_a_.info(worldOptimizer.func_212215_m().getString());
            }
            if ((\u2603 = worldOptimizer.func_212211_j()) > 0) {
                int n = worldOptimizer.func_212208_k() + worldOptimizer.func_212209_l();
                field_240759_a_.info("{}% completed ({} / {} chunks)...", (Object)MathHelper.func_76141_d((float)n / (float)\u2603 * 100.0f), (Object)n, (Object)\u2603);
            }
            if (!booleanSupplier2.getAsBoolean()) {
                worldOptimizer.func_212217_a();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer func_240762_a_(IDynamicRegistries.Impl impl, SaveFormat.LevelSave levelSave, ResourcePackList resourcePackList, DataPackRegistries dataPackRegistries, IServerConfiguration iServerConfiguration, ServerPropertiesProvider serverPropertiesProvider, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, PlayerProfileCache playerProfileCache, OptionSet optionSet, OptionSpec optionSpec, OptionSpec optionSpec2, OptionSpec optionSpec3, OptionSpec optionSpec4, OptionSpec optionSpec5, OptionSpec optionSpec6, Thread thread) {
        DedicatedServer dedicatedServer = new DedicatedServer(thread, impl, levelSave, resourcePackList, dataPackRegistries, iServerConfiguration, serverPropertiesProvider, DataFixesManager.func_210901_a(), minecraftSessionService, gameProfileRepository, playerProfileCache, LoggingChunkStatusListener::new);
        dedicatedServer.func_71224_l((String)optionSet.valueOf(optionSpec));
        dedicatedServer.func_71208_b((Integer)optionSet.valueOf(optionSpec2));
        dedicatedServer.func_71204_b(optionSet.has(optionSpec3));
        dedicatedServer.func_213208_c((String)optionSet.valueOf(optionSpec4));
        boolean bl = \u2603 = !optionSet.has(optionSpec5) && !optionSet.valuesOf(optionSpec6).contains("nogui");
        if (\u2603 && !GraphicsEnvironment.isHeadless()) {
            dedicatedServer.func_120011_ar();
        }
        return dedicatedServer;
    }
}

