/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ICommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.player.SpawnLocationHelper;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootTableManager;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.profiler.EmptyProfiler;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.LongTickDetector;
import net.minecraft.profiler.Snooper;
import net.minecraft.profiler.TimeTracker;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.scoreboard.ScoreboardSaveData;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.CustomServerBossInfoManager;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.WhiteList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.test.TestCollection;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WanderingTraderSpawner;
import net.minecraft.world.storage.CommandStorage;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraft.world.storage.PlayerData;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSavedDataCallableSave;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends RecursiveEventLoop<TickDelayedTask>
implements ISnooperInfo,
ICommandSource,
AutoCloseable {
    private static final Logger field_147145_h = LogManager.getLogger();
    public static final File field_152367_a = new File("usercache.json");
    public static final WorldSettings field_213219_c = new WorldSettings("Demo World", GameType.SURVIVAL, false, Difficulty.NORMAL, false, new GameRules(), DatapackCodec.field_234880_a_);
    protected final SaveFormat.LevelSave field_71310_m;
    protected final PlayerData field_240766_e_;
    private final Snooper field_71307_n = new Snooper("server", this, Util.func_211177_b());
    private final List<Runnable> field_71322_p = Lists.newArrayList();
    private TimeTracker field_240769_m_ = new TimeTracker(Util.field_211180_a, this::func_71259_af);
    private IProfiler field_71304_b = EmptyProfiler.field_219906_a;
    private final NetworkSystem field_147144_o;
    private final IChunkStatusListenerFactory field_213220_d;
    private final ServerStatusResponse field_147147_p = new ServerStatusResponse();
    private final Random field_147146_q = new Random();
    private final DataFixer field_184112_s;
    private String field_71320_r;
    private int field_71319_s = -1;
    protected final IDynamicRegistries.Impl field_240767_f_;
    private final Map<RegistryKey<World>, ServerWorld> field_71305_c = Maps.newLinkedHashMap();
    private PlayerList field_71318_t;
    private volatile boolean field_71317_u = true;
    private boolean field_71316_v;
    private int field_71315_w;
    protected final Proxy field_110456_c;
    private boolean field_71325_x;
    private boolean field_190519_A;
    private boolean field_71284_A;
    private boolean field_71285_B;
    @Nullable
    private String field_71286_C;
    private int field_71280_D;
    private int field_143008_E;
    public final long[] field_71311_j = new long[100];
    @Nullable
    private KeyPair field_71292_I;
    @Nullable
    private String field_71293_J;
    private boolean field_71288_M;
    private String field_147141_M = "";
    private String field_175588_P = "";
    private volatile boolean field_71296_Q;
    private long field_71299_R;
    private boolean field_71295_T;
    private boolean field_104057_T;
    private final MinecraftSessionService field_147143_S;
    private final GameProfileRepository field_152365_W;
    private final PlayerProfileCache field_152366_X;
    private long field_147142_T;
    private final Thread field_175590_aa;
    private long field_211151_aa = Util.func_211177_b();
    private long field_213213_ab;
    private boolean field_213214_ac;
    private final ResourcePackList<ResourcePackInfo> field_195577_ad;
    private final ServerScoreboard field_200255_ai = new ServerScoreboard(this);
    @Nullable
    private CommandStorage field_229733_al_;
    private final CustomServerBossInfoManager field_201301_aj = new CustomServerBossInfoManager();
    private final FunctionManager field_200258_al;
    private final FrameTimer field_213215_ap = new FrameTimer();
    private boolean field_205745_an;
    private float field_211152_ao;
    private final Executor field_213217_au;
    @Nullable
    private String field_213218_av;
    private DataPackRegistries field_195576_ac;
    private final TemplateManager field_240765_ak_;
    protected final IServerConfiguration field_240768_i_;

    public static <S extends MinecraftServer> S func_240784_a_(Function<Thread, S> function) {
        AtomicReference<MinecraftServer> atomicReference = new AtomicReference<MinecraftServer>();
        Thread \u26032 = new Thread(() -> ((MinecraftServer)atomicReference.get()).func_240802_v_(), "Server thread");
        \u26032.setUncaughtExceptionHandler((thread, throwable) -> field_147145_h.error((Object)throwable));
        MinecraftServer \u26033 = (MinecraftServer)function.apply(\u26032);
        atomicReference.set(\u26033);
        \u26032.start();
        return (S)\u26033;
    }

    public MinecraftServer(Thread thread, IDynamicRegistries.Impl impl, SaveFormat.LevelSave levelSave, IServerConfiguration iServerConfiguration, ResourcePackList<ResourcePackInfo> resourcePackList, Proxy proxy, DataFixer dataFixer, DataPackRegistries dataPackRegistries, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, PlayerProfileCache playerProfileCache, IChunkStatusListenerFactory iChunkStatusListenerFactory) {
        super("Server");
        this.field_240767_f_ = impl;
        this.field_240768_i_ = iServerConfiguration;
        this.field_110456_c = proxy;
        this.field_195577_ad = resourcePackList;
        this.field_195576_ac = dataPackRegistries;
        this.field_147143_S = minecraftSessionService;
        this.field_152365_W = gameProfileRepository;
        this.field_152366_X = playerProfileCache;
        this.field_147144_o = new NetworkSystem(this);
        this.field_213220_d = iChunkStatusListenerFactory;
        this.field_71310_m = levelSave;
        this.field_240766_e_ = levelSave.func_237292_b_();
        this.field_184112_s = dataFixer;
        this.field_200258_al = new FunctionManager(this, dataPackRegistries.func_240960_a_());
        this.field_240765_ak_ = new TemplateManager(dataPackRegistries.func_240970_h_(), levelSave, dataFixer);
        this.field_175590_aa = thread;
        this.field_213217_au = Util.func_215072_e();
    }

    private void func_213204_a(DimensionSavedDataManager dimensionSavedDataManager) {
        ScoreboardSaveData scoreboardSaveData = dimensionSavedDataManager.func_215752_a(ScoreboardSaveData::new, "scoreboard");
        scoreboardSaveData.func_96499_a(this.func_200251_aP());
        this.func_200251_aP().func_186684_a(new WorldSavedDataCallableSave(scoreboardSaveData));
    }

    protected abstract boolean func_71197_b() throws IOException;

    public static void func_240777_a_(SaveFormat.LevelSave levelSave) {
        if (levelSave.func_237295_c_()) {
            field_147145_h.info("Converting map!");
            levelSave.func_237283_a_(new IProgressUpdate(){
                private long field_96245_b = Util.func_211177_b();

                @Override
                public void func_200210_a(ITextComponent iTextComponent) {
                }

                @Override
                public void func_73718_a(int n) {
                    if (Util.func_211177_b() - this.field_96245_b >= 1000L) {
                        this.field_96245_b = Util.func_211177_b();
                        field_147145_h.info("Converting... {}%", (Object)n);
                    }
                }

                @Override
                public void func_200209_c(ITextComponent iTextComponent) {
                }
            });
        }
    }

    protected void func_240800_l__() {
        this.func_175584_a();
        this.field_240768_i_.func_230412_a_(this.getServerModName(), this.func_230045_q_().isPresent());
        IChunkStatusListener iChunkStatusListener = this.field_213220_d.create(11);
        this.func_240787_a_(iChunkStatusListener);
        this.func_230543_p_();
        this.func_213186_a(iChunkStatusListener);
    }

    protected void func_230543_p_() {
    }

    protected void func_240787_a_(IChunkStatusListener iChunkStatusListener) {
        ChunkGenerator \u26039;
        IServerWorldInfo iServerWorldInfo = this.field_240768_i_.func_230407_G_();
        DimensionGeneratorSettings \u26032 = this.field_240768_i_.func_230418_z_();
        boolean \u26033 = \u26032.func_236227_h_();
        long \u26034 = \u26032.func_236221_b_();
        long \u26035 = BiomeManager.func_235200_a_(\u26034);
        ImmutableList \u26036 = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner(iServerWorldInfo));
        SimpleRegistry<Dimension> \u26037 = \u26032.func_236224_e_();
        Dimension \u26038 = \u26037.func_230516_a_(Dimension.field_236053_b_);
        if (\u26038 == null) {
            DimensionType dimensionType = DimensionType.func_236019_a_();
            \u26039 = DimensionGeneratorSettings.func_236211_a_(new Random().nextLong());
        } else {
            dimensionType = \u26038.func_236063_b_();
            \u26039 = \u26038.func_236064_c_();
        }
        RegistryKey<DimensionType> registryKey = this.field_240767_f_.func_230520_a_().func_230519_c_(dimensionType).orElseThrow(() -> new IllegalStateException("Unregistered dimension type: " + dimensionType));
        ServerWorld \u260310 = new ServerWorld(this, this.field_213217_au, this.field_71310_m, iServerWorldInfo, World.field_234918_g_, registryKey, dimensionType, iChunkStatusListener, \u26039, \u26033, \u26035, (List<ISpecialSpawner>)\u26036, true);
        this.field_71305_c.put(World.field_234918_g_, \u260310);
        DimensionSavedDataManager \u260311 = \u260310.func_217481_x();
        this.func_213204_a(\u260311);
        this.field_229733_al_ = new CommandStorage(\u260311);
        WorldBorder \u260312 = \u260310.func_175723_af();
        \u260312.func_235926_a_(iServerWorldInfo.func_230398_q_());
        if (!iServerWorldInfo.func_76070_v()) {
            try {
                MinecraftServer.func_240786_a_(\u260310, iServerWorldInfo, \u26032.func_236223_d_(), \u26033, true);
                iServerWorldInfo.func_76091_d(true);
                if (\u26033) {
                    this.func_240778_a_(this.field_240768_i_);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception initializing level");
                try {
                    \u260310.func_72914_a(crashReport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            iServerWorldInfo.func_76091_d(true);
        }
        this.func_184103_al().func_212504_a(\u260310);
        if (this.field_240768_i_.func_230404_D_() != null) {
            this.func_201300_aS().func_201381_a(this.field_240768_i_.func_230404_D_());
        }
        for (Map.Entry<RegistryKey<Dimension>, Dimension> entry : \u26037.func_239659_c_()) {
            RegistryKey<Dimension> registryKey2 = entry.getKey();
            if (registryKey2 == Dimension.field_236053_b_) continue;
            RegistryKey<World> \u260313 = RegistryKey.func_240903_a_(Registry.field_239699_ae_, registryKey2.func_240901_a_());
            DimensionType \u260314 = entry.getValue().func_236063_b_();
            RegistryKey<DimensionType> \u260315 = this.field_240767_f_.func_230520_a_().func_230519_c_(\u260314).orElseThrow(() -> new IllegalStateException("Unregistered dimension type: " + \u260314));
            ChunkGenerator \u260316 = entry.getValue().func_236064_c_();
            DerivedWorldInfo \u260317 = new DerivedWorldInfo(this.field_240768_i_, iServerWorldInfo);
            ServerWorld \u260318 = new ServerWorld(this, this.field_213217_au, this.field_71310_m, \u260317, \u260313, \u260315, \u260314, iChunkStatusListener, \u260316, \u26033, \u26035, (List<ISpecialSpawner>)ImmutableList.of(), false);
            \u260312.func_177737_a(new IBorderListener.Impl(\u260318.func_175723_af()));
            this.field_71305_c.put(\u260313, \u260318);
        }
    }

    private static void func_240786_a_(ServerWorld serverWorld, IServerWorldInfo iServerWorldInfo2, boolean bl4, boolean bl2, boolean bl3) {
        boolean bl4;
        IServerWorldInfo iServerWorldInfo2;
        ChunkGenerator chunkGenerator = serverWorld.func_72863_F().func_201711_g();
        if (!bl3) {
            iServerWorldInfo2.func_176143_a(BlockPos.field_177992_a.func_177981_b(chunkGenerator.func_205470_d()));
            return;
        }
        if (bl2) {
            iServerWorldInfo2.func_176143_a(BlockPos.field_177992_a.func_177984_a());
            return;
        }
        BiomeProvider \u26032 = chunkGenerator.func_202090_b();
        List<Biome> \u26033 = \u26032.func_76932_a();
        Random \u26034 = new Random(serverWorld.func_72905_C());
        BlockPos \u26035 = \u26032.func_225531_a_(0, serverWorld.func_181545_F(), 0, 256, \u26033, \u26034);
        ChunkPos chunkPos = \u2603 = \u26035 == null ? new ChunkPos(0, 0) : new ChunkPos(\u26035);
        if (\u26035 == null) {
            field_147145_h.warn("Unable to find spawn biome");
        }
        boolean \u26036 = false;
        for (Block block : BlockTags.field_205599_H.func_230236_b_()) {
            if (!\u26032.func_205706_b().contains(block.func_176223_P())) continue;
            \u26036 = true;
            break;
        }
        iServerWorldInfo2.func_176143_a(\u2603.func_206849_h().func_177982_a(8, chunkGenerator.func_205470_d(), 8));
        int \u26037 = 0;
        int \u26038 = 0;
        int \u26039 = 0;
        int \u260310 = -1;
        int \u260311 = 32;
        for (int i = 0; i < 1024; ++i) {
            if (\u26037 > -16 && \u26037 <= 16 && \u26038 > -16 && \u26038 <= 16 && (\u2603 = SpawnLocationHelper.func_241094_a_(serverWorld, new ChunkPos(\u2603.field_77276_a + \u26037, \u2603.field_77275_b + \u26038), \u26036)) != null) {
                iServerWorldInfo2.func_176143_a(\u2603);
                break;
            }
            if (\u26037 == \u26038 || \u26037 < 0 && \u26037 == -\u26038 || \u26037 > 0 && \u26037 == 1 - \u26038) {
                \u2603 = \u26039;
                \u26039 = -\u260310;
                \u260310 = \u2603;
            }
            \u26037 += \u26039;
            \u26038 += \u260310;
        }
        if (bl4) {
            ConfiguredFeature<NoFeatureConfig, ?> configuredFeature = Feature.field_214487_aO.func_225566_b_(IFeatureConfig.field_202429_e);
            configuredFeature.func_236265_a_(serverWorld, serverWorld.func_241112_a_(), chunkGenerator, serverWorld.field_73012_v, new BlockPos(iServerWorldInfo2.func_76079_c(), iServerWorldInfo2.func_76075_d(), iServerWorldInfo2.func_76074_e()));
        }
    }

    private void func_240778_a_(IServerConfiguration iServerConfiguration) {
        iServerConfiguration.func_230409_a_(Difficulty.PEACEFUL);
        iServerConfiguration.func_230415_d_(true);
        IServerWorldInfo iServerWorldInfo = iServerConfiguration.func_230407_G_();
        iServerWorldInfo.func_76084_b(false);
        iServerWorldInfo.func_76069_a(false);
        iServerWorldInfo.func_230391_a_(1000000000);
        iServerWorldInfo.func_76068_b(6000L);
        iServerWorldInfo.func_230392_a_(GameType.SPECTATOR);
    }

    private void func_213186_a(IChunkStatusListener iChunkStatusListener) {
        ServerWorld serverWorld = this.func_241755_D_();
        field_147145_h.info("Preparing start region for dimension {}", (Object)serverWorld.func_234923_W_().func_240901_a_());
        BlockPos \u26032 = serverWorld.func_241135_u_();
        iChunkStatusListener.func_219509_a(new ChunkPos(\u26032));
        ServerChunkProvider \u26033 = serverWorld.func_72863_F();
        \u26033.func_212863_j_().func_215598_a(500);
        this.field_211151_aa = Util.func_211177_b();
        \u26033.func_217228_a(TicketType.field_219488_a, new ChunkPos(\u26032), 11, Unit.INSTANCE);
        while (\u26033.func_217229_b() != 441) {
            this.field_211151_aa = Util.func_211177_b() + 10L;
            this.func_213202_o();
        }
        this.field_211151_aa = Util.func_211177_b() + 10L;
        this.func_213202_o();
        for (ServerWorld serverWorld2 : this.field_71305_c.values()) {
            ForcedChunksSaveData forcedChunksSaveData = serverWorld2.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
            if (forcedChunksSaveData == null) continue;
            LongIterator \u26034 = forcedChunksSaveData.func_212438_a().iterator();
            while (\u26034.hasNext()) {
                long l = \u26034.nextLong();
                ChunkPos \u26035 = new ChunkPos(l);
                serverWorld2.func_72863_F().func_217206_a(\u26035, true);
            }
        }
        this.field_211151_aa = Util.func_211177_b() + 10L;
        this.func_213202_o();
        iChunkStatusListener.func_219510_b();
        \u26033.func_212863_j_().func_215598_a(5);
        this.func_240794_aZ_();
    }

    protected void func_175584_a() {
        File file = this.field_71310_m.func_237285_a_(FolderName.field_237252_h_).toFile();
        if (file.isFile()) {
            String string = this.field_71310_m.func_237282_a_();
            try {
                this.func_180507_a_("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException \u26032) {
                field_147145_h.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public GameType func_71265_f() {
        return this.field_240768_i_.func_76077_q();
    }

    public boolean func_71199_h() {
        return this.field_240768_i_.func_76093_s();
    }

    public abstract int func_110455_j();

    public abstract int func_223707_k();

    public abstract boolean func_195569_l();

    public boolean func_213211_a(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        for (ServerWorld serverWorld : this.func_212370_w()) {
            if (!bl) {
                field_147145_h.info("Saving chunks for level '{}'/{}", (Object)serverWorld, (Object)serverWorld.func_234923_W_().func_240901_a_());
            }
            serverWorld.func_217445_a(null, bl2, serverWorld.field_73058_d && !bl3);
            bl4 = true;
        }
        ServerWorld serverWorld = this.func_241755_D_();
        IServerWorldInfo iServerWorldInfo = this.field_240768_i_.func_230407_G_();
        iServerWorldInfo.func_230393_a_(serverWorld.func_175723_af().func_235927_t_());
        this.field_240768_i_.func_230414_b_(this.func_201300_aS().func_201380_c());
        this.field_71310_m.func_237288_a_(this.field_240767_f_, this.field_240768_i_, this.func_184103_al().func_72378_q());
        return bl4;
    }

    @Override
    public void close() {
        this.func_71260_j();
    }

    protected void func_71260_j() {
        field_147145_h.info("Stopping server");
        if (this.func_147137_ag() != null) {
            this.func_147137_ag().func_151268_b();
        }
        if (this.field_71318_t != null) {
            field_147145_h.info("Saving players");
            this.field_71318_t.func_72389_g();
            this.field_71318_t.func_72392_r();
        }
        field_147145_h.info("Saving worlds");
        for (ServerWorld serverWorld : this.func_212370_w()) {
            if (serverWorld == null) continue;
            serverWorld.field_73058_d = false;
        }
        this.func_213211_a(false, true, false);
        for (ServerWorld serverWorld : this.func_212370_w()) {
            if (serverWorld == null) continue;
            try {
                serverWorld.close();
            }
            catch (IOException iOException) {
                field_147145_h.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.field_71307_n.func_76468_d()) {
            this.field_71307_n.func_76470_e();
        }
        this.field_195576_ac.close();
        try {
            this.field_71310_m.close();
        }
        catch (IOException iOException) {
            field_147145_h.error("Failed to unlock level {}", (Object)this.field_71310_m.func_237282_a_(), (Object)iOException);
        }
    }

    public String func_71211_k() {
        return this.field_71320_r;
    }

    public void func_71189_e(String string) {
        this.field_71320_r = string;
    }

    public boolean func_71278_l() {
        return this.field_71317_u;
    }

    public void func_71263_m(boolean bl) {
        this.field_71317_u = false;
        if (bl) {
            try {
                this.field_175590_aa.join();
            }
            catch (InterruptedException interruptedException) {
                field_147145_h.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_240802_v_() {
        try {
            if (this.func_71197_b()) {
                this.field_211151_aa = Util.func_211177_b();
                this.field_147147_p.func_151315_a(new StringTextComponent(this.field_71286_C));
                this.field_147147_p.func_151321_a(new ServerStatusResponse.Version(SharedConstants.func_215069_a().getName(), SharedConstants.func_215069_a().getProtocolVersion()));
                this.func_184107_a(this.field_147147_p);
                while (this.field_71317_u) {
                    long l = Util.func_211177_b() - this.field_211151_aa;
                    if (l > 2000L && this.field_211151_aa - this.field_71299_R >= 15000L) {
                        \u2603 = l / 50L;
                        field_147145_h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l, (Object)\u2603);
                        this.field_211151_aa += \u2603 * 50L;
                        this.field_71299_R = this.field_211151_aa;
                    }
                    this.field_211151_aa += 50L;
                    LongTickDetector \u26032 = LongTickDetector.func_233524_a_("Server");
                    this.func_240773_a_(\u26032);
                    this.field_71304_b.func_219894_a();
                    this.field_71304_b.func_76320_a("tick");
                    this.func_71217_p(this::func_212379_aT);
                    this.field_71304_b.func_219895_b("nextTickWait");
                    this.field_213214_ac = true;
                    this.field_213213_ab = Math.max(Util.func_211177_b() + 50L, this.field_211151_aa);
                    this.func_213202_o();
                    this.field_71304_b.func_76319_b();
                    this.field_71304_b.func_219897_b();
                    this.func_240795_b_(\u26032);
                    this.field_71296_Q = true;
                }
            } else {
                this.func_71228_a(null);
            }
        }
        catch (Throwable throwable) {
            field_147145_h.error("Encountered an unexpected exception", throwable);
            CrashReport crashReport = throwable instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable));
            File \u26033 = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashReport.func_147149_a(\u26033)) {
                field_147145_h.error("This crash report has been saved to: {}", (Object)\u26033.getAbsolutePath());
            } else {
                field_147145_h.error("We were unable to save this crash report to disk.");
            }
            this.func_71228_a(crashReport);
        }
        finally {
            try {
                this.field_71316_v = true;
                this.func_71260_j();
            }
            catch (Throwable \u26034) {
                field_147145_h.error("Exception stopping the server", \u26034);
            }
            finally {
                this.func_71240_o();
            }
        }
    }

    private boolean func_212379_aT() {
        return this.func_213182_bg() || Util.func_211177_b() < (this.field_213214_ac ? this.field_213213_ab : this.field_211151_aa);
    }

    protected void func_213202_o() {
        this.func_213160_bf();
        this.func_213161_c(() -> !this.func_212379_aT());
    }

    @Override
    protected TickDelayedTask func_212875_d_(Runnable runnable) {
        return new TickDelayedTask(this.field_71315_w, runnable);
    }

    @Override
    protected boolean func_212874_c_(TickDelayedTask tickDelayedTask) {
        return tickDelayedTask.func_218823_a() + 3 < this.field_71315_w || this.func_212379_aT();
    }

    @Override
    public boolean func_213168_p() {
        boolean bl;
        this.field_213214_ac = bl = this.func_213205_aW();
        return bl;
    }

    private boolean func_213205_aW() {
        if (super.func_213168_p()) {
            return true;
        }
        if (this.func_212379_aT()) {
            for (ServerWorld serverWorld : this.func_212370_w()) {
                if (!serverWorld.func_72863_F().func_217234_d()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void func_213166_h(TickDelayedTask tickDelayedTask) {
        this.func_213185_aS().func_230035_c_("runTask");
        super.func_213166_h(tickDelayedTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void func_184107_a(ServerStatusResponse serverStatusResponse) {
        File file = this.func_71209_f("server-icon.png");
        if (!file.exists()) {
            file = this.field_71310_m.func_237298_f_();
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                serverStatusResponse.func_151320_a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                field_147145_h.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public File func_71238_n() {
        return new File(".");
    }

    protected void func_71228_a(CrashReport crashReport) {
    }

    protected void func_71240_o() {
    }

    protected void func_71217_p(BooleanSupplier booleanSupplier) {
        long l = Util.func_211178_c();
        ++this.field_71315_w;
        this.func_71190_q(booleanSupplier);
        if (l - this.field_147142_T >= 5000000000L) {
            this.field_147142_T = l;
            this.field_147147_p.func_151319_a(new ServerStatusResponse.Players(this.func_71275_y(), this.func_71233_x()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.func_71233_x(), 12)];
            int \u26032 = MathHelper.func_76136_a(this.field_147146_q, 0, this.func_71233_x() - gameProfileArray.length);
            for (int i = 0; i < gameProfileArray.length; ++i) {
                gameProfileArray[i] = this.field_71318_t.func_181057_v().get(\u26032 + i).func_146103_bH();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.field_147147_p.func_151318_b().func_151330_a(gameProfileArray);
        }
        if (this.field_71315_w % 6000 == 0) {
            field_147145_h.debug("Autosave started");
            this.field_71304_b.func_76320_a("save");
            this.field_71318_t.func_72389_g();
            this.func_213211_a(true, false, false);
            this.field_71304_b.func_76319_b();
            field_147145_h.debug("Autosave finished");
        }
        this.field_71304_b.func_76320_a("snooper");
        if (!this.field_71307_n.func_76468_d() && this.field_71315_w > 100) {
            this.field_71307_n.func_76463_a();
        }
        if (this.field_71315_w % 6000 == 0) {
            this.field_71307_n.func_76471_b();
        }
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76320_a("tallying");
        long l2 = Util.func_211178_c() - l;
        this.field_71311_j[this.field_71315_w % 100] = l2;
        \u2603 = l2;
        this.field_211152_ao = this.field_211152_ao * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        \u2603 = Util.func_211178_c();
        this.field_213215_ap.func_181747_a(\u2603 - l);
        this.field_71304_b.func_76319_b();
    }

    protected void func_71190_q(BooleanSupplier booleanSupplier) {
        this.field_71304_b.func_76320_a("commandFunctions");
        this.func_193030_aL().func_73660_a();
        this.field_71304_b.func_219895_b("levels");
        for (ServerWorld serverWorld : this.func_212370_w()) {
            this.field_71304_b.func_194340_a(() -> serverWorld + " " + serverWorld.func_234923_W_().func_240901_a_());
            if (this.field_71315_w % 20 == 0) {
                this.field_71304_b.func_76320_a("timeSync");
                this.field_71318_t.func_232642_a_(new SUpdateTimePacket(serverWorld.func_82737_E(), serverWorld.func_72820_D(), serverWorld.func_82736_K().func_223586_b(GameRules.field_223607_j)), serverWorld.func_234923_W_());
                this.field_71304_b.func_76319_b();
            }
            this.field_71304_b.func_76320_a("tick");
            try {
                serverWorld.func_72835_b(booleanSupplier);
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception ticking world");
                serverWorld.func_72914_a(crashReport);
                throw new ReportedException(crashReport);
            }
            this.field_71304_b.func_76319_b();
            this.field_71304_b.func_76319_b();
        }
        this.field_71304_b.func_219895_b("connection");
        this.func_147137_ag().func_151269_c();
        this.field_71304_b.func_219895_b("players");
        this.field_71318_t.func_72374_b();
        if (SharedConstants.field_206244_b) {
            TestCollection.field_229570_a_.func_229574_b_();
        }
        this.field_71304_b.func_219895_b("server gui refresh");
        for (int i = 0; i < this.field_71322_p.size(); ++i) {
            this.field_71322_p.get(i).run();
        }
        this.field_71304_b.func_76319_b();
    }

    public boolean func_71255_r() {
        return true;
    }

    public void func_82010_a(Runnable runnable) {
        this.field_71322_p.add(runnable);
    }

    protected void func_213208_c(String string) {
        this.field_213218_av = string;
    }

    public File func_71209_f(String string) {
        return new File(this.func_71238_n(), string);
    }

    public final ServerWorld func_241755_D_() {
        return this.field_71305_c.get(World.field_234918_g_);
    }

    @Nullable
    public ServerWorld func_71218_a(RegistryKey<World> registryKey) {
        return this.field_71305_c.get(registryKey);
    }

    public Set<RegistryKey<World>> func_240770_D_() {
        return this.field_71305_c.keySet();
    }

    public Iterable<ServerWorld> func_212370_w() {
        return this.field_71305_c.values();
    }

    public String func_71249_w() {
        return SharedConstants.func_215069_a().getName();
    }

    public int func_71233_x() {
        return this.field_71318_t.func_72394_k();
    }

    public int func_71275_y() {
        return this.field_71318_t.func_72352_l();
    }

    public String[] func_71213_z() {
        return this.field_71318_t.func_72369_d();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public CrashReport func_71230_b(CrashReport crashReport) {
        if (this.field_71318_t != null) {
            crashReport.func_85056_g().func_189529_a("Player Count", () -> this.field_71318_t.func_72394_k() + " / " + this.field_71318_t.func_72352_l() + "; " + this.field_71318_t.func_181057_v());
        }
        crashReport.func_85056_g().func_189529_a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (ResourcePackInfo resourcePackInfo : this.field_195577_ad.func_198980_d()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(resourcePackInfo.func_195790_f());
                if (resourcePackInfo.func_195791_d().func_198968_a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.field_213218_av != null) {
            crashReport.func_85056_g().func_189529_a("Server Id", () -> this.field_213218_av);
        }
        return crashReport;
    }

    public abstract Optional<String> func_230045_q_();

    @Override
    public void func_145747_a(ITextComponent iTextComponent, UUID uUID) {
        field_147145_h.info(iTextComponent.getString());
    }

    public KeyPair func_71250_E() {
        return this.field_71292_I;
    }

    public int func_71215_F() {
        return this.field_71319_s;
    }

    public void func_71208_b(int n) {
        this.field_71319_s = n;
    }

    public String func_71214_G() {
        return this.field_71293_J;
    }

    public void func_71224_l(String string) {
        this.field_71293_J = string;
    }

    public boolean func_71264_H() {
        return this.field_71293_J != null;
    }

    public void func_71253_a(KeyPair keyPair) {
        this.field_71292_I = keyPair;
    }

    public void func_147139_a(Difficulty difficulty, boolean bl) {
        if (!bl && this.field_240768_i_.func_176123_z()) {
            return;
        }
        this.field_240768_i_.func_230409_a_(this.field_240768_i_.func_76093_s() ? Difficulty.HARD : difficulty);
        this.func_240794_aZ_();
        this.func_184103_al().func_181057_v().forEach(this::func_213189_a);
    }

    public int func_230512_b_(int n) {
        return n;
    }

    private void func_240794_aZ_() {
        for (ServerWorld serverWorld : this.func_212370_w()) {
            serverWorld.func_72891_a(this.func_230536_N_(), this.func_230537_U_());
        }
    }

    public void func_213209_d(boolean bl) {
        this.field_240768_i_.func_230415_d_(bl);
        this.func_184103_al().func_181057_v().forEach(this::func_213189_a);
    }

    private void func_213189_a(ServerPlayerEntity serverPlayerEntity) {
        IWorldInfo iWorldInfo = serverPlayerEntity.func_71121_q().func_72912_H();
        serverPlayerEntity.field_71135_a.func_147359_a(new SServerDifficultyPacket(iWorldInfo.func_176130_y(), iWorldInfo.func_176123_z()));
    }

    protected boolean func_230536_N_() {
        return this.field_240768_i_.func_176130_y() != Difficulty.PEACEFUL;
    }

    public boolean func_71242_L() {
        return this.field_71288_M;
    }

    public void func_71204_b(boolean bl) {
        this.field_71288_M = bl;
    }

    public String func_147133_T() {
        return this.field_147141_M;
    }

    public String func_175581_ab() {
        return this.field_175588_P;
    }

    public void func_180507_a_(String string, String string2) {
        this.field_147141_M = string;
        this.field_175588_P = string2;
    }

    @Override
    public void func_70000_a(Snooper snooper2) {
        Snooper snooper2;
        snooper2.func_152768_a("whitelist_enabled", false);
        snooper2.func_152768_a("whitelist_count", 0);
        if (this.field_71318_t != null) {
            snooper2.func_152768_a("players_current", this.func_71233_x());
            snooper2.func_152768_a("players_max", this.func_71275_y());
            snooper2.func_152768_a("players_seen", this.field_240766_e_.func_237334_a_().length);
        }
        snooper2.func_152768_a("uses_auth", this.field_71325_x);
        snooper2.func_152768_a("gui_state", this.func_71279_ae() ? "enabled" : "disabled");
        snooper2.func_152768_a("run_time", (Util.func_211177_b() - snooper2.func_130105_g()) / 60L * 1000L);
        snooper2.func_152768_a("avg_tick_ms", (int)(MathHelper.func_76127_a(this.field_71311_j) * 1.0E-6));
        int n = 0;
        for (ServerWorld serverWorld : this.func_212370_w()) {
            if (serverWorld == null) continue;
            snooper2.func_152768_a("world[" + n + "][dimension]", serverWorld.func_234923_W_().func_240901_a_());
            snooper2.func_152768_a("world[" + n + "][mode]", (Object)this.field_240768_i_.func_76077_q());
            snooper2.func_152768_a("world[" + n + "][difficulty]", (Object)serverWorld.func_175659_aa());
            snooper2.func_152768_a("world[" + n + "][hardcore]", this.field_240768_i_.func_76093_s());
            snooper2.func_152768_a("world[" + n + "][height]", this.field_71280_D);
            snooper2.func_152768_a("world[" + n + "][chunks_loaded]", serverWorld.func_72863_F().func_73152_e());
            ++n;
        }
        snooper2.func_152768_a("worlds", n);
    }

    public abstract boolean func_71262_S();

    public boolean func_71266_T() {
        return this.field_71325_x;
    }

    public void func_71229_d(boolean bl) {
        this.field_71325_x = bl;
    }

    public boolean func_190518_ac() {
        return this.field_190519_A;
    }

    public void func_190517_e(boolean bl) {
        this.field_190519_A = bl;
    }

    public boolean func_230537_U_() {
        return true;
    }

    public boolean func_230538_V_() {
        return true;
    }

    public abstract boolean func_181035_ah();

    public boolean func_71219_W() {
        return this.field_71284_A;
    }

    public void func_71188_g(boolean bl) {
        this.field_71284_A = bl;
    }

    public boolean func_71231_X() {
        return this.field_71285_B;
    }

    public void func_71245_h(boolean bl) {
        this.field_71285_B = bl;
    }

    public abstract boolean func_82356_Z();

    public String func_71273_Y() {
        return this.field_71286_C;
    }

    public void func_71205_p(String string) {
        this.field_71286_C = string;
    }

    public int func_71207_Z() {
        return this.field_71280_D;
    }

    public void func_71191_d(int n) {
        this.field_71280_D = n;
    }

    public boolean func_71241_aa() {
        return this.field_71316_v;
    }

    public PlayerList func_184103_al() {
        return this.field_71318_t;
    }

    public void func_184105_a(PlayerList playerList) {
        this.field_71318_t = playerList;
    }

    public abstract boolean func_71344_c();

    public void func_71235_a(GameType gameType) {
        this.field_240768_i_.func_230392_a_(gameType);
    }

    @Nullable
    public NetworkSystem func_147137_ag() {
        return this.field_147144_o;
    }

    public boolean func_71279_ae() {
        return false;
    }

    public abstract boolean func_195565_a(GameType var1, boolean var2, int var3);

    public int func_71259_af() {
        return this.field_71315_w;
    }

    public int func_82357_ak() {
        return 16;
    }

    public boolean func_175579_a(ServerWorld serverWorld, BlockPos blockPos, PlayerEntity playerEntity) {
        return false;
    }

    public void func_104055_i(boolean bl) {
        this.field_104057_T = bl;
    }

    public boolean func_104056_am() {
        return this.field_104057_T;
    }

    public boolean func_230541_aj_() {
        return true;
    }

    public int func_143007_ar() {
        return this.field_143008_E;
    }

    public void func_143006_e(int n) {
        this.field_143008_E = n;
    }

    public MinecraftSessionService func_147130_as() {
        return this.field_147143_S;
    }

    public GameProfileRepository func_152359_aw() {
        return this.field_152365_W;
    }

    public PlayerProfileCache func_152358_ax() {
        return this.field_152366_X;
    }

    public ServerStatusResponse func_147134_at() {
        return this.field_147147_p;
    }

    public void func_147132_au() {
        this.field_147142_T = 0L;
    }

    public int func_175580_aG() {
        return 29999984;
    }

    @Override
    public boolean func_213164_aw() {
        return super.func_213164_aw() && !this.func_71241_aa();
    }

    @Override
    public Thread func_213170_ax() {
        return this.field_175590_aa;
    }

    public int func_175577_aI() {
        return 256;
    }

    public long func_211150_az() {
        return this.field_211151_aa;
    }

    public DataFixer func_195563_aC() {
        return this.field_184112_s;
    }

    public int func_184108_a(@Nullable ServerWorld serverWorld) {
        if (serverWorld != null) {
            return serverWorld.func_82736_K().func_223592_c(GameRules.field_223614_q);
        }
        return 10;
    }

    public AdvancementManager func_191949_aK() {
        return this.field_195576_ac.func_240969_g_();
    }

    public FunctionManager func_193030_aL() {
        return this.field_200258_al;
    }

    public CompletableFuture<Void> func_240780_a_(Collection<String> collection) {
        CompletionStage completionStage = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)collection.stream().map(this.field_195577_ad::func_198981_a).filter(Objects::nonNull).map(ResourcePackInfo::func_195796_e).collect(ImmutableList.toImmutableList()), this).thenCompose(immutableList -> DataPackRegistries.func_240961_a_((List<IResourcePack>)immutableList, this.func_71262_S() ? Commands.EnvironmentType.DEDICATED : Commands.EnvironmentType.INTEGRATED, this.func_223707_k(), this.field_213217_au, this))).thenAcceptAsync(dataPackRegistries -> {
            this.field_195576_ac.close();
            this.field_195576_ac = dataPackRegistries;
            this.field_195577_ad.func_198985_a(collection);
            this.field_240768_i_.func_230410_a_(MinecraftServer.func_240771_a_(this.field_195577_ad));
            dataPackRegistries.func_240971_i_();
            this.func_184103_al().func_72389_g();
            this.func_184103_al().func_193244_w();
            this.field_200258_al.func_240946_a_(this.field_195576_ac.func_240960_a_());
            this.field_240765_ak_.func_195410_a(this.field_195576_ac.func_240970_h_());
        }, (Executor)this);
        if (this.func_213162_bc()) {
            this.func_213161_c(((CompletableFuture)completionStage)::isDone);
        }
        return completionStage;
    }

    public static DatapackCodec func_240772_a_(ResourcePackList<ResourcePackInfo> resourcePackList2, DatapackCodec datapackCodec, boolean bl) {
        resourcePackList2.func_198983_a();
        if (bl) {
            resourcePackList2.func_198985_a(Collections.singleton("vanilla"));
            return new DatapackCodec((List<String>)ImmutableList.of((Object)"vanilla"), (List<String>)ImmutableList.of());
        }
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (String string : datapackCodec.func_234884_a_()) {
            if (resourcePackList2.func_232617_b_(string)) {
                linkedHashSet.add(string);
                continue;
            }
            field_147145_h.warn("Missing data pack {}", (Object)string);
        }
        for (ResourcePackInfo resourcePackInfo : resourcePackList2.func_198978_b()) {
            String string = resourcePackInfo.func_195790_f();
            if (datapackCodec.func_234887_b_().contains(string) || linkedHashSet.contains(string)) continue;
            field_147145_h.info("Found new data pack {}, loading it automatically", (Object)string);
            linkedHashSet.add(string);
        }
        if (linkedHashSet.isEmpty()) {
            field_147145_h.info("No datapacks selected, forcing vanilla");
            linkedHashSet.add("vanilla");
        }
        resourcePackList2.func_198985_a(linkedHashSet);
        return MinecraftServer.func_240771_a_(resourcePackList2);
    }

    private static DatapackCodec func_240771_a_(ResourcePackList<?> resourcePackList) {
        Collection<String> collection = resourcePackList.func_232621_d_();
        ImmutableList \u26032 = ImmutableList.copyOf(collection);
        List \u26033 = (List)resourcePackList.func_232616_b_().stream().filter(string -> !collection.contains(string)).collect(ImmutableList.toImmutableList());
        return new DatapackCodec((List<String>)\u26032, \u26033);
    }

    public void func_205743_a(CommandSource commandSource) {
        if (!this.func_205744_aT()) {
            return;
        }
        PlayerList playerList = commandSource.func_197028_i().func_184103_al();
        WhiteList \u26032 = playerList.func_152599_k();
        ArrayList \u26033 = Lists.newArrayList(playerList.func_181057_v());
        for (ServerPlayerEntity serverPlayerEntity : \u26033) {
            if (\u26032.func_152705_a(serverPlayerEntity.func_146103_bH())) continue;
            serverPlayerEntity.field_71135_a.func_194028_b(new TranslationTextComponent("multiplayer.disconnect.not_whitelisted"));
        }
    }

    public ResourcePackList<ResourcePackInfo> func_195561_aH() {
        return this.field_195577_ad;
    }

    public Commands func_195571_aL() {
        return this.field_195576_ac.func_240968_f_();
    }

    public CommandSource func_195573_aM() {
        ServerWorld serverWorld = this.func_241755_D_();
        return new CommandSource(this, serverWorld == null ? Vector3d.field_186680_a : Vector3d.func_237491_b_(serverWorld.func_241135_u_()), Vector2f.field_189974_a, serverWorld, 4, "Server", new StringTextComponent("Server"), this, null);
    }

    @Override
    public boolean func_195039_a() {
        return true;
    }

    @Override
    public boolean func_195040_b() {
        return true;
    }

    public RecipeManager func_199529_aN() {
        return this.field_195576_ac.func_240967_e_();
    }

    public NetworkTagManager func_199731_aO() {
        return this.field_195576_ac.func_240966_d_();
    }

    public ServerScoreboard func_200251_aP() {
        return this.field_200255_ai;
    }

    public CommandStorage func_229735_aN_() {
        if (this.field_229733_al_ == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.field_229733_al_;
    }

    public LootTableManager func_200249_aQ() {
        return this.field_195576_ac.func_240965_c_();
    }

    public LootPredicateManager func_229736_aP_() {
        return this.field_195576_ac.func_240964_b_();
    }

    public GameRules func_200252_aR() {
        return this.func_241755_D_().func_82736_K();
    }

    public CustomServerBossInfoManager func_201300_aS() {
        return this.field_201301_aj;
    }

    public boolean func_205744_aT() {
        return this.field_205745_an;
    }

    public void func_205741_k(boolean bl) {
        this.field_205745_an = bl;
    }

    public float func_211149_aT() {
        return this.field_211152_ao;
    }

    public int func_211833_a(GameProfile gameProfile) {
        if (this.func_184103_al().func_152596_g(gameProfile)) {
            OpEntry opEntry = (OpEntry)this.func_184103_al().func_152603_m().func_152683_b(gameProfile);
            if (opEntry != null) {
                return opEntry.func_152644_a();
            }
            if (this.func_213199_b(gameProfile)) {
                return 4;
            }
            if (this.func_71264_H()) {
                return this.func_184103_al().func_206257_x() ? 4 : 0;
            }
            return this.func_110455_j();
        }
        return 0;
    }

    public IProfiler func_213185_aS() {
        return this.field_71304_b;
    }

    public abstract boolean func_213199_b(GameProfile var1);

    public void func_223711_a(Path path) throws IOException {
        \u2603 = path.resolve("levels");
        for (Map.Entry<RegistryKey<World>, ServerWorld> entry : this.field_71305_c.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey().func_240901_a_();
            Path \u26032 = \u2603.resolve(resourceLocation.func_110624_b()).resolve(resourceLocation.func_110623_a());
            Files.createDirectories(\u26032, new FileAttribute[0]);
            entry.getValue().func_225322_a(\u26032);
        }
        this.func_223708_d(path.resolve("gamerules.txt"));
        this.func_223706_e(path.resolve("classpath.txt"));
        this.func_223709_c(path.resolve("example_crash.txt"));
        this.func_223710_b(path.resolve("stats.txt"));
        this.func_223712_f(path.resolve("threads.txt"));
    }

    private void func_223710_b(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format("pending_tasks: %d\n", this.func_223704_be()));
            bufferedWriter.write(String.format("average_tick_time: %f\n", Float.valueOf(this.func_211149_aT())));
            bufferedWriter.write(String.format("tick_times: %s\n", Arrays.toString(this.field_71311_j)));
            bufferedWriter.write(String.format("queue: %s\n", Util.func_215072_e()));
        }
    }

    private void func_223709_c(Path path) throws IOException {
        CrashReport crashReport = new CrashReport("Server dump", new Exception("dummy"));
        this.func_71230_b(crashReport);
        try (BufferedWriter \u26032 = Files.newBufferedWriter(path, new OpenOption[0]);){
            \u26032.write(crashReport.func_71502_e());
        }
    }

    private void func_223708_d(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList arrayList = Lists.newArrayList();
            final GameRules \u26032 = this.func_200252_aR();
            GameRules.func_223590_a(new GameRules.IRuleEntryVisitor(){

                @Override
                public <T extends GameRules.RuleValue<T>> void func_223481_a(GameRules.RuleKey<T> ruleKey, GameRules.RuleType<T> ruleType) {
                    arrayList.add(String.format("%s=%s\n", ruleKey.func_223576_a(), ((GameRules.RuleValue)\u26032.func_223585_a(ruleKey)).toString()));
                }
            });
            for (String string : arrayList) {
                bufferedWriter.write(string);
            }
        }
    }

    private void func_223706_e(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String string = System.getProperty("java.class.path");
            \u2603 = System.getProperty("path.separator");
            for (String string2 : Splitter.on((String)\u2603).split((CharSequence)string)) {
                bufferedWriter.write(string2);
                bufferedWriter.write("\n");
            }
        }
    }

    private void func_223712_f(Path path) throws IOException {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] \u26032 = threadMXBean.dumpAllThreads(true, true);
        Arrays.sort(\u26032, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter \u26033 = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : \u26032) {
                \u26033.write(threadInfo.toString());
                ((Writer)\u26033).write(10);
            }
        }
    }

    private void func_240773_a_(@Nullable LongTickDetector longTickDetector) {
        if (this.field_71295_T) {
            this.field_71295_T = false;
            this.field_240769_m_.func_233507_c_();
        }
        this.field_71304_b = LongTickDetector.func_233523_a_(this.field_240769_m_.func_233508_d_(), longTickDetector);
    }

    private void func_240795_b_(@Nullable LongTickDetector longTickDetector) {
        if (longTickDetector != null) {
            longTickDetector.func_233525_b_();
        }
        this.field_71304_b = this.field_240769_m_.func_233508_d_();
    }

    public boolean func_240789_aP_() {
        return this.field_240769_m_.func_233505_a_();
    }

    public void func_240790_aQ_() {
        this.field_71295_T = true;
    }

    public IProfileResult func_240791_aR_() {
        IProfileResult iProfileResult = this.field_240769_m_.func_233509_e_();
        this.field_240769_m_.func_233506_b_();
        return iProfileResult;
    }

    public Path func_240776_a_(FolderName folderName) {
        return this.field_71310_m.func_237285_a_(folderName);
    }

    public boolean func_230540_aS_() {
        return true;
    }

    public TemplateManager func_240792_aT_() {
        return this.field_240765_ak_;
    }

    public IServerConfiguration func_240793_aU_() {
        return this.field_240768_i_;
    }

    @Override
    public /* synthetic */ void func_213166_h(Runnable runnable) {
        this.func_213166_h((TickDelayedTask)runnable);
    }

    @Override
    public /* synthetic */ boolean func_212874_c_(Runnable runnable) {
        return this.func_212874_c_((TickDelayedTask)runnable);
    }

    @Override
    public /* synthetic */ Runnable func_212875_d_(Runnable runnable) {
        return this.func_212875_d_(runnable);
    }
}

