/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.state.Property;
import net.minecraft.state.StateHolder;
import net.minecraft.util.datafix.codec.RangeCodec;

public class StateContainer<O, S extends StateHolder<O, S>> {
    private static final Pattern field_185921_a = Pattern.compile("^[a-z0-9_]+$");
    private final O field_177627_c;
    private final ImmutableSortedMap<String, Property<?>> field_177624_d;
    private final ImmutableList<S> field_177625_e;

    protected StateContainer(Function<O, S> function, O o, IFactory<O, S> iFactory2, Map<String, Property<?>> map) {
        IFactory<O, S> iFactory2;
        Object \u260332;
        this.field_177627_c = o;
        this.field_177624_d = ImmutableSortedMap.copyOf(map);
        Supplier<StateHolder> supplier = () -> (StateHolder)function.apply(o);
        MapCodec<StateHolder> \u26032 = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(supplier));
        for (Object \u260332 : this.field_177624_d.entrySet()) {
            \u26032 = StateContainer.func_241487_a_(\u26032, supplier, (String)\u260332.getKey(), (Property)\u260332.getValue());
        }
        MapCodec<StateHolder> mapCodec = \u26032;
        \u260332 = Maps.newLinkedHashMap();
        ArrayList \u26034 = Lists.newArrayList();
        Stream<List<List<Object>>> \u26035 = Stream.of(Collections.emptyList());
        for (Object object : this.field_177624_d.values()) {
            \u26035 = \u26035.flatMap(arg_0 -> StateContainer.func_200999_a_((Property)object, arg_0));
        }
        \u26035.forEach(arg_0 -> StateContainer.func_201000_a_(iFactory2, o, mapCodec, (Map)\u260332, \u26034, arg_0));
        for (Object object : \u26034) {
            ((StateHolder)object).func_235899_a_(\u260332);
        }
        this.field_177625_e = ImmutableList.copyOf((Collection)\u26034);
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> MapCodec<S> func_241487_a_(MapCodec<S> mapCodec, Supplier<S> supplier, String string, Property<T> property) {
        return Codec.mapPair(mapCodec, RangeCodec.func_241292_a_(property.func_241492_e_().fieldOf(string), () -> property.func_241489_a_((StateHolder)supplier.get()))).xmap(pair -> (StateHolder)((StateHolder)pair.getFirst()).func_206870_a(property, ((Property.ValuePair)pair.getSecond()).func_241493_b_()), stateHolder -> Pair.of((Object)stateHolder, property.func_241489_a_((StateHolder<?, ?>)stateHolder)));
    }

    public ImmutableList<S> func_177619_a() {
        return this.field_177625_e;
    }

    public S func_177621_b() {
        return (S)((StateHolder)this.field_177625_e.get(0));
    }

    public O func_177622_c() {
        return this.field_177627_c;
    }

    public Collection<Property<?>> func_177623_d() {
        return this.field_177624_d.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("block", this.field_177627_c).add("properties", this.field_177624_d.values().stream().map(Property::func_177701_a).collect(Collectors.toList())).toString();
    }

    @Nullable
    public Property<?> func_185920_a(String string) {
        return (Property)this.field_177624_d.get((Object)string);
    }

    private static /* synthetic */ void func_201000_a_(IFactory iFactory, Object object, MapCodec mapCodec, Map map, List list, List list2) {
        ImmutableMap immutableMap = (ImmutableMap)list2.stream().collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
        StateHolder \u26032 = (StateHolder)iFactory.create(object, immutableMap, mapCodec);
        map.put(immutableMap, \u26032);
        list.add(\u26032);
    }

    private static /* synthetic */ Stream func_200999_a_(Property property, List list) {
        return property.func_177700_c().stream().map(comparable -> {
            ArrayList arrayList = Lists.newArrayList((Iterable)list);
            arrayList.add(Pair.of((Object)property, (Object)comparable));
            return arrayList;
        });
    }

    public static class Builder<O, S extends StateHolder<O, S>> {
        private final O field_206895_a;
        private final Map<String, Property<?>> field_206896_b = Maps.newHashMap();

        public Builder(O o) {
            this.field_206895_a = o;
        }

        public Builder<O, S> func_206894_a(Property<?> ... propertyArray) {
            for (Property<?> property : propertyArray) {
                this.func_206892_a(property);
                this.field_206896_b.put(property.func_177701_a(), property);
            }
            return this;
        }

        private <T extends Comparable<T>> void func_206892_a(Property<T> property) {
            String string = property.func_177701_a();
            if (!field_185921_a.matcher(string).matches()) {
                throw new IllegalArgumentException(this.field_206895_a + " has invalidly named property: " + string);
            }
            Collection<T> \u26032 = property.func_177700_c();
            if (\u26032.size() <= 1) {
                throw new IllegalArgumentException(this.field_206895_a + " attempted use property " + string + " with <= 1 possible values");
            }
            for (Comparable comparable : \u26032) {
                String string2 = property.func_177702_a(comparable);
                if (field_185921_a.matcher(string2).matches()) continue;
                throw new IllegalArgumentException(this.field_206895_a + " has property: " + string + " with invalidly named value: " + string2);
            }
            if (this.field_206896_b.containsKey(string)) {
                throw new IllegalArgumentException(this.field_206895_a + " has duplicate property: " + string);
            }
        }

        public StateContainer<O, S> func_235882_a_(Function<O, S> function, IFactory<O, S> iFactory) {
            return new StateContainer<O, S>(function, this.field_206895_a, iFactory, this.field_206896_b);
        }
    }

    public static interface IFactory<O, S> {
        public S create(O var1, ImmutableMap<Property<?>, Comparable<?>> var2, MapCodec<S> var3);
    }
}

