/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.state;

import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.state.Property;

public abstract class StateHolder<O, S> {
    private static final Function<Map.Entry<Property<?>, Comparable<?>>, String> field_235890_a_ = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            Property<?> property = entry.getKey();
            return property.func_177701_a() + "=" + this.func_235905_a_(property, entry.getValue());
        }

        private <T extends Comparable<T>> String func_235905_a_(Property<T> property, Comparable<?> comparable) {
            return property.func_177702_a(comparable);
        }

        @Override
        public /* synthetic */ Object apply(@Nullable Object object) {
            return this.apply((Map.Entry)object);
        }
    };
    protected final O field_235892_c_;
    private final ImmutableMap<Property<?>, Comparable<?>> field_235891_b_;
    private Table<Property<?>, Comparable<?>, S> field_235894_e_;
    protected final MapCodec<S> field_235893_d_;

    protected StateHolder(O o, ImmutableMap<Property<?>, Comparable<?>> immutableMap, MapCodec<S> mapCodec) {
        this.field_235892_c_ = o;
        this.field_235891_b_ = immutableMap;
        this.field_235893_d_ = mapCodec;
    }

    public <T extends Comparable<T>> S func_235896_a_(Property<T> property) {
        return this.func_206870_a(property, (Comparable)StateHolder.func_235898_a_(property.func_177700_c(), this.func_177229_b(property)));
    }

    protected static <T> T func_235898_a_(Collection<T> collection, T t) {
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(t)) continue;
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return collection.iterator().next();
        }
        return iterator.next();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.field_235892_c_);
        if (!this.func_206871_b().isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(this.func_206871_b().entrySet().stream().map(field_235890_a_).collect(Collectors.joining(",")));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public Collection<Property<?>> func_235904_r_() {
        return Collections.unmodifiableCollection(this.field_235891_b_.keySet());
    }

    public <T extends Comparable<T>> boolean func_235901_b_(Property<T> property) {
        return this.field_235891_b_.containsKey(property);
    }

    public <T extends Comparable<T>> T func_177229_b(Property<T> property) {
        Comparable comparable = (Comparable)this.field_235891_b_.get(property);
        if (comparable == null) {
            throw new IllegalArgumentException("Cannot get property " + property + " as it does not exist in " + this.field_235892_c_);
        }
        return (T)((Comparable)property.func_177699_b().cast(comparable));
    }

    public <T extends Comparable<T>> Optional<T> func_235903_d_(Property<T> property) {
        Comparable comparable = (Comparable)this.field_235891_b_.get(property);
        if (comparable == null) {
            return Optional.empty();
        }
        return Optional.of(property.func_177699_b().cast(comparable));
    }

    public <T extends Comparable<T>, V extends T> S func_206870_a(Property<T> property, V v) {
        Comparable comparable = (Comparable)this.field_235891_b_.get(property);
        if (comparable == null) {
            throw new IllegalArgumentException("Cannot set property " + property + " as it does not exist in " + this.field_235892_c_);
        }
        if (comparable == v) {
            return (S)this;
        }
        Object \u26032 = this.field_235894_e_.get(property, v);
        if (\u26032 == null) {
            throw new IllegalArgumentException("Cannot set property " + property + " to " + v + " on " + this.field_235892_c_ + ", it is not an allowed value");
        }
        return (S)\u26032;
    }

    public void func_235899_a_(Map<Map<Property<?>, Comparable<?>>, S> map) {
        if (this.field_235894_e_ != null) {
            throw new IllegalStateException();
        }
        HashBasedTable hashBasedTable = HashBasedTable.create();
        for (Map.Entry entry : this.field_235891_b_.entrySet()) {
            Property property = (Property)entry.getKey();
            for (Comparable comparable : property.func_177700_c()) {
                if (comparable == entry.getValue()) continue;
                hashBasedTable.put((Object)property, (Object)comparable, map.get(this.func_235902_b_(property, comparable)));
            }
        }
        this.field_235894_e_ = hashBasedTable.isEmpty() ? hashBasedTable : ArrayTable.create((Table)hashBasedTable);
    }

    private Map<Property<?>, Comparable<?>> func_235902_b_(Property<?> property, Comparable<?> comparable) {
        HashMap hashMap = Maps.newHashMap(this.field_235891_b_);
        hashMap.put(property, comparable);
        return hashMap;
    }

    public ImmutableMap<Property<?>, Comparable<?>> func_206871_b() {
        return this.field_235891_b_;
    }

    protected static <O, S extends StateHolder<O, S>> Codec<S> func_235897_a_(Codec<O> codec, Function<O, S> function) {
        return codec.dispatch("Name", stateHolder -> stateHolder.field_235892_c_, object -> {
            StateHolder stateHolder = (StateHolder)function.apply(object);
            if (stateHolder.func_206871_b().isEmpty()) {
                return Codec.unit((Object)stateHolder);
            }
            return stateHolder.field_235893_d_.fieldOf("Properties").codec();
        });
    }
}

