/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagCollection<T> {
    private static final Logger field_199918_a = LogManager.getLogger();
    private static final Gson field_199919_b = new Gson();
    private static final int field_199920_c = ".json".length();
    private final ITag<T> field_232970_d_ = Tag.func_241284_a_();
    private volatile BiMap<ResourceLocation, ITag<T>> field_199921_d = HashBiMap.create();
    private final Function<ResourceLocation, Optional<T>> field_200040_e;
    private final String field_199923_f;
    private final String field_200157_i;

    public TagCollection(Function<ResourceLocation, Optional<T>> function, String string, String string2) {
        this.field_200040_e = function;
        this.field_199923_f = string;
        this.field_200157_i = string2;
    }

    @Nullable
    public ITag<T> func_199910_a(ResourceLocation resourceLocation) {
        return (ITag)this.field_199921_d.get((Object)resourceLocation);
    }

    public ITag<T> func_199915_b(ResourceLocation resourceLocation) {
        return (ITag)this.field_199921_d.getOrDefault((Object)resourceLocation, this.field_232970_d_);
    }

    @Nullable
    public ResourceLocation func_232973_a_(ITag<T> iTag) {
        if (iTag instanceof ITag.INamedTag) {
            return ((ITag.INamedTag)iTag).func_230234_a_();
        }
        return (ResourceLocation)this.field_199921_d.inverse().get(iTag);
    }

    public ResourceLocation func_232975_b_(ITag<T> iTag) {
        ResourceLocation resourceLocation = this.func_232973_a_(iTag);
        if (resourceLocation == null) {
            throw new IllegalStateException("Unrecognized tag");
        }
        return resourceLocation;
    }

    public Collection<ResourceLocation> func_199908_a() {
        return this.field_199921_d.keySet();
    }

    public CompletableFuture<Map<ResourceLocation, ITag.Builder>> func_219781_a(IResourceManager iResourceManager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap hashMap = Maps.newHashMap();
            for (ResourceLocation resourceLocation2 : iResourceManager.func_199003_a(this.field_199923_f, string -> string.endsWith(".json"))) {
                String string2 = resourceLocation2.func_110623_a();
                ResourceLocation \u26032 = new ResourceLocation(resourceLocation2.func_110624_b(), string2.substring(this.field_199923_f.length() + 1, string2.length() - field_199920_c));
                try {
                    for (IResource iResource : iResourceManager.func_199004_b(resourceLocation2)) {
                        try {
                            InputStream inputStream = iResource.func_199027_b();
                            Throwable throwable = null;
                            try {
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                                Throwable throwable2 = null;
                                try {
                                    JsonObject jsonObject = JSONUtils.func_193839_a(field_199919_b, bufferedReader, JsonObject.class);
                                    if (jsonObject == null) {
                                        field_199918_a.error("Couldn't load {} tag list {} from {} in data pack {} as it is empty or null", (Object)this.field_200157_i, (Object)\u26032, (Object)resourceLocation2, (Object)iResource.func_199026_d());
                                        continue;
                                    }
                                    hashMap.computeIfAbsent(\u26032, resourceLocation -> ITag.Builder.func_200047_a()).func_232956_a_(jsonObject, iResource.func_199026_d());
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (bufferedReader == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            ((Reader)bufferedReader).close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    ((Reader)bufferedReader).close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (inputStream == null) continue;
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                inputStream.close();
                            }
                        }
                        catch (IOException | RuntimeException exception) {
                            field_199918_a.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)this.field_200157_i, (Object)\u26032, (Object)resourceLocation2, (Object)iResource.func_199026_d(), (Object)exception);
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)iResource);
                        }
                    }
                }
                catch (IOException iOException) {
                    field_199918_a.error("Couldn't read {} tag list {} from {}", (Object)this.field_200157_i, (Object)\u26032, (Object)resourceLocation2, (Object)iOException);
                }
            }
            return hashMap;
        }, executor);
    }

    public void func_219779_a(Map<ResourceLocation, ITag.Builder> map) {
        HashMap hashMap = Maps.newHashMap();
        Function \u26032 = hashMap::get;
        Function<ResourceLocation, Object> \u26033 = resourceLocation -> this.field_200040_e.apply((ResourceLocation)resourceLocation).orElse(null);
        while (!map.isEmpty()) {
            boolean \u26036 = false;
            Iterator<Map.Entry<ResourceLocation, ITag.Builder>> \u26034 = map.entrySet().iterator();
            while (\u26034.hasNext()) {
                Map.Entry<ResourceLocation, ITag.Builder> entry = \u26034.next();
                Optional<ITag<Object>> \u26035 = entry.getValue().func_232959_a_(\u26032, \u26033);
                if (!\u26035.isPresent()) continue;
                hashMap.put(entry.getKey(), \u26035.get());
                \u26034.remove();
                \u26036 = true;
            }
            if (\u26036) continue;
            break;
        }
        map.forEach((resourceLocation, builder) -> field_199918_a.error("Couldn't load {} tag {} as it is missing following references: {}", (Object)this.field_200157_i, resourceLocation, (Object)builder.func_232963_b_(\u26032, \u26033).map(Objects::toString).collect(Collectors.joining(","))));
        this.func_223507_b(hashMap);
    }

    protected void func_223507_b(Map<ResourceLocation, ITag<T>> map) {
        this.field_199921_d = ImmutableBiMap.copyOf(map);
    }

    public Map<ResourceLocation, ITag<T>> func_200039_c() {
        return this.field_199921_d;
    }
}

