/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public abstract class TileEntity {
    private static final Logger field_145852_a = LogManager.getLogger();
    private final TileEntityType<?> field_200663_e;
    @Nullable
    protected World field_145850_b;
    protected BlockPos field_174879_c = BlockPos.field_177992_a;
    protected boolean field_145846_f;
    @Nullable
    private BlockState field_195045_e;
    private boolean field_222816_g;

    public TileEntity(TileEntityType<?> tileEntityType) {
        this.field_200663_e = tileEntityType;
    }

    @Nullable
    public World func_145831_w() {
        return this.field_145850_b;
    }

    public void func_226984_a_(World world, BlockPos blockPos) {
        this.field_145850_b = world;
        this.field_174879_c = blockPos.func_185334_h();
    }

    public boolean func_145830_o() {
        return this.field_145850_b != null;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compoundNBT) {
        this.field_174879_c = new BlockPos(compoundNBT.func_74762_e("x"), compoundNBT.func_74762_e("y"), compoundNBT.func_74762_e("z"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        return this.func_189516_d(compoundNBT);
    }

    private CompoundNBT func_189516_d(CompoundNBT compoundNBT) {
        ResourceLocation resourceLocation = TileEntityType.func_200969_a(this.func_200662_C());
        if (resourceLocation == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compoundNBT.func_74778_a("id", resourceLocation.toString());
        compoundNBT.func_74768_a("x", this.field_174879_c.func_177958_n());
        compoundNBT.func_74768_a("y", this.field_174879_c.func_177956_o());
        compoundNBT.func_74768_a("z", this.field_174879_c.func_177952_p());
        return compoundNBT;
    }

    @Nullable
    public static TileEntity func_235657_b_(BlockState blockState, CompoundNBT compoundNBT) {
        String string = compoundNBT.func_74779_i("id");
        return Registry.field_212626_o.func_218349_b(new ResourceLocation(string)).map(tileEntityType -> {
            try {
                return tileEntityType.func_200968_a();
            }
            catch (Throwable throwable) {
                field_145852_a.error("Failed to create block entity {}", (Object)string, (Object)throwable);
                return null;
            }
        }).map(tileEntity -> {
            try {
                tileEntity.func_230337_a_(blockState, compoundNBT);
                return tileEntity;
            }
            catch (Throwable throwable) {
                field_145852_a.error("Failed to load data for block entity {}", (Object)string, (Object)throwable);
                return null;
            }
        }).orElseGet(() -> {
            field_145852_a.warn("Skipping BlockEntity with id {}", (Object)string);
            return null;
        });
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_195045_e = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_175646_b(this.field_174879_c, this);
            if (!this.field_195045_e.func_196958_f()) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_195045_e.func_177230_c());
            }
        }
    }

    public BlockPos func_174877_v() {
        return this.field_174879_c;
    }

    public BlockState func_195044_w() {
        if (this.field_195045_e == null) {
            this.field_195045_e = this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        return this.field_195045_e;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return null;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189516_d(new CompoundNBT());
    }

    public boolean func_145837_r() {
        return this.field_145846_f;
    }

    public void func_145843_s() {
        this.field_145846_f = true;
    }

    public void func_145829_t() {
        this.field_145846_f = false;
    }

    public boolean func_145842_c(int n, int n2) {
        return false;
    }

    public void func_145836_u() {
        this.field_195045_e = null;
    }

    public void func_145828_a(CrashReportCategory crashReportCategory) {
        crashReportCategory.func_189529_a("Name", () -> Registry.field_212626_o.func_177774_c(this.func_200662_C()) + " // " + this.getClass().getCanonicalName());
        if (this.field_145850_b == null) {
            return;
        }
        CrashReportCategory.func_175750_a(crashReportCategory, this.field_174879_c, this.func_195044_w());
        CrashReportCategory.func_175750_a(crashReportCategory, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
    }

    public void func_174878_a(BlockPos blockPos) {
        this.field_174879_c = blockPos.func_185334_h();
    }

    public boolean func_183000_F() {
        return false;
    }

    public void func_189667_a(Rotation rotation) {
    }

    public void func_189668_a(Mirror mirror) {
    }

    public TileEntityType<?> func_200662_C() {
        return this.field_200663_e;
    }

    public void func_222814_r() {
        if (this.field_222816_g) {
            return;
        }
        this.field_222816_g = true;
        field_145852_a.warn("Block entity invalid: {} @ {}", new Supplier[]{() -> Registry.field_212626_o.func_177774_c(this.func_200662_C()), this::func_174877_v});
    }
}

