/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.biome.provider.NetherBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;

public final class Dimension {
    public static final MapCodec<Dimension> field_236052_a_ = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DimensionType.field_236002_f_.fieldOf("type").forGetter(Dimension::func_236059_a_), (App)ChunkGenerator.field_235948_a_.fieldOf("generator").forGetter(Dimension::func_236064_c_)).apply((Applicative)instance, instance.stable(Dimension::new)));
    public static final RegistryKey<Dimension> field_236053_b_ = RegistryKey.func_240903_a_(Registry.field_239700_af_, new ResourceLocation("overworld"));
    public static final RegistryKey<Dimension> field_236054_c_ = RegistryKey.func_240903_a_(Registry.field_239700_af_, new ResourceLocation("the_nether"));
    public static final RegistryKey<Dimension> field_236055_d_ = RegistryKey.func_240903_a_(Registry.field_239700_af_, new ResourceLocation("the_end"));
    private static final LinkedHashSet<RegistryKey<Dimension>> field_236056_e_ = Sets.newLinkedHashSet((Iterable)ImmutableList.of(field_236053_b_, field_236054_c_, field_236055_d_));
    private final Supplier<DimensionType> field_236057_f_;
    private final ChunkGenerator field_236058_g_;

    public Dimension(Supplier<DimensionType> supplier, ChunkGenerator chunkGenerator) {
        this.field_236057_f_ = supplier;
        this.field_236058_g_ = chunkGenerator;
    }

    public Supplier<DimensionType> func_236059_a_() {
        return this.field_236057_f_;
    }

    public DimensionType func_236063_b_() {
        return this.field_236057_f_.get();
    }

    public ChunkGenerator func_236064_c_() {
        return this.field_236058_g_;
    }

    public static SimpleRegistry<Dimension> func_236062_a_(SimpleRegistry<Dimension> simpleRegistry3) {
        SimpleRegistry<Dimension> simpleRegistry2 = new SimpleRegistry<Dimension>(Registry.field_239700_af_, Lifecycle.experimental());
        for (RegistryKey registryKey : field_236056_e_) {
            Dimension object = simpleRegistry3.func_230516_a_(registryKey);
            if (object == null) continue;
            simpleRegistry2.func_218381_a(registryKey, object);
            if (!simpleRegistry3.func_239660_c_(registryKey)) continue;
            simpleRegistry2.func_239662_d_(registryKey);
        }
        for (Map.Entry entry : simpleRegistry3.func_239659_c_()) {
            RegistryKey registryKey = (RegistryKey)entry.getKey();
            if (field_236056_e_.contains(registryKey)) continue;
            simpleRegistry2.func_218381_a(registryKey, entry.getValue());
            if (!simpleRegistry3.func_239660_c_(registryKey)) continue;
            simpleRegistry2.func_239662_d_(registryKey);
        }
        return simpleRegistry2;
    }

    public static boolean func_236060_a_(long l, SimpleRegistry<Dimension> simpleRegistry) {
        ArrayList arrayList = Lists.newArrayList(simpleRegistry.func_239659_c_());
        if (arrayList.size() != field_236056_e_.size()) {
            return false;
        }
        Map.Entry \u26032 = (Map.Entry)arrayList.get(0);
        Map.Entry \u26033 = (Map.Entry)arrayList.get(1);
        Map.Entry \u26034 = (Map.Entry)arrayList.get(2);
        if (\u26032.getKey() != field_236053_b_ || \u26033.getKey() != field_236054_c_ || \u26034.getKey() != field_236055_d_) {
            return false;
        }
        if (((Dimension)\u26032.getValue()).func_236063_b_() != DimensionType.field_236004_h_ && ((Dimension)\u26032.getValue()).func_236063_b_() != DimensionType.field_241498_j_) {
            return false;
        }
        if (((Dimension)\u26033.getValue()).func_236063_b_() != DimensionType.field_236005_i_) {
            return false;
        }
        if (((Dimension)\u26034.getValue()).func_236063_b_() != DimensionType.field_236006_j_) {
            return false;
        }
        if (!(((Dimension)\u26033.getValue()).func_236064_c_() instanceof NoiseChunkGenerator) || !(((Dimension)\u26034.getValue()).func_236064_c_() instanceof NoiseChunkGenerator)) {
            return false;
        }
        NoiseChunkGenerator \u26035 = (NoiseChunkGenerator)((Dimension)\u26033.getValue()).func_236064_c_();
        NoiseChunkGenerator \u26036 = (NoiseChunkGenerator)((Dimension)\u26034.getValue()).func_236064_c_();
        if (!\u26035.func_236088_a_(l, DimensionSettings.Preset.field_236124_d_)) {
            return false;
        }
        if (!\u26036.func_236088_a_(l, DimensionSettings.Preset.field_236125_e_)) {
            return false;
        }
        if (!(\u26035.func_202090_b() instanceof NetherBiomeProvider)) {
            return false;
        }
        NetherBiomeProvider \u26037 = (NetherBiomeProvider)\u26035.func_202090_b();
        if (!\u26037.func_235280_b_(l)) {
            return false;
        }
        if (!(\u26036.func_202090_b() instanceof EndBiomeProvider)) {
            return false;
        }
        EndBiomeProvider \u26038 = (EndBiomeProvider)\u26036.func_202090_b();
        return \u26038.func_235318_b_(l);
    }
}

