/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Biome {
    public static final Logger field_150586_aC = LogManager.getLogger();
    public static final Codec<Biome> field_235051_b_ = RecordCodecBuilder.create(instance -> instance.group((App)RainType.field_235121_d_.fieldOf("precipitation").forGetter(biome -> biome.field_201878_av), (App)Category.field_235102_r_.fieldOf("category").forGetter(biome -> biome.field_201877_au), (App)Codec.FLOAT.fieldOf("depth").forGetter(biome -> Float.valueOf(biome.field_76748_D)), (App)Codec.FLOAT.fieldOf("scale").forGetter(biome -> Float.valueOf(biome.field_76749_E)), (App)Codec.FLOAT.fieldOf("temperature").forGetter(biome -> Float.valueOf(biome.field_76750_F)), (App)Codec.FLOAT.fieldOf("downfall").forGetter(biome -> Float.valueOf(biome.field_76751_G)), (App)BiomeAmbience.field_235204_a_.fieldOf("effects").forGetter(biome -> biome.field_235052_p_), (App)Codec.INT.fieldOf("sky_color").forGetter(biome -> biome.field_229978_u_), (App)ConfiguredSurfaceBuilder.field_237168_a_.fieldOf("surface_builder").forGetter(biome -> biome.field_201875_ar), (App)Codec.simpleMap(GenerationStage.Carving.field_236074_c_, (Codec)ConfiguredCarver.field_236235_a_.listOf().promotePartial(Util.func_240982_a_("Carver: ", arg_0 -> ((Logger)field_150586_aC).error(arg_0))), (Keyable)IStringSerializable.func_233025_a_(GenerationStage.Carving.values())).fieldOf("carvers").forGetter(biome -> biome.field_201871_ag), (App)Codec.simpleMap(GenerationStage.Decoration.field_236076_k_, (Codec)ConfiguredFeature.field_236264_b_.listOf().promotePartial(Util.func_240982_a_("Feature: ", arg_0 -> ((Logger)field_150586_aC).error(arg_0))), (Keyable)IStringSerializable.func_233025_a_(GenerationStage.Decoration.values())).fieldOf("features").forGetter(biome -> biome.field_201872_ah), (App)StructureFeature.field_236267_a_.listOf().promotePartial(Util.func_240982_a_("Structure start: ", arg_0 -> ((Logger)field_150586_aC).error(arg_0))).fieldOf("starts").forGetter(biome -> biome.field_201874_aj.values().stream().sorted(Comparator.comparing(structureFeature -> Registry.field_218361_B.func_177774_c((Structure<?>)structureFeature.field_236268_b_))).collect(Collectors.toList())), (App)Codec.simpleMap(EntityClassification.field_233667_g_, (Codec)SpawnListEntry.field_235123_b_.listOf().promotePartial(Util.func_240982_a_("Spawn data: ", arg_0 -> ((Logger)field_150586_aC).error(arg_0))), (Keyable)IStringSerializable.func_233025_a_(EntityClassification.values())).fieldOf("spawners").forGetter(biome -> biome.field_201880_ax), (App)Attributes.field_235104_a_.listOf().fieldOf("climate_parameters").forGetter(biome -> biome.field_235054_x_), (App)Codec.STRING.optionalFieldOf("parent").forGetter(biome -> Optional.ofNullable(biome.field_185364_H))).apply((Applicative)instance, Biome::new));
    public static final Set<Biome> field_201870_ab = Sets.newHashSet();
    public static final ObjectIntIdentityMap<Biome> field_185373_j = new ObjectIntIdentityMap();
    protected static final PerlinNoiseGenerator field_150605_ac = new PerlinNoiseGenerator(new SharedSeedRandom(1234L), (List<Integer>)ImmutableList.of((Object)0));
    public static final PerlinNoiseGenerator field_180281_af = new PerlinNoiseGenerator(new SharedSeedRandom(2345L), (List<Integer>)ImmutableList.of((Object)0));
    @Nullable
    protected String field_205405_aL;
    protected final float field_76748_D;
    protected final float field_76749_E;
    protected final float field_76750_F;
    protected final float field_76751_G;
    private final int field_229978_u_;
    @Nullable
    protected final String field_185364_H;
    protected final ConfiguredSurfaceBuilder<?> field_201875_ar;
    protected final Category field_201877_au;
    protected final RainType field_201878_av;
    protected final BiomeAmbience field_235052_p_;
    protected final Map<GenerationStage.Carving, List<ConfiguredCarver<?>>> field_201871_ag;
    protected final Map<GenerationStage.Decoration, List<ConfiguredFeature<?, ?>>> field_201872_ah;
    protected final List<ConfiguredFeature<?, ?>> field_201873_ai = Lists.newArrayList();
    private final Map<Structure<?>, StructureFeature<?, ?>> field_201874_aj;
    private final Map<EntityClassification, List<SpawnListEntry>> field_201880_ax;
    private final Map<EntityType<?>, EntityDensity> field_235053_w_ = Maps.newHashMap();
    private final List<Attributes> field_235054_x_;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> field_225488_v = ThreadLocal.withInitial(() -> Util.func_199748_a(() -> {
        Long2FloatLinkedOpenHashMap long2FloatLinkedOpenHashMap = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int n) {
            }
        };
        long2FloatLinkedOpenHashMap.defaultReturnValue(Float.NaN);
        return long2FloatLinkedOpenHashMap;
    }));

    @Nullable
    public static Biome func_185356_b(Biome biome) {
        return field_185373_j.func_148745_a(Registry.field_212624_m.func_148757_b(biome));
    }

    public static <C extends ICarverConfig> ConfiguredCarver<C> func_203606_a(WorldCarver<C> worldCarver, C c) {
        return new ConfiguredCarver<C>(worldCarver, c);
    }

    protected Biome(Builder builder) {
        if (builder.field_205422_a == null || builder.field_205423_b == null || builder.field_205424_c == null || builder.field_205425_d == null || builder.field_205426_e == null || builder.field_205427_f == null || builder.field_205428_g == null || builder.field_235096_j_ == null) {
            throw new IllegalStateException("You are missing parameters to build a proper biome for " + this.getClass().getSimpleName() + "\n" + builder);
        }
        this.field_201875_ar = builder.field_205422_a;
        this.field_201878_av = builder.field_205423_b;
        this.field_201877_au = builder.field_205424_c;
        this.field_76748_D = builder.field_205425_d.floatValue();
        this.field_76749_E = builder.field_205426_e.floatValue();
        this.field_76750_F = builder.field_205427_f.floatValue();
        this.field_76751_G = builder.field_205428_g.floatValue();
        this.field_229978_u_ = this.func_229979_u_();
        this.field_185364_H = builder.field_205431_j;
        this.field_235054_x_ = builder.field_235095_i_ != null ? builder.field_235095_i_ : ImmutableList.of();
        this.field_235052_p_ = builder.field_235096_j_;
        this.field_201871_ag = Maps.newHashMap();
        this.field_201874_aj = Maps.newHashMap();
        this.field_201872_ah = Maps.newHashMap();
        for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
            this.field_201872_ah.put(decoration, Lists.newArrayList());
        }
        this.field_201880_ax = Maps.newHashMap();
        for (Enum enum_ : EntityClassification.values()) {
            this.field_201880_ax.put((EntityClassification)enum_, Lists.newArrayList());
        }
    }

    private Biome(RainType rainType, Category category, float f, float f2, float f3, float f4, BiomeAmbience biomeAmbience, int n, ConfiguredSurfaceBuilder<?> configuredSurfaceBuilder, Map<GenerationStage.Carving, List<ConfiguredCarver<?>>> map, Map<GenerationStage.Decoration, List<ConfiguredFeature<?, ?>>> map2, List<StructureFeature<?, ?>> list, Map<EntityClassification, List<SpawnListEntry>> map3, List<Attributes> list2, Optional<String> optional) {
        this.field_201878_av = rainType;
        this.field_201877_au = category;
        this.field_76748_D = f;
        this.field_76749_E = f2;
        this.field_76750_F = f3;
        this.field_76751_G = f4;
        this.field_235052_p_ = biomeAmbience;
        this.field_229978_u_ = n;
        this.field_201875_ar = configuredSurfaceBuilder;
        this.field_201871_ag = map;
        this.field_201872_ah = map2;
        this.field_201874_aj = list.stream().collect(Collectors.toMap(structureFeature -> structureFeature.field_236268_b_, Function.identity()));
        this.field_201880_ax = map3;
        this.field_235054_x_ = list2;
        this.field_185364_H = optional.orElse(null);
        map2.values().stream().flatMap(Collection::stream).filter(configuredFeature -> configuredFeature.field_222737_a == Feature.field_214484_aL).forEach(this.field_201873_ai::add);
    }

    public boolean func_185363_b() {
        return this.field_185364_H != null;
    }

    private int func_229979_u_() {
        float f = this.field_76750_F;
        f /= 3.0f;
        f = MathHelper.func_76131_a(f, -1.0f, 1.0f);
        return MathHelper.func_181758_c(0.62222224f - f * 0.05f, 0.5f + f * 0.1f, 1.0f);
    }

    protected void func_201866_a(EntityClassification entityClassification, SpawnListEntry spawnListEntry) {
        this.field_201880_ax.get(entityClassification).add(spawnListEntry);
    }

    protected void func_235059_a_(EntityType<?> entityType, double d, double d2) {
        this.field_235053_w_.put(entityType, new EntityDensity(d2, d));
    }

    public List<SpawnListEntry> func_76747_a(EntityClassification entityClassification) {
        return this.field_201880_ax.get(entityClassification);
    }

    @Nullable
    public EntityDensity func_235058_a_(EntityType<?> entityType) {
        return this.field_235053_w_.get(entityType);
    }

    public RainType func_201851_b() {
        return this.field_201878_av;
    }

    public boolean func_76736_e() {
        return this.func_76727_i() > 0.85f;
    }

    public float func_76741_f() {
        return 0.1f;
    }

    protected float func_180626_a(BlockPos blockPos) {
        if (blockPos.func_177956_o() > 64) {
            float f = (float)(field_150605_ac.func_215464_a((float)blockPos.func_177958_n() / 8.0f, (float)blockPos.func_177952_p() / 8.0f, false) * 4.0);
            return this.func_185353_n() - (f + (float)blockPos.func_177956_o() - 64.0f) * 0.05f / 30.0f;
        }
        return this.func_185353_n();
    }

    public final float func_225486_c(BlockPos blockPos) {
        long l = blockPos.func_218275_a();
        Long2FloatLinkedOpenHashMap \u26032 = this.field_225488_v.get();
        float \u26033 = \u26032.get(l);
        if (!Float.isNaN(\u26033)) {
            return \u26033;
        }
        float \u26034 = this.func_180626_a(blockPos);
        if (\u26032.size() == 1024) {
            \u26032.removeFirstFloat();
        }
        \u26032.put(l, \u26034);
        return \u26034;
    }

    public boolean func_201848_a(IWorldReader iWorldReader, BlockPos blockPos) {
        return this.func_201854_a(iWorldReader, blockPos, true);
    }

    public boolean func_201854_a(IWorldReader iWorldReader, BlockPos blockPos, boolean bl) {
        if (this.func_225486_c(blockPos) >= 0.15f) {
            return false;
        }
        if (blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && iWorldReader.func_226658_a_(LightType.BLOCK, blockPos) < 10) {
            BlockState blockState = iWorldReader.func_180495_p(blockPos);
            FluidState \u26032 = iWorldReader.func_204610_c(blockPos);
            if (\u26032.func_206886_c() == Fluids.field_204546_a && blockState.func_177230_c() instanceof FlowingFluidBlock) {
                if (!bl) {
                    return true;
                }
                boolean bl2 = \u2603 = iWorldReader.func_201671_F(blockPos.func_177976_e()) && iWorldReader.func_201671_F(blockPos.func_177974_f()) && iWorldReader.func_201671_F(blockPos.func_177978_c()) && iWorldReader.func_201671_F(blockPos.func_177968_d());
                if (!\u2603) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_201850_b(IWorldReader iWorldReader, BlockPos blockPos) {
        if (this.func_225486_c(blockPos) >= 0.15f) {
            return false;
        }
        return blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && iWorldReader.func_226658_a_(LightType.BLOCK, blockPos) < 10 && (\u2603 = iWorldReader.func_180495_p(blockPos)).func_196958_f() && Blocks.field_150433_aE.func_176223_P().func_196955_c(iWorldReader, blockPos);
    }

    public void func_203611_a(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> configuredFeature) {
        if (configuredFeature.field_222737_a == Feature.field_214484_aL) {
            this.field_201873_ai.add(configuredFeature);
        }
        this.field_201872_ah.get(decoration).add(configuredFeature);
    }

    public <C extends ICarverConfig> void func_203609_a(GenerationStage.Carving carving2, ConfiguredCarver<C> configuredCarver) {
        this.field_201871_ag.computeIfAbsent(carving2, carving -> Lists.newArrayList()).add(configuredCarver);
    }

    public List<ConfiguredCarver<?>> func_203603_a(GenerationStage.Carving carving2) {
        return this.field_201871_ag.computeIfAbsent(carving2, carving -> Lists.newArrayList());
    }

    public void func_235063_a_(StructureFeature<?, ?> structureFeature) {
        this.field_201874_aj.put((Structure<?>)structureFeature.field_236268_b_, structureFeature);
    }

    public boolean func_201858_a(Structure<?> structure) {
        return this.field_201874_aj.containsKey(structure);
    }

    public Iterable<StructureFeature<?, ?>> func_235077_g_() {
        return this.field_201874_aj.values();
    }

    public StructureFeature<?, ?> func_235068_b_(StructureFeature<?, ?> structureFeature) {
        return this.field_201874_aj.getOrDefault(structureFeature.field_236268_b_, structureFeature);
    }

    public List<ConfiguredFeature<?, ?>> func_201853_g() {
        return this.field_201873_ai;
    }

    public List<ConfiguredFeature<?, ?>> func_203607_a(GenerationStage.Decoration decoration) {
        return this.field_201872_ah.get(decoration);
    }

    public void func_235061_a_(GenerationStage.Decoration decoration2, StructureManager structureManager, ChunkGenerator chunkGenerator, ISeedReader iSeedReader, long l, SharedSeedRandom sharedSeedRandom, BlockPos blockPos) {
        int n = 0;
        if (structureManager.func_235005_a_()) {
            for (Structure structure : Registry.field_218361_B) {
                if (structure.func_236396_f_() != decoration2) continue;
                sharedSeedRandom.func_202426_b(l, n, decoration2.ordinal());
                int n2 = blockPos.func_177958_n() >> 4;
                int n3 = blockPos.func_177952_p() >> 4;
                \u2603 = n2 << 4;
                \u2603 = n3 << 4;
                try {
                    structureManager.func_235011_a_(SectionPos.func_218167_a(blockPos), structure).forEach(structureStart -> structureStart.func_230366_a_(iSeedReader, structureManager, chunkGenerator, sharedSeedRandom, new MutableBoundingBox(\u2603, \u2603, \u2603 + 15, \u2603 + 15), new ChunkPos(n2, n3)));
                }
                catch (Exception \u26032) {
                    CrashReport crashReport = CrashReport.func_85055_a(\u26032, "Feature placement");
                    crashReport.func_85058_a("Feature").func_71507_a("Id", Registry.field_218361_B.func_177774_c(structure)).func_189529_a("Description", () -> structure.toString());
                    throw new ReportedException(crashReport);
                }
                ++n;
            }
        }
        for (ConfiguredFeature<?, ?> configuredFeature : this.field_201872_ah.get(decoration2)) {
            sharedSeedRandom.func_202426_b(l, n, decoration2.ordinal());
            try {
                configuredFeature.func_236265_a_(iSeedReader, structureManager, chunkGenerator, sharedSeedRandom, blockPos);
            }
            catch (Exception exception) {
                CrashReport crashReport = CrashReport.func_85055_a(exception, "Feature placement");
                crashReport.func_85058_a("Feature").func_71507_a("Id", Registry.field_218379_q.func_177774_c((Feature<?>)configuredFeature.field_222737_a)).func_71507_a("Config", configuredFeature.field_222738_b).func_189529_a("Description", () -> configuredFeature.field_222737_a.toString());
                throw new ReportedException(crashReport);
            }
            ++n;
        }
    }

    public void func_206854_a(Random random, IChunk iChunk, int n, int n2, int n3, double d, BlockState blockState, BlockState blockState2, int n4, long l) {
        this.field_201875_ar.func_215451_a(l);
        this.field_201875_ar.func_215450_a(random, iChunk, this, n, n2, n3, d, blockState, blockState2, n4, l);
    }

    public TempCategory func_150561_m() {
        if (this.field_201877_au == Category.OCEAN) {
            return TempCategory.OCEAN;
        }
        if ((double)this.func_185353_n() < 0.2) {
            return TempCategory.COLD;
        }
        if ((double)this.func_185353_n() < 1.0) {
            return TempCategory.MEDIUM;
        }
        return TempCategory.WARM;
    }

    public final float func_185355_j() {
        return this.field_76748_D;
    }

    public final float func_76727_i() {
        return this.field_76751_G;
    }

    public String func_210773_k() {
        if (this.field_205405_aL == null) {
            this.field_205405_aL = Util.func_200697_a("biome", Registry.field_212624_m.func_177774_c(this));
        }
        return this.field_205405_aL;
    }

    public final float func_185360_m() {
        return this.field_76749_E;
    }

    public final float func_185353_n() {
        return this.field_76750_F;
    }

    public BiomeAmbience func_235089_q_() {
        return this.field_235052_p_;
    }

    public final Category func_201856_r() {
        return this.field_201877_au;
    }

    public ConfiguredSurfaceBuilder<?> func_205401_q() {
        return this.field_201875_ar;
    }

    public ISurfaceBuilderConfig func_203944_q() {
        return this.field_201875_ar.func_215452_a();
    }

    public Stream<Attributes> func_235055_B_() {
        return this.field_235054_x_.stream();
    }

    @Nullable
    public String func_205402_s() {
        return this.field_185364_H;
    }

    public static class Attributes {
        public static final Codec<Attributes> field_235104_a_ = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("temperature").forGetter(attributes -> Float.valueOf(attributes.field_235105_b_)), (App)Codec.FLOAT.fieldOf("humidity").forGetter(attributes -> Float.valueOf(attributes.field_235106_c_)), (App)Codec.FLOAT.fieldOf("altitude").forGetter(attributes -> Float.valueOf(attributes.field_235107_d_)), (App)Codec.FLOAT.fieldOf("weirdness").forGetter(attributes -> Float.valueOf(attributes.field_235108_e_)), (App)Codec.FLOAT.fieldOf("offset").forGetter(attributes -> Float.valueOf(attributes.field_235109_f_))).apply((Applicative)instance, Attributes::new));
        private final float field_235105_b_;
        private final float field_235106_c_;
        private final float field_235107_d_;
        private final float field_235108_e_;
        private final float field_235109_f_;

        public Attributes(float f, float f2, float f3, float f4, float f5) {
            this.field_235105_b_ = f;
            this.field_235106_c_ = f2;
            this.field_235107_d_ = f3;
            this.field_235108_e_ = f4;
            this.field_235109_f_ = f5;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Attributes attributes = (Attributes)object;
            if (Float.compare(attributes.field_235105_b_, this.field_235105_b_) != 0) {
                return false;
            }
            if (Float.compare(attributes.field_235106_c_, this.field_235106_c_) != 0) {
                return false;
            }
            if (Float.compare(attributes.field_235107_d_, this.field_235107_d_) != 0) {
                return false;
            }
            return Float.compare(attributes.field_235108_e_, this.field_235108_e_) == 0;
        }

        public int hashCode() {
            int n = this.field_235105_b_ != 0.0f ? Float.floatToIntBits(this.field_235105_b_) : 0;
            n = 31 * n + (this.field_235106_c_ != 0.0f ? Float.floatToIntBits(this.field_235106_c_) : 0);
            n = 31 * n + (this.field_235107_d_ != 0.0f ? Float.floatToIntBits(this.field_235107_d_) : 0);
            n = 31 * n + (this.field_235108_e_ != 0.0f ? Float.floatToIntBits(this.field_235108_e_) : 0);
            return n;
        }

        public float func_235110_a_(Attributes attributes) {
            return (this.field_235105_b_ - attributes.field_235105_b_) * (this.field_235105_b_ - attributes.field_235105_b_) + (this.field_235106_c_ - attributes.field_235106_c_) * (this.field_235106_c_ - attributes.field_235106_c_) + (this.field_235107_d_ - attributes.field_235107_d_) * (this.field_235107_d_ - attributes.field_235107_d_) + (this.field_235108_e_ - attributes.field_235108_e_) * (this.field_235108_e_ - attributes.field_235108_e_) + (this.field_235109_f_ - attributes.field_235109_f_) * (this.field_235109_f_ - attributes.field_235109_f_);
        }
    }

    public static class Builder {
        @Nullable
        private ConfiguredSurfaceBuilder<?> field_205422_a;
        @Nullable
        private RainType field_205423_b;
        @Nullable
        private Category field_205424_c;
        @Nullable
        private Float field_205425_d;
        @Nullable
        private Float field_205426_e;
        @Nullable
        private Float field_205427_f;
        @Nullable
        private Float field_205428_g;
        @Nullable
        private String field_205431_j;
        @Nullable
        private List<Attributes> field_235095_i_;
        @Nullable
        private BiomeAmbience field_235096_j_;

        public <SC extends ISurfaceBuilderConfig> Builder func_222351_a(SurfaceBuilder<SC> surfaceBuilder, SC SC) {
            this.field_205422_a = new ConfiguredSurfaceBuilder<SC>(surfaceBuilder, SC);
            return this;
        }

        public Builder func_205416_a(ConfiguredSurfaceBuilder<?> configuredSurfaceBuilder) {
            this.field_205422_a = configuredSurfaceBuilder;
            return this;
        }

        public Builder func_205415_a(RainType rainType) {
            this.field_205423_b = rainType;
            return this;
        }

        public Builder func_205419_a(Category category) {
            this.field_205424_c = category;
            return this;
        }

        public Builder func_205421_a(float f) {
            this.field_205425_d = Float.valueOf(f);
            return this;
        }

        public Builder func_205420_b(float f) {
            this.field_205426_e = Float.valueOf(f);
            return this;
        }

        public Builder func_205414_c(float f) {
            this.field_205427_f = Float.valueOf(f);
            return this;
        }

        public Builder func_205417_d(float f) {
            this.field_205428_g = Float.valueOf(f);
            return this;
        }

        public Builder func_205418_a(@Nullable String string) {
            this.field_205431_j = string;
            return this;
        }

        public Builder func_235098_a_(List<Attributes> list) {
            this.field_235095_i_ = list;
            return this;
        }

        public Builder func_235097_a_(BiomeAmbience biomeAmbience) {
            this.field_235096_j_ = biomeAmbience;
            return this;
        }

        public String toString() {
            return "BiomeBuilder{\nsurfaceBuilder=" + this.field_205422_a + ",\nprecipitation=" + this.field_205423_b + ",\nbiomeCategory=" + this.field_205424_c + ",\ndepth=" + this.field_205425_d + ",\nscale=" + this.field_205426_e + ",\ntemperature=" + this.field_205427_f + ",\ndownfall=" + this.field_205428_g + ",\nspecialEffects=" + this.field_235096_j_ + ",\nparent='" + this.field_205431_j + '\'' + "\n" + '}';
        }
    }

    public static class SpawnListEntry
    extends WeightedRandom.Item {
        public static final Codec<SpawnListEntry> field_235123_b_ = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212629_r.fieldOf("type").forGetter(spawnListEntry -> spawnListEntry.field_200702_b), (App)Codec.INT.fieldOf("weight").forGetter(spawnListEntry -> spawnListEntry.field_76292_a), (App)Codec.INT.fieldOf("minCount").forGetter(spawnListEntry -> spawnListEntry.field_76301_c), (App)Codec.INT.fieldOf("maxCount").forGetter(spawnListEntry -> spawnListEntry.field_76299_d)).apply((Applicative)instance, SpawnListEntry::new));
        public final EntityType<?> field_200702_b;
        public final int field_76301_c;
        public final int field_76299_d;

        public SpawnListEntry(EntityType<?> entityType, int n, int n2, int n3) {
            super(n);
            this.field_200702_b = entityType.func_220339_d() == EntityClassification.MISC ? EntityType.field_200784_X : entityType;
            this.field_76301_c = n2;
            this.field_76299_d = n3;
        }

        public String toString() {
            return EntityType.func_200718_a(this.field_200702_b) + "*(" + this.field_76301_c + "-" + this.field_76299_d + "):" + this.field_76292_a;
        }
    }

    public static class EntityDensity {
        private final double field_235117_a_;
        private final double field_235118_b_;

        public EntityDensity(double d, double d2) {
            this.field_235117_a_ = d;
            this.field_235118_b_ = d2;
        }

        public double func_235119_a_() {
            return this.field_235117_a_;
        }

        public double func_235120_b_() {
            return this.field_235118_b_;
        }
    }

    public static enum RainType implements IStringSerializable
    {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        public static final Codec<RainType> field_235121_d_;
        private static final Map<String, RainType> field_222362_d;
        private final String field_222363_e;

        private RainType(String string2) {
            this.field_222363_e = string2;
        }

        public String func_222361_a() {
            return this.field_222363_e;
        }

        public static RainType func_235122_a_(String string) {
            return field_222362_d.get(string);
        }

        @Override
        public String func_176610_l() {
            return this.field_222363_e;
        }

        static {
            field_235121_d_ = IStringSerializable.func_233023_a_(RainType::values, RainType::func_235122_a_);
            field_222362_d = Arrays.stream(RainType.values()).collect(Collectors.toMap(RainType::func_222361_a, rainType -> rainType));
        }
    }

    public static enum Category implements IStringSerializable
    {
        NONE("none"),
        TAIGA("taiga"),
        EXTREME_HILLS("extreme_hills"),
        JUNGLE("jungle"),
        MESA("mesa"),
        PLAINS("plains"),
        SAVANNA("savanna"),
        ICY("icy"),
        THEEND("the_end"),
        BEACH("beach"),
        FOREST("forest"),
        OCEAN("ocean"),
        DESERT("desert"),
        RIVER("river"),
        SWAMP("swamp"),
        MUSHROOM("mushroom"),
        NETHER("nether");

        public static final Codec<Category> field_235102_r_;
        private static final Map<String, Category> field_222354_r;
        private final String field_222355_s;

        private Category(String string2) {
            this.field_222355_s = string2;
        }

        public String func_222352_a() {
            return this.field_222355_s;
        }

        public static Category func_235103_a_(String string) {
            return field_222354_r.get(string);
        }

        @Override
        public String func_176610_l() {
            return this.field_222355_s;
        }

        static {
            field_235102_r_ = IStringSerializable.func_233023_a_(Category::values, Category::func_235103_a_);
            field_222354_r = Arrays.stream(Category.values()).collect(Collectors.toMap(Category::func_222352_a, category -> category));
        }
    }

    public static enum TempCategory {
        OCEAN("ocean"),
        COLD("cold"),
        MEDIUM("medium"),
        WARM("warm");

        private static final Map<String, TempCategory> field_222358_e;
        private final String field_222359_f;

        private TempCategory(String string2) {
            this.field_222359_f = string2;
        }

        public String func_222357_a() {
            return this.field_222359_f;
        }

        static {
            field_222358_e = Arrays.stream(TempCategory.values()).collect(Collectors.toMap(TempCategory::func_222357_a, tempCategory -> tempCategory));
        }
    }
}

