/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome.provider;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.MaxMinNoiseMixer;

public class NetherBiomeProvider
extends BiomeProvider {
    public static final MapCodec<NetherBiomeProvider> field_235262_e_ = RecordCodecBuilder.mapCodec(instance2 -> instance2.group((App)Codec.LONG.fieldOf("seed").forGetter(netherBiomeProvider -> netherBiomeProvider.field_235270_m_), (App)RecordCodecBuilder.create(instance -> instance.group((App)Biome.Attributes.field_235104_a_.fieldOf("parameters").forGetter(Pair::getFirst), (App)Registry.field_212624_m.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf().fieldOf("biomes").forGetter(netherBiomeProvider -> netherBiomeProvider.field_235268_k_)).apply((Applicative)instance2, NetherBiomeProvider::new));
    public static final Codec<NetherBiomeProvider> field_235263_f_ = Codec.mapEither(Preset.field_235287_a_, field_235262_e_).xmap(either -> (NetherBiomeProvider)either.map(pair -> ((Preset)pair.getFirst()).func_235292_a_((Long)pair.getSecond()), Function.identity()), netherBiomeProvider -> netherBiomeProvider.field_235271_n_.map(preset -> Either.left((Object)Pair.of((Object)preset, (Object)netherBiomeProvider.field_235270_m_))).orElseGet(() -> Either.right((Object)netherBiomeProvider))).codec();
    private final MaxMinNoiseMixer field_235264_g_;
    private final MaxMinNoiseMixer field_235265_h_;
    private final MaxMinNoiseMixer field_235266_i_;
    private final MaxMinNoiseMixer field_235267_j_;
    private final List<Pair<Biome.Attributes, Biome>> field_235268_k_;
    private final boolean field_235269_l_;
    private final long field_235270_m_;
    private final Optional<Preset> field_235271_n_;

    private NetherBiomeProvider(long l, List<Pair<Biome.Attributes, Biome>> list) {
        this(l, list, Optional.empty());
    }

    public NetherBiomeProvider(long l, List<Pair<Biome.Attributes, Biome>> list, Optional<Preset> optional) {
        super(list.stream().map(Pair::getSecond).collect(Collectors.toList()));
        this.field_235270_m_ = l;
        this.field_235271_n_ = optional;
        IntStream intStream = IntStream.rangeClosed(-7, -6);
        \u2603 = IntStream.rangeClosed(-7, -6);
        \u2603 = IntStream.rangeClosed(-7, -6);
        \u2603 = IntStream.rangeClosed(-7, -6);
        this.field_235264_g_ = new MaxMinNoiseMixer(new SharedSeedRandom(l), intStream);
        this.field_235265_h_ = new MaxMinNoiseMixer(new SharedSeedRandom(l + 1L), \u2603);
        this.field_235266_i_ = new MaxMinNoiseMixer(new SharedSeedRandom(l + 2L), \u2603);
        this.field_235267_j_ = new MaxMinNoiseMixer(new SharedSeedRandom(l + 3L), \u2603);
        this.field_235268_k_ = list;
        this.field_235269_l_ = false;
    }

    private static NetherBiomeProvider func_235285_d_(long l) {
        ImmutableList immutableList = ImmutableList.of((Object)Biomes.field_235254_j_, (Object)Biomes.field_235252_ay_, (Object)Biomes.field_235253_az_, (Object)Biomes.field_235250_aA_, (Object)Biomes.field_235251_aB_);
        return new NetherBiomeProvider(l, (List)immutableList.stream().flatMap(biome -> biome.func_235055_B_().map(attributes -> Pair.of((Object)attributes, (Object)biome))).collect(ImmutableList.toImmutableList()), Optional.of(Preset.field_235288_b_));
    }

    @Override
    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return field_235263_f_;
    }

    @Override
    public Biome func_225526_b_(int n, int n2, int n3) {
        \u2603 = this.field_235269_l_ ? n2 : 0;
        Biome.Attributes attributes = new Biome.Attributes((float)this.field_235264_g_.func_237211_a_(n, \u2603, n3), (float)this.field_235265_h_.func_237211_a_(n, \u2603, n3), (float)this.field_235266_i_.func_237211_a_(n, \u2603, n3), (float)this.field_235267_j_.func_237211_a_(n, \u2603, n3), 0.0f);
        return this.field_235268_k_.stream().min(Comparator.comparing(pair -> Float.valueOf(((Biome.Attributes)pair.getFirst()).func_235110_a_(attributes)))).map(Pair::getSecond).orElse(Biomes.field_185440_P);
    }

    public boolean func_235280_b_(long l) {
        return this.field_235270_m_ == l && Objects.equals(this.field_235271_n_, Optional.of(Preset.field_235288_b_));
    }

    public static class Preset {
        private static final Map<ResourceLocation, Preset> field_235289_c_ = Maps.newHashMap();
        public static final MapCodec<Pair<Preset, Long>> field_235287_a_ = Codec.mapPair((MapCodec)ResourceLocation.field_240908_a_.flatXmap(resourceLocation -> Optional.ofNullable(field_235289_c_.get(resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + resourceLocation))), preset -> DataResult.success((Object)preset.field_235290_d_)).fieldOf("preset"), (MapCodec)Codec.LONG.fieldOf("seed")).stable();
        public static final Preset field_235288_b_ = new Preset(new ResourceLocation("nether"), l -> NetherBiomeProvider.func_235283_c_(l));
        private final ResourceLocation field_235290_d_;
        private final LongFunction<NetherBiomeProvider> field_235291_e_;

        public Preset(ResourceLocation resourceLocation, LongFunction<NetherBiomeProvider> longFunction) {
            this.field_235290_d_ = resourceLocation;
            this.field_235291_e_ = longFunction;
            field_235289_c_.put(resourceLocation, this);
        }

        public NetherBiomeProvider func_235292_a_(long l) {
            return this.field_235291_e_.apply(l);
        }
    }
}

