/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.storage.RegionBitmap;
import net.minecraft.world.chunk.storage.RegionFileVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionFile
implements AutoCloseable {
    private static final Logger field_227122_a_ = LogManager.getLogger();
    private static final ByteBuffer field_227123_b_ = ByteBuffer.allocateDirect(1);
    private final FileChannel field_76719_c;
    private final Path field_227124_d_;
    private final RegionFileVersion field_227125_e_;
    private final ByteBuffer field_227126_f_ = ByteBuffer.allocateDirect(8192);
    private final IntBuffer field_76716_d;
    private final IntBuffer field_227127_h_;
    private final RegionBitmap field_227128_i_ = new RegionBitmap();

    public RegionFile(File file, File file2, boolean bl) throws IOException {
        this(file.toPath(), file2.toPath(), RegionFileVersion.field_227159_b_, bl);
    }

    public RegionFile(Path path, Path path2, RegionFileVersion regionFileVersion, boolean bl) throws IOException {
        this.field_227125_e_ = regionFileVersion;
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + path2.toAbsolutePath());
        }
        this.field_227124_d_ = path2;
        this.field_76716_d = this.field_227126_f_.asIntBuffer();
        this.field_76716_d.limit(1024);
        this.field_227126_f_.position(4096);
        this.field_227127_h_ = this.field_227126_f_.asIntBuffer();
        this.field_76719_c = bl ? FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.field_227128_i_.func_227120_a_(0, 2);
        this.field_227126_f_.position(0);
        int n = this.field_76719_c.read(this.field_227126_f_, 0L);
        if (n != -1) {
            if (n != 8192) {
                field_227122_a_.warn("Region file {} has truncated header: {}", (Object)path, (Object)n);
            }
            for (\u2603 = 0; \u2603 < 1024; ++\u2603) {
                \u2603 = this.field_76716_d.get(\u2603);
                if (\u2603 == 0) continue;
                \u2603 = RegionFile.func_227142_b_(\u2603);
                \u2603 = RegionFile.func_227131_a_(\u2603);
                this.field_227128_i_.func_227120_a_(\u2603, \u2603);
            }
        }
    }

    private Path func_227145_e_(ChunkPos chunkPos) {
        String string = "c." + chunkPos.field_77276_a + "." + chunkPos.field_77275_b + ".mcc";
        return this.field_227124_d_.resolve(string);
    }

    @Nullable
    public synchronized DataInputStream func_222666_a(ChunkPos chunkPos) throws IOException {
        int n = this.func_222660_e(chunkPos);
        if (n == 0) {
            return null;
        }
        \u2603 = RegionFile.func_227142_b_(n);
        \u2603 = RegionFile.func_227131_a_(n);
        \u2603 = \u2603 * 4096;
        ByteBuffer \u26032 = ByteBuffer.allocate(\u2603);
        this.field_76719_c.read(\u26032, \u2603 * 4096);
        \u26032.flip();
        if (\u26032.remaining() < 5) {
            field_227122_a_.error("Chunk {} header is truncated: expected {} but read {}", (Object)chunkPos, (Object)\u2603, (Object)\u26032.remaining());
            return null;
        }
        \u2603 = \u26032.getInt();
        byte \u26033 = \u26032.get();
        if (\u2603 == 0) {
            field_227122_a_.warn("Chunk {} is allocated, but stream is missing", (Object)chunkPos);
            return null;
        }
        \u2603 = \u2603 - 1;
        if (RegionFile.func_227130_a_(\u26033)) {
            if (\u2603 != 0) {
                field_227122_a_.warn("Chunk has both internal and external streams");
            }
            return this.func_227133_a_(chunkPos, RegionFile.func_227141_b_(\u26033));
        }
        if (\u2603 > \u26032.remaining()) {
            field_227122_a_.error("Chunk {} stream is truncated: expected {} but read {}", (Object)chunkPos, (Object)\u2603, (Object)\u26032.remaining());
            return null;
        }
        if (\u2603 < 0) {
            field_227122_a_.error("Declared size {} of chunk {} is negative", (Object)\u2603, (Object)chunkPos);
            return null;
        }
        return this.func_227134_a_(chunkPos, \u26033, RegionFile.func_227137_a_(\u26032, \u2603));
    }

    private static boolean func_227130_a_(byte by) {
        return (by & 0x80) != 0;
    }

    private static byte func_227141_b_(byte by) {
        return (byte)(by & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream func_227134_a_(ChunkPos chunkPos, byte by, InputStream inputStream) throws IOException {
        RegionFileVersion regionFileVersion = RegionFileVersion.func_227166_a_(by);
        if (regionFileVersion == null) {
            field_227122_a_.error("Chunk {} has invalid chunk stream version {}", (Object)chunkPos, (Object)by);
            return null;
        }
        return new DataInputStream(new BufferedInputStream(regionFileVersion.func_227168_a_(inputStream)));
    }

    @Nullable
    private DataInputStream func_227133_a_(ChunkPos chunkPos, byte by) throws IOException {
        Path path = this.func_227145_e_(chunkPos);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            field_227122_a_.error("External chunk path {} is not file", (Object)path);
            return null;
        }
        return this.func_227134_a_(chunkPos, by, Files.newInputStream(path, new OpenOption[0]));
    }

    private static ByteArrayInputStream func_227137_a_(ByteBuffer byteBuffer, int n) {
        return new ByteArrayInputStream(byteBuffer.array(), byteBuffer.position(), n);
    }

    private int func_227132_a_(int n, int n2) {
        return n << 8 | n2;
    }

    private static int func_227131_a_(int n) {
        return n & 0xFF;
    }

    private static int func_227142_b_(int n) {
        return n >> 8;
    }

    private static int func_227144_c_(int n) {
        return (n + 4096 - 1) / 4096;
    }

    public boolean func_222662_b(ChunkPos chunkPos) {
        int n = this.func_222660_e(chunkPos);
        if (n == 0) {
            return false;
        }
        \u2603 = RegionFile.func_227142_b_(n);
        \u2603 = RegionFile.func_227131_a_(n);
        ByteBuffer \u26032 = ByteBuffer.allocate(5);
        try {
            this.field_76719_c.read(\u26032, \u2603 * 4096);
            \u26032.flip();
            if (\u26032.remaining() != 5) {
                return false;
            }
            \u2603 = \u26032.getInt();
            byte by = \u26032.get();
            if (RegionFile.func_227130_a_(by)) {
                if (!RegionFileVersion.func_227170_b_(RegionFile.func_227141_b_(by))) {
                    return false;
                }
                if (!Files.isRegularFile(this.func_227145_e_(chunkPos), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!RegionFileVersion.func_227170_b_(by)) {
                    return false;
                }
                if (\u2603 == 0) {
                    return false;
                }
                int n2 = \u2603 - 1;
                if (n2 < 0 || n2 > 4096 * \u2603) {
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public DataOutputStream func_222661_c(ChunkPos chunkPos) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(this.field_227125_e_.func_227169_a_(new ChunkBuffer(chunkPos))));
    }

    public void func_235985_a_() throws IOException {
        this.field_76719_c.force(true);
    }

    protected synchronized void func_227135_a_(ChunkPos chunkPos, ByteBuffer byteBuffer) throws IOException {
        ICompleteCallback \u26034;
        int \u26033;
        int \u26032;
        int n = RegionFile.func_222668_f(chunkPos);
        \u2603 = this.field_76716_d.get(n);
        \u2603 = RegionFile.func_227142_b_(\u2603);
        \u2603 = RegionFile.func_227131_a_(\u2603);
        \u2603 = byteBuffer.remaining();
        \u26032 = RegionFile.func_227144_c_(\u2603);
        if (\u26032 >= 256) {
            Path path = this.func_227145_e_(chunkPos);
            field_227122_a_.warn("Saving oversized chunk {} ({} bytes} to external file {}", (Object)chunkPos, (Object)\u2603, (Object)path);
            \u26032 = 1;
            \u26033 = this.field_227128_i_.func_227119_a_(\u26032);
            \u26034 = this.func_227138_a_(path, byteBuffer);
            ByteBuffer \u26035 = this.func_227129_a_();
            this.field_76719_c.write(\u26035, \u26033 * 4096);
        } else {
            \u26033 = this.field_227128_i_.func_227119_a_(\u26032);
            \u26034 = () -> Files.deleteIfExists(this.func_227145_e_(chunkPos));
            this.field_76719_c.write(byteBuffer, \u26033 * 4096);
        }
        int n2 = (int)(Util.func_211179_d() / 1000L);
        this.field_76716_d.put(n, this.func_227132_a_(\u26033, \u26032));
        this.field_227127_h_.put(n, n2);
        this.func_227140_b_();
        \u26034.run();
        if (\u2603 != 0) {
            this.field_227128_i_.func_227121_b_(\u2603, \u2603);
        }
    }

    private ByteBuffer func_227129_a_() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        byteBuffer.putInt(1);
        byteBuffer.put((byte)(this.field_227125_e_.func_227165_a_() | 0x80));
        byteBuffer.flip();
        return byteBuffer;
    }

    private ICompleteCallback func_227138_a_(Path path, ByteBuffer byteBuffer) throws IOException {
        Path path2 = Files.createTempFile(this.field_227124_d_, "tmp", null, new FileAttribute[0]);
        try (FileChannel \u26032 = FileChannel.open(path2, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            byteBuffer.position(5);
            \u26032.write(byteBuffer);
        }
        return () -> Files.move(path2, path, StandardCopyOption.REPLACE_EXISTING);
    }

    private void func_227140_b_() throws IOException {
        this.field_227126_f_.position(0);
        this.field_76719_c.write(this.field_227126_f_, 0L);
    }

    private int func_222660_e(ChunkPos chunkPos) {
        return this.field_76716_d.get(RegionFile.func_222668_f(chunkPos));
    }

    public boolean func_222667_d(ChunkPos chunkPos) {
        return this.func_222660_e(chunkPos) != 0;
    }

    private static int func_222668_f(ChunkPos chunkPos) {
        return chunkPos.func_222240_j() + chunkPos.func_222238_k() * 32;
    }

    @Override
    public void close() throws IOException {
        try {
            this.func_227143_c_();
        }
        finally {
            try {
                this.field_76719_c.force(true);
            }
            finally {
                this.field_76719_c.close();
            }
        }
    }

    private void func_227143_c_() throws IOException {
        int n = (int)this.field_76719_c.size();
        if (n != (\u2603 = RegionFile.func_227144_c_(n) * 4096)) {
            ByteBuffer byteBuffer = field_227123_b_.duplicate();
            byteBuffer.position(0);
            this.field_76719_c.write(byteBuffer, \u2603 - 1);
        }
    }

    static interface ICompleteCallback {
        public void run() throws IOException;
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkPos field_222659_b;

        public ChunkBuffer(ChunkPos chunkPos) {
            super(8096);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(RegionFile.this.field_227125_e_.func_227165_a_());
            this.field_222659_b = chunkPos;
        }

        @Override
        public void close() throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            byteBuffer.putInt(0, this.count - 5 + 1);
            RegionFile.this.func_227135_a_(this.field_222659_b, byteBuffer);
        }
    }
}

