/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.treedecorator.TreeDecorator;

public class TreeFeature
extends Feature<BaseTreeFeatureConfig> {
    public TreeFeature(Codec<BaseTreeFeatureConfig> codec) {
        super(codec);
    }

    public static boolean func_236410_c_(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return TreeFeature.func_236404_a_(iWorldGenerationBaseReader, blockPos) || iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> blockState.func_235714_a_(BlockTags.field_200031_h));
    }

    private static boolean func_236414_e_(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> blockState.func_203425_a(Blocks.field_150395_bd));
    }

    private static boolean func_236416_f_(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> blockState.func_203425_a(Blocks.field_150355_j));
    }

    public static boolean func_236412_d_(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> blockState.func_196958_f() || blockState.func_235714_a_(BlockTags.field_206952_E));
    }

    private static boolean func_236418_g_(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> {
            Block block = blockState.func_177230_c();
            return TreeFeature.func_227250_b_(block) || block == Blocks.field_150458_ak;
        });
    }

    private static boolean func_236419_h_(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> {
            Material material = blockState.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    public static void func_236408_b_(IWorldWriter iWorldWriter, BlockPos blockPos, BlockState blockState) {
        iWorldWriter.func_180501_a(blockPos, blockState, 19);
    }

    public static boolean func_236404_a_(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return TreeFeature.func_236412_d_(iWorldGenerationBaseReader, blockPos) || TreeFeature.func_236419_h_(iWorldGenerationBaseReader, blockPos) || TreeFeature.func_236416_f_(iWorldGenerationBaseReader, blockPos);
    }

    private boolean func_225557_a_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos3, Set<BlockPos> set, Set<BlockPos> set2, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        BlockPos blockPos2;
        int n = baseTreeFeatureConfig.field_236678_g_.func_236917_a_(random);
        \u2603 = baseTreeFeatureConfig.field_236677_f_.func_230374_a_(random, n, baseTreeFeatureConfig);
        \u2603 = n - \u2603;
        \u2603 = baseTreeFeatureConfig.field_236677_f_.func_230376_a_(random, \u2603);
        if (!baseTreeFeatureConfig.field_227372_q_) {
            \u2603 = iWorldGenerationReader.func_205770_a(Heightmap.Type.OCEAN_FLOOR, blockPos3).func_177956_o();
            \u26033 = iWorldGenerationReader.func_205770_a(Heightmap.Type.WORLD_SURFACE, blockPos3).func_177956_o();
            if (\u26033 - \u2603 > baseTreeFeatureConfig.field_236680_i_) {
                return false;
            }
            \u2603 = baseTreeFeatureConfig.field_236682_l_ == Heightmap.Type.OCEAN_FLOOR ? \u2603 : (baseTreeFeatureConfig.field_236682_l_ == Heightmap.Type.WORLD_SURFACE ? \u26033 : iWorldGenerationReader.func_205770_a(baseTreeFeatureConfig.field_236682_l_, blockPos3).func_177956_o());
            blockPos2 = new BlockPos(blockPos3.func_177958_n(), \u2603, blockPos3.func_177952_p());
        } else {
            BlockPos blockPos3;
            blockPos2 = blockPos3;
        }
        if (blockPos2.func_177956_o() < 1 || blockPos2.func_177956_o() + n + 1 > 256) {
            return false;
        }
        if (!TreeFeature.func_236418_g_(iWorldGenerationReader, blockPos2.func_177977_b())) {
            return false;
        }
        OptionalInt \u26032 = baseTreeFeatureConfig.field_236679_h_.func_236710_c_();
        int \u26033 = this.func_241521_a_(iWorldGenerationReader, n, blockPos2, baseTreeFeatureConfig);
        if (!(\u26033 >= n || \u26032.isPresent() && \u26033 >= \u26032.getAsInt())) {
            return false;
        }
        List<FoliagePlacer.Foliage> \u26034 = baseTreeFeatureConfig.field_236678_g_.func_230382_a_(iWorldGenerationReader, random, \u26033, blockPos2, set, mutableBoundingBox, baseTreeFeatureConfig);
        \u26034.forEach(foliage -> baseTreeFeatureConfig.field_236677_f_.func_236752_a_(iWorldGenerationReader, random, baseTreeFeatureConfig, \u26033, (FoliagePlacer.Foliage)foliage, \u2603, \u2603, set2, mutableBoundingBox));
        return true;
    }

    private int func_241521_a_(IWorldGenerationBaseReader iWorldGenerationBaseReader, int n2, BlockPos blockPos, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        int n2;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int i = 0; i <= n2 + 1; ++i) {
            \u2603 = baseTreeFeatureConfig.field_236679_h_.func_230369_a_(n2, i);
            for (\u2603 = -\u2603; \u2603 <= \u2603; ++\u2603) {
                for (\u2603 = -\u2603; \u2603 <= \u2603; ++\u2603) {
                    mutable.func_239621_a_(blockPos, \u2603, i, \u2603);
                    if (TreeFeature.func_236410_c_(iWorldGenerationBaseReader, mutable) && (baseTreeFeatureConfig.field_236681_j_ || !TreeFeature.func_236414_e_(iWorldGenerationBaseReader, mutable))) continue;
                    return i - 2;
                }
            }
        }
        return n2;
    }

    @Override
    protected void func_230367_a_(IWorldWriter iWorldWriter, BlockPos blockPos, BlockState blockState) {
        TreeFeature.func_236408_b_(iWorldWriter, blockPos, blockState);
    }

    @Override
    public final boolean func_230362_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        HashSet hashSet = Sets.newHashSet();
        \u2603 = Sets.newHashSet();
        \u2603 = Sets.newHashSet();
        MutableBoundingBox \u26032 = MutableBoundingBox.func_78887_a();
        boolean \u26033 = this.func_225557_a_(iSeedReader, random, blockPos, hashSet, \u2603, \u26032, baseTreeFeatureConfig);
        if (\u26032.field_78897_a > \u26032.field_78893_d || !\u26033 || hashSet.isEmpty()) {
            return false;
        }
        if (!baseTreeFeatureConfig.field_227370_o_.isEmpty()) {
            Object object = Lists.newArrayList((Iterable)hashSet);
            ArrayList \u26034 = Lists.newArrayList((Iterable)\u2603);
            object.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            \u26034.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            baseTreeFeatureConfig.field_227370_o_.forEach(arg_0 -> TreeFeature.func_236405_a_(iSeedReader, random, (List)object, \u26034, \u2603, \u26032, arg_0));
        }
        object = this.func_236403_a_(iSeedReader, \u26032, hashSet, \u2603);
        Template.func_222857_a(iSeedReader, 3, (VoxelShapePart)object, \u26032.field_78897_a, \u26032.field_78895_b, \u26032.field_78896_c);
        return true;
    }

    private VoxelShapePart func_236403_a_(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Set<BlockPos> set3, Set<BlockPos> set2) {
        Set<BlockPos> set3;
        ArrayList arrayList = Lists.newArrayList();
        BitSetVoxelShapePart \u26032 = new BitSetVoxelShapePart(mutableBoundingBox.func_78883_b(), mutableBoundingBox.func_78882_c(), mutableBoundingBox.func_78880_d());
        int \u26033 = 6;
        for (int i = 0; i < 6; ++i) {
            arrayList.add(Sets.newHashSet());
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (Object \u26034 : Lists.newArrayList(set2)) {
            if (!mutableBoundingBox.func_175898_b((Vector3i)\u26034)) continue;
            ((VoxelShapePart)\u26032).func_199625_a(((Vector3i)\u26034).func_177958_n() - mutableBoundingBox.field_78897_a, ((Vector3i)\u26034).func_177956_o() - mutableBoundingBox.field_78895_b, ((Vector3i)\u26034).func_177952_p() - mutableBoundingBox.field_78896_c, true, true);
        }
        for (Object \u26034 : Lists.newArrayList(set3)) {
            if (mutableBoundingBox.func_175898_b((Vector3i)\u26034)) {
                ((VoxelShapePart)\u26032).func_199625_a(((Vector3i)\u26034).func_177958_n() - mutableBoundingBox.field_78897_a, ((Vector3i)\u26034).func_177956_o() - mutableBoundingBox.field_78895_b, ((Vector3i)\u26034).func_177952_p() - mutableBoundingBox.field_78896_c, true, true);
            }
            for (Direction direction : Direction.values()) {
                mutable.func_239622_a_((Vector3i)\u26034, direction);
                if (set3.contains(mutable) || !(\u2603 = iWorld.func_180495_p(mutable)).func_235901_b_(BlockStateProperties.field_208514_aa)) continue;
                ((Set)arrayList.get(0)).add(mutable.func_185334_h());
                TreeFeature.func_236408_b_(iWorld, mutable, (BlockState)\u2603.func_206870_a(BlockStateProperties.field_208514_aa, 1));
                if (!mutableBoundingBox.func_175898_b(mutable)) continue;
                ((VoxelShapePart)\u26032).func_199625_a(mutable.func_177958_n() - mutableBoundingBox.field_78897_a, mutable.func_177956_o() - mutableBoundingBox.field_78895_b, mutable.func_177952_p() - mutableBoundingBox.field_78896_c, true, true);
            }
        }
        for (int i = 1; i < 6; ++i) {
            Object \u26034;
            \u26034 = (Set)arrayList.get(i - 1);
            Set set4 = (Set)arrayList.get(i);
            Iterator iterator = \u26034.iterator();
            while (iterator.hasNext()) {
                BlockPos blockPos = (BlockPos)iterator.next();
                if (mutableBoundingBox.func_175898_b(blockPos)) {
                    ((VoxelShapePart)\u26032).func_199625_a(blockPos.func_177958_n() - mutableBoundingBox.field_78897_a, blockPos.func_177956_o() - mutableBoundingBox.field_78895_b, blockPos.func_177952_p() - mutableBoundingBox.field_78896_c, true, true);
                }
                for (Direction direction : Direction.values()) {
                    mutable.func_239622_a_(blockPos, direction);
                    if (\u26034.contains(mutable) || set4.contains(mutable) || !(\u2603 = iWorld.func_180495_p(mutable)).func_235901_b_(BlockStateProperties.field_208514_aa) || (\u2603 = \u2603.func_177229_b(BlockStateProperties.field_208514_aa).intValue()) <= i + 1) continue;
                    BlockState blockState = (BlockState)\u2603.func_206870_a(BlockStateProperties.field_208514_aa, i + 1);
                    TreeFeature.func_236408_b_(iWorld, mutable, blockState);
                    if (mutableBoundingBox.func_175898_b(mutable)) {
                        ((VoxelShapePart)\u26032).func_199625_a(mutable.func_177958_n() - mutableBoundingBox.field_78897_a, mutable.func_177956_o() - mutableBoundingBox.field_78895_b, mutable.func_177952_p() - mutableBoundingBox.field_78896_c, true, true);
                    }
                    set4.add(mutable.func_185334_h());
                }
            }
        }
        return \u26032;
    }

    private static /* synthetic */ void func_236405_a_(ISeedReader iSeedReader, Random random, List list, List list2, Set set, MutableBoundingBox mutableBoundingBox, TreeDecorator treeDecorator) {
        treeDecorator.func_225576_a_(iSeedReader, random, list, list2, set, mutableBoundingBox);
    }
}

