/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.jigsaw;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.template.GravityStructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JigsawPattern {
    private static final Logger field_236853_d_ = LogManager.getLogger();
    public static final Codec<JigsawPattern> field_236852_a_ = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("name").forGetter(JigsawPattern::func_214947_b), (App)ResourceLocation.field_240908_a_.fieldOf("fallback").forGetter(JigsawPattern::func_214948_a), (App)Codec.mapPair((MapCodec)JigsawPiece.field_236847_e_.fieldOf("element"), (MapCodec)Codec.INT.fieldOf("weight")).codec().listOf().promotePartial(Util.func_240982_a_("Pool element: ", arg_0 -> ((Logger)field_236853_d_).error(arg_0))).fieldOf("elements").forGetter(jigsawPattern -> jigsawPattern.field_214952_d), (App)PlacementBehaviour.field_236858_c_.fieldOf("projection").forGetter(jigsawPattern -> jigsawPattern.field_214955_g)).apply((Applicative)instance, JigsawPattern::new));
    public static final JigsawPattern field_214949_a = new JigsawPattern(new ResourceLocation("empty"), new ResourceLocation("empty"), (List<Pair<JigsawPiece, Integer>>)ImmutableList.of(), PlacementBehaviour.RIGID);
    public static final JigsawPattern field_214950_b = new JigsawPattern(new ResourceLocation("invalid"), new ResourceLocation("invalid"), (List<Pair<JigsawPiece, Integer>>)ImmutableList.of(), PlacementBehaviour.RIGID);
    private final ResourceLocation field_214951_c;
    private final ImmutableList<Pair<JigsawPiece, Integer>> field_214952_d;
    private final List<JigsawPiece> field_214953_e;
    private final ResourceLocation field_214954_f;
    private final PlacementBehaviour field_214955_g;
    private int field_214956_h = Integer.MIN_VALUE;

    public JigsawPattern(ResourceLocation resourceLocation, ResourceLocation resourceLocation22, List<Pair<JigsawPiece, Integer>> list, PlacementBehaviour placementBehaviour) {
        ResourceLocation resourceLocation22;
        this.field_214951_c = resourceLocation;
        this.field_214952_d = ImmutableList.copyOf(list);
        this.field_214953_e = Lists.newArrayList();
        for (Pair<JigsawPiece, Integer> pair : list) {
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                this.field_214953_e.add(((JigsawPiece)pair.getFirst()).func_214845_a(placementBehaviour));
            }
        }
        this.field_214954_f = resourceLocation22;
        this.field_214955_g = placementBehaviour;
    }

    public int func_214945_a(TemplateManager templateManager) {
        if (this.field_214956_h == Integer.MIN_VALUE) {
            this.field_214956_h = this.field_214953_e.stream().mapToInt(jigsawPiece -> jigsawPiece.func_214852_a(templateManager, BlockPos.field_177992_a, Rotation.NONE).func_78882_c()).max().orElse(0);
        }
        return this.field_214956_h;
    }

    public ResourceLocation func_214948_a() {
        return this.field_214954_f;
    }

    public JigsawPiece func_214944_a(Random random) {
        return this.field_214953_e.get(random.nextInt(this.field_214953_e.size()));
    }

    public List<JigsawPiece> func_214943_b(Random random) {
        return ImmutableList.copyOf((Object[])ObjectArrays.shuffle((Object[])this.field_214953_e.toArray(new JigsawPiece[0]), (Random)random));
    }

    public ResourceLocation func_214947_b() {
        return this.field_214951_c;
    }

    public int func_214946_c() {
        return this.field_214953_e.size();
    }

    public static enum PlacementBehaviour implements IStringSerializable
    {
        TERRAIN_MATCHING("terrain_matching", (ImmutableList<StructureProcessor>)ImmutableList.of((Object)new GravityStructureProcessor(Heightmap.Type.WORLD_SURFACE_WG, -1))),
        RIGID("rigid", (ImmutableList<StructureProcessor>)ImmutableList.of());

        public static final Codec<PlacementBehaviour> field_236858_c_;
        private static final Map<String, PlacementBehaviour> field_214939_c;
        private final String field_214940_d;
        private final ImmutableList<StructureProcessor> field_214941_e;

        private PlacementBehaviour(String string2, ImmutableList<StructureProcessor> immutableList) {
            this.field_214940_d = string2;
            this.field_214941_e = immutableList;
        }

        public String func_214936_a() {
            return this.field_214940_d;
        }

        public static PlacementBehaviour func_214938_a(String string) {
            return field_214939_c.get(string);
        }

        public ImmutableList<StructureProcessor> func_214937_b() {
            return this.field_214941_e;
        }

        @Override
        public String func_176610_l() {
            return this.field_214940_d;
        }

        static {
            field_236858_c_ = IStringSerializable.func_233023_a_(PlacementBehaviour::values, PlacementBehaviour::func_214938_a);
            field_214939_c = Arrays.stream(PlacementBehaviour.values()).collect(Collectors.toMap(PlacementBehaviour::func_214936_a, placementBehaviour -> placementBehaviour));
        }
    }
}

