/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.EndCityPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class EndCityStructure
extends Structure<NoFeatureConfig> {
    public EndCityStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @Override
    protected boolean func_230365_b_() {
        return false;
    }

    @Override
    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider, long l, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome, ChunkPos chunkPos, NoFeatureConfig noFeatureConfig) {
        return EndCityStructure.func_191070_b(n, n2, chunkGenerator) >= 60;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    private static int func_191070_b(int n, int n2, ChunkGenerator chunkGenerator) {
        Random random = new Random(n + n2 * 10387313);
        Rotation \u26032 = Rotation.func_222466_a(random);
        int \u26033 = 5;
        int \u26034 = 5;
        if (\u26032 == Rotation.CLOCKWISE_90) {
            \u26033 = -5;
        } else if (\u26032 == Rotation.CLOCKWISE_180) {
            \u26033 = -5;
            \u26034 = -5;
        } else if (\u26032 == Rotation.COUNTERCLOCKWISE_90) {
            \u26034 = -5;
        }
        int \u26035 = (n << 4) + 7;
        int \u26036 = (n2 << 4) + 7;
        int \u26037 = chunkGenerator.func_222531_c(\u26035, \u26036, Heightmap.Type.WORLD_SURFACE_WG);
        int \u26038 = chunkGenerator.func_222531_c(\u26035, \u26036 + \u26034, Heightmap.Type.WORLD_SURFACE_WG);
        int \u26039 = chunkGenerator.func_222531_c(\u26035 + \u26033, \u26036, Heightmap.Type.WORLD_SURFACE_WG);
        int \u260310 = chunkGenerator.func_222531_c(\u26035 + \u26033, \u26036 + \u26034, Heightmap.Type.WORLD_SURFACE_WG);
        return Math.min(Math.min(\u26037, \u26038), Math.min(\u26039, \u260310));
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int n, int n2, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_230364_a_(ChunkGenerator chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome, NoFeatureConfig noFeatureConfig) {
            Rotation rotation = Rotation.func_222466_a(this.field_214631_d);
            int \u26032 = EndCityStructure.func_191070_b(n, n2, chunkGenerator);
            if (\u26032 < 60) {
                return;
            }
            BlockPos \u26033 = new BlockPos(n * 16 + 8, \u26032, n2 * 16 + 8);
            EndCityPieces.func_191087_a(templateManager, \u26033, rotation, this.field_75075_a, this.field_214631_d);
            this.func_202500_a();
        }
    }
}

