/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.placement;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.placement.AtHeight64;
import net.minecraft.world.gen.placement.AtSurface;
import net.minecraft.world.gen.placement.AtSurfaceRandomCount;
import net.minecraft.world.gen.placement.AtSurfaceWithChance;
import net.minecraft.world.gen.placement.AtSurfaceWithChanceMultiple;
import net.minecraft.world.gen.placement.AtSurfaceWithExtra;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.CaveEdge;
import net.minecraft.world.gen.placement.CaveEdgeConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ChanceRange;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.ChorusPlant;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.CountRange;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.DarkOakTreePlacement;
import net.minecraft.world.gen.placement.DepthAverage;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.DungeonRoom;
import net.minecraft.world.gen.placement.EndGateway;
import net.minecraft.world.gen.placement.EndIsland;
import net.minecraft.world.gen.placement.FirePlacement;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.Height4To32;
import net.minecraft.world.gen.placement.HeightBiasedRange;
import net.minecraft.world.gen.placement.HeightVeryBiasedRange;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.IcebergPlacement;
import net.minecraft.world.gen.placement.LakeLava;
import net.minecraft.world.gen.placement.LakeWater;
import net.minecraft.world.gen.placement.NetherGlowstone;
import net.minecraft.world.gen.placement.NetherMagma;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Passthrough;
import net.minecraft.world.gen.placement.RandomCountWithRange;
import net.minecraft.world.gen.placement.SurfacePlus32;
import net.minecraft.world.gen.placement.SurfacePlus32WithNoise;
import net.minecraft.world.gen.placement.TopSolid;
import net.minecraft.world.gen.placement.TopSolidOnce;
import net.minecraft.world.gen.placement.TopSolidRange;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.placement.TopSolidWithChance;
import net.minecraft.world.gen.placement.TopSolidWithNoise;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;
import net.minecraft.world.gen.placement.TwiceSurface;
import net.minecraft.world.gen.placement.TwiceSurfaceWithChance;
import net.minecraft.world.gen.placement.TwiceSurfaceWithChanceMultiple;
import net.minecraft.world.gen.placement.TwiceSurfaceWithNoise;
import net.minecraft.world.gen.placement.WithChance;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class Placement<DC extends IPlacementConfig> {
    public static final Placement<NoPlacementConfig> field_215022_h = Placement.func_214999_a("nope", new Passthrough(NoPlacementConfig.field_236555_a_));
    public static final Placement<FrequencyConfig> field_215015_a = Placement.func_214999_a("count_heightmap", new AtSurface(FrequencyConfig.field_236971_a_));
    public static final Placement<FrequencyConfig> field_215016_b = Placement.func_214999_a("count_top_solid", new TopSolid(FrequencyConfig.field_236971_a_));
    public static final Placement<FrequencyConfig> field_215017_c = Placement.func_214999_a("count_heightmap_32", new SurfacePlus32(FrequencyConfig.field_236971_a_));
    public static final Placement<FrequencyConfig> field_215018_d = Placement.func_214999_a("count_heightmap_double", new TwiceSurface(FrequencyConfig.field_236971_a_));
    public static final Placement<FrequencyConfig> field_215019_e = Placement.func_214999_a("count_height_64", new AtHeight64(FrequencyConfig.field_236971_a_));
    public static final Placement<NoiseDependant> field_215020_f = Placement.func_214999_a("noise_heightmap_32", new SurfacePlus32WithNoise(NoiseDependant.field_236550_a_));
    public static final Placement<NoiseDependant> field_215021_g = Placement.func_214999_a("noise_heightmap_double", new TwiceSurfaceWithNoise(NoiseDependant.field_236550_a_));
    public static final Placement<ChanceConfig> field_215023_i = Placement.func_214999_a("chance_heightmap", new AtSurfaceWithChance(ChanceConfig.field_236950_a_));
    public static final Placement<ChanceConfig> field_215024_j = Placement.func_214999_a("chance_heightmap_double", new TwiceSurfaceWithChance(ChanceConfig.field_236950_a_));
    public static final Placement<ChanceConfig> field_215025_k = Placement.func_214999_a("chance_passthrough", new WithChance(ChanceConfig.field_236950_a_));
    public static final Placement<ChanceConfig> field_215026_l = Placement.func_214999_a("chance_top_solid_heightmap", new TopSolidWithChance(ChanceConfig.field_236950_a_));
    public static final Placement<AtSurfaceWithExtraConfig> field_215027_m = Placement.func_214999_a("count_extra_heightmap", new AtSurfaceWithExtra(AtSurfaceWithExtraConfig.field_236973_a_));
    public static final Placement<CountRangeConfig> field_215028_n = Placement.func_214999_a("count_range", new CountRange(CountRangeConfig.field_236485_a_));
    public static final Placement<CountRangeConfig> field_215029_o = Placement.func_214999_a("count_biased_range", new HeightBiasedRange(CountRangeConfig.field_236485_a_));
    public static final Placement<CountRangeConfig> field_215030_p = Placement.func_214999_a("count_very_biased_range", new HeightVeryBiasedRange(CountRangeConfig.field_236485_a_));
    public static final Placement<CountRangeConfig> field_215031_q = Placement.func_214999_a("random_count_range", new RandomCountWithRange(CountRangeConfig.field_236485_a_));
    public static final Placement<ChanceRangeConfig> field_215032_r = Placement.func_214999_a("chance_range", new ChanceRange(ChanceRangeConfig.field_236459_a_));
    public static final Placement<HeightWithChanceConfig> field_215033_s = Placement.func_214999_a("count_chance_heightmap", new AtSurfaceWithChanceMultiple(HeightWithChanceConfig.field_236967_a_));
    public static final Placement<HeightWithChanceConfig> field_215034_t = Placement.func_214999_a("count_chance_heightmap_double", new TwiceSurfaceWithChanceMultiple(HeightWithChanceConfig.field_236967_a_));
    public static final Placement<DepthAverageConfig> field_215035_u = Placement.func_214999_a("count_depth_average", new DepthAverage(DepthAverageConfig.field_236955_a_));
    public static final Placement<NoPlacementConfig> field_215036_v = Placement.func_214999_a("top_solid_heightmap", new TopSolidOnce(NoPlacementConfig.field_236555_a_));
    public static final Placement<TopSolidRangeConfig> field_215037_w = Placement.func_214999_a("top_solid_heightmap_range", new TopSolidRange(TopSolidRangeConfig.field_236985_a_));
    public static final Placement<TopSolidWithNoiseConfig> field_215038_x = Placement.func_214999_a("top_solid_heightmap_noise_biased", new TopSolidWithNoise(TopSolidWithNoiseConfig.field_236978_a_));
    public static final Placement<CaveEdgeConfig> field_215039_y = Placement.func_214999_a("carving_mask", new CaveEdge(CaveEdgeConfig.field_236946_a_));
    public static final Placement<FrequencyConfig> field_215040_z = Placement.func_214999_a("forest_rock", new AtSurfaceRandomCount(FrequencyConfig.field_236971_a_));
    public static final Placement<FrequencyConfig> field_236960_A_ = Placement.func_214999_a("fire", new FirePlacement(FrequencyConfig.field_236971_a_));
    public static final Placement<FrequencyConfig> field_215003_B = Placement.func_214999_a("magma", new NetherMagma(FrequencyConfig.field_236971_a_));
    public static final Placement<NoPlacementConfig> field_215004_C = Placement.func_214999_a("emerald_ore", new Height4To32(NoPlacementConfig.field_236555_a_));
    public static final Placement<ChanceConfig> field_215005_D = Placement.func_214999_a("lava_lake", new LakeLava(ChanceConfig.field_236950_a_));
    public static final Placement<ChanceConfig> field_215006_E = Placement.func_214999_a("water_lake", new LakeWater(ChanceConfig.field_236950_a_));
    public static final Placement<ChanceConfig> field_215007_F = Placement.func_214999_a("dungeons", new DungeonRoom(ChanceConfig.field_236950_a_));
    public static final Placement<NoPlacementConfig> field_215008_G = Placement.func_214999_a("dark_oak_tree", new DarkOakTreePlacement(NoPlacementConfig.field_236555_a_));
    public static final Placement<ChanceConfig> field_215009_H = Placement.func_214999_a("iceberg", new IcebergPlacement(ChanceConfig.field_236950_a_));
    public static final Placement<FrequencyConfig> field_215010_I = Placement.func_214999_a("light_gem_chance", new NetherGlowstone(FrequencyConfig.field_236971_a_));
    public static final Placement<NoPlacementConfig> field_215011_J = Placement.func_214999_a("end_island", new EndIsland(NoPlacementConfig.field_236555_a_));
    public static final Placement<NoPlacementConfig> field_215012_K = Placement.func_214999_a("chorus_plant", new ChorusPlant(NoPlacementConfig.field_236555_a_));
    public static final Placement<NoPlacementConfig> field_215013_L = Placement.func_214999_a("end_gateway", new EndGateway(NoPlacementConfig.field_236555_a_));
    private final Codec<ConfiguredPlacement<DC>> field_236961_M_;

    private static <T extends IPlacementConfig, G extends Placement<T>> G func_214999_a(String string, G g) {
        return (G)Registry.func_218325_a(Registry.field_218380_r, string, g);
    }

    public Placement(Codec<DC> codec) {
        this.field_236961_M_ = codec.fieldOf("config").xmap(iPlacementConfig -> new ConfiguredPlacement<IPlacementConfig>(this, (IPlacementConfig)iPlacementConfig), configuredPlacement -> configuredPlacement.field_215097_b).codec();
    }

    public ConfiguredPlacement<DC> func_227446_a_(DC DC) {
        return new ConfiguredPlacement<DC>(this, DC);
    }

    public Codec<ConfiguredPlacement<DC>> func_236962_a_() {
        return this.field_236961_M_;
    }

    protected <FC extends IFeatureConfig, F extends Feature<FC>> boolean func_236963_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos2, DC DC, ConfiguredFeature<FC, F> configuredFeature) {
        MutableBoolean mutableBoolean = new MutableBoolean();
        this.func_212848_a_(iSeedReader, chunkGenerator, random, DC, blockPos2).forEach(blockPos -> {
            if (configuredFeature.func_236265_a_(iSeedReader, structureManager, chunkGenerator, random, (BlockPos)blockPos)) {
                mutableBoolean.setTrue();
            }
        });
        return mutableBoolean.isTrue();
    }

    public abstract Stream<BlockPos> func_212848_a_(IWorld var1, ChunkGenerator var2, Random var3, DC var4, BlockPos var5);

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }
}

