/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.settings;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DimensionGeneratorSettings {
    public static final Codec<DimensionGeneratorSettings> field_236201_a_ = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(DimensionGeneratorSettings::func_236221_b_), (App)Codec.BOOL.fieldOf("generate_features").withDefault((Object)true).stable().forGetter(DimensionGeneratorSettings::func_236222_c_), (App)Codec.BOOL.fieldOf("bonus_chest").withDefault((Object)false).stable().forGetter(DimensionGeneratorSettings::func_236223_d_), (App)SimpleRegistry.func_241744_b_(Registry.field_239700_af_, Lifecycle.stable(), Dimension.field_236052_a_).xmap(Dimension::func_236062_a_, Function.identity()).fieldOf("dimensions").forGetter(DimensionGeneratorSettings::func_236224_e_), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(dimensionGeneratorSettings -> dimensionGeneratorSettings.field_236209_i_)).apply((Applicative)instance, instance.stable(DimensionGeneratorSettings::new))).comapFlatMap(DimensionGeneratorSettings::func_236233_n_, Function.identity());
    private static final Logger field_236203_c_ = LogManager.getLogger();
    private static final int field_236204_d_ = "North Carolina".hashCode();
    public static final DimensionGeneratorSettings field_236202_b_ = new DimensionGeneratorSettings(field_236204_d_, true, true, DimensionGeneratorSettings.func_236216_a_(DimensionType.func_236022_a_(field_236204_d_), DimensionGeneratorSettings.func_236211_a_(field_236204_d_)));
    private final long field_236205_e_;
    private final boolean field_236206_f_;
    private final boolean field_236207_g_;
    private final SimpleRegistry<Dimension> field_236208_h_;
    private final Optional<String> field_236209_i_;

    private DataResult<DimensionGeneratorSettings> func_236233_n_() {
        if (this.func_236234_o_()) {
            return DataResult.success((Object)this, (Lifecycle)Lifecycle.stable());
        }
        return DataResult.success((Object)this);
    }

    private boolean func_236234_o_() {
        return Dimension.func_236060_a_(this.field_236205_e_, this.field_236208_h_);
    }

    public DimensionGeneratorSettings(long l, boolean bl, boolean bl2, SimpleRegistry<Dimension> simpleRegistry) {
        this(l, bl, bl2, simpleRegistry, Optional.empty());
    }

    private DimensionGeneratorSettings(long l, boolean bl, boolean bl2, SimpleRegistry<Dimension> simpleRegistry, Optional<String> optional) {
        this.field_236205_e_ = l;
        this.field_236206_f_ = bl;
        this.field_236207_g_ = bl2;
        this.field_236208_h_ = simpleRegistry;
        this.field_236209_i_ = optional;
    }

    public static DimensionGeneratorSettings func_236210_a_() {
        long l = new Random().nextLong();
        return new DimensionGeneratorSettings(l, true, false, DimensionGeneratorSettings.func_236216_a_(DimensionType.func_236022_a_(l), DimensionGeneratorSettings.func_236211_a_(l)));
    }

    public static NoiseChunkGenerator func_236211_a_(long l) {
        return new NoiseChunkGenerator(new OverworldBiomeProvider(l, false, false), l, DimensionSettings.Preset.field_236122_b_.func_236137_b_());
    }

    public long func_236221_b_() {
        return this.field_236205_e_;
    }

    public boolean func_236222_c_() {
        return this.field_236206_f_;
    }

    public boolean func_236223_d_() {
        return this.field_236207_g_;
    }

    public static SimpleRegistry<Dimension> func_236216_a_(SimpleRegistry<Dimension> simpleRegistry, ChunkGenerator chunkGenerator) {
        Dimension dimension = simpleRegistry.func_230516_a_(Dimension.field_236053_b_);
        Supplier<DimensionType> \u26032 = () -> dimension == null ? DimensionType.func_236019_a_() : dimension.func_236063_b_();
        return DimensionGeneratorSettings.func_241520_a_(simpleRegistry, \u26032, chunkGenerator);
    }

    public static SimpleRegistry<Dimension> func_241520_a_(SimpleRegistry<Dimension> simpleRegistry, Supplier<DimensionType> supplier, ChunkGenerator chunkGenerator) {
        SimpleRegistry<Dimension> simpleRegistry2 = new SimpleRegistry<Dimension>(Registry.field_239700_af_, Lifecycle.experimental());
        simpleRegistry2.func_218381_a(Dimension.field_236053_b_, new Dimension(supplier, chunkGenerator));
        simpleRegistry2.func_239662_d_(Dimension.field_236053_b_);
        for (Map.Entry<RegistryKey<Dimension>, Dimension> entry : simpleRegistry.func_239659_c_()) {
            RegistryKey<Dimension> registryKey = entry.getKey();
            if (registryKey == Dimension.field_236053_b_) continue;
            simpleRegistry2.func_218381_a(registryKey, entry.getValue());
            if (!simpleRegistry.func_239660_c_(registryKey)) continue;
            simpleRegistry2.func_239662_d_(registryKey);
        }
        return simpleRegistry2;
    }

    public SimpleRegistry<Dimension> func_236224_e_() {
        return this.field_236208_h_;
    }

    public ChunkGenerator func_236225_f_() {
        Dimension dimension = this.field_236208_h_.func_230516_a_(Dimension.field_236053_b_);
        if (dimension == null) {
            return DimensionGeneratorSettings.func_236211_a_(new Random().nextLong());
        }
        return dimension.func_236064_c_();
    }

    public ImmutableSet<RegistryKey<World>> func_236226_g_() {
        return (ImmutableSet)this.func_236224_e_().func_239659_c_().stream().map(entry -> RegistryKey.func_240903_a_(Registry.field_239699_ae_, ((RegistryKey)entry.getKey()).func_240901_a_())).collect(ImmutableSet.toImmutableSet());
    }

    public boolean func_236227_h_() {
        return this.func_236225_f_() instanceof DebugChunkGenerator;
    }

    public boolean func_236228_i_() {
        return this.func_236225_f_() instanceof FlatChunkGenerator;
    }

    public DimensionGeneratorSettings func_236230_k_() {
        return new DimensionGeneratorSettings(this.field_236205_e_, this.field_236206_f_, true, this.field_236208_h_, this.field_236209_i_);
    }

    public static DimensionGeneratorSettings func_236219_a_(Properties properties) {
        String string2 = (String)MoreObjects.firstNonNull((Object)((String)properties.get("generator-settings")), (Object)"");
        properties.put("generator-settings", string2);
        \u2603 = (String)MoreObjects.firstNonNull((Object)((String)properties.get("level-seed")), (Object)"");
        properties.put("level-seed", \u2603);
        \u2603 = (String)properties.get("generate-structures");
        boolean \u26032 = \u2603 == null || Boolean.parseBoolean(\u2603);
        properties.put("generate-structures", Objects.toString(\u26032));
        \u2603 = (String)properties.get("level-type");
        \u2603 = Optional.ofNullable(\u2603).map(string -> string.toLowerCase(Locale.ROOT)).orElse("default");
        properties.put("level-type", \u2603);
        long \u26033 = new Random().nextLong();
        if (!\u2603.isEmpty()) {
            try {
                long l = Long.parseLong(\u2603);
                if (l != 0L) {
                    \u26033 = l;
                }
            }
            catch (NumberFormatException numberFormatException) {
                \u26033 = \u2603.hashCode();
            }
        }
        SimpleRegistry<Dimension> simpleRegistry = DimensionType.func_236022_a_(\u26033);
        switch (\u2603) {
            case "flat": {
                JsonObject jsonObject = !string2.isEmpty() ? JSONUtils.func_212745_a(string2) : new JsonObject();
                Dynamic \u26034 = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject);
                return new DimensionGeneratorSettings(\u26033, \u26032, false, DimensionGeneratorSettings.func_236216_a_(simpleRegistry, new FlatChunkGenerator(FlatGenerationSettings.field_236932_a_.parse(\u26034).resultOrPartial(arg_0 -> ((Logger)field_236203_c_).error(arg_0)).orElseGet(FlatGenerationSettings::func_82649_e))));
            }
            case "debug_all_block_states": {
                return new DimensionGeneratorSettings(\u26033, \u26032, false, DimensionGeneratorSettings.func_236216_a_(simpleRegistry, DebugChunkGenerator.field_236065_d_));
            }
            case "amplified": {
                return new DimensionGeneratorSettings(\u26033, \u26032, false, DimensionGeneratorSettings.func_236216_a_(simpleRegistry, new NoiseChunkGenerator(new OverworldBiomeProvider(\u26033, false, false), \u26033, DimensionSettings.Preset.field_236123_c_.func_236137_b_())));
            }
            case "largebiomes": {
                return new DimensionGeneratorSettings(\u26033, \u26032, false, DimensionGeneratorSettings.func_236216_a_(simpleRegistry, new NoiseChunkGenerator(new OverworldBiomeProvider(\u26033, false, true), \u26033, DimensionSettings.Preset.field_236122_b_.func_236137_b_())));
            }
        }
        return new DimensionGeneratorSettings(\u26033, \u26032, false, DimensionGeneratorSettings.func_236216_a_(simpleRegistry, DimensionGeneratorSettings.func_236211_a_(\u26033)));
    }
}

