/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.SwordItem;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BambooLeaves;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class BambooBlock
extends Block
implements IGrowable {
    protected static final VoxelShape field_220261_a = Block.func_208617_a(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    protected static final VoxelShape field_220262_b = Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    protected static final VoxelShape field_220263_c = Block.func_208617_a(6.5, 0.0, 6.5, 9.5, 16.0, 9.5);
    public static final IntegerProperty field_220264_d = BlockStateProperties.field_222512_Y;
    public static final EnumProperty<BambooLeaves> field_220265_e = BlockStateProperties.field_222508_aF;
    public static final IntegerProperty field_220266_f = BlockStateProperties.field_208137_al;

    public BambooBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_220264_d, Integer.valueOf(0)))).func_206870_a((Property)field_220265_e, (Comparable)BambooLeaves.NONE))).func_206870_a((Property)field_220266_f, Integer.valueOf(0))));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_220264_d, field_220265_e, field_220266_f});
    }

    @Override
    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    @Override
    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape voxelshape = state.func_177229_b((Property)field_220265_e) == BambooLeaves.LARGE ? field_220262_b : field_220261_a;
        Vector3d vector3d = state.func_191059_e(worldIn, pos);
        return voxelshape.func_197751_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d vector3d = state.func_191059_e(worldIn, pos);
        return field_220263_c.func_197751_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        if (!fluidstate.func_206888_e()) {
            return null;
        }
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b());
        if (blockstate.func_235714_a_(BlockTags.field_219749_R)) {
            if (blockstate.func_203425_a(Blocks.field_222404_kP)) {
                return (BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_220264_d, Integer.valueOf(0)));
            }
            if (blockstate.func_203425_a(Blocks.field_222405_kQ)) {
                int i = (Integer)blockstate.func_177229_b((Property)field_220264_d) > 0 ? 1 : 0;
                return (BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_220264_d, Integer.valueOf(i)));
            }
            return Blocks.field_222404_kP.func_176223_P();
        }
        return null;
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)((Object)worldIn), pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    @Override
    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)field_220266_f) == 0;
    }

    @Override
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        int i;
        if ((Integer)state.func_177229_b((Property)field_220266_f) == 0 && random.nextInt(3) == 0 && worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9 && (i = this.func_220260_b((IBlockReader)((Object)worldIn), pos) + 1) < 16 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(3) == 0 && worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9 ? 1 : 0) != 0)) {
            this.func_220258_a(state, worldIn, pos, random, i);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_(BlockTags.field_219749_R);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        if (facing == Direction.UP && facingState.func_203425_a(Blocks.field_222405_kQ) && (Integer)facingState.func_177229_b((Property)field_220264_d) > (Integer)stateIn.func_177229_b((Property)field_220264_d)) {
            worldIn.func_180501_a(currentPos, (BlockState)((Object)stateIn.func_235896_a_((Property)field_220264_d)), 2);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        int j;
        int i = this.func_220259_a(worldIn, pos);
        return i + (j = this.func_220260_b(worldIn, pos)) + 1 < 16 && (Integer)worldIn.func_180495_p(pos.func_177981_b(i)).func_177229_b((Property)field_220266_f) != 1;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = this.func_220259_a((IBlockReader)((Object)worldIn), pos);
        int j = this.func_220260_b((IBlockReader)((Object)worldIn), pos);
        int k = i + j + 1;
        int l = 1 + rand.nextInt(2);
        for (int i1 = 0; i1 < l; ++i1) {
            BlockPos blockpos = pos.func_177981_b(i);
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (k >= 16 || (Integer)blockstate.func_177229_b((Property)field_220266_f) == 1 || !worldIn.func_175623_d(blockpos.func_177984_a())) {
                return;
            }
            this.func_220258_a(blockstate, worldIn, blockpos, rand, k);
            ++i;
            ++k;
        }
    }

    @Override
    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return player.func_184614_ca().func_77973_b() instanceof SwordItem ? 1.0f : super.func_180647_a(state, player, worldIn, pos);
    }

    protected void func_220258_a(BlockState blockStateIn, World worldIn, BlockPos posIn, Random rand, int p_220258_5_) {
        BlockState blockstate = worldIn.func_180495_p(posIn.func_177977_b());
        BlockPos blockpos = posIn.func_177979_c(2);
        BlockState blockstate1 = worldIn.func_180495_p(blockpos);
        BambooLeaves bambooleaves = BambooLeaves.NONE;
        if (p_220258_5_ >= 1) {
            if (blockstate.func_203425_a(Blocks.field_222405_kQ) && blockstate.func_177229_b((Property)field_220265_e) != BambooLeaves.NONE) {
                if (blockstate.func_203425_a(Blocks.field_222405_kQ) && blockstate.func_177229_b((Property)field_220265_e) != BambooLeaves.NONE) {
                    bambooleaves = BambooLeaves.LARGE;
                    if (blockstate1.func_203425_a(Blocks.field_222405_kQ)) {
                        worldIn.func_180501_a(posIn.func_177977_b(), (BlockState)((Object)blockstate.func_206870_a((Property)field_220265_e, (Comparable)BambooLeaves.SMALL)), 3);
                        worldIn.func_180501_a(blockpos, (BlockState)((Object)blockstate1.func_206870_a((Property)field_220265_e, (Comparable)BambooLeaves.NONE)), 3);
                    }
                }
            } else {
                bambooleaves = BambooLeaves.SMALL;
            }
        }
        int i = (Integer)blockStateIn.func_177229_b((Property)field_220264_d) != 1 && !blockstate1.func_203425_a(Blocks.field_222405_kQ) ? 0 : 1;
        int j = !(p_220258_5_ >= 11 && rand.nextFloat() < 0.25f || p_220258_5_ == 15) ? 0 : 1;
        worldIn.func_180501_a(posIn.func_177984_a(), (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_220264_d, Integer.valueOf(i)))).func_206870_a((Property)field_220265_e, (Comparable)bambooleaves))).func_206870_a((Property)field_220266_f, Integer.valueOf(j))), 3);
    }

    protected int func_220259_a(IBlockReader worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && worldIn.func_180495_p(pos.func_177981_b(i + 1)).func_203425_a(Blocks.field_222405_kQ); ++i) {
        }
        return i;
    }

    protected int func_220260_b(IBlockReader worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && worldIn.func_180495_p(pos.func_177979_c(i + 1)).func_203425_a(Blocks.field_222405_kQ); ++i) {
        }
        return i;
    }
}

