/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.datafixers.DataFixer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.client.settings.AttackIndicatorStatus;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.settings.NarratorStatus;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.settings.ToggleableKeyBinding;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.HandSide;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.Difficulty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.ClientModLoader;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GameSettings {
    private static final Logger field_151454_ax = LogManager.getLogger();
    private static final Gson field_151450_ay = new Gson();
    private static final TypeToken<List<String>> field_151449_az = new TypeToken<List<String>>(){};
    private static final Splitter field_230003_aR_ = Splitter.on((char)':').limit(2);
    public double field_74341_c = 0.5;
    public int field_151451_c = -1;
    public float field_238329_c_ = 1.0f;
    public int field_74350_i = 120;
    public CloudOption field_74345_l = CloudOption.FANCY;
    public GraphicsFanciness field_238330_f_ = GraphicsFanciness.FANCY;
    public AmbientOcclusionStatus field_74348_k = AmbientOcclusionStatus.MAX;
    public List<String> field_151453_l = Lists.newArrayList();
    public List<String> field_183018_l = Lists.newArrayList();
    public ChatVisibility field_74343_n = ChatVisibility.FULL;
    public double field_74357_r = 1.0;
    public double field_238331_l_ = 0.0;
    public double field_216845_l = 0.5;
    @Nullable
    public String field_198019_u;
    public boolean field_80005_w;
    public boolean field_82882_x;
    public boolean field_82881_y = true;
    private final Set<PlayerModelPart> field_178882_aU = Sets.newHashSet((Object[])PlayerModelPart.values());
    public HandSide field_186715_A = HandSide.RIGHT;
    public int field_92118_B;
    public int field_92119_C;
    public boolean field_92117_D = true;
    public double field_96691_E = 1.0;
    public double field_96692_F = 1.0;
    public double field_96693_G = 0.44366195797920227;
    public double field_96694_H = 1.0;
    public double field_238332_z_ = 0.0;
    public int field_151442_I = 4;
    private final Map<SoundCategory, Float> field_186714_aM = Maps.newEnumMap(SoundCategory.class);
    public boolean field_181150_U = true;
    public AttackIndicatorStatus field_186716_M = AttackIndicatorStatus.CROSSHAIR;
    public TutorialSteps field_193631_S = TutorialSteps.MOVEMENT;
    public int field_205217_U = 2;
    public double field_208033_V = 1.0;
    public boolean field_225307_E = true;
    public int field_209231_W = 1;
    public boolean field_189989_R = true;
    public boolean field_198018_T = true;
    public boolean field_74344_o = true;
    public boolean field_74359_p = true;
    public boolean field_74358_q = true;
    public boolean field_74352_v = true;
    public boolean field_181151_V = true;
    public boolean field_211842_aO;
    public boolean field_74338_d;
    public boolean field_216843_O;
    public boolean field_183509_X = true;
    public boolean field_178879_v;
    public boolean field_74355_t = true;
    public boolean field_186717_N;
    public boolean field_216844_T = true;
    public boolean field_85185_A;
    public boolean field_74353_u;
    public boolean field_74336_f = true;
    public boolean field_228044_Y_;
    public boolean field_228045_Z_;
    public boolean field_230152_Z_;
    public final KeyBinding field_74351_w = new KeyBinding("key.forward", 87, "key.categories.movement");
    public final KeyBinding field_74370_x = new KeyBinding("key.left", 65, "key.categories.movement");
    public final KeyBinding field_74368_y = new KeyBinding("key.back", 83, "key.categories.movement");
    public final KeyBinding field_74366_z = new KeyBinding("key.right", 68, "key.categories.movement");
    public final KeyBinding field_74314_A = new KeyBinding("key.jump", 32, "key.categories.movement");
    public final KeyBinding field_228046_af_ = new ToggleableKeyBinding("key.sneak", 340, "key.categories.movement", () -> this.field_228044_Y_);
    public final KeyBinding field_151444_V = new ToggleableKeyBinding("key.sprint", 341, "key.categories.movement", () -> this.field_228045_Z_);
    public final KeyBinding field_151445_Q = new KeyBinding("key.inventory", 69, "key.categories.inventory");
    public final KeyBinding field_186718_X = new KeyBinding("key.swapOffhand", 70, "key.categories.inventory");
    public final KeyBinding field_74316_C = new KeyBinding("key.drop", 81, "key.categories.inventory");
    public final KeyBinding field_74313_G = new KeyBinding("key.use", InputMappings.Type.MOUSE, 1, "key.categories.gameplay");
    public final KeyBinding field_74312_F = new KeyBinding("key.attack", InputMappings.Type.MOUSE, 0, "key.categories.gameplay");
    public final KeyBinding field_74322_I = new KeyBinding("key.pickItem", InputMappings.Type.MOUSE, 2, "key.categories.gameplay");
    public final KeyBinding field_74310_D = new KeyBinding("key.chat", 84, "key.categories.multiplayer");
    public final KeyBinding field_74321_H = new KeyBinding("key.playerlist", 258, "key.categories.multiplayer");
    public final KeyBinding field_74323_J = new KeyBinding("key.command", 47, "key.categories.multiplayer");
    public final KeyBinding field_151447_Z = new KeyBinding("key.screenshot", 291, "key.categories.misc");
    public final KeyBinding field_151457_aa = new KeyBinding("key.togglePerspective", 294, "key.categories.misc");
    public final KeyBinding field_151458_ab = new KeyBinding("key.smoothCamera", InputMappings.field_197958_a.func_197937_c(), "key.categories.misc");
    public final KeyBinding field_152395_am = new KeyBinding("key.fullscreen", 300, "key.categories.misc");
    public final KeyBinding field_178883_an = new KeyBinding("key.spectatorOutlines", InputMappings.field_197958_a.func_197937_c(), "key.categories.misc");
    public final KeyBinding field_194146_ao = new KeyBinding("key.advancements", 76, "key.categories.misc");
    public final KeyBinding[] field_151456_ac = new KeyBinding[]{new KeyBinding("key.hotbar.1", 49, "key.categories.inventory"), new KeyBinding("key.hotbar.2", 50, "key.categories.inventory"), new KeyBinding("key.hotbar.3", 51, "key.categories.inventory"), new KeyBinding("key.hotbar.4", 52, "key.categories.inventory"), new KeyBinding("key.hotbar.5", 53, "key.categories.inventory"), new KeyBinding("key.hotbar.6", 54, "key.categories.inventory"), new KeyBinding("key.hotbar.7", 55, "key.categories.inventory"), new KeyBinding("key.hotbar.8", 56, "key.categories.inventory"), new KeyBinding("key.hotbar.9", 57, "key.categories.inventory")};
    public final KeyBinding field_193629_ap = new KeyBinding("key.saveToolbarActivator", 67, "key.categories.creative");
    public final KeyBinding field_193630_aq = new KeyBinding("key.loadToolbarActivator", 88, "key.categories.creative");
    public KeyBinding[] field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])new KeyBinding[]{this.field_74312_F, this.field_74313_G, this.field_74351_w, this.field_74370_x, this.field_74368_y, this.field_74366_z, this.field_74314_A, this.field_228046_af_, this.field_151444_V, this.field_74316_C, this.field_151445_Q, this.field_74310_D, this.field_74321_H, this.field_74322_I, this.field_74323_J, this.field_151447_Z, this.field_151457_aa, this.field_151458_ab, this.field_152395_am, this.field_178883_an, this.field_186718_X, this.field_193629_ap, this.field_193630_aq, this.field_194146_ao}, (Object[])this.field_151456_ac);
    protected Minecraft field_74317_L;
    private final File field_74354_ai;
    public Difficulty field_74318_M = Difficulty.NORMAL;
    public boolean field_74319_N;
    public int field_74320_O;
    public boolean field_74330_P;
    public boolean field_74329_Q;
    public boolean field_181657_aC;
    public String field_74332_R = "";
    public boolean field_74326_T;
    public double field_74334_X = 70.0;
    public double field_74333_Y;
    public int field_74335_Z;
    public ParticleStatus field_74362_aa = ParticleStatus.ALL;
    public NarratorStatus field_192571_R = NarratorStatus.OFF;
    public String field_74363_ab = "en_us";
    public boolean field_241568_aS_;

    public GameSettings(Minecraft mcIn, File mcDataDir) {
        this.setForgeKeybindProperties();
        this.field_74317_L = mcIn;
        this.field_74354_ai = new File(mcDataDir, "options.txt");
        if (mcIn.func_147111_S() && Runtime.getRuntime().maxMemory() >= 1000000000L) {
            AbstractOption.field_216706_m.func_216728_a(32.0f);
        } else {
            AbstractOption.field_216706_m.func_216728_a(16.0f);
        }
        this.field_151451_c = mcIn.func_147111_S() ? 12 : 8;
        this.field_241568_aS_ = Util.func_110647_a() == Util.OS.WINDOWS;
        this.func_74300_a();
    }

    public float func_216840_a(float p_216840_1_) {
        return this.field_216844_T ? p_216840_1_ : (float)this.field_216845_l;
    }

    public int func_216841_b(float p_216841_1_) {
        return (int)(this.func_216840_a(p_216841_1_) * 255.0f) << 24 & 0xFF000000;
    }

    public int func_216839_a(int p_216839_1_) {
        return this.field_216844_T ? p_216839_1_ : (int)(this.field_216845_l * 255.0) << 24 & 0xFF000000;
    }

    public void func_198014_a(KeyBinding keyBindingIn, InputMappings.Input inputIn) {
        keyBindingIn.func_197979_b(inputIn);
        this.func_74303_b();
    }

    public void func_74300_a() {
        try {
            if (!this.field_74354_ai.exists()) {
                return;
            }
            this.field_186714_aM.clear();
            CompoundNBT compoundnbt = new CompoundNBT();
            BufferedReader bufferedreader = Files.newReader((File)this.field_74354_ai, (Charset)Charsets.UTF_8);
            Object object = null;
            try {
                bufferedreader.lines().forEach(p_230004_1_ -> {
                    try {
                        Iterator iterator = field_230003_aR_.split((CharSequence)p_230004_1_).iterator();
                        compoundnbt.func_74778_a((String)iterator.next(), (String)iterator.next());
                    }
                    catch (Exception exception2) {
                        field_151454_ax.warn("Skipping bad option: {}", p_230004_1_);
                    }
                });
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (bufferedreader != null) {
                    if (object != null) {
                        try {
                            bufferedreader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        bufferedreader.close();
                    }
                }
            }
            CompoundNBT compoundnbt1 = this.func_189988_a(compoundnbt);
            if (!compoundnbt1.func_74764_b("graphicsMode") && compoundnbt1.func_74764_b("fancyGraphics")) {
                this.field_238330_f_ = "true".equals(compoundnbt1.func_74779_i("fancyGraphics")) ? GraphicsFanciness.FANCY : GraphicsFanciness.FAST;
            }
            for (String s : compoundnbt1.func_150296_c()) {
                String s1 = compoundnbt1.func_74779_i(s);
                try {
                    if ("autoJump".equals(s)) {
                        AbstractOption.field_216719_z.func_216742_a(this, s1);
                    }
                    if ("autoSuggestions".equals(s)) {
                        AbstractOption.field_216677_A.func_216742_a(this, s1);
                    }
                    if ("chatColors".equals(s)) {
                        AbstractOption.field_216678_B.func_216742_a(this, s1);
                    }
                    if ("chatLinks".equals(s)) {
                        AbstractOption.field_216679_C.func_216742_a(this, s1);
                    }
                    if ("chatLinksPrompt".equals(s)) {
                        AbstractOption.field_216680_D.func_216742_a(this, s1);
                    }
                    if ("enableVsync".equals(s)) {
                        AbstractOption.field_216682_F.func_216742_a(this, s1);
                    }
                    if ("entityShadows".equals(s)) {
                        AbstractOption.field_216683_G.func_216742_a(this, s1);
                    }
                    if ("forceUnicodeFont".equals(s)) {
                        AbstractOption.field_216684_H.func_216742_a(this, s1);
                    }
                    if ("discrete_mouse_scroll".equals(s)) {
                        AbstractOption.field_216681_E.func_216742_a(this, s1);
                    }
                    if ("invertYMouse".equals(s)) {
                        AbstractOption.field_216685_I.func_216742_a(this, s1);
                    }
                    if ("realmsNotifications".equals(s)) {
                        AbstractOption.field_216686_J.func_216742_a(this, s1);
                    }
                    if ("reducedDebugInfo".equals(s)) {
                        AbstractOption.field_216687_K.func_216742_a(this, s1);
                    }
                    if ("showSubtitles".equals(s)) {
                        AbstractOption.field_216688_L.func_216742_a(this, s1);
                    }
                    if ("snooperEnabled".equals(s)) {
                        AbstractOption.field_216689_M.func_216742_a(this, s1);
                    }
                    if ("touchscreen".equals(s)) {
                        AbstractOption.field_216690_N.func_216742_a(this, s1);
                    }
                    if ("fullscreen".equals(s)) {
                        AbstractOption.field_216691_O.func_216742_a(this, s1);
                    }
                    if ("bobView".equals(s)) {
                        AbstractOption.field_216692_P.func_216742_a(this, s1);
                    }
                    if ("toggleCrouch".equals(s)) {
                        this.field_228044_Y_ = "true".equals(s1);
                    }
                    if ("toggleSprint".equals(s)) {
                        this.field_228045_Z_ = "true".equals(s1);
                    }
                    if ("mouseSensitivity".equals(s)) {
                        this.field_74341_c = GameSettings.func_74305_a(s1);
                    }
                    if ("fov".equals(s)) {
                        this.field_74334_X = GameSettings.func_74305_a(s1) * 40.0f + 70.0f;
                    }
                    if ("gamma".equals(s)) {
                        this.field_74333_Y = GameSettings.func_74305_a(s1);
                    }
                    if ("renderDistance".equals(s)) {
                        this.field_151451_c = Integer.parseInt(s1);
                    }
                    if ("entityDistanceScaling".equals(s)) {
                        this.field_238329_c_ = Float.parseFloat(s1);
                    }
                    if ("guiScale".equals(s)) {
                        this.field_74335_Z = Integer.parseInt(s1);
                    }
                    if ("particles".equals(s)) {
                        this.field_74362_aa = ParticleStatus.func_216833_a((int)Integer.parseInt(s1));
                    }
                    if ("maxFps".equals(s)) {
                        this.field_74350_i = Integer.parseInt(s1);
                        if (this.field_74317_L.func_228018_at_() != null) {
                            this.field_74317_L.func_228018_at_().func_216526_a(this.field_74350_i);
                        }
                    }
                    if ("difficulty".equals(s)) {
                        this.field_74318_M = Difficulty.func_151523_a((int)Integer.parseInt(s1));
                    }
                    if ("graphicsMode".equals(s)) {
                        this.field_238330_f_ = GraphicsFanciness.func_238163_a_((int)Integer.parseInt(s1));
                    }
                    if ("tutorialStep".equals(s)) {
                        this.field_193631_S = TutorialSteps.func_193307_a((String)s1);
                    }
                    if ("ao".equals(s)) {
                        this.field_74348_k = "true".equals(s1) ? AmbientOcclusionStatus.MAX : ("false".equals(s1) ? AmbientOcclusionStatus.OFF : AmbientOcclusionStatus.func_216570_a((int)Integer.parseInt(s1)));
                    }
                    if ("renderClouds".equals(s)) {
                        if ("true".equals(s1)) {
                            this.field_74345_l = CloudOption.FANCY;
                        } else if ("false".equals(s1)) {
                            this.field_74345_l = CloudOption.OFF;
                        } else if ("fast".equals(s1)) {
                            this.field_74345_l = CloudOption.FAST;
                        }
                    }
                    if ("attackIndicator".equals(s)) {
                        this.field_186716_M = AttackIndicatorStatus.func_216749_a((int)Integer.parseInt(s1));
                    }
                    if ("resourcePacks".equals(s)) {
                        this.field_151453_l = (List)JSONUtils.func_233012_a_((Gson)field_151450_ay, (String)s1, field_151449_az);
                        if (this.field_151453_l == null) {
                            this.field_151453_l = Lists.newArrayList();
                        }
                    }
                    if ("incompatibleResourcePacks".equals(s)) {
                        this.field_183018_l = (List)JSONUtils.func_233012_a_((Gson)field_151450_ay, (String)s1, field_151449_az);
                        if (this.field_183018_l == null) {
                            this.field_183018_l = Lists.newArrayList();
                        }
                    }
                    if ("lastServer".equals(s)) {
                        this.field_74332_R = s1;
                    }
                    if ("lang".equals(s)) {
                        this.field_74363_ab = s1;
                    }
                    if ("chatVisibility".equals(s)) {
                        this.field_74343_n = ChatVisibility.func_221252_a((int)Integer.parseInt(s1));
                    }
                    if ("chatOpacity".equals(s)) {
                        this.field_74357_r = GameSettings.func_74305_a(s1);
                    }
                    if ("chatLineSpacing".equals(s)) {
                        this.field_238331_l_ = GameSettings.func_74305_a(s1);
                    }
                    if ("textBackgroundOpacity".equals(s)) {
                        this.field_216845_l = GameSettings.func_74305_a(s1);
                    }
                    if ("backgroundForChatOnly".equals(s)) {
                        this.field_216844_T = "true".equals(s1);
                    }
                    if ("fullscreenResolution".equals(s)) {
                        this.field_198019_u = s1;
                    }
                    if ("hideServerAddress".equals(s)) {
                        this.field_80005_w = "true".equals(s1);
                    }
                    if ("advancedItemTooltips".equals(s)) {
                        this.field_82882_x = "true".equals(s1);
                    }
                    if ("pauseOnLostFocus".equals(s)) {
                        this.field_82881_y = "true".equals(s1);
                    }
                    if ("overrideHeight".equals(s)) {
                        this.field_92119_C = Integer.parseInt(s1);
                    }
                    if ("overrideWidth".equals(s)) {
                        this.field_92118_B = Integer.parseInt(s1);
                    }
                    if ("heldItemTooltips".equals(s)) {
                        this.field_92117_D = "true".equals(s1);
                    }
                    if ("chatHeightFocused".equals(s)) {
                        this.field_96694_H = GameSettings.func_74305_a(s1);
                    }
                    if ("chatDelay".equals(s)) {
                        this.field_238332_z_ = GameSettings.func_74305_a(s1);
                    }
                    if ("chatHeightUnfocused".equals(s)) {
                        this.field_96693_G = GameSettings.func_74305_a(s1);
                    }
                    if ("chatScale".equals(s)) {
                        this.field_96691_E = GameSettings.func_74305_a(s1);
                    }
                    if ("chatWidth".equals(s)) {
                        this.field_96692_F = GameSettings.func_74305_a(s1);
                    }
                    if ("mipmapLevels".equals(s)) {
                        this.field_151442_I = Integer.parseInt(s1);
                    }
                    if ("useNativeTransport".equals(s)) {
                        this.field_181150_U = "true".equals(s1);
                    }
                    if ("mainHand".equals(s)) {
                        HandSide handSide = this.field_186715_A = "left".equals(s1) ? HandSide.LEFT : HandSide.RIGHT;
                    }
                    if ("narrator".equals(s)) {
                        this.field_192571_R = NarratorStatus.func_216825_a((int)Integer.parseInt(s1));
                    }
                    if ("biomeBlendRadius".equals(s)) {
                        this.field_205217_U = Integer.parseInt(s1);
                    }
                    if ("mouseWheelSensitivity".equals(s)) {
                        this.field_208033_V = GameSettings.func_74305_a(s1);
                    }
                    if ("rawMouseInput".equals(s)) {
                        this.field_225307_E = "true".equals(s1);
                    }
                    if ("glDebugVerbosity".equals(s)) {
                        this.field_209231_W = Integer.parseInt(s1);
                    }
                    if ("skipMultiplayerWarning".equals(s)) {
                        this.field_230152_Z_ = "true".equals(s1);
                    }
                    if ("syncChunkWrites".equals(s)) {
                        this.field_241568_aS_ = "true".equals(s1);
                    }
                    for (KeyBinding keyBinding : this.field_74324_K) {
                        if (!s.equals("key_" + keyBinding.func_151464_g())) continue;
                        if (s1.indexOf(58) != -1) {
                            String[] pts = s1.split(":");
                            keyBinding.setKeyModifierAndCode(KeyModifier.valueFromString((String)pts[1]), InputMappings.func_197955_a((String)pts[0]));
                            continue;
                        }
                        keyBinding.setKeyModifierAndCode(KeyModifier.NONE, InputMappings.func_197955_a((String)s1));
                    }
                    for (KeyBinding keyBinding : SoundCategory.values()) {
                        if (!s.equals("soundCategory_" + keyBinding.func_187948_a())) continue;
                        this.field_186714_aM.put((SoundCategory)keyBinding, Float.valueOf(GameSettings.func_74305_a(s1)));
                    }
                    for (KeyBinding keyBinding : PlayerModelPart.values()) {
                        if (!s.equals("modelPart_" + keyBinding.func_179329_c())) continue;
                        this.func_178878_a((PlayerModelPart)keyBinding, "true".equals(s1));
                    }
                }
                catch (Exception exception) {
                    field_151454_ax.warn("Skipping bad option: {}:{}", (Object)s, (Object)s1);
                }
            }
            KeyBinding.func_74508_b();
        }
        catch (Exception exception1) {
            field_151454_ax.error("Failed to load options", (Throwable)exception1);
        }
    }

    private CompoundNBT func_189988_a(CompoundNBT nbt) {
        int i = 0;
        try {
            i = Integer.parseInt(nbt.func_74779_i("version"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return NBTUtil.func_210822_a((DataFixer)this.field_74317_L.func_184126_aj(), (DefaultTypeReferences)DefaultTypeReferences.OPTIONS, (CompoundNBT)nbt, (int)i);
    }

    private static float func_74305_a(String p_74305_0_) {
        if ("true".equals(p_74305_0_)) {
            return 1.0f;
        }
        return "false".equals(p_74305_0_) ? 0.0f : Float.parseFloat(p_74305_0_);
    }

    public void func_74303_b() {
        if (ClientModLoader.isLoading()) {
            return;
        }
        try (PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.field_74354_ai), StandardCharsets.UTF_8));){
            printwriter.println("version:" + SharedConstants.func_215069_a().getWorldVersion());
            printwriter.println("autoJump:" + AbstractOption.field_216719_z.func_216741_b(this));
            printwriter.println("autoSuggestions:" + AbstractOption.field_216677_A.func_216741_b(this));
            printwriter.println("chatColors:" + AbstractOption.field_216678_B.func_216741_b(this));
            printwriter.println("chatLinks:" + AbstractOption.field_216679_C.func_216741_b(this));
            printwriter.println("chatLinksPrompt:" + AbstractOption.field_216680_D.func_216741_b(this));
            printwriter.println("enableVsync:" + AbstractOption.field_216682_F.func_216741_b(this));
            printwriter.println("entityShadows:" + AbstractOption.field_216683_G.func_216741_b(this));
            printwriter.println("forceUnicodeFont:" + AbstractOption.field_216684_H.func_216741_b(this));
            printwriter.println("discrete_mouse_scroll:" + AbstractOption.field_216681_E.func_216741_b(this));
            printwriter.println("invertYMouse:" + AbstractOption.field_216685_I.func_216741_b(this));
            printwriter.println("realmsNotifications:" + AbstractOption.field_216686_J.func_216741_b(this));
            printwriter.println("reducedDebugInfo:" + AbstractOption.field_216687_K.func_216741_b(this));
            printwriter.println("snooperEnabled:" + AbstractOption.field_216689_M.func_216741_b(this));
            printwriter.println("showSubtitles:" + AbstractOption.field_216688_L.func_216741_b(this));
            printwriter.println("touchscreen:" + AbstractOption.field_216690_N.func_216741_b(this));
            printwriter.println("fullscreen:" + AbstractOption.field_216691_O.func_216741_b(this));
            printwriter.println("bobView:" + AbstractOption.field_216692_P.func_216741_b(this));
            printwriter.println("toggleCrouch:" + this.field_228044_Y_);
            printwriter.println("toggleSprint:" + this.field_228045_Z_);
            printwriter.println("mouseSensitivity:" + this.field_74341_c);
            printwriter.println("fov:" + (this.field_74334_X - 70.0) / 40.0);
            printwriter.println("gamma:" + this.field_74333_Y);
            printwriter.println("renderDistance:" + this.field_151451_c);
            printwriter.println("entityDistanceScaling:" + this.field_238329_c_);
            printwriter.println("guiScale:" + this.field_74335_Z);
            printwriter.println("particles:" + this.field_74362_aa.func_216832_b());
            printwriter.println("maxFps:" + this.field_74350_i);
            printwriter.println("difficulty:" + this.field_74318_M.func_151525_a());
            printwriter.println("graphicsMode:" + this.field_238330_f_.func_238162_a_());
            printwriter.println("ao:" + this.field_74348_k.func_216572_a());
            printwriter.println("biomeBlendRadius:" + this.field_205217_U);
            switch (this.field_74345_l) {
                case FANCY: {
                    printwriter.println("renderClouds:true");
                    break;
                }
                case FAST: {
                    printwriter.println("renderClouds:fast");
                    break;
                }
                case OFF: {
                    printwriter.println("renderClouds:false");
                }
            }
            printwriter.println("resourcePacks:" + field_151450_ay.toJson(this.field_151453_l));
            printwriter.println("incompatibleResourcePacks:" + field_151450_ay.toJson(this.field_183018_l));
            printwriter.println("lastServer:" + this.field_74332_R);
            printwriter.println("lang:" + this.field_74363_ab);
            printwriter.println("chatVisibility:" + this.field_74343_n.func_221254_a());
            printwriter.println("chatOpacity:" + this.field_74357_r);
            printwriter.println("chatLineSpacing:" + this.field_238331_l_);
            printwriter.println("textBackgroundOpacity:" + this.field_216845_l);
            printwriter.println("backgroundForChatOnly:" + this.field_216844_T);
            if (this.field_74317_L.func_228018_at_().func_198106_d().isPresent()) {
                printwriter.println("fullscreenResolution:" + this.field_74317_L.func_228018_at_().func_198106_d().get().func_198066_g());
            }
            printwriter.println("hideServerAddress:" + this.field_80005_w);
            printwriter.println("advancedItemTooltips:" + this.field_82882_x);
            printwriter.println("pauseOnLostFocus:" + this.field_82881_y);
            printwriter.println("overrideWidth:" + this.field_92118_B);
            printwriter.println("overrideHeight:" + this.field_92119_C);
            printwriter.println("heldItemTooltips:" + this.field_92117_D);
            printwriter.println("chatHeightFocused:" + this.field_96694_H);
            printwriter.println("chatDelay: " + this.field_238332_z_);
            printwriter.println("chatHeightUnfocused:" + this.field_96693_G);
            printwriter.println("chatScale:" + this.field_96691_E);
            printwriter.println("chatWidth:" + this.field_96692_F);
            printwriter.println("mipmapLevels:" + this.field_151442_I);
            printwriter.println("useNativeTransport:" + this.field_181150_U);
            printwriter.println("mainHand:" + (this.field_186715_A == HandSide.LEFT ? "left" : "right"));
            printwriter.println("attackIndicator:" + this.field_186716_M.func_216751_a());
            printwriter.println("narrator:" + this.field_192571_R.func_216827_a());
            printwriter.println("tutorialStep:" + this.field_193631_S.func_193308_a());
            printwriter.println("mouseWheelSensitivity:" + this.field_208033_V);
            printwriter.println("rawMouseInput:" + AbstractOption.field_225302_l.func_216741_b(this));
            printwriter.println("glDebugVerbosity:" + this.field_209231_W);
            printwriter.println("skipMultiplayerWarning:" + this.field_230152_Z_);
            printwriter.println("syncChunkWrites:" + this.field_241568_aS_);
            for (KeyBinding keyBinding : this.field_74324_K) {
                printwriter.println("key_" + keyBinding.func_151464_g() + ":" + keyBinding.func_197982_m() + (keyBinding.getKeyModifier() != KeyModifier.NONE ? ":" + keyBinding.getKeyModifier() : ""));
            }
            for (KeyBinding keyBinding : SoundCategory.values()) {
                printwriter.println("soundCategory_" + keyBinding.func_187948_a() + ":" + this.func_186711_a((SoundCategory)keyBinding));
            }
            for (KeyBinding keyBinding : PlayerModelPart.values()) {
                printwriter.println("modelPart_" + keyBinding.func_179329_c() + ":" + this.field_178882_aU.contains(keyBinding));
            }
        }
        catch (Exception exception) {
            field_151454_ax.error("Failed to save options", (Throwable)exception);
        }
        this.func_82879_c();
    }

    public float func_186711_a(SoundCategory category) {
        return this.field_186714_aM.containsKey(category) ? this.field_186714_aM.get(category).floatValue() : 1.0f;
    }

    public void func_186712_a(SoundCategory category, float volume) {
        this.field_186714_aM.put(category, Float.valueOf(volume));
        this.field_74317_L.func_147118_V().func_184399_a(category, volume);
    }

    public void func_82879_c() {
        if (this.field_74317_L.field_71439_g != null) {
            int i = 0;
            for (PlayerModelPart playermodelpart : this.field_178882_aU) {
                i |= playermodelpart.func_179327_a();
            }
            this.field_74317_L.field_71439_g.field_71174_a.func_147297_a(new CClientSettingsPacket(this.field_74363_ab, this.field_151451_c, this.field_74343_n, this.field_74344_o, i, this.field_186715_A));
        }
    }

    public Set<PlayerModelPart> func_178876_d() {
        return ImmutableSet.copyOf(this.field_178882_aU);
    }

    public void func_178878_a(PlayerModelPart modelPart, boolean enable) {
        if (enable) {
            this.field_178882_aU.add(modelPart);
        } else {
            this.field_178882_aU.remove(modelPart);
        }
        this.func_82879_c();
    }

    public void func_178877_a(PlayerModelPart modelPart) {
        if (this.func_178876_d().contains(modelPart)) {
            this.field_178882_aU.remove(modelPart);
        } else {
            this.field_178882_aU.add(modelPart);
        }
        this.func_82879_c();
    }

    public CloudOption func_216842_e() {
        return this.field_151451_c >= 4 ? this.field_74345_l : CloudOption.OFF;
    }

    public boolean func_181148_f() {
        return this.field_181150_U;
    }

    public void func_198017_a(ResourcePackList<ClientResourcePackInfo> resourcePackListIn) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Iterator<String> iterator = this.field_151453_l.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            ClientResourcePackInfo clientresourcepackinfo = resourcePackListIn.func_198981_a(s);
            if (clientresourcepackinfo == null && !s.startsWith("file/")) {
                clientresourcepackinfo = resourcePackListIn.func_198981_a("file/" + s);
            }
            if (clientresourcepackinfo == null) {
                field_151454_ax.warn("Removed resource pack {} from options because it doesn't seem to exist anymore", (Object)s);
                iterator.remove();
                continue;
            }
            if (!clientresourcepackinfo.func_195791_d().func_198968_a() && !this.field_183018_l.contains(s)) {
                field_151454_ax.warn("Removed resource pack {} from options because it is no longer compatible", (Object)s);
                iterator.remove();
                continue;
            }
            if (clientresourcepackinfo.func_195791_d().func_198968_a() && this.field_183018_l.contains(s)) {
                field_151454_ax.info("Removed resource pack {} from incompatibility list because it's now compatible", (Object)s);
                this.field_183018_l.remove(s);
                continue;
            }
            set.add(clientresourcepackinfo.func_195790_f());
        }
        resourcePackListIn.func_198985_a(set);
    }

    private void setForgeKeybindProperties() {
        KeyConflictContext inGame = KeyConflictContext.IN_GAME;
        this.field_74351_w.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74370_x.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74368_y.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74366_z.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74314_A.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_228046_af_.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_151444_V.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74312_F.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74310_D.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74321_H.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74323_J.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_151457_aa.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_151458_ab.setKeyConflictContext((IKeyConflictContext)inGame);
    }
}

