/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.PlatformDescriptors;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.GameConfiguration;
import net.minecraft.client.GameSettings;
import net.minecraft.client.KeyboardListener;
import net.minecraft.client.MainWindow;
import net.minecraft.client.MinecraftGame;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.client.audio.BackgroundMusicTracks;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.LoadingGui;
import net.minecraft.client.gui.ResourceLoadProgressGui;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.advancements.AdvancementsScreen;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.fonts.FontResourceManager;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.ConfirmBackupScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.DatapackFailureScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.EditWorldScreen;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MemoryErrorScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SleepInMultiplayerScreen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.screen.WorkingScreen;
import net.minecraft.client.gui.screen.WorldLoadProgressScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.login.ClientLoginNetHandler;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GPUWarning;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IWindowEventListener;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.ScreenSize;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VirtualScreen;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.PaintingSpriteUploader;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.LegacyResourcePackWrapper;
import net.minecraft.client.resources.LegacyResourcePackWrapperV4;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.CreativeSettings;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.client.util.IMutableSearchTree;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.SearchTree;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.client.util.SearchTreeReloadable;
import net.minecraft.client.util.Splashes;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SkullItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.profiler.DataPoint;
import net.minecraft.profiler.EmptyProfiler;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.LongTickDetector;
import net.minecraft.profiler.Snooper;
import net.minecraft.profiler.TimeTracker;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Timer;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Dimension;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.listener.ChainedChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.TrackingChunkStatusListener;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.client.ClientHooks;
import net.minecraftforge.fml.client.ClientModLoader;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Minecraft
extends RecursiveEventLoop<Runnable>
implements ISnooperInfo,
IWindowEventListener {
    private static Minecraft field_71432_P;
    private static final Logger field_147123_G;
    public static final boolean field_142025_a;
    public static final ResourceLocation field_211502_b;
    public static final ResourceLocation field_238177_c_;
    public static final ResourceLocation field_71464_q;
    private static final CompletableFuture<Unit> field_223714_G;
    private final File field_130070_K;
    private final PropertyMap field_181038_N;
    public final TextureManager field_71446_o;
    private final DataFixer field_184131_U;
    private final VirtualScreen field_195557_T;
    private final MainWindow field_195558_d;
    private final Timer field_71428_T = new Timer(20.0f, 0L);
    private final Snooper field_71427_U = new Snooper("client", (ISnooperInfo)this, Util.func_211177_b());
    private final RenderTypeBuffers field_228006_P_;
    public final WorldRenderer field_71438_f;
    private final EntityRendererManager field_175616_W;
    private final ItemRenderer field_175621_X;
    private final FirstPersonRenderer field_175620_Y;
    public final ParticleManager field_71452_i;
    private final SearchTreeManager field_193995_ae = new SearchTreeManager();
    private final Session field_71449_j;
    public final FontRenderer field_71466_p;
    public final GameRenderer field_71460_t;
    public final DebugRenderer field_184132_p;
    private final AtomicReference<TrackingChunkStatusListener> field_213277_ad = new AtomicReference();
    public final IngameGui field_71456_v;
    public final GameSettings field_71474_y;
    private final CreativeSettings field_191950_u;
    public final MouseHelper field_71417_B;
    public final KeyboardListener field_195559_v;
    public final File field_71412_D;
    private final String field_110447_Z;
    private final String field_184130_ao;
    private final Proxy field_110453_aa;
    private final SaveFormat field_71469_aa;
    public final FrameTimer field_181542_y = new FrameTimer();
    private final boolean field_147129_ai;
    private final boolean field_71459_aj;
    private final boolean field_238175_ae_;
    private final boolean field_238176_af_;
    private final IReloadableResourceManager field_110451_am;
    private final DownloadingPackFinder field_195554_ax;
    private final ResourcePackList<ClientResourcePackInfo> field_110448_aq;
    private final LanguageManager field_135017_as;
    private final BlockColors field_184127_aH;
    private final ItemColors field_184128_aI;
    private final Framebuffer field_147124_at;
    private final SoundHandler field_147127_av;
    private final MusicTicker field_147126_aw;
    private final FontResourceManager field_211501_aD;
    private final Splashes field_213271_aF;
    private final GPUWarning field_241557_ar_;
    private final MinecraftSessionService field_152355_az;
    private final SkinManager field_152350_aA;
    private final ModelManager field_175617_aL;
    private final BlockRendererDispatcher field_175618_aM;
    private final PaintingSpriteUploader field_213272_aL;
    private final PotionSpriteUploader field_213273_aM;
    private final ToastGui field_193034_aS;
    private final MinecraftGame field_213274_aO = new MinecraftGame(this);
    private final Tutorial field_193035_aW;
    public static byte[] field_71444_a;
    @Nullable
    public PlayerController field_71442_b;
    @Nullable
    public ClientWorld field_71441_e;
    @Nullable
    public ClientPlayerEntity field_71439_g;
    @Nullable
    private IntegratedServer field_71437_Z;
    @Nullable
    private ServerData field_71422_O;
    @Nullable
    private NetworkManager field_71453_ak;
    private boolean field_71455_al;
    @Nullable
    public Entity field_175622_Z;
    @Nullable
    public Entity field_147125_j;
    @Nullable
    public RayTraceResult field_71476_x;
    private int field_71467_ac;
    protected int field_71429_W;
    private boolean field_71445_n;
    private float field_193996_ah;
    private long field_181543_z = Util.func_211178_c();
    private long field_71419_L;
    private int field_71420_M;
    public boolean field_71454_w;
    @Nullable
    public Screen field_71462_r;
    @Nullable
    public LoadingGui field_213279_p;
    private boolean field_181541_X;
    private Thread field_152352_aC;
    private volatile boolean field_71425_J = true;
    @Nullable
    private CrashReport field_71433_S;
    private static int field_71470_ab;
    public String field_71426_K = "";
    public boolean field_228004_B_;
    public boolean field_228005_C_;
    public boolean field_175612_E = true;
    private boolean field_195555_I;
    private final Queue<Runnable> field_213275_aU = Queues.newConcurrentLinkedQueue();
    @Nullable
    private CompletableFuture<Void> field_213276_aV;
    private IProfiler field_71424_I = EmptyProfiler.field_219906_a;
    private int field_238172_aT_;
    private final TimeTracker field_238173_aU_ = new TimeTracker(Util.field_211180_a, () -> this.field_238172_aT_);
    @Nullable
    private IProfileResult field_238174_aV_;
    private String field_71465_an = "root";

    public Minecraft(GameConfiguration gameConfig) {
        super("Client");
        int i;
        String s;
        field_71432_P = this;
        ForgeHooksClient.invalidateLog4jThreadCache();
        this.field_71412_D = gameConfig.field_178744_c.field_178760_a;
        File file1 = gameConfig.field_178744_c.field_178759_c;
        this.field_130070_K = gameConfig.field_178744_c.field_178758_b;
        this.field_110447_Z = gameConfig.field_178741_d.field_178755_b;
        this.field_184130_ao = gameConfig.field_178741_d.field_187053_c;
        this.field_181038_N = gameConfig.field_178745_a.field_181172_c;
        this.field_195554_ax = new DownloadingPackFinder(new File(this.field_71412_D, "server-resource-packs"), gameConfig.field_178744_c.func_187052_a());
        this.field_110448_aq = new ResourcePackList<ClientResourcePackInfo>(Minecraft::func_228011_a_, new IPackFinder[]{this.field_195554_ax, new FolderPackFinder(this.field_130070_K, IPackNameDecorator.field_232625_a_)});
        this.field_110453_aa = gameConfig.field_178745_a.field_178751_c;
        this.field_152355_az = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString()).createMinecraftSessionService();
        this.field_71449_j = gameConfig.field_178745_a.field_178752_a;
        field_147123_G.info("Setting user: {}", (Object)this.field_71449_j.func_111285_a());
        this.field_71459_aj = gameConfig.field_178741_d.field_178756_a;
        this.field_238175_ae_ = !gameConfig.field_178741_d.field_239099_d_;
        this.field_238176_af_ = !gameConfig.field_178741_d.field_239100_e_;
        this.field_147129_ai = Minecraft.func_147122_X();
        this.field_71437_Z = null;
        if (this.field_238175_ae_ && gameConfig.field_178742_e.field_178754_a != null) {
            s = gameConfig.field_178742_e.field_178754_a;
            i = gameConfig.field_178742_e.field_178753_b;
        } else {
            s = null;
            i = 0;
        }
        KeybindTextComponent.func_240696_a_(KeyBinding::func_193626_b);
        this.field_184131_U = DataFixesManager.func_210901_a();
        this.field_193034_aS = new ToastGui(this);
        this.field_193035_aW = new Tutorial(this);
        this.field_152352_aC = Thread.currentThread();
        this.field_71474_y = new GameSettings(this, this.field_71412_D);
        this.field_191950_u = new CreativeSettings(this.field_71412_D, this.field_184131_U);
        field_147123_G.info("Backend library: {}", (Object)RenderSystem.getBackendDescription());
        ScreenSize screensize = this.field_71474_y.field_92119_C > 0 && this.field_71474_y.field_92118_B > 0 ? new ScreenSize(this.field_71474_y.field_92118_B, this.field_71474_y.field_92119_C, gameConfig.field_178743_b.field_216496_c, gameConfig.field_178743_b.field_216497_d, gameConfig.field_178743_b.field_216498_e) : gameConfig.field_178743_b;
        Util.field_211180_a = RenderSystem.initBackendSystem();
        this.field_195557_T = new VirtualScreen(this);
        this.field_195558_d = this.field_195557_T.func_217626_a(screensize, this.field_71474_y.field_198019_u, this.func_230149_ax_());
        this.func_213228_a(true);
        try {
            InputStream inputstream = this.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_16x16.png"));
            InputStream inputstream1 = this.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_32x32.png"));
            this.field_195558_d.func_216529_a(inputstream, inputstream1);
        }
        catch (IOException ioexception) {
            field_147123_G.error("Couldn't set icon", (Throwable)ioexception);
        }
        this.field_195558_d.func_216526_a(this.field_71474_y.field_74350_i);
        this.field_71417_B = new MouseHelper(this);
        this.field_195559_v = new KeyboardListener(this);
        this.field_195559_v.func_197968_a(this.field_195558_d.func_198092_i());
        RenderSystem.initRenderer((int)this.field_71474_y.field_209231_W, (boolean)false);
        this.field_147124_at = new Framebuffer(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), true, field_142025_a);
        this.field_147124_at.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.field_110451_am = new SimpleReloadableResourceManager(ResourcePackType.CLIENT_RESOURCES);
        ClientModLoader.begin((Minecraft)this, this.field_110448_aq, (IReloadableResourceManager)this.field_110451_am, (DownloadingPackFinder)this.field_195554_ax);
        this.field_110448_aq.func_198983_a();
        DatapackCodec.field_234880_a_.addModPacks(ForgeHooks.getModPacks());
        this.field_71474_y.func_198017_a(this.field_110448_aq);
        this.field_135017_as = new LanguageManager(this.field_71474_y.field_74363_ab);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_135017_as);
        this.field_71446_o = new TextureManager((IResourceManager)this.field_110451_am);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_71446_o);
        this.field_152350_aA = new SkinManager(this.field_71446_o, new File(file1, "skins"), this.field_152355_az);
        this.field_71469_aa = new SaveFormat(this.field_71412_D.toPath().resolve("saves"), this.field_71412_D.toPath().resolve("backups"), this.field_184131_U);
        this.field_147127_av = new SoundHandler((IResourceManager)this.field_110451_am, this.field_71474_y);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_147127_av);
        this.field_213271_aF = new Splashes(this.field_71449_j);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_213271_aF);
        this.field_147126_aw = new MusicTicker(this);
        this.field_211501_aD = new FontResourceManager(this.field_71446_o);
        this.field_71466_p = this.field_211501_aD.func_238548_a_();
        this.field_110451_am.func_219534_a(this.field_211501_aD.func_216884_a());
        this.func_238209_b_(this.func_211821_e());
        this.field_110451_am.func_219534_a((IFutureReloadListener)new GrassColorReloadListener());
        this.field_110451_am.func_219534_a((IFutureReloadListener)new FoliageColorReloadListener());
        this.field_195558_d.func_227799_a_("Startup");
        RenderSystem.setupDefaultState((int)0, (int)0, (int)this.field_195558_d.func_198109_k(), (int)this.field_195558_d.func_198091_l());
        this.field_195558_d.func_227799_a_("Post startup");
        this.field_184127_aH = BlockColors.func_186723_a();
        this.field_184128_aI = ItemColors.func_186729_a(this.field_184127_aH);
        this.field_175617_aL = new ModelManager(this.field_71446_o, this.field_184127_aH, this.field_71474_y.field_151442_I);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_175617_aL);
        this.field_175621_X = new ItemRenderer(this.field_71446_o, this.field_175617_aL, this.field_184128_aI);
        this.field_175616_W = new EntityRendererManager(this.field_71446_o, this.field_175621_X, this.field_110451_am, this.field_71466_p, this.field_71474_y);
        this.field_175620_Y = new FirstPersonRenderer(this);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_175621_X);
        this.field_228006_P_ = new RenderTypeBuffers();
        this.field_71460_t = new GameRenderer(this, (IResourceManager)this.field_110451_am, this.field_228006_P_);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_71460_t);
        this.field_175618_aM = new BlockRendererDispatcher(this.field_175617_aL.func_174954_c(), this.field_184127_aH);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_175618_aM);
        this.field_71438_f = new WorldRenderer(this, this.field_228006_P_);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_71438_f);
        this.func_193986_ar();
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_193995_ae);
        this.field_71452_i = new ParticleManager(this.field_71441_e, this.field_71446_o);
        ModLoader.get().postEvent((Event)new ParticleFactoryRegisterEvent());
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_71452_i);
        this.field_213272_aL = new PaintingSpriteUploader(this.field_71446_o);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_213272_aL);
        this.field_213273_aM = new PotionSpriteUploader(this.field_71446_o);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_213273_aM);
        this.field_241557_ar_ = new GPUWarning();
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_241557_ar_);
        this.field_71456_v = new ForgeIngameGui(this);
        this.field_71417_B.func_198029_a(this.field_195558_d.func_198092_i());
        this.field_184132_p = new DebugRenderer(this);
        RenderSystem.setErrorCallback(this::func_195545_a);
        if (this.field_71474_y.field_74353_u && !this.field_195558_d.func_198113_j()) {
            this.field_195558_d.func_198077_g();
            this.field_71474_y.field_74353_u = this.field_195558_d.func_198113_j();
        }
        this.field_195558_d.func_216523_b(this.field_71474_y.field_74352_v);
        this.field_195558_d.func_224798_d(this.field_71474_y.field_225307_E);
        this.field_195558_d.func_227801_c_();
        this.func_213226_a();
        ResourceLoadProgressGui.func_212970_a(this);
        List<IResourcePack> list = this.field_110448_aq.func_232623_f_();
        this.func_213268_a(new ResourceLoadProgressGui(this, this.field_110451_am.func_219537_a(Util.func_215072_e(), (Executor)((Object)this), field_223714_G, list), p_238197_1_ -> Util.func_215077_a((Optional)p_238197_1_, this::func_229988_a_, () -> {
            if (SharedConstants.field_206244_b) {
                this.func_213256_aB();
            }
            if (ClientModLoader.completeModLoading()) {
                return;
            }
            if (s != null) {
                this.func_147108_a((Screen)new ConnectingScreen((Screen)new MainMenuScreen(), this, s, i));
            } else {
                this.func_147108_a(new MainMenuScreen(true));
            }
        }), false));
    }

    public void func_230150_b_() {
        this.field_195558_d.func_230148_b_(this.func_230149_ax_());
    }

    private String func_230149_ax_() {
        StringBuilder stringbuilder = new StringBuilder("Minecraft");
        if (this.func_230151_c_()) {
            stringbuilder.append("*");
        }
        stringbuilder.append(" ");
        stringbuilder.append(SharedConstants.func_215069_a().getName());
        ClientPlayNetHandler clientplaynethandler = this.func_147114_u();
        if (clientplaynethandler != null && clientplaynethandler.func_147298_b().func_150724_d()) {
            stringbuilder.append(" - ");
            if (this.field_71437_Z != null && !this.field_71437_Z.func_71344_c()) {
                stringbuilder.append(I18n.func_135052_a("title.singleplayer", new Object[0]));
            } else if (this.func_181540_al()) {
                stringbuilder.append(I18n.func_135052_a("title.multiplayer.realms", new Object[0]));
            } else if (!(this.field_71437_Z != null || this.field_71422_O != null && this.field_71422_O.func_181041_d())) {
                stringbuilder.append(I18n.func_135052_a("title.multiplayer.other", new Object[0]));
            } else {
                stringbuilder.append(I18n.func_135052_a("title.multiplayer.lan", new Object[0]));
            }
        }
        return stringbuilder.toString();
    }

    public boolean func_230151_c_() {
        return !"vanilla".equals(ClientBrandRetriever.getClientModName()) || Minecraft.class.getSigners() == null;
    }

    private void func_229988_a_(Throwable throwableIn) {
        if (this.field_110448_aq.func_198980_d().stream().anyMatch(e -> !e.func_195797_g())) {
            StringTextComponent itextcomponent = throwableIn instanceof SimpleReloadableResourceManager.FailedPackException ? new StringTextComponent(((SimpleReloadableResourceManager.FailedPackException)throwableIn).func_241203_a().func_195762_a()) : null;
            field_147123_G.info("Caught error loading resourcepacks, removing all selected resourcepacks", throwableIn);
            this.field_110448_aq.func_198985_a(Collections.emptyList());
            this.field_71474_y.field_151453_l.clear();
            this.field_71474_y.field_183018_l.clear();
            this.field_71474_y.func_74303_b();
            this.func_213237_g().thenRun(() -> this.lambda$restoreResourcePacks$4((ITextComponent)itextcomponent));
        } else {
            Util.func_229756_b_((Throwable)throwableIn);
        }
    }

    public void func_99999_d() {
        this.field_152352_aC = Thread.currentThread();
        try {
            boolean flag = false;
            while (this.field_71425_J) {
                if (this.field_71433_S != null) {
                    Minecraft.func_71377_b(this.field_71433_S);
                    return;
                }
                try {
                    LongTickDetector longtickdetector = LongTickDetector.func_233524_a_((String)"Renderer");
                    boolean flag1 = this.func_238202_aF_();
                    this.func_238201_a_(flag1, longtickdetector);
                    this.field_71424_I.func_219894_a();
                    this.func_195542_b(!flag);
                    this.field_71424_I.func_219897_b();
                    this.func_238210_b_(flag1, longtickdetector);
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    if (flag) {
                        throw outofmemoryerror;
                    }
                    this.func_71398_f();
                    this.func_147108_a((Screen)new MemoryErrorScreen());
                    System.gc();
                    field_147123_G.fatal("Out of memory", (Throwable)outofmemoryerror);
                    flag = true;
                }
            }
        }
        catch (ReportedException reportedexception) {
            this.func_71396_d(reportedexception.func_71575_a());
            this.func_71398_f();
            field_147123_G.fatal("Reported exception thrown!", (Throwable)reportedexception);
            Minecraft.func_71377_b(reportedexception.func_71575_a());
        }
        catch (Throwable throwable) {
            CrashReport crashreport = this.func_71396_d(new CrashReport("Unexpected error", throwable));
            field_147123_G.fatal("Unreported exception thrown!", throwable);
            this.func_71398_f();
            Minecraft.func_71377_b(crashreport);
        }
    }

    void func_238209_b_(boolean p_238209_1_) {
        this.field_211501_aD.func_238551_a_((Map)(p_238209_1_ ? ImmutableMap.of((Object)field_211502_b, (Object)field_238177_c_) : ImmutableMap.of()));
    }

    public void func_193986_ar() {
        SearchTree searchtree = new SearchTree(p_213242_0_ -> p_213242_0_.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL).stream().map(p_213230_0_ -> TextFormatting.func_110646_a((String)p_213230_0_.getString()).trim()).filter(p_213267_0_ -> !p_213267_0_.isEmpty()), p_213251_0_ -> Stream.of(Registry.field_212630_s.func_177774_c((Object)p_213251_0_.func_77973_b())));
        SearchTreeReloadable searchtreereloadable = new SearchTreeReloadable(p_213235_0_ -> p_213235_0_.func_77973_b().getTags().stream());
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (Item item : Registry.field_212630_s) {
            item.func_150895_a(ItemGroup.field_78027_g, (NonNullList<ItemStack>)nonnulllist);
        }
        nonnulllist.forEach(p_213232_2_ -> {
            searchtree.func_217872_a((Object)p_213232_2_);
            searchtreereloadable.func_217872_a((Object)p_213232_2_);
        });
        SearchTree searchtree1 = new SearchTree(p_213252_0_ -> p_213252_0_.func_192711_b().stream().flatMap(p_213234_0_ -> p_213234_0_.func_77571_b().func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL).stream()).map(p_213264_0_ -> TextFormatting.func_110646_a((String)p_213264_0_.getString()).trim()).filter(p_213238_0_ -> !p_213238_0_.isEmpty()), p_213258_0_ -> p_213258_0_.func_192711_b().stream().map(p_213244_0_ -> Registry.field_212630_s.func_177774_c((Object)p_213244_0_.func_77571_b().func_77973_b())));
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_215359_a, searchtree);
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_215360_b, searchtreereloadable);
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_194012_b, searchtree1);
    }

    private void func_195545_a(int error, long description) {
        this.field_71474_y.field_74352_v = false;
        this.field_71474_y.func_74303_b();
    }

    private static boolean func_147122_X() {
        String[] astring;
        for (String s : astring = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String s1 = System.getProperty(s);
            if (s1 == null || !s1.contains("64")) continue;
            return true;
        }
        return false;
    }

    public Framebuffer func_147110_a() {
        return this.field_147124_at;
    }

    public String func_175600_c() {
        return this.field_110447_Z;
    }

    public String func_184123_d() {
        return this.field_184130_ao;
    }

    public void func_71404_a(CrashReport crash) {
        this.field_71433_S = crash;
    }

    public static void func_71377_b(CrashReport report) {
        File file1 = new File(Minecraft.func_71410_x().field_71412_D, "crash-reports");
        File file2 = new File(file1, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        Bootstrap.func_179870_a(report.func_71502_e());
        if (report.func_71497_f() != null) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + report.func_71497_f());
            ServerLifecycleHooks.handleExit((int)-1);
        } else if (report.func_147149_a(file2)) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + file2.getAbsolutePath());
            ServerLifecycleHooks.handleExit((int)-1);
        } else {
            Bootstrap.func_179870_a("#@?@# Game crashed! Crash report could not be saved. #@?@#");
            ServerLifecycleHooks.handleExit((int)-2);
        }
    }

    public boolean func_211821_e() {
        return this.field_71474_y.field_211842_aO;
    }

    @Deprecated
    public CompletableFuture<Void> func_213237_g() {
        if (this.field_213276_aV != null) {
            return this.field_213276_aV;
        }
        CompletableFuture<Void> completablefuture = new CompletableFuture<Void>();
        if (this.field_213279_p instanceof ResourceLoadProgressGui) {
            this.field_213276_aV = completablefuture;
            return completablefuture;
        }
        this.field_110448_aq.func_198983_a();
        List<IResourcePack> list = this.field_110448_aq.func_232623_f_();
        this.func_213268_a(new ResourceLoadProgressGui(this, this.field_110451_am.func_219537_a(Util.func_215072_e(), (Executor)((Object)this), field_223714_G, list), p_238200_2_ -> Util.func_215077_a((Optional)p_238200_2_, this::func_229988_a_, () -> {
            this.field_71438_f.func_72712_a();
            completablefuture.complete(null);
        }), true));
        return completablefuture;
    }

    private void func_213256_aB() {
        boolean flag = false;
        BlockModelShapes blockmodelshapes = this.func_175602_ab().func_175023_a();
        IBakedModel ibakedmodel = blockmodelshapes.func_178126_b().func_174951_a();
        for (Object block : Registry.field_212618_g) {
            for (BlockState blockstate : ((Block)((Object)block)).func_176194_O().func_177619_a()) {
                IBakedModel ibakedmodel1;
                if (blockstate.func_185901_i() != BlockRenderType.MODEL || (ibakedmodel1 = blockmodelshapes.func_178125_b(blockstate)) != ibakedmodel) continue;
                field_147123_G.debug("Missing model for: {}", (Object)blockstate);
                flag = true;
            }
        }
        TextureAtlasSprite textureatlassprite1 = ibakedmodel.func_177554_e();
        for (Block block1 : Registry.field_212618_g) {
            for (BlockState blockstate1 : block1.func_176194_O().func_177619_a()) {
                TextureAtlasSprite textureatlassprite = blockmodelshapes.func_178122_a(blockstate1);
                if (blockstate1.func_196958_f() || textureatlassprite != textureatlassprite1) continue;
                field_147123_G.debug("Missing particle icon for: {}", (Object)blockstate1);
                flag = true;
            }
        }
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (Item item : Registry.field_212630_s) {
            nonnulllist.clear();
            item.func_150895_a(ItemGroup.field_78027_g, (NonNullList<ItemStack>)nonnulllist);
            for (ItemStack itemstack : nonnulllist) {
                String s = itemstack.func_77977_a();
                String s1 = new TranslationTextComponent(s).getString();
                if (!s1.toLowerCase(Locale.ROOT).equals(item.func_77658_a())) continue;
                field_147123_G.debug("Missing translation for: {} {} {}", (Object)itemstack, (Object)s, (Object)itemstack.func_77973_b());
            }
        }
        if (flag |= ScreenManager.func_216910_a()) {
            throw new IllegalStateException("Your game data is foobar, fix the errors above!");
        }
    }

    public SaveFormat func_71359_d() {
        return this.field_71469_aa;
    }

    private void func_238207_b_(String p_238207_1_) {
        if (!this.func_71387_A() && !this.func_238217_s_()) {
            if (this.field_71439_g != null) {
                this.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("chat.cannotSend").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
        } else {
            this.func_147108_a((Screen)new ChatScreen(p_238207_1_));
        }
    }

    public void func_147108_a(@Nullable Screen guiScreenIn) {
        if (guiScreenIn == null && this.field_71441_e == null) {
            guiScreenIn = new MainMenuScreen();
        } else if (guiScreenIn == null && this.field_71439_g.func_233643_dh_()) {
            if (this.field_71439_g.func_228353_F_()) {
                guiScreenIn = new DeathScreen(null, this.field_71441_e.func_72912_H().func_76093_s());
            } else {
                this.field_71439_g.func_71004_bE();
            }
        }
        Screen old = this.field_71462_r;
        GuiOpenEvent event = new GuiOpenEvent(guiScreenIn);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        guiScreenIn = event.getGui();
        if (old != null && guiScreenIn != old) {
            old.func_231164_f_();
        }
        if (guiScreenIn instanceof MainMenuScreen || guiScreenIn instanceof MultiplayerScreen) {
            this.field_71474_y.field_74330_P = false;
            this.field_71456_v.func_146158_b().func_146231_a(true);
        }
        this.field_71462_r = guiScreenIn;
        if (guiScreenIn != null) {
            this.field_71417_B.func_198032_j();
            KeyBinding.func_74506_a();
            guiScreenIn.func_231158_b_(this, this.field_195558_d.func_198107_o(), this.field_195558_d.func_198087_p());
            this.field_71454_w = false;
            NarratorChatListener.field_193643_a.func_216864_a(guiScreenIn.func_231167_h_());
        } else {
            this.field_147127_av.func_147687_e();
            this.field_71417_B.func_198034_i();
        }
        this.func_230150_b_();
    }

    public void func_213268_a(@Nullable LoadingGui loadingGuiIn) {
        this.field_213279_p = loadingGuiIn;
    }

    public void func_71405_e() {
        try {
            field_147123_G.info("Stopping!");
            try {
                NarratorChatListener.field_193643_a.func_216867_c();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.field_71441_e != null) {
                    this.field_71441_e.func_72882_A();
                }
                this.func_213254_o();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.field_71462_r != null) {
                this.field_71462_r.func_231164_f_();
            }
            this.close();
        }
        finally {
            Util.field_211180_a = System::nanoTime;
            if (this.field_71433_S == null) {
                System.exit(0);
            }
        }
    }

    public void close() {
        try {
            this.field_175617_aL.close();
            this.field_211501_aD.close();
            this.field_71460_t.close();
            this.field_71438_f.close();
            this.field_147127_av.func_147685_d();
            this.field_110448_aq.close();
            this.field_71452_i.func_215232_a();
            this.field_213273_aM.close();
            this.field_213272_aL.close();
            this.field_71446_o.close();
            this.field_110451_am.close();
            Util.func_240993_h_();
        }
        catch (Throwable throwable) {
            field_147123_G.error("Shutdown failure!", throwable);
            throw throwable;
        }
        finally {
            this.field_195557_T.close();
            this.field_195558_d.close();
        }
    }

    private void func_195542_b(boolean renderWorldIn) {
        boolean flag;
        Runnable runnable;
        this.field_195558_d.func_227799_a_("Pre render");
        long i = Util.func_211178_c();
        if (this.field_195558_d.func_227800_b_()) {
            this.func_71400_g();
        }
        if (this.field_213276_aV != null && !(this.field_213279_p instanceof ResourceLoadProgressGui)) {
            CompletableFuture<Void> completablefuture = this.field_213276_aV;
            this.field_213276_aV = null;
            this.func_213237_g().thenRun(() -> completablefuture.complete(null));
        }
        while ((runnable = this.field_213275_aU.poll()) != null) {
            runnable.run();
        }
        if (renderWorldIn) {
            int j = this.field_71428_T.func_238400_a_(Util.func_211177_b());
            this.field_71424_I.func_76320_a("scheduledExecutables");
            this.func_213160_bf();
            this.field_71424_I.func_76319_b();
            this.field_71424_I.func_76320_a("tick");
            for (int k = 0; k < Math.min(10, j); ++k) {
                this.field_71424_I.func_230035_c_("clientTick");
                this.func_71407_l();
            }
            this.field_71424_I.func_76319_b();
        }
        this.field_71417_B.func_198028_a();
        this.field_195558_d.func_227799_a_("Render");
        this.field_71424_I.func_76320_a("sound");
        this.field_147127_av.func_215289_a(this.field_71460_t.func_215316_n());
        this.field_71424_I.func_76319_b();
        this.field_71424_I.func_76320_a("render");
        RenderSystem.pushMatrix();
        RenderSystem.clear((int)16640, (boolean)field_142025_a);
        this.field_147124_at.func_147610_a(true);
        FogRenderer.func_228370_a_();
        this.field_71424_I.func_76320_a("display");
        RenderSystem.enableTexture();
        RenderSystem.enableCull();
        this.field_71424_I.func_76319_b();
        if (!this.field_71454_w) {
            BasicEventHooks.onRenderTickStart((float)(this.field_71445_n ? this.field_193996_ah : this.field_71428_T.field_194147_b));
            this.field_71424_I.func_219895_b("gameRenderer");
            this.field_71460_t.func_195458_a(this.field_71445_n ? this.field_193996_ah : this.field_71428_T.field_194147_b, i, renderWorldIn);
            this.field_71424_I.func_219895_b("toasts");
            this.field_193034_aS.func_238541_a_(new MatrixStack());
            this.field_71424_I.func_76319_b();
            BasicEventHooks.onRenderTickEnd((float)(this.field_71445_n ? this.field_193996_ah : this.field_71428_T.field_194147_b));
        }
        if (this.field_238174_aV_ != null) {
            this.field_71424_I.func_76320_a("fpsPie");
            this.func_238183_a_(new MatrixStack(), this.field_238174_aV_);
            this.field_71424_I.func_76319_b();
        }
        this.field_71424_I.func_76320_a("blit");
        this.field_147124_at.func_147609_e();
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        this.field_147124_at.func_147615_c(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        RenderSystem.popMatrix();
        this.field_71424_I.func_219895_b("updateDisplay");
        this.field_195558_d.func_227802_e_();
        int i1 = this.func_213243_aC();
        if ((double)i1 < AbstractOption.field_216701_h.func_216733_c()) {
            RenderSystem.limitDisplayFPS((int)i1);
        }
        this.field_71424_I.func_219895_b("yield");
        Thread.yield();
        this.field_71424_I.func_76319_b();
        this.field_195558_d.func_227799_a_("Post render");
        ++this.field_71420_M;
        boolean bl = flag = this.func_71356_B() && (this.field_71462_r != null && this.field_71462_r.func_231177_au__() || this.field_213279_p != null && this.field_213279_p.func_212969_a()) && !this.field_71437_Z.func_71344_c();
        if (this.field_71445_n != flag) {
            if (this.field_71445_n) {
                this.field_193996_ah = this.field_71428_T.field_194147_b;
            } else {
                this.field_71428_T.field_194147_b = this.field_193996_ah;
            }
            this.field_71445_n = flag;
        }
        long l = Util.func_211178_c();
        this.field_181542_y.func_181747_a(l - this.field_181543_z);
        this.field_181543_z = l;
        this.field_71424_I.func_76320_a("fpsUpdate");
        while (Util.func_211177_b() >= this.field_71419_L + 1000L) {
            field_71470_ab = this.field_71420_M;
            this.field_71426_K = String.format("%d fps T: %s%s%s%s B: %d", field_71470_ab, (double)this.field_71474_y.field_74350_i == AbstractOption.field_216701_h.func_216733_c() ? "inf" : Integer.valueOf(this.field_71474_y.field_74350_i), this.field_71474_y.field_74352_v ? " vsync" : "", this.field_71474_y.field_238330_f_.toString(), this.field_71474_y.field_74345_l == CloudOption.OFF ? "" : (this.field_71474_y.field_74345_l == CloudOption.FAST ? " fast-clouds" : " fancy-clouds"), this.field_71474_y.field_205217_U);
            this.field_71419_L += 1000L;
            this.field_71420_M = 0;
            this.field_71427_U.func_76471_b();
            if (this.field_71427_U.func_76468_d()) continue;
            this.field_71427_U.func_76463_a();
        }
        this.field_71424_I.func_76319_b();
    }

    private boolean func_238202_aF_() {
        return this.field_71474_y.field_74330_P && this.field_71474_y.field_74329_Q && !this.field_71474_y.field_74319_N;
    }

    private void func_238201_a_(boolean p_238201_1_, @Nullable LongTickDetector p_238201_2_) {
        if (p_238201_1_) {
            if (!this.field_238173_aU_.func_233505_a_()) {
                this.field_238172_aT_ = 0;
                this.field_238173_aU_.func_233507_c_();
            }
            ++this.field_238172_aT_;
        } else {
            this.field_238173_aU_.func_233506_b_();
        }
        this.field_71424_I = LongTickDetector.func_233523_a_((IProfiler)this.field_238173_aU_.func_233508_d_(), (LongTickDetector)p_238201_2_);
    }

    private void func_238210_b_(boolean p_238210_1_, @Nullable LongTickDetector p_238210_2_) {
        if (p_238210_2_ != null) {
            p_238210_2_.func_233525_b_();
        }
        this.field_238174_aV_ = p_238210_1_ ? this.field_238173_aU_.func_233509_e_() : null;
        this.field_71424_I = this.field_238173_aU_.func_233508_d_();
    }

    public void func_213226_a() {
        int i = this.field_195558_d.func_216521_a(this.field_71474_y.field_74335_Z, this.func_211821_e());
        this.field_195558_d.func_216525_a(i);
        if (this.field_71462_r != null) {
            this.field_71462_r.func_231152_a_(this, this.field_195558_d.func_198107_o(), this.field_195558_d.func_198087_p());
        }
        Framebuffer framebuffer = this.func_147110_a();
        framebuffer.func_216491_a(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), field_142025_a);
        if (this.field_71460_t != null) {
            this.field_71460_t.func_147704_a(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        }
        this.field_71417_B.func_198021_g();
    }

    public void func_241216_b_() {
        this.field_71417_B.func_241563_k_();
    }

    private int func_213243_aC() {
        return this.field_71441_e != null || this.field_71462_r == null && this.field_213279_p == null ? this.field_195558_d.func_198082_x() : 60;
    }

    public void func_71398_f() {
        try {
            field_71444_a = new byte[0];
            this.field_71438_f.func_72728_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            if (this.field_71455_al && this.field_71437_Z != null) {
                this.field_71437_Z.func_71263_m(true);
            }
            this.func_213231_b((Screen)new DirtMessageScreen((ITextComponent)new TranslationTextComponent("menu.savingLevel")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    void func_71383_b(int keyCount) {
        List list;
        if (this.field_238174_aV_ != null && !(list = this.field_238174_aV_.func_219917_a(this.field_71465_an)).isEmpty()) {
            DataPoint datapoint = (DataPoint)list.remove(0);
            if (keyCount == 0) {
                int i;
                if (!datapoint.field_219945_c.isEmpty() && (i = this.field_71465_an.lastIndexOf(30)) >= 0) {
                    this.field_71465_an = this.field_71465_an.substring(0, i);
                }
            } else if (--keyCount < list.size() && !"unspecified".equals(((DataPoint)list.get((int)keyCount)).field_219945_c)) {
                if (!this.field_71465_an.isEmpty()) {
                    this.field_71465_an = this.field_71465_an + '\u001e';
                }
                this.field_71465_an = this.field_71465_an + ((DataPoint)list.get((int)keyCount)).field_219945_c;
            }
        }
    }

    private void func_238183_a_(MatrixStack p_238183_1_, IProfileResult p_238183_2_) {
        List list = p_238183_2_.func_219917_a(this.field_71465_an);
        DataPoint datapoint = (DataPoint)list.remove(0);
        RenderSystem.clear((int)256, (boolean)field_142025_a);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)this.field_195558_d.func_198109_k(), (double)this.field_195558_d.func_198091_l(), (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        int i = 160;
        int j = this.field_195558_d.func_198109_k() - 160 - 10;
        int k = this.field_195558_d.func_198091_l() - 320;
        RenderSystem.enableBlend();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((float)j - 176.0f, (float)k - 96.0f - 16.0f, 0.0).func_225586_a_(200, 0, 0, 0).func_181675_d();
        bufferbuilder.func_225582_a_((float)j - 176.0f, k + 320, 0.0).func_225586_a_(200, 0, 0, 0).func_181675_d();
        bufferbuilder.func_225582_a_((float)j + 176.0f, k + 320, 0.0).func_225586_a_(200, 0, 0, 0).func_181675_d();
        bufferbuilder.func_225582_a_((float)j + 176.0f, (float)k - 96.0f - 16.0f, 0.0).func_225586_a_(200, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
        double d0 = 0.0;
        for (DataPoint datapoint1 : list) {
            int l = MathHelper.func_76128_c((double)(datapoint1.field_219943_a / 4.0)) + 1;
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            int i1 = datapoint1.func_219942_a();
            int j1 = i1 >> 16 & 0xFF;
            int k1 = i1 >> 8 & 0xFF;
            int l1 = i1 & 0xFF;
            bufferbuilder.func_225582_a_(j, k, 0.0).func_225586_a_(j1, k1, l1, 255).func_181675_d();
            for (int i2 = l; i2 >= 0; --i2) {
                float f = (float)((d0 + datapoint1.field_219943_a * (double)i2 / (double)l) * 6.2831854820251465 / 100.0);
                float f1 = MathHelper.func_76126_a((float)f) * 160.0f;
                float f2 = MathHelper.func_76134_b((float)f) * 160.0f * 0.5f;
                bufferbuilder.func_225582_a_((float)j + f1, (float)k - f2, 0.0).func_225586_a_(j1, k1, l1, 255).func_181675_d();
            }
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (int l2 = l; l2 >= 0; --l2) {
                float f3 = (float)((d0 + datapoint1.field_219943_a * (double)l2 / (double)l) * 6.2831854820251465 / 100.0);
                float f4 = MathHelper.func_76126_a((float)f3) * 160.0f;
                float f5 = MathHelper.func_76134_b((float)f3) * 160.0f * 0.5f;
                if (f5 > 0.0f) continue;
                bufferbuilder.func_225582_a_((float)j + f4, (float)k - f5, 0.0).func_225586_a_(j1 >> 1, k1 >> 1, l1 >> 1, 255).func_181675_d();
                bufferbuilder.func_225582_a_((float)j + f4, (float)k - f5 + 10.0f, 0.0).func_225586_a_(j1 >> 1, k1 >> 1, l1 >> 1, 255).func_181675_d();
            }
            tessellator.func_78381_a();
            d0 += datapoint1.field_219943_a;
        }
        DecimalFormat decimalformat = new DecimalFormat("##0.00");
        decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        RenderSystem.enableTexture();
        String s = IProfileResult.func_225434_b((String)datapoint.field_219945_c);
        String s1 = "";
        if (!"unspecified".equals(s)) {
            s1 = s1 + "[0] ";
        }
        s1 = s.isEmpty() ? s1 + "ROOT " : s1 + s + ' ';
        int k2 = 0xFFFFFF;
        this.field_71466_p.func_238405_a_(p_238183_1_, s1, (float)(j - 160), (float)(k - 80 - 16), 0xFFFFFF);
        s1 = decimalformat.format(datapoint.field_219944_b) + "%";
        this.field_71466_p.func_238405_a_(p_238183_1_, s1, (float)(j + 160 - this.field_71466_p.func_78256_a(s1)), (float)(k - 80 - 16), 0xFFFFFF);
        for (int j2 = 0; j2 < list.size(); ++j2) {
            DataPoint datapoint2 = (DataPoint)list.get(j2);
            StringBuilder stringbuilder = new StringBuilder();
            if ("unspecified".equals(datapoint2.field_219945_c)) {
                stringbuilder.append("[?] ");
            } else {
                stringbuilder.append("[").append(j2 + 1).append("] ");
            }
            String s2 = stringbuilder.append(datapoint2.field_219945_c).toString();
            this.field_71466_p.func_238405_a_(p_238183_1_, s2, (float)(j - 160), (float)(k + 80 + j2 * 8 + 20), datapoint2.func_219942_a());
            s2 = decimalformat.format(datapoint2.field_219943_a) + "%";
            this.field_71466_p.func_238405_a_(p_238183_1_, s2, (float)(j + 160 - 50 - this.field_71466_p.func_78256_a(s2)), (float)(k + 80 + j2 * 8 + 20), datapoint2.func_219942_a());
            s2 = decimalformat.format(datapoint2.field_219944_b) + "%";
            this.field_71466_p.func_238405_a_(p_238183_1_, s2, (float)(j + 160 - this.field_71466_p.func_78256_a(s2)), (float)(k + 80 + j2 * 8 + 20), datapoint2.func_219942_a());
        }
    }

    public void func_71400_g() {
        this.field_71425_J = false;
    }

    public boolean func_228025_l_() {
        return this.field_71425_J;
    }

    public void func_71385_j(boolean pauseOnly) {
        if (this.field_71462_r == null) {
            boolean flag;
            boolean bl = flag = this.func_71356_B() && !this.field_71437_Z.func_71344_c();
            if (flag) {
                this.func_147108_a((Screen)new IngameMenuScreen(!pauseOnly));
                this.field_147127_av.func_147689_b();
            } else {
                this.func_147108_a((Screen)new IngameMenuScreen(true));
            }
        }
    }

    private void func_147115_a(boolean leftClick) {
        if (!leftClick) {
            this.field_71429_W = 0;
        }
        if (this.field_71429_W <= 0 && !this.field_71439_g.func_184587_cr()) {
            if (leftClick && this.field_71476_x != null && this.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)this.field_71476_x;
                BlockPos blockpos = blockraytraceresult.func_216350_a();
                if (!this.field_71441_e.func_175623_d(blockpos)) {
                    InputEvent.ClickInputEvent inputEvent = ForgeHooksClient.onClickInput((int)0, (KeyBinding)this.field_71474_y.field_74312_F, (Hand)Hand.MAIN_HAND);
                    if (inputEvent.isCanceled()) {
                        if (inputEvent.shouldSwingHand()) {
                            this.field_71452_i.addBlockHitEffects(blockpos, blockraytraceresult);
                            this.field_71439_g.func_184609_a(Hand.MAIN_HAND);
                        }
                        return;
                    }
                    Direction direction = blockraytraceresult.func_216354_b();
                    if (this.field_71442_b.func_180512_c(blockpos, direction) && inputEvent.shouldSwingHand()) {
                        this.field_71452_i.addBlockHitEffects(blockpos, blockraytraceresult);
                        this.field_71439_g.func_184609_a(Hand.MAIN_HAND);
                    }
                }
            } else {
                this.field_71442_b.func_78767_c();
            }
        }
    }

    private void func_147116_af() {
        if (this.field_71429_W <= 0) {
            if (this.field_71476_x == null) {
                field_147123_G.error("Null returned as 'hitResult', this shouldn't happen!");
                if (this.field_71442_b.func_78762_g()) {
                    this.field_71429_W = 10;
                }
            } else if (!this.field_71439_g.func_184838_M()) {
                InputEvent.ClickInputEvent inputEvent = ForgeHooksClient.onClickInput((int)0, (KeyBinding)this.field_71474_y.field_74312_F, (Hand)Hand.MAIN_HAND);
                if (!inputEvent.isCanceled()) {
                    switch (this.field_71476_x.func_216346_c()) {
                        case ENTITY: {
                            this.field_71442_b.func_78764_a(this.field_71439_g, ((EntityRayTraceResult)this.field_71476_x).func_216348_a());
                            break;
                        }
                        case BLOCK: {
                            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)this.field_71476_x;
                            BlockPos blockpos = blockraytraceresult.func_216350_a();
                            if (!this.field_71441_e.func_175623_d(blockpos)) {
                                this.field_71442_b.func_180511_b(blockpos, blockraytraceresult.func_216354_b());
                                break;
                            }
                        }
                        case MISS: {
                            if (this.field_71442_b.func_78762_g()) {
                                this.field_71429_W = 10;
                            }
                            this.field_71439_g.func_184821_cY();
                            ForgeHooks.onEmptyLeftClick((PlayerEntity)this.field_71439_g);
                        }
                    }
                }
                if (inputEvent.shouldSwingHand()) {
                    this.field_71439_g.func_184609_a(Hand.MAIN_HAND);
                }
            }
        }
    }

    private void func_147121_ag() {
        if (!this.field_71442_b.func_181040_m()) {
            this.field_71467_ac = 4;
            if (!this.field_71439_g.func_184838_M()) {
                if (this.field_71476_x == null) {
                    field_147123_G.warn("Null returned as 'hitResult', this shouldn't happen!");
                }
                for (Hand hand : Hand.values()) {
                    ActionResultType actionresulttype2;
                    InputEvent.ClickInputEvent inputEvent = ForgeHooksClient.onClickInput((int)1, (KeyBinding)this.field_71474_y.field_74313_G, (Hand)hand);
                    if (inputEvent.isCanceled()) {
                        if (inputEvent.shouldSwingHand()) {
                            this.field_71439_g.func_184609_a(hand);
                        }
                        return;
                    }
                    ItemStack itemstack = this.field_71439_g.func_184586_b(hand);
                    if (this.field_71476_x != null) {
                        switch (this.field_71476_x.func_216346_c()) {
                            case ENTITY: {
                                EntityRayTraceResult entityraytraceresult = (EntityRayTraceResult)this.field_71476_x;
                                Entity entity = entityraytraceresult.func_216348_a();
                                ActionResultType actionresulttype = this.field_71442_b.func_187102_a(this.field_71439_g, entity, entityraytraceresult, hand);
                                if (!actionresulttype.func_226246_a_()) {
                                    actionresulttype = this.field_71442_b.func_187097_a(this.field_71439_g, entity, hand);
                                }
                                if (!actionresulttype.func_226246_a_()) break;
                                if (actionresulttype.func_226247_b_() && inputEvent.shouldSwingHand()) {
                                    this.field_71439_g.func_184609_a(hand);
                                }
                                return;
                            }
                            case BLOCK: {
                                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)this.field_71476_x;
                                int i = itemstack.func_190916_E();
                                ActionResultType actionresulttype1 = this.field_71442_b.func_217292_a(this.field_71439_g, this.field_71441_e, hand, blockraytraceresult);
                                if (actionresulttype1.func_226246_a_()) {
                                    if (actionresulttype1.func_226247_b_()) {
                                        if (inputEvent.shouldSwingHand()) {
                                            this.field_71439_g.func_184609_a(hand);
                                        }
                                        if (!itemstack.func_190926_b() && (itemstack.func_190916_E() != i || this.field_71442_b.func_78758_h())) {
                                            this.field_71460_t.field_78516_c.func_187460_a(hand);
                                        }
                                    }
                                    return;
                                }
                                if (actionresulttype1 != ActionResultType.FAIL) break;
                                return;
                            }
                        }
                    }
                    if (itemstack.func_190926_b() && (this.field_71476_x == null || this.field_71476_x.func_216346_c() == RayTraceResult.Type.MISS)) {
                        ForgeHooks.onEmptyClick((PlayerEntity)this.field_71439_g, (Hand)hand);
                    }
                    if (itemstack.func_190926_b() || !(actionresulttype2 = this.field_71442_b.func_187101_a(this.field_71439_g, this.field_71441_e, hand)).func_226246_a_()) continue;
                    if (actionresulttype2.func_226247_b_()) {
                        this.field_71439_g.func_184609_a(hand);
                    }
                    this.field_71460_t.field_78516_c.func_187460_a(hand);
                    return;
                }
            }
        }
    }

    public MusicTicker func_181535_r() {
        return this.field_147126_aw;
    }

    public void func_71407_l() {
        if (this.field_71467_ac > 0) {
            --this.field_71467_ac;
        }
        BasicEventHooks.onPreClientTick();
        this.field_71424_I.func_76320_a("gui");
        if (!this.field_71445_n) {
            this.field_71456_v.func_73831_a();
        }
        this.field_71424_I.func_76319_b();
        this.field_71460_t.func_78473_a(1.0f);
        this.field_193035_aW.func_193297_a(this.field_71441_e, this.field_71476_x);
        this.field_71424_I.func_76320_a("gameMode");
        if (!this.field_71445_n && this.field_71441_e != null) {
            this.field_71442_b.func_78765_e();
        }
        this.field_71424_I.func_219895_b("textures");
        if (this.field_71441_e != null) {
            this.field_71446_o.func_110550_d();
        }
        if (this.field_71462_r == null && this.field_71439_g != null) {
            if (this.field_71439_g.func_233643_dh_() && !(this.field_71462_r instanceof DeathScreen)) {
                this.func_147108_a(null);
            } else if (this.field_71439_g.func_70608_bn() && this.field_71441_e != null) {
                this.func_147108_a((Screen)new SleepInMultiplayerScreen());
            }
        } else if (this.field_71462_r != null && this.field_71462_r instanceof SleepInMultiplayerScreen && !this.field_71439_g.func_70608_bn()) {
            this.func_147108_a(null);
        }
        if (this.field_71462_r != null) {
            this.field_71429_W = 10000;
        }
        if (this.field_71462_r != null) {
            Screen.func_231153_a_(() -> this.field_71462_r.func_231023_e_(), "Ticking screen", ((Object)((Object)this.field_71462_r)).getClass().getCanonicalName());
        }
        if (!this.field_71474_y.field_74330_P) {
            this.field_71456_v.func_212910_m();
        }
        if (this.field_213279_p == null && (this.field_71462_r == null || this.field_71462_r.field_230711_n_)) {
            this.field_71424_I.func_219895_b("Keybindings");
            this.func_184117_aA();
            if (this.field_71429_W > 0) {
                --this.field_71429_W;
            }
        }
        if (this.field_71441_e != null) {
            this.field_71424_I.func_219895_b("gameRenderer");
            if (!this.field_71445_n) {
                this.field_71460_t.func_78464_a();
            }
            this.field_71424_I.func_219895_b("levelRenderer");
            if (!this.field_71445_n) {
                this.field_71438_f.func_72734_e();
            }
            this.field_71424_I.func_219895_b("level");
            if (!this.field_71445_n) {
                if (this.field_71441_e.func_228332_n_() > 0) {
                    this.field_71441_e.func_225605_c_(this.field_71441_e.func_228332_n_() - 1);
                }
                this.field_71441_e.func_217419_d();
            }
        } else if (this.field_71460_t.func_147706_e() != null) {
            this.field_71460_t.func_181022_b();
        }
        if (!this.field_71445_n) {
            this.field_147126_aw.func_73660_a();
        }
        this.field_147127_av.func_215290_a(this.field_71445_n);
        if (this.field_71441_e != null) {
            if (!this.field_71445_n) {
                this.field_193035_aW.func_193303_d();
                try {
                    this.field_71441_e.func_72835_b(() -> true);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception in world tick");
                    if (this.field_71441_e == null) {
                        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Affected level");
                        crashreportcategory.func_71507_a("Problem", "Level is null!");
                    } else {
                        this.field_71441_e.func_72914_a(crashreport);
                    }
                    throw new ReportedException(crashreport);
                }
            }
            this.field_71424_I.func_219895_b("animateTick");
            if (!this.field_71445_n && this.field_71441_e != null) {
                this.field_71441_e.func_73029_E(MathHelper.func_76128_c((double)this.field_71439_g.func_226277_ct_()), MathHelper.func_76128_c((double)this.field_71439_g.func_226278_cu_()), MathHelper.func_76128_c((double)this.field_71439_g.func_226281_cx_()));
            }
            this.field_71424_I.func_219895_b("particles");
            if (!this.field_71445_n) {
                this.field_71452_i.func_78868_a();
            }
        } else if (this.field_71453_ak != null) {
            this.field_71424_I.func_219895_b("pendingConnection");
            this.field_71453_ak.func_74428_b();
        }
        this.field_71424_I.func_219895_b("keyboard");
        this.field_195559_v.func_204870_b();
        this.field_71424_I.func_76319_b();
        BasicEventHooks.onPostClientTick();
    }

    private void func_184117_aA() {
        boolean flag2;
        while (this.field_71474_y.field_151457_aa.func_151468_f()) {
            ++this.field_71474_y.field_74320_O;
            if (this.field_71474_y.field_74320_O > 2) {
                this.field_71474_y.field_74320_O = 0;
            }
            if (this.field_71474_y.field_74320_O == 0) {
                this.field_71460_t.func_175066_a(this.func_175606_aa());
            } else if (this.field_71474_y.field_74320_O == 1) {
                this.field_71460_t.func_175066_a(null);
            }
            this.field_71438_f.func_174979_m();
        }
        while (this.field_71474_y.field_151458_ab.func_151468_f()) {
            this.field_71474_y.field_74326_T = !this.field_71474_y.field_74326_T;
        }
        for (int i = 0; i < 9; ++i) {
            boolean flag = this.field_71474_y.field_193629_ap.func_151470_d();
            boolean flag1 = this.field_71474_y.field_193630_aq.func_151470_d();
            if (!this.field_71474_y.field_151456_ac[i].func_151468_f()) continue;
            if (this.field_71439_g.func_175149_v()) {
                this.field_71456_v.func_175187_g().func_175260_a(i);
                continue;
            }
            if (!this.field_71439_g.func_184812_l_() || this.field_71462_r != null || !flag1 && !flag) {
                this.field_71439_g.field_71071_by.field_70461_c = i;
                continue;
            }
            CreativeScreen.func_192044_a(this, i, flag1, flag);
        }
        while (this.field_71474_y.field_151445_Q.func_151468_f()) {
            if (this.field_71442_b.func_110738_j()) {
                this.field_71439_g.func_175163_u();
                continue;
            }
            this.field_193035_aW.func_193296_a();
            this.func_147108_a((Screen)new InventoryScreen((PlayerEntity)this.field_71439_g));
        }
        while (this.field_71474_y.field_194146_ao.func_151468_f()) {
            this.func_147108_a(new AdvancementsScreen(this.field_71439_g.field_71174_a.func_191982_f()));
        }
        while (this.field_71474_y.field_186718_X.func_151468_f()) {
            if (this.field_71439_g.func_175149_v()) continue;
            this.func_147114_u().func_147297_a((IPacket<?>)new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.field_177992_a, Direction.DOWN));
        }
        while (this.field_71474_y.field_74316_C.func_151468_f()) {
            if (this.field_71439_g.func_175149_v() || !this.field_71439_g.func_225609_n_(Screen.func_231172_r_())) continue;
            this.field_71439_g.func_184609_a(Hand.MAIN_HAND);
        }
        boolean bl = flag2 = this.field_71474_y.field_74343_n != ChatVisibility.HIDDEN;
        if (flag2) {
            while (this.field_71474_y.field_74310_D.func_151468_f()) {
                this.func_238207_b_("");
            }
            if (this.field_71462_r == null && this.field_213279_p == null && this.field_71474_y.field_74323_J.func_151468_f()) {
                this.func_238207_b_("/");
            }
        }
        if (this.field_71439_g.func_184587_cr()) {
            if (!this.field_71474_y.field_74313_G.func_151470_d()) {
                this.field_71442_b.func_78766_c(this.field_71439_g);
            }
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
            }
        } else {
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
                this.func_147116_af();
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
                this.func_147121_ag();
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
                this.func_147112_ai();
            }
        }
        if (this.field_71474_y.field_74313_G.func_151470_d() && this.field_71467_ac == 0 && !this.field_71439_g.func_184587_cr()) {
            this.func_147121_ag();
        }
        this.func_147115_a(this.field_71462_r == null && this.field_71474_y.field_74312_F.func_151470_d() && this.field_71417_B.func_198035_h());
    }

    public static DatapackCodec func_238180_a_(SaveFormat.LevelSave p_238180_0_) {
        MinecraftServer.func_240777_a_(p_238180_0_);
        DatapackCodec datapackcodec = p_238180_0_.func_237297_e_();
        if (datapackcodec == null) {
            throw new IllegalStateException("Failed to load data pack config");
        }
        return datapackcodec;
    }

    public static IServerConfiguration func_238181_a_(SaveFormat.LevelSave p_238181_0_, IDynamicRegistries.Impl p_238181_1_, IResourceManager p_238181_2_, DatapackCodec p_238181_3_) {
        WorldSettingsImport worldsettingsimport = WorldSettingsImport.func_240876_a_((DynamicOps)NBTDynamicOps.field_210820_a, (IResourceManager)p_238181_2_, (IDynamicRegistries)p_238181_1_);
        IServerConfiguration iserverconfiguration = p_238181_0_.func_237284_a_((DynamicOps<INBT>)worldsettingsimport, p_238181_3_);
        if (iserverconfiguration == null) {
            throw new IllegalStateException("Failed to load world");
        }
        return iserverconfiguration;
    }

    public void func_238191_a_(String p_238191_1_) {
        this.func_238195_a_(p_238191_1_, IDynamicRegistries.func_239770_b_(), Minecraft::func_238180_a_, (Function4<SaveFormat.LevelSave, IDynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration>)((Function4)Minecraft::func_238181_a_), false, WorldSelectionType.BACKUP);
    }

    public void func_238192_a_(String p_238192_1_, WorldSettings p_238192_2_, IDynamicRegistries.Impl p_238192_3_, DimensionGeneratorSettings p_238192_4_) {
        this.func_238195_a_(p_238192_1_, p_238192_3_, p_238179_1_ -> p_238192_2_.func_234958_g_(), (Function4<SaveFormat.LevelSave, IDynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration>)((Function4)(p_238187_3_, p_238187_4_, p_238187_5_, p_238187_6_) -> {
            WorldSettingsImport worldsettingsimport = WorldSettingsImport.func_240876_a_((DynamicOps)JsonOps.INSTANCE, (IResourceManager)p_238187_5_, (IDynamicRegistries)p_238192_3_);
            DataResult dataresult = worldsettingsimport.func_241797_a_(p_238192_4_.func_236224_e_(), Registry.field_239700_af_, Dimension.field_236052_a_);
            SimpleRegistry simpleregistry = dataresult.resultOrPartial(arg_0 -> ((Logger)field_147123_G).error(arg_0)).orElse(p_238192_4_.func_236224_e_());
            return new ServerWorldInfo(p_238192_2_, p_238192_4_.func_236215_a_(simpleregistry), dataresult.lifecycle());
        }), false, WorldSelectionType.CREATE);
    }

    private void func_238195_a_(String p_238195_1_, IDynamicRegistries.Impl p_238195_2_, Function<SaveFormat.LevelSave, DatapackCodec> p_238195_3_, Function4<SaveFormat.LevelSave, IDynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration> p_238195_4_, boolean p_238195_5_, WorldSelectionType p_238195_6_) {
        boolean flag1;
        PackManager minecraft$packmanager;
        SaveFormat.LevelSave saveformat$levelsave;
        try {
            saveformat$levelsave = this.field_71469_aa.func_237274_c_(p_238195_1_);
        }
        catch (IOException ioexception2) {
            field_147123_G.warn("Failed to read level {} data", (Object)p_238195_1_, (Object)ioexception2);
            SystemToast.func_238535_a_((Minecraft)this, (String)p_238195_1_);
            this.func_147108_a(null);
            return;
        }
        try {
            minecraft$packmanager = this.func_238189_a_(p_238195_2_, p_238195_3_, p_238195_4_, p_238195_5_, saveformat$levelsave);
        }
        catch (Exception exception) {
            field_147123_G.warn("Failed to load datapacks, can't proceed with server load", (Throwable)exception);
            this.func_147108_a((Screen)new DatapackFailureScreen(() -> this.func_238195_a_(p_238195_1_, p_238195_2_, p_238195_3_, p_238195_4_, true, p_238195_6_)));
            try {
                saveformat$levelsave.close();
            }
            catch (IOException ioexception) {
                field_147123_G.warn("Failed to unlock access to level {}", (Object)p_238195_1_, (Object)ioexception);
            }
            return;
        }
        IServerConfiguration iserverconfiguration = minecraft$packmanager.func_238226_c_();
        boolean flag = iserverconfiguration.func_230418_z_().func_236229_j_();
        boolean bl = flag1 = iserverconfiguration.func_230401_A_() != Lifecycle.stable();
        if (p_238195_6_ == WorldSelectionType.NONE || !flag && !flag1) {
            this.func_213254_o();
            this.field_213277_ad.set(null);
            try {
                saveformat$levelsave.func_237287_a_((IDynamicRegistries)p_238195_2_, iserverconfiguration);
                minecraft$packmanager.func_238225_b_().func_240971_i_();
                YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
                MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
                GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
                PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
                SkullTileEntity.func_184293_a((PlayerProfileCache)playerprofilecache);
                SkullTileEntity.func_184294_a((MinecraftSessionService)minecraftsessionservice);
                PlayerProfileCache.func_187320_a((boolean)false);
                this.field_71437_Z = MinecraftServer.func_240784_a_(p_238188_8_ -> new IntegratedServer((Thread)p_238188_8_, this, p_238195_2_, saveformat$levelsave, minecraft$packmanager.func_238224_a_(), minecraft$packmanager.func_238225_b_(), iserverconfiguration, minecraftsessionservice, gameprofilerepository, playerprofilecache, p_238211_1_ -> {
                    TrackingChunkStatusListener trackingchunkstatuslistener = new TrackingChunkStatusListener(p_238211_1_ + 0);
                    trackingchunkstatuslistener.func_219521_a();
                    this.field_213277_ad.set(trackingchunkstatuslistener);
                    return new ChainedChunkStatusListener((IChunkStatusListener)trackingchunkstatuslistener, this.field_213275_aU::add);
                }));
                this.field_71455_al = true;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Starting integrated server");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Starting integrated server");
                crashreportcategory.func_71507_a("Level ID", p_238195_1_);
                crashreportcategory.func_71507_a("Level Name", iserverconfiguration.func_76065_j());
                throw new ReportedException(crashreport);
            }
            while (this.field_213277_ad.get() == null) {
                Thread.yield();
            }
            WorldLoadProgressScreen worldloadprogressscreen = new WorldLoadProgressScreen(this.field_213277_ad.get());
            this.func_147108_a((Screen)worldloadprogressscreen);
            this.field_71424_I.func_76320_a("waitForServer");
            while (!this.field_71437_Z.func_71200_ad()) {
                worldloadprogressscreen.func_231023_e_();
                this.func_195542_b(false);
                try {
                    Thread.sleep(16L);
                }
                catch (InterruptedException crashreport) {
                    // empty catch block
                }
                if (this.field_71433_S == null) continue;
                Minecraft.func_71377_b(this.field_71433_S);
                return;
            }
            this.field_71424_I.func_76319_b();
            SocketAddress socketaddress = this.field_71437_Z.func_147137_ag().func_151270_a();
            NetworkManager networkmanager = NetworkManager.func_150722_a(socketaddress);
            networkmanager.func_150719_a((INetHandler)new ClientLoginNetHandler(networkmanager, this, null, p_229998_0_ -> {}));
            networkmanager.func_179290_a(new CHandshakePacket(socketaddress.toString(), 0, ProtocolType.LOGIN));
            GameProfile gameProfile = this.func_110432_I().func_148256_e();
            if (!this.func_110432_I().hasCachedProperties()) {
                gameProfile = this.field_152355_az.fillProfileProperties(gameProfile, true);
                this.func_110432_I().setProperties(gameProfile.getProperties());
            }
            networkmanager.func_179290_a((IPacket<?>)new CLoginStartPacket(gameProfile));
            this.field_71453_ak = networkmanager;
        } else {
            this.func_241559_a_(p_238195_6_, p_238195_1_, flag, () -> this.func_238195_a_(p_238195_1_, p_238195_2_, p_238195_3_, p_238195_4_, p_238195_5_, WorldSelectionType.NONE));
            minecraft$packmanager.close();
            try {
                saveformat$levelsave.close();
            }
            catch (IOException ioexception1) {
                field_147123_G.warn("Failed to unlock access to level {}", (Object)p_238195_1_, (Object)ioexception1);
            }
        }
    }

    private void func_241559_a_(WorldSelectionType p_241559_1_, String p_241559_2_, boolean p_241559_3_, Runnable p_241559_4_) {
        if (p_241559_1_ == WorldSelectionType.BACKUP) {
            TranslationTextComponent itextcomponent1;
            TranslationTextComponent itextcomponent;
            if (p_241559_3_) {
                itextcomponent = new TranslationTextComponent("selectWorld.backupQuestion.customized");
                itextcomponent1 = new TranslationTextComponent("selectWorld.backupWarning.customized");
            } else {
                itextcomponent = new TranslationTextComponent("selectWorld.backupQuestion.experimental");
                itextcomponent1 = new TranslationTextComponent("selectWorld.backupWarning.experimental");
            }
            this.func_147108_a((Screen)new ConfirmBackupScreen((Screen)null, (p_241561_3_, p_241561_4_) -> {
                if (p_241561_3_) {
                    EditWorldScreen.func_241651_a_((SaveFormat)this.field_71469_aa, (String)p_241559_2_);
                }
                p_241559_4_.run();
            }, (ITextComponent)itextcomponent, (ITextComponent)itextcomponent1, false));
        } else {
            this.func_147108_a((Screen)new ConfirmScreen(p_241560_3_ -> {
                if (p_241560_3_) {
                    p_241559_4_.run();
                } else {
                    this.func_147108_a(null);
                    try (SaveFormat.LevelSave saveformat$levelsave = this.field_71469_aa.func_237274_c_(p_241559_2_);){
                        saveformat$levelsave.func_237299_g_();
                    }
                    catch (IOException ioexception) {
                        SystemToast.func_238538_b_((Minecraft)this, (String)p_241559_2_);
                        field_147123_G.error("Failed to delete world {}", (Object)p_241559_2_, (Object)ioexception);
                    }
                }
            }, (ITextComponent)new TranslationTextComponent("selectWorld.backupQuestion.experimental"), (ITextComponent)new TranslationTextComponent("selectWorld.backupWarning.experimental"), DialogTexts.field_240636_g_, DialogTexts.field_240633_d_));
        }
    }

    public PackManager func_238189_a_(IDynamicRegistries.Impl p_238189_1_, Function<SaveFormat.LevelSave, DatapackCodec> p_238189_2_, Function4<SaveFormat.LevelSave, IDynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration> p_238189_3_, boolean p_238189_4_, SaveFormat.LevelSave p_238189_5_) throws InterruptedException, ExecutionException {
        DatapackCodec datapackcodec = p_238189_2_.apply(p_238189_5_);
        ResourcePackList<ResourcePackInfo> resourcepacklist = new ResourcePackList<ResourcePackInfo>(ResourcePackInfo::new, new IPackFinder[]{new ServerPackFinder(), new FolderPackFinder(p_238189_5_.func_237285_a_(FolderName.field_237251_g_).toFile(), IPackNameDecorator.field_232627_c_)});
        try {
            DatapackCodec datapackcodec1 = MinecraftServer.func_240772_a_(resourcepacklist, datapackcodec, p_238189_4_);
            CompletableFuture<DataPackRegistries> completablefuture = DataPackRegistries.func_240961_a_(resourcepacklist.func_232623_f_(), Commands.EnvironmentType.INTEGRATED, 2, Util.func_215072_e(), (Executor)((Object)this));
            this.func_213161_c(completablefuture::isDone);
            DataPackRegistries datapackregistries = completablefuture.get();
            IServerConfiguration iserverconfiguration = (IServerConfiguration)p_238189_3_.apply((Object)p_238189_5_, (Object)p_238189_1_, (Object)datapackregistries.func_240970_h_(), (Object)datapackcodec1);
            return new PackManager(resourcepacklist, datapackregistries, iserverconfiguration);
        }
        catch (InterruptedException | ExecutionException interruptedexception) {
            resourcepacklist.close();
            throw interruptedexception;
        }
    }

    public void func_71403_a(ClientWorld worldClientIn) {
        if (this.field_71441_e != null) {
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)this.field_71441_e));
        }
        WorkingScreen workingscreen = new WorkingScreen();
        workingscreen.func_200210_a((ITextComponent)new TranslationTextComponent("connect.joining"));
        this.func_213241_c((Screen)workingscreen);
        this.field_71441_e = worldClientIn;
        this.func_213257_b(worldClientIn);
        if (!this.field_71455_al) {
            YggdrasilAuthenticationService authenticationservice = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = authenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = authenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
            SkullTileEntity.func_184293_a((PlayerProfileCache)playerprofilecache);
            SkullTileEntity.func_184294_a((MinecraftSessionService)minecraftsessionservice);
            PlayerProfileCache.func_187320_a((boolean)false);
        }
    }

    public void func_213254_o() {
        this.func_213231_b((Screen)new WorkingScreen());
    }

    public void func_213231_b(Screen screenIn) {
        ClientPlayNetHandler clientplaynethandler = this.func_147114_u();
        if (clientplaynethandler != null) {
            this.func_213159_be();
            clientplaynethandler.func_147296_c();
        }
        IntegratedServer integratedserver = this.field_71437_Z;
        this.field_71437_Z = null;
        this.field_71460_t.func_190564_k();
        ClientHooks.firePlayerLogout((PlayerController)this.field_71442_b, (ClientPlayerEntity)this.field_71439_g);
        this.field_71442_b = null;
        NarratorChatListener.field_193643_a.func_193642_b();
        this.func_213241_c(screenIn);
        if (this.field_71441_e != null) {
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)this.field_71441_e));
            if (integratedserver != null) {
                this.field_71424_I.func_76320_a("waitForServer");
                while (!integratedserver.func_213201_w()) {
                    this.func_195542_b(false);
                }
                this.field_71424_I.func_76319_b();
            }
            this.field_195554_ax.func_195749_c();
            this.field_71456_v.func_181029_i();
            this.field_71422_O = null;
            this.field_71455_al = false;
            ClientHooks.handleClientWorldClosing((ClientWorld)this.field_71441_e);
            this.field_213274_aO.func_216815_b();
        }
        this.field_71441_e = null;
        this.func_213257_b(null);
        this.field_71439_g = null;
    }

    private void func_213241_c(Screen screenIn) {
        this.field_71424_I.func_76320_a("forcedTick");
        this.field_147127_av.func_147690_c();
        this.field_175622_Z = null;
        this.field_71453_ak = null;
        this.func_147108_a(screenIn);
        this.func_195542_b(false);
        this.field_71424_I.func_76319_b();
    }

    public void func_241562_c_(Screen p_241562_1_) {
        this.field_71424_I.func_76320_a("forcedTick");
        this.func_147108_a(p_241562_1_);
        this.func_195542_b(false);
        this.field_71424_I.func_76319_b();
    }

    private void func_213257_b(@Nullable ClientWorld worldIn) {
        this.field_71438_f.func_72732_a(worldIn);
        this.field_71452_i.func_78870_a(worldIn);
        TileEntityRendererDispatcher.field_147556_a.func_147543_a(worldIn);
        this.func_230150_b_();
        MinecraftForgeClient.clearRenderCache();
    }

    public boolean func_238216_r_() {
        return this.field_238175_ae_;
    }

    public boolean func_238198_a_(UUID p_238198_1_) {
        if (this.func_238217_s_()) {
            return false;
        }
        return (this.field_71439_g == null || !p_238198_1_.equals(this.field_71439_g.func_110124_au())) && !p_238198_1_.equals(Util.field_240973_b_);
    }

    public boolean func_238217_s_() {
        return this.field_238176_af_;
    }

    public final boolean func_71355_q() {
        return this.field_71459_aj;
    }

    @Nullable
    public ClientPlayNetHandler func_147114_u() {
        return this.field_71439_g == null ? null : this.field_71439_g.field_71174_a;
    }

    public static boolean func_71382_s() {
        return !Minecraft.field_71432_P.field_71474_y.field_74319_N;
    }

    public static boolean func_71375_t() {
        return Minecraft.field_71432_P.field_71474_y.field_238330_f_.func_238162_a_() >= GraphicsFanciness.FANCY.func_238162_a_();
    }

    public static boolean func_238218_y_() {
        return Minecraft.field_71432_P.field_71474_y.field_238330_f_.func_238162_a_() >= GraphicsFanciness.FABULOUS.func_238162_a_();
    }

    public static boolean func_71379_u() {
        return Minecraft.field_71432_P.field_71474_y.field_74348_k != AmbientOcclusionStatus.OFF;
    }

    private void func_147112_ai() {
        if (this.field_71476_x != null && this.field_71476_x.func_216346_c() != RayTraceResult.Type.MISS && !ForgeHooksClient.onClickInput((int)2, (KeyBinding)this.field_71474_y.field_74322_I, (Hand)Hand.MAIN_HAND).isCanceled()) {
            ForgeHooks.onPickBlock((RayTraceResult)this.field_71476_x, (PlayerEntity)this.field_71439_g, (World)this.field_71441_e);
        }
    }

    public ItemStack func_184119_a(ItemStack stack, TileEntity te) {
        CompoundNBT compoundnbt = te.func_189515_b(new CompoundNBT());
        if (stack.func_77973_b() instanceof SkullItem && compoundnbt.func_74764_b("SkullOwner")) {
            CompoundNBT compoundnbt2 = compoundnbt.func_74775_l("SkullOwner");
            stack.func_196082_o().func_218657_a("SkullOwner", compoundnbt2);
            return stack;
        }
        stack.func_77983_a("BlockEntityTag", compoundnbt);
        CompoundNBT compoundnbt1 = new CompoundNBT();
        ListNBT listnbt = new ListNBT();
        listnbt.add((Object)StringNBT.func_229705_a_("\"(+NBT)\""));
        compoundnbt1.func_218657_a("Lore", (INBT)listnbt);
        stack.func_77983_a("display", compoundnbt1);
        return stack;
    }

    public CrashReport func_71396_d(CrashReport theCrash) {
        Minecraft.func_228009_a_(this.field_135017_as, this.field_110447_Z, this.field_71474_y, theCrash);
        if (this.field_71441_e != null) {
            this.field_71441_e.func_72914_a(theCrash);
        }
        return theCrash;
    }

    public static void func_228009_a_(@Nullable LanguageManager languageManagerIn, String versionIn, @Nullable GameSettings settingsIn, CrashReport crashReportIn) {
        CrashReportCategory crashreportcategory = crashReportIn.func_85056_g();
        crashreportcategory.func_189529_a("Launched Version", (ICrashReportDetail<String>)((ICrashReportDetail)() -> versionIn));
        crashreportcategory.func_189529_a("Backend library", (ICrashReportDetail<String>)((ICrashReportDetail)RenderSystem::getBackendDescription));
        crashreportcategory.func_189529_a("Backend API", (ICrashReportDetail<String>)((ICrashReportDetail)RenderSystem::getApiDescription));
        crashreportcategory.func_189529_a("GL Caps", (ICrashReportDetail<String>)((ICrashReportDetail)RenderSystem::getCapsString));
        crashreportcategory.func_189529_a("Using VBOs", (ICrashReportDetail<String>)((ICrashReportDetail)() -> "Yes"));
        crashreportcategory.func_189529_a("Is Modded", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            String s = ClientBrandRetriever.getClientModName();
            if (!"vanilla".equals(s)) {
                return "Definitely; Client brand changed to '" + s + "'";
            }
            return Minecraft.class.getSigners() == null ? "Very likely; Jar signature invalidated" : "Probably not. Jar signature remains and client brand is untouched.";
        }));
        crashreportcategory.func_71507_a("Type", "Client (map_client.txt)");
        if (settingsIn != null) {
            crashreportcategory.func_189529_a("Resource Packs", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
                StringBuilder stringbuilder = new StringBuilder();
                for (String s : settingsIn.field_151453_l) {
                    if (stringbuilder.length() > 0) {
                        stringbuilder.append(", ");
                    }
                    stringbuilder.append(s);
                    if (!settingsIn.field_183018_l.contains(s)) continue;
                    stringbuilder.append(" (incompatible)");
                }
                return stringbuilder.toString();
            }));
        }
        if (languageManagerIn != null) {
            crashreportcategory.func_189529_a("Current Language", (ICrashReportDetail<String>)((ICrashReportDetail)() -> languageManagerIn.func_135041_c().toString()));
        }
        crashreportcategory.func_189529_a("CPU", (ICrashReportDetail<String>)((ICrashReportDetail)PlatformDescriptors::func_227775_b_));
    }

    public static Minecraft func_71410_x() {
        return field_71432_P;
    }

    @Deprecated
    public CompletableFuture<Void> func_213245_w() {
        return this.func_213169_a(this::func_213237_g).thenCompose(p_229993_0_ -> p_229993_0_);
    }

    public void func_70000_a(Snooper snooper) {
        snooper.func_152768_a("fps", (Object)field_71470_ab);
        snooper.func_152768_a("vsync_enabled", (Object)this.field_71474_y.field_74352_v);
        snooper.func_152768_a("display_frequency", (Object)this.field_195558_d.func_227798_a_());
        snooper.func_152768_a("display_type", (Object)(this.field_195558_d.func_198113_j() ? "fullscreen" : "windowed"));
        snooper.func_152768_a("run_time", (Object)((Util.func_211177_b() - snooper.func_130105_g()) / 60L * 1000L));
        snooper.func_152768_a("current_action", (Object)this.func_181538_aA());
        snooper.func_152768_a("language", (Object)(this.field_71474_y.field_74363_ab == null ? "en_us" : this.field_71474_y.field_74363_ab));
        String s = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "little" : "big";
        snooper.func_152768_a("endianness", (Object)s);
        snooper.func_152768_a("subtitles", (Object)this.field_71474_y.field_186717_N);
        snooper.func_152768_a("touch", (Object)(this.field_71474_y.field_85185_A ? "touch" : "mouse"));
        int i = 0;
        for (ClientResourcePackInfo clientresourcepackinfo : this.field_110448_aq.func_198980_d()) {
            if (clientresourcepackinfo.func_195797_g() || clientresourcepackinfo.func_195798_h()) continue;
            snooper.func_152768_a("resource_pack[" + i++ + "]", (Object)clientresourcepackinfo.func_195790_f());
        }
        snooper.func_152768_a("resource_packs", (Object)i);
        if (this.field_71437_Z != null) {
            snooper.func_152768_a("snooper_partner", (Object)this.field_71437_Z.func_80003_ah().func_80006_f());
        }
    }

    private String func_181538_aA() {
        if (this.field_71437_Z != null) {
            return this.field_71437_Z.func_71344_c() ? "hosting_lan" : "singleplayer";
        }
        if (this.field_71422_O != null) {
            return this.field_71422_O.func_181041_d() ? "playing_lan" : "multiplayer";
        }
        return "out_of_game";
    }

    public void func_71351_a(@Nullable ServerData serverDataIn) {
        this.field_71422_O = serverDataIn;
    }

    @Nullable
    public ServerData func_147104_D() {
        return this.field_71422_O;
    }

    public boolean func_71387_A() {
        return this.field_71455_al;
    }

    public boolean func_71356_B() {
        return this.field_71455_al && this.field_71437_Z != null;
    }

    @Nullable
    public IntegratedServer func_71401_C() {
        return this.field_71437_Z;
    }

    public Snooper func_71378_E() {
        return this.field_71427_U;
    }

    public Session func_110432_I() {
        return this.field_71449_j;
    }

    public PropertyMap func_181037_M() {
        if (this.field_181038_N.isEmpty()) {
            GameProfile gameprofile = this.func_152347_ac().fillProfileProperties(this.field_71449_j.func_148256_e(), false);
            this.field_181038_N.putAll((Multimap)gameprofile.getProperties());
        }
        return this.field_181038_N;
    }

    public Proxy func_110437_J() {
        return this.field_110453_aa;
    }

    public TextureManager func_110434_K() {
        return this.field_71446_o;
    }

    public IResourceManager func_195551_G() {
        return this.field_110451_am;
    }

    public ResourcePackList<ClientResourcePackInfo> func_195548_H() {
        return this.field_110448_aq;
    }

    public DownloadingPackFinder func_195541_I() {
        return this.field_195554_ax;
    }

    public File func_195549_J() {
        return this.field_130070_K;
    }

    public LanguageManager func_135016_M() {
        return this.field_135017_as;
    }

    public Function<ResourceLocation, TextureAtlasSprite> func_228015_a_(ResourceLocation locationIn) {
        return this.field_175617_aL.func_229356_a_(locationIn)::func_195424_a;
    }

    public boolean func_147111_S() {
        return this.field_147129_ai;
    }

    public boolean func_147113_T() {
        return this.field_71445_n;
    }

    public GPUWarning func_241558_U_() {
        return this.field_241557_ar_;
    }

    public SoundHandler func_147118_V() {
        return this.field_147127_av;
    }

    public BackgroundMusicSelector func_238178_U_() {
        if (this.field_71462_r instanceof WinGameScreen) {
            return BackgroundMusicTracks.field_232672_c_;
        }
        if (this.field_71439_g != null) {
            if (this.field_71439_g.field_70170_p.func_234923_W_() == World.field_234920_i_) {
                return this.field_71456_v.func_184046_j().func_184054_d() ? BackgroundMusicTracks.field_232673_d_ : BackgroundMusicTracks.field_232674_e_;
            }
            Biome.Category biome$category = this.field_71439_g.field_70170_p.func_226691_t_(this.field_71439_g.func_233580_cy_()).func_201856_r();
            if (!this.field_147126_aw.func_239540_b_(BackgroundMusicTracks.field_232675_f_) && (!this.field_71439_g.func_204231_K() || biome$category != Biome.Category.OCEAN && biome$category != Biome.Category.RIVER)) {
                return this.field_71439_g.field_70170_p.func_234923_W_() != World.field_234919_h_ && this.field_71439_g.field_71075_bZ.field_75098_d && this.field_71439_g.field_71075_bZ.field_75101_c ? BackgroundMusicTracks.field_232671_b_ : this.field_71441_e.func_225523_d_().func_235201_b_(this.field_71439_g.func_233580_cy_()).func_235094_x_().orElse(BackgroundMusicTracks.field_232676_g_);
            }
            return BackgroundMusicTracks.field_232675_f_;
        }
        return BackgroundMusicTracks.field_232670_a_;
    }

    public MinecraftSessionService func_152347_ac() {
        return this.field_152355_az;
    }

    public SkinManager func_152342_ad() {
        return this.field_152350_aA;
    }

    @Nullable
    public Entity func_175606_aa() {
        return this.field_175622_Z;
    }

    public void func_175607_a(Entity viewingEntity) {
        this.field_175622_Z = viewingEntity;
        this.field_71460_t.func_175066_a(viewingEntity);
    }

    public boolean func_238206_b_(Entity p_238206_1_) {
        return p_238206_1_.func_225510_bt_() || this.field_71439_g != null && this.field_71439_g.func_175149_v() && this.field_71474_y.field_178883_an.func_151470_d() && p_238206_1_.func_200600_R() == EntityType.field_200729_aH;
    }

    protected Thread func_213170_ax() {
        return this.field_152352_aC;
    }

    protected Runnable func_212875_d_(Runnable runnable) {
        return runnable;
    }

    protected boolean func_212874_c_(Runnable runnable) {
        return true;
    }

    public BlockRendererDispatcher func_175602_ab() {
        return this.field_175618_aM;
    }

    public EntityRendererManager func_175598_ae() {
        return this.field_175616_W;
    }

    public ItemRenderer func_175599_af() {
        return this.field_175621_X;
    }

    public FirstPersonRenderer func_175597_ag() {
        return this.field_175620_Y;
    }

    public <T> IMutableSearchTree<T> func_213253_a(SearchTreeManager.Key<T> key) {
        return this.field_193995_ae.func_215358_a(key);
    }

    public FrameTimer func_181539_aj() {
        return this.field_181542_y;
    }

    public boolean func_181540_al() {
        return this.field_181541_X;
    }

    public void func_181537_a(boolean isConnected) {
        this.field_181541_X = isConnected;
    }

    public DataFixer func_184126_aj() {
        return this.field_184131_U;
    }

    public float func_184121_ak() {
        return this.field_71428_T.field_194147_b;
    }

    public float func_193989_ak() {
        return this.field_71428_T.field_194148_c;
    }

    public BlockColors func_184125_al() {
        return this.field_184127_aH;
    }

    public boolean func_189648_am() {
        return this.field_71439_g != null && this.field_71439_g.func_175140_cp() || this.field_71474_y.field_178879_v;
    }

    public ToastGui func_193033_an() {
        return this.field_193034_aS;
    }

    public Tutorial func_193032_ao() {
        return this.field_193035_aW;
    }

    public boolean func_195544_aj() {
        return this.field_195555_I;
    }

    public CreativeSettings func_199403_al() {
        return this.field_191950_u;
    }

    public ModelManager func_209506_al() {
        return this.field_175617_aL;
    }

    public PaintingSpriteUploader func_213263_ao() {
        return this.field_213272_aL;
    }

    public PotionSpriteUploader func_213248_ap() {
        return this.field_213273_aM;
    }

    public void func_213228_a(boolean focused) {
        this.field_195555_I = focused;
    }

    public IProfiler func_213239_aq() {
        return this.field_71424_I;
    }

    public MinecraftGame func_213229_ar() {
        return this.field_213274_aO;
    }

    public Splashes func_213269_at() {
        return this.field_213271_aF;
    }

    @Nullable
    public LoadingGui func_213250_au() {
        return this.field_213279_p;
    }

    public boolean func_228017_as_() {
        return false;
    }

    public MainWindow func_228018_at_() {
        return this.field_195558_d;
    }

    public RenderTypeBuffers func_228019_au_() {
        return this.field_228006_P_;
    }

    private static ClientResourcePackInfo func_228011_a_(String name, boolean isAlwaysEnabled, Supplier<IResourcePack> p_228011_2_, IResourcePack p_228011_3_, PackMetadataSection p_228011_4_, ResourcePackInfo.Priority priority, IPackNameDecorator p_228011_6_) {
        int i = p_228011_4_.func_198962_b();
        Supplier<IResourcePack> supplier = p_228011_2_;
        if (i <= 3) {
            supplier = Minecraft.func_228021_b_(p_228011_2_);
        }
        if (i <= 4) {
            supplier = Minecraft.func_228022_c_(supplier);
        }
        return new ClientResourcePackInfo(name, isAlwaysEnabled, supplier, p_228011_3_, p_228011_4_, priority, p_228011_6_, p_228011_3_.isHidden());
    }

    private static Supplier<IResourcePack> func_228021_b_(Supplier<IResourcePack> p_228021_0_) {
        return () -> new LegacyResourcePackWrapper((IResourcePack)p_228021_0_.get(), LegacyResourcePackWrapper.field_211853_a);
    }

    private static Supplier<IResourcePack> func_228022_c_(Supplier<IResourcePack> p_228022_0_) {
        return () -> new LegacyResourcePackWrapperV4((IResourcePack)p_228022_0_.get());
    }

    public void func_228020_b_(int p_228020_1_) {
        this.field_175617_aL.func_229355_a_(p_228020_1_);
    }

    public ItemColors getItemColors() {
        return this.field_184128_aI;
    }

    public SearchTreeManager getSearchTreeManager() {
        return this.field_193995_ae;
    }

    private /* synthetic */ void lambda$restoreResourcePacks$4(ITextComponent itextcomponent) {
        ToastGui toastgui = this.func_193033_an();
        SystemToast.func_193657_a((ToastGui)toastgui, (SystemToast.Type)SystemToast.Type.PACK_LOAD_FAILURE, (ITextComponent)new TranslationTextComponent("resourcePack.load_fail"), (ITextComponent)itextcomponent);
    }

    static {
        field_147123_G = LogManager.getLogger();
        field_142025_a = Util.func_110647_a() == Util.OS.OSX;
        field_211502_b = new ResourceLocation("default");
        field_238177_c_ = new ResourceLocation("uniform");
        field_71464_q = new ResourceLocation("alt");
        field_223714_G = CompletableFuture.completedFuture(Unit.INSTANCE);
        field_71444_a = new byte[0xA00000];
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum WorldSelectionType {
        NONE,
        CREATE,
        BACKUP;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class PackManager
    implements AutoCloseable {
        private final ResourcePackList<ResourcePackInfo> field_238221_a_;
        private final DataPackRegistries field_238222_b_;
        private final IServerConfiguration field_238223_c_;

        private PackManager(ResourcePackList<ResourcePackInfo> p_i232241_1_, DataPackRegistries p_i232241_2_, IServerConfiguration p_i232241_3_) {
            this.field_238221_a_ = p_i232241_1_;
            this.field_238222_b_ = p_i232241_2_;
            this.field_238223_c_ = p_i232241_3_;
        }

        public ResourcePackList<ResourcePackInfo> func_238224_a_() {
            return this.field_238221_a_;
        }

        public DataPackRegistries func_238225_b_() {
            return this.field_238222_b_;
        }

        public IServerConfiguration func_238226_c_() {
            return this.field_238223_c_;
        }

        @Override
        public void close() {
            this.field_238221_a_.close();
            this.field_238222_b_.close();
        }
    }
}

