/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.crash;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrashReportCategory {
    private final CrashReport field_85078_a;
    private final String field_85076_b;
    private final List<Entry> field_85077_c = Lists.newArrayList();
    private StackTraceElement[] field_85075_d = new StackTraceElement[0];

    public CrashReportCategory(CrashReport report, String name) {
        this.field_85078_a = report;
        this.field_85076_b = name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String func_85074_a(double x, double y, double z) {
        return String.format(Locale.ROOT, "%.2f,%.2f,%.2f - %s", x, y, z, CrashReportCategory.func_180522_a(new BlockPos(x, y, z)));
    }

    public static String func_180522_a(BlockPos pos) {
        return CrashReportCategory.func_184876_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static String func_184876_a(int x, int y, int z) {
        StringBuilder stringbuilder = new StringBuilder();
        try {
            stringbuilder.append(String.format("World: (%d,%d,%d)", x, y, z));
        }
        catch (Throwable throwable2) {
            stringbuilder.append("(Error finding world loc)");
        }
        stringbuilder.append(", ");
        try {
            int i = x >> 4;
            int j = z >> 4;
            int k = x & 0xF;
            int l = y >> 4;
            int i1 = z & 0xF;
            int j1 = i << 4;
            int k1 = j << 4;
            int l1 = (i + 1 << 4) - 1;
            int i2 = (j + 1 << 4) - 1;
            stringbuilder.append(String.format("Chunk: (at %d,%d,%d in %d,%d; contains blocks %d,0,%d to %d,255,%d)", k, l, i1, i, j, j1, k1, l1, i2));
        }
        catch (Throwable throwable1) {
            stringbuilder.append("(Error finding chunk loc)");
        }
        stringbuilder.append(", ");
        try {
            int k2 = x >> 9;
            int l2 = z >> 9;
            int i3 = k2 << 5;
            int j3 = l2 << 5;
            int k3 = (k2 + 1 << 5) - 1;
            int l3 = (l2 + 1 << 5) - 1;
            int i4 = k2 << 9;
            int j4 = l2 << 9;
            int k4 = (k2 + 1 << 9) - 1;
            int j2 = (l2 + 1 << 9) - 1;
            stringbuilder.append(String.format("Region: (%d,%d; contains chunks %d,%d to %d,%d, blocks %d,0,%d to %d,255,%d)", k2, l2, i3, j3, k3, l3, i4, j4, k4, j2));
        }
        catch (Throwable throwable) {
            stringbuilder.append("(Error finding world loc)");
        }
        return stringbuilder.toString();
    }

    public CrashReportCategory func_189529_a(String nameIn, ICrashReportDetail<String> detail) {
        try {
            this.func_71507_a(nameIn, detail.call());
        }
        catch (Throwable throwable) {
            this.func_71499_a(nameIn, throwable);
        }
        return this;
    }

    public CrashReportCategory func_71507_a(String sectionName, Object value) {
        this.field_85077_c.add(new Entry(sectionName, value));
        return this;
    }

    public void func_71499_a(String sectionName, Throwable throwable) {
        this.func_71507_a(sectionName, throwable);
    }

    public int func_85073_a(int size) {
        StackTraceElement[] astacktraceelement = Thread.currentThread().getStackTrace();
        if (astacktraceelement.length <= 0) {
            return 0;
        }
        int len = astacktraceelement.length - 3 - size;
        if (len <= 0) {
            len = astacktraceelement.length;
        }
        this.field_85075_d = new StackTraceElement[len];
        System.arraycopy(astacktraceelement, astacktraceelement.length - len, this.field_85075_d, 0, this.field_85075_d.length);
        return this.field_85075_d.length;
    }

    public boolean func_85069_a(StackTraceElement s1, StackTraceElement s2) {
        if (this.field_85075_d.length != 0 && s1 != null) {
            StackTraceElement stacktraceelement = this.field_85075_d[0];
            if (stacktraceelement.isNativeMethod() == s1.isNativeMethod() && stacktraceelement.getClassName().equals(s1.getClassName()) && stacktraceelement.getFileName().equals(s1.getFileName()) && stacktraceelement.getMethodName().equals(s1.getMethodName())) {
                if (s2 != null != this.field_85075_d.length > 1) {
                    return false;
                }
                if (s2 != null && !this.field_85075_d[1].equals(s2)) {
                    return false;
                }
                this.field_85075_d[0] = s1;
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_85070_b(int amount) {
        StackTraceElement[] astacktraceelement = new StackTraceElement[this.field_85075_d.length - amount];
        System.arraycopy(this.field_85075_d, 0, astacktraceelement, 0, astacktraceelement.length);
        this.field_85075_d = astacktraceelement;
    }

    public void func_85072_a(StringBuilder builder) {
        builder.append("-- ").append(this.field_85076_b).append(" --\n");
        builder.append("Details:");
        for (Entry crashreportcategory$entry : this.field_85077_c) {
            builder.append("\n\t");
            builder.append(crashreportcategory$entry.func_85089_a());
            builder.append(": ");
            builder.append(crashreportcategory$entry.func_85090_b());
        }
        if (this.field_85075_d != null && this.field_85075_d.length > 0) {
            builder.append("\nStacktrace:");
            for (StackTraceElement stacktraceelement : this.field_85075_d) {
                builder.append("\n\tat ");
                builder.append(stacktraceelement);
            }
        }
    }

    public StackTraceElement[] func_147152_a() {
        return this.field_85075_d;
    }

    public static void func_175750_a(CrashReportCategory category, BlockPos pos, @Nullable BlockState state) {
        if (state != null) {
            category.func_189529_a("Block", (ICrashReportDetail<String>)((ICrashReportDetail)() -> ((BlockState)state).toString()));
        }
        category.func_189529_a("Block location", (ICrashReportDetail<String>)((ICrashReportDetail)() -> CrashReportCategory.func_180522_a(pos)));
    }

    static class Entry {
        private final String field_85092_a;
        private final String field_85091_b;

        public Entry(String key, Object value) {
            this.field_85092_a = key;
            if (value == null) {
                this.field_85091_b = "~~NULL~~";
            } else if (value instanceof Throwable) {
                Throwable throwable = (Throwable)value;
                this.field_85091_b = "~~ERROR~~ " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
            } else {
                this.field_85091_b = value.toString();
            }
        }

        public String func_85089_a() {
            return this.field_85092_a;
        }

        public String func_85090_b() {
            return this.field_85091_b;
        }
    }
}

