/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public abstract class AnimalEntity
extends AgeableEntity {
    private int field_70881_d;
    private UUID field_146084_br;

    protected AnimalEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
    }

    protected void func_70619_bc() {
        if (this.func_70874_b() != 0) {
            this.field_70881_d = 0;
        }
        super.func_70619_bc();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70874_b() != 0) {
            this.field_70881_d = 0;
        }
        if (this.field_70881_d > 0) {
            --this.field_70881_d;
            if (this.field_70881_d % 10 == 0) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.field_70881_d = 0;
        return super.func_70097_a(source, amount);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i) ? 10.0f : worldIn.func_205052_D(pos) - 0.5f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("InLove", this.field_70881_d);
        if (this.field_146084_br != null) {
            compound.func_186854_a("LoveCause", this.field_146084_br);
        }
    }

    public double func_70033_W() {
        return 0.14;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70881_d = compound.func_74762_e("InLove");
        this.field_146084_br = compound.func_186855_b("LoveCause") ? compound.func_186857_a("LoveCause") : null;
    }

    public static boolean func_223316_b(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public int func_70627_aG() {
        return 120;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151015_O;
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (this.func_70877_b(itemstack)) {
            int i = this.func_70874_b();
            if (!this.field_70170_p.field_72995_K && i == 0 && this.func_204701_dC()) {
                this.func_175505_a(p_230254_1_, itemstack);
                this.func_146082_f(p_230254_1_);
                return ActionResultType.SUCCESS;
            }
            if (this.func_70631_g_()) {
                this.func_175505_a(p_230254_1_, itemstack);
                this.func_175501_a((int)((float)(-i / 20) * 0.1f), true);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.field_70170_p.field_72995_K) {
                return ActionResultType.CONSUME;
            }
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected void func_175505_a(PlayerEntity player, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
    }

    public boolean func_204701_dC() {
        return this.field_70881_d <= 0;
    }

    public void func_146082_f(@Nullable PlayerEntity player) {
        this.field_70881_d = 600;
        if (player != null) {
            this.field_146084_br = player.func_110124_au();
        }
        this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)18);
    }

    public void func_204700_e(int ticks) {
        this.field_70881_d = ticks;
    }

    public int func_234178_eO_() {
        return this.field_70881_d;
    }

    @Nullable
    public ServerPlayerEntity func_191993_do() {
        if (this.field_146084_br == null) {
            return null;
        }
        PlayerEntity playerentity = this.field_70170_p.func_217371_b(this.field_146084_br);
        return playerentity instanceof ServerPlayerEntity ? (ServerPlayerEntity)playerentity : null;
    }

    public boolean func_70880_s() {
        return this.field_70881_d > 0;
    }

    public void func_70875_t() {
        this.field_70881_d = 0;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (((Object)((Object)otherAnimal)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.func_70880_s() && otherAnimal.func_70880_s();
    }

    public void func_234177_a_(World p_234177_1_, AnimalEntity p_234177_2_) {
        AgeableEntity ageableentity = this.func_90011_a(p_234177_2_);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((MobEntity)((Object)this), (MobEntity)((Object)p_234177_2_), ageableentity);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        ageableentity = event.getChild();
        if (cancelled) {
            this.func_70873_a(6000);
            p_234177_2_.func_70873_a(6000);
            this.func_70875_t();
            p_234177_2_.func_70875_t();
            return;
        }
        if (ageableentity != null) {
            ServerPlayerEntity serverplayerentity = this.func_191993_do();
            if (serverplayerentity == null && p_234177_2_.func_191993_do() != null) {
                serverplayerentity = p_234177_2_.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this, p_234177_2_, ageableentity);
            }
            this.func_70873_a(6000);
            p_234177_2_.func_70873_a(6000);
            this.func_70875_t();
            p_234177_2_.func_70875_t();
            ageableentity.func_82227_f(true);
            ageableentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
            p_234177_1_.func_217376_c((Entity)ageableentity);
            p_234177_1_.func_72960_a((Entity)((Object)this), (byte)18);
            if (p_234177_1_.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                p_234177_1_.func_217376_c(new ExperienceOrbEntity(p_234177_1_, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_70681_au().nextInt(7) + 1));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        } else {
            super.func_70103_a(id);
        }
    }
}

