/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;

public class FishingBobberEntity
extends ProjectileEntity {
    private final Random field_234596_b_ = new Random();
    private boolean field_234597_c_;
    private int field_234598_d_;
    private static final DataParameter<Integer> field_184528_c = EntityDataManager.func_187226_a(FishingBobberEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_234599_f_ = EntityDataManager.func_187226_a(FishingBobberEntity.class, DataSerializers.field_187198_h);
    private int field_146049_av;
    private int field_146045_ax;
    private int field_146040_ay;
    private int field_146038_az;
    private float field_146054_aA;
    private boolean field_234595_aq_ = true;
    private Entity field_146043_c;
    private State field_190627_av = State.FLYING;
    private final int field_191518_aw;
    private final int field_191519_ax;

    private FishingBobberEntity(World p_i50219_1_, PlayerEntity p_i50219_2_, int p_i50219_3_, int p_i50219_4_) {
        super(EntityType.field_200730_aI, p_i50219_1_);
        this.field_70158_ak = true;
        this.func_212361_a(p_i50219_2_);
        p_i50219_2_.field_71104_cf = this;
        this.field_191518_aw = Math.max(0, p_i50219_3_);
        this.field_191519_ax = Math.max(0, p_i50219_4_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FishingBobberEntity(World worldIn, PlayerEntity p_i47290_2_, double x, double y, double z) {
        this(worldIn, p_i47290_2_, 0, 0);
        this.func_70107_b(x, y, z);
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
    }

    public FishingBobberEntity(PlayerEntity p_i50220_1_, World p_i50220_2_, int p_i50220_3_, int p_i50220_4_) {
        this(p_i50220_2_, p_i50220_1_, p_i50220_3_, p_i50220_4_);
        float f = p_i50220_1_.field_70125_A;
        float f1 = p_i50220_1_.field_70177_z;
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        double d0 = p_i50220_1_.func_226277_ct_() - (double)f3 * 0.3;
        double d1 = p_i50220_1_.func_226280_cw_();
        double d2 = p_i50220_1_.func_226281_cx_() - (double)f2 * 0.3;
        this.func_70012_b(d0, d1, d2, f1, f);
        Vector3d vector3d = new Vector3d(-f3, MathHelper.func_76131_a((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), -f2);
        double d3 = vector3d.func_72433_c();
        vector3d = vector3d.func_216372_d(0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045);
        this.func_213317_d(vector3d);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)MathHelper.func_76133_a((double)FishingBobberEntity.func_213296_b((Vector3d)vector3d))) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184528_c, 0);
        this.func_184212_Q().func_187214_a(field_234599_f_, false);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (field_184528_c.equals(key)) {
            int i = this.func_184212_Q().func_187225_a(field_184528_c);
            Entity entity = this.field_146043_c = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        if (field_234599_f_.equals(key)) {
            this.field_234597_c_ = this.func_184212_Q().func_187225_a(field_234599_f_);
            if (this.field_234597_c_) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.field_234596_b_, (float)0.6f, (float)1.0f), this.func_213322_ci().field_72449_c);
            }
        }
        super.func_184206_a(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0;
        return distance < 4096.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70071_h_() {
        this.field_234596_b_.setSeed(this.func_110124_au().getLeastSignificantBits() ^ this.field_70170_p.func_82737_E());
        super.func_70071_h_();
        PlayerEntity playerentity = this.func_234606_i_();
        if (playerentity == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.func_234600_a_(playerentity)) {
            boolean flag;
            if (this.field_70122_E) {
                ++this.field_146049_av;
                if (this.field_146049_av >= 1200) {
                    this.func_70106_y();
                    return;
                }
            } else {
                this.field_146049_av = 0;
            }
            float f = 0.0f;
            BlockPos blockpos = this.func_233580_cy_();
            FluidState fluidstate = this.field_70170_p.func_204610_c(blockpos);
            if (fluidstate.func_206884_a(FluidTags.field_206959_a)) {
                f = fluidstate.func_215679_a((IBlockReader)((Object)this.field_70170_p), blockpos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.field_190627_av == State.FLYING) {
                if (this.field_146043_c != null) {
                    this.func_213317_d(Vector3d.field_186680_a);
                    this.field_190627_av = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                    this.field_190627_av = State.BOBBING;
                    return;
                }
                this.func_190624_r();
            } else {
                if (this.field_190627_av == State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (this.field_146043_c.field_70128_L) {
                            this.field_146043_c = null;
                            this.field_190627_av = State.FLYING;
                        } else {
                            this.func_70107_b(this.field_146043_c.func_226277_ct_(), this.field_146043_c.func_226283_e_(0.8), this.field_146043_c.func_226281_cx_());
                        }
                    }
                    return;
                }
                if (this.field_190627_av == State.BOBBING) {
                    Vector3d vector3d = this.func_213322_ci();
                    double d0 = this.func_226278_cu_() + vector3d.field_72448_b - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.func_213293_j(vector3d.field_72450_a * 0.9, vector3d.field_72448_b - d0 * (double)this.field_70146_Z.nextFloat() * 0.2, vector3d.field_72449_c * 0.9);
                    if (this.field_146045_ax <= 0 && this.field_146038_az <= 0) {
                        this.field_234595_aq_ = true;
                    } else {
                        boolean bl2 = this.field_234595_aq_ = this.field_234595_aq_ && this.field_234598_d_ < 10 && this.func_234603_b_(blockpos);
                    }
                    if (flag) {
                        this.field_234598_d_ = Math.max(0, this.field_234598_d_ - 1);
                        if (this.field_234597_c_) {
                            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.1 * (double)this.field_234596_b_.nextFloat() * (double)this.field_234596_b_.nextFloat(), 0.0));
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            this.func_190621_a(blockpos);
                        }
                    } else {
                        this.field_234598_d_ = Math.min(10, this.field_234598_d_ + 1);
                    }
                }
            }
            if (!fluidstate.func_206884_a(FluidTags.field_206959_a)) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_234617_x_();
            if (this.field_190627_av == State.FLYING && (this.field_70122_E || this.field_70123_F)) {
                this.func_213317_d(Vector3d.field_186680_a);
            }
            double d1 = 0.92;
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.92));
            this.func_226264_Z_();
        }
    }

    private boolean func_234600_a_(PlayerEntity p_234600_1_) {
        ItemStack itemstack = p_234600_1_.func_184614_ca();
        ItemStack itemstack1 = p_234600_1_.func_184592_cb();
        boolean flag = itemstack.func_77973_b() instanceof FishingRodItem;
        boolean flag1 = itemstack1.func_77973_b() instanceof FishingRodItem;
        if (!p_234600_1_.field_70128_L && p_234600_1_.func_70089_S() && (flag || flag1) && !(this.func_70068_e(p_234600_1_) > 1024.0)) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void func_190624_r() {
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)((Object)this), this::func_230298_a_, RayTraceContext.BlockMode.COLLIDER);
        this.func_70227_a(raytraceresult);
    }

    protected boolean func_230298_a_(Entity p_230298_1_) {
        return super.func_230298_a_(p_230298_1_) || p_230298_1_.func_70089_S() && p_230298_1_ instanceof ItemEntity;
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        super.func_213868_a(p_213868_1_);
        if (!this.field_70170_p.field_72995_K) {
            this.field_146043_c = p_213868_1_.func_216348_a();
            this.func_190622_s();
        }
    }

    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        super.func_230299_a_(p_230299_1_);
        this.func_213317_d(this.func_213322_ci().func_72432_b().func_186678_a(p_230299_1_.func_237486_a_((Entity)((Object)this))));
    }

    private void func_190622_s() {
        this.func_184212_Q().func_187227_b(field_184528_c, this.field_146043_c.func_145782_y() + 1);
    }

    private void func_190621_a(BlockPos p_190621_1_) {
        ServerWorld serverworld = (ServerWorld)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = p_190621_1_.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_226660_f_(blockpos)) {
            --i;
        }
        if (this.field_146045_ax > 0) {
            --this.field_146045_ax;
            if (this.field_146045_ax <= 0) {
                this.field_146040_ay = 0;
                this.field_146038_az = 0;
                this.func_184212_Q().func_187227_b(field_234599_f_, false);
            }
        } else if (this.field_146038_az > 0) {
            this.field_146038_az -= i;
            if (this.field_146038_az > 0) {
                this.field_146054_aA = (float)((double)this.field_146054_aA + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.field_146054_aA * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.func_226277_ct_() + (double)(f1 * (float)this.field_146038_az * 0.1f);
                double d1 = (float)MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1.0f;
                double d2 = this.func_226281_cx_() + (double)(f2 * (float)this.field_146038_az * 0.1f);
                BlockState blockstate = serverworld.func_180495_p(new BlockPos(d0, d1 - 1.0, d2));
                if (serverworld.func_180495_p(new BlockPos((int)d0, (int)d1 - 1, (int)d2)).func_185904_a() == Material.field_151586_h) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        serverworld.func_195598_a(ParticleTypes.field_197612_e, d0, d1 - (double)0.1f, d2, 1, f1, 0.1, f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    serverworld.func_195598_a(ParticleTypes.field_197630_w, d0, d1, d2, 0, f4, 0.01, -f3, 1.0);
                    serverworld.func_195598_a(ParticleTypes.field_197630_w, d0, d1, d2, 0, -f4, 0.01, f3, 1.0);
                }
            } else {
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double d3 = this.func_226278_cu_() + 0.5;
                serverworld.func_195598_a(ParticleTypes.field_197612_e, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), this.func_213311_cf(), 0.0, this.func_213311_cf(), 0.2f);
                serverworld.func_195598_a(ParticleTypes.field_197630_w, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), this.func_213311_cf(), 0.0, this.func_213311_cf(), 0.2f);
                this.field_146045_ax = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
                this.func_184212_Q().func_187227_b(field_234599_f_, true);
            }
        } else if (this.field_146040_ay > 0) {
            this.field_146040_ay -= i;
            float f5 = 0.15f;
            if (this.field_146040_ay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.field_146040_ay) * 0.05);
            } else if (this.field_146040_ay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.field_146040_ay) * 0.02);
            } else if (this.field_146040_ay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.field_146040_ay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.func_226277_ct_() + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                double d5 = (float)MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1.0f;
                double d6 = this.func_226281_cx_() + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f);
                BlockState blockstate1 = serverworld.func_180495_p(new BlockPos(d4, d5 - 1.0, d6));
                if (serverworld.func_180495_p(new BlockPos(d4, d5 - 1.0, d6)).func_185904_a() == Material.field_151586_h) {
                    serverworld.func_195598_a(ParticleTypes.field_218422_X, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), 0.1f, 0.0, 0.1f, 0.0);
                }
            }
            if (this.field_146040_ay <= 0) {
                this.field_146054_aA = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.field_146038_az = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.field_146040_ay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.field_146040_ay -= this.field_191519_ax * 20 * 5;
        }
    }

    private boolean func_234603_b_(BlockPos p_234603_1_) {
        WaterType fishingbobberentity$watertype = WaterType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            WaterType fishingbobberentity$watertype1 = this.func_234602_a_(p_234603_1_.func_177982_a(-2, i, -2), p_234603_1_.func_177982_a(2, i, 2));
            switch (fishingbobberentity$watertype1) {
                case INVALID: {
                    return false;
                }
                case ABOVE_WATER: {
                    if (fishingbobberentity$watertype != WaterType.INVALID) break;
                    return false;
                }
                case INSIDE_WATER: {
                    if (fishingbobberentity$watertype != WaterType.ABOVE_WATER) break;
                    return false;
                }
            }
            fishingbobberentity$watertype = fishingbobberentity$watertype1;
        }
        return true;
    }

    private WaterType func_234602_a_(BlockPos p_234602_1_, BlockPos p_234602_2_) {
        return BlockPos.func_218281_b((BlockPos)p_234602_1_, (BlockPos)p_234602_2_).map(this::func_234604_c_).reduce((p_234601_0_, p_234601_1_) -> p_234601_0_ == p_234601_1_ ? p_234601_0_ : WaterType.INVALID).orElse(WaterType.INVALID);
    }

    private WaterType func_234604_c_(BlockPos p_234604_1_) {
        BlockState blockstate = this.field_70170_p.func_180495_p(p_234604_1_);
        if (!blockstate.func_196958_f() && !blockstate.func_203425_a(Blocks.field_196651_dG)) {
            FluidState fluidstate = blockstate.func_204520_s();
            return fluidstate.func_206884_a(FluidTags.field_206959_a) && fluidstate.func_206889_d() && blockstate.func_196952_d((IBlockReader)((Object)this.field_70170_p), p_234604_1_).func_197766_b() ? WaterType.INSIDE_WATER : WaterType.INVALID;
        }
        return WaterType.ABOVE_WATER;
    }

    public boolean func_234605_g_() {
        return this.field_234595_aq_;
    }

    public void func_213281_b(CompoundNBT compound) {
    }

    public void func_70037_a(CompoundNBT compound) {
    }

    public int func_146034_e(ItemStack p_146034_1_) {
        PlayerEntity playerentity = this.func_234606_i_();
        if (!this.field_70170_p.field_72995_K && playerentity != null) {
            int i = 0;
            ItemFishedEvent event = null;
            if (this.field_146043_c != null) {
                this.func_184527_k();
                CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)playerentity, p_146034_1_, this, Collections.emptyList());
                this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)31);
                i = this.field_146043_c instanceof ItemEntity ? 3 : 5;
            } else if (this.field_146045_ax > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_216286_f, this.func_233580_cy_()).func_216015_a(LootParameters.field_216289_i, p_146034_1_).func_216015_a(LootParameters.field_216281_a, this).func_216023_a(this.field_70146_Z).func_186469_a((float)this.field_191518_aw + playerentity.func_184817_da());
                lootcontext$builder.func_216015_a(LootParameters.field_216284_d, this.func_234616_v_()).func_216015_a(LootParameters.field_216281_a, this);
                LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
                List<ItemStack> list = loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216262_c));
                event = new ItemFishedEvent(list, this.field_70122_E ? 2 : 1, this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.func_70106_y();
                    return event.getRodDamage();
                }
                CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)playerentity, p_146034_1_, this, list);
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), itemstack);
                    double d0 = playerentity.func_226277_ct_() - this.func_226277_ct_();
                    double d1 = playerentity.func_226278_cu_() - this.func_226278_cu_();
                    double d2 = playerentity.func_226281_cx_() - this.func_226281_cx_();
                    double d3 = 0.1;
                    itementity.func_213293_j(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.field_70170_p.func_217376_c(itementity);
                    playerentity.field_70170_p.func_217376_c(new ExperienceOrbEntity(playerentity.field_70170_p, playerentity.func_226277_ct_(), playerentity.func_226278_cu_() + 0.5, playerentity.func_226281_cx_() + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    if (!itemstack.func_77973_b().func_206844_a(ItemTags.field_206964_G)) continue;
                    playerentity.func_195067_a(Stats.field_188071_E, 1);
                }
                i = 1;
            }
            if (this.field_70122_E) {
                i = 2;
            }
            this.func_70106_y();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 31 && this.field_70170_p.field_72995_K && this.field_146043_c instanceof PlayerEntity && ((PlayerEntity)this.field_146043_c).func_175144_cb()) {
            this.func_184527_k();
        }
        super.func_70103_a(id);
    }

    protected void func_184527_k() {
        Entity entity = this.func_234616_v_();
        if (entity != null) {
            Vector3d vector3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226278_cu_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_()).func_186678_a(0.1);
            this.field_146043_c.func_213317_d(this.field_146043_c.func_213322_ci().func_178787_e(vector3d));
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        PlayerEntity playerentity = this.func_234606_i_();
        if (playerentity != null) {
            playerentity.field_71104_cf = null;
        }
    }

    @Nullable
    public PlayerEntity func_234606_i_() {
        Entity entity = this.func_234616_v_();
        return entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
    }

    @Nullable
    public Entity func_234607_k_() {
        return this.field_146043_c;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public IPacket<?> func_213297_N() {
        Entity entity = this.func_234616_v_();
        return new SSpawnObjectPacket((Entity)((Object)this), entity == null ? this.func_145782_y() : entity.func_145782_y());
    }

    static enum WaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

