/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Pose;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeHooks;

public class DataSerializers {
    private static final IntIdentityHashBiMap<IDataSerializer<?>> field_187204_n = new IntIdentityHashBiMap(16);
    public static final IDataSerializer<Byte> field_187191_a = new IDataSerializer<Byte>(){

        public void func_187160_a(PacketBuffer buf, Byte value) {
            buf.writeByte(value.byteValue());
        }

        public Byte func_187159_a(PacketBuffer buf) {
            return buf.readByte();
        }

        public Byte func_192717_a(Byte value) {
            return value;
        }
    };
    public static final IDataSerializer<Integer> field_187192_b = new IDataSerializer<Integer>(){

        public void func_187160_a(PacketBuffer buf, Integer value) {
            buf.func_150787_b(value);
        }

        public Integer func_187159_a(PacketBuffer buf) {
            return buf.func_150792_a();
        }

        public Integer func_192717_a(Integer value) {
            return value;
        }
    };
    public static final IDataSerializer<Float> field_187193_c = new IDataSerializer<Float>(){

        public void func_187160_a(PacketBuffer buf, Float value) {
            buf.writeFloat(value.floatValue());
        }

        public Float func_187159_a(PacketBuffer buf) {
            return Float.valueOf(buf.readFloat());
        }

        public Float func_192717_a(Float value) {
            return value;
        }
    };
    public static final IDataSerializer<String> field_187194_d = new IDataSerializer<String>(){

        public void func_187160_a(PacketBuffer buf, String value) {
            buf.func_180714_a(value);
        }

        public String func_187159_a(PacketBuffer buf) {
            return buf.func_150789_c(Short.MAX_VALUE);
        }

        public String func_192717_a(String value) {
            return value;
        }
    };
    public static final IDataSerializer<ITextComponent> field_187195_e = new IDataSerializer<ITextComponent>(){

        public void func_187160_a(PacketBuffer buf, ITextComponent value) {
            buf.func_179256_a(value);
        }

        public ITextComponent func_187159_a(PacketBuffer buf) {
            return buf.func_179258_d();
        }

        public ITextComponent func_192717_a(ITextComponent value) {
            return value;
        }
    };
    public static final IDataSerializer<Optional<ITextComponent>> field_200544_f = new IDataSerializer<Optional<ITextComponent>>(){

        public void func_187160_a(PacketBuffer buf, Optional<ITextComponent> value) {
            if (value.isPresent()) {
                buf.writeBoolean(true);
                buf.func_179256_a(value.get());
            } else {
                buf.writeBoolean(false);
            }
        }

        public Optional<ITextComponent> func_187159_a(PacketBuffer buf) {
            return buf.readBoolean() ? Optional.of(buf.func_179258_d()) : Optional.empty();
        }

        public Optional<ITextComponent> func_192717_a(Optional<ITextComponent> value) {
            return value;
        }
    };
    public static final IDataSerializer<ItemStack> field_187196_f = new IDataSerializer<ItemStack>(){

        public void func_187160_a(PacketBuffer buf, ItemStack value) {
            buf.func_150788_a(value);
        }

        public ItemStack func_187159_a(PacketBuffer buf) {
            return buf.func_150791_c();
        }

        public ItemStack func_192717_a(ItemStack value) {
            return value.func_77946_l();
        }
    };
    public static final IDataSerializer<Optional<BlockState>> field_187197_g = new IDataSerializer<Optional<BlockState>>(){

        public void func_187160_a(PacketBuffer buf, Optional<BlockState> value) {
            if (value.isPresent()) {
                buf.func_150787_b(Block.func_196246_j(value.get()));
            } else {
                buf.func_150787_b(0);
            }
        }

        public Optional<BlockState> func_187159_a(PacketBuffer buf) {
            int i = buf.func_150792_a();
            return i == 0 ? Optional.empty() : Optional.of(Block.func_196257_b(i));
        }

        public Optional<BlockState> func_192717_a(Optional<BlockState> value) {
            return value;
        }
    };
    public static final IDataSerializer<Boolean> field_187198_h = new IDataSerializer<Boolean>(){

        public void func_187160_a(PacketBuffer buf, Boolean value) {
            buf.writeBoolean(value);
        }

        public Boolean func_187159_a(PacketBuffer buf) {
            return buf.readBoolean();
        }

        public Boolean func_192717_a(Boolean value) {
            return value;
        }
    };
    public static final IDataSerializer<IParticleData> field_198166_i = new IDataSerializer<IParticleData>(){

        public void func_187160_a(PacketBuffer buf, IParticleData value) {
            buf.func_150787_b(Registry.field_212632_u.func_148757_b(value.func_197554_b()));
            value.func_197553_a(buf);
        }

        public IParticleData func_187159_a(PacketBuffer buf) {
            return this.func_200543_a(buf, (ParticleType)((Object)Registry.field_212632_u.func_148745_a(buf.func_150792_a())));
        }

        private <T extends IParticleData> T func_200543_a(PacketBuffer p_200543_1_, ParticleType<T> p_200543_2_) {
            return (T)p_200543_2_.func_197571_g().func_197543_b(p_200543_2_, p_200543_1_);
        }

        public IParticleData func_192717_a(IParticleData value) {
            return value;
        }
    };
    public static final IDataSerializer<Rotations> field_187199_i = new IDataSerializer<Rotations>(){

        public void func_187160_a(PacketBuffer buf, Rotations value) {
            buf.writeFloat(value.func_179415_b());
            buf.writeFloat(value.func_179416_c());
            buf.writeFloat(value.func_179413_d());
        }

        public Rotations func_187159_a(PacketBuffer buf) {
            return new Rotations(buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        public Rotations func_192717_a(Rotations value) {
            return value;
        }
    };
    public static final IDataSerializer<BlockPos> field_187200_j = new IDataSerializer<BlockPos>(){

        public void func_187160_a(PacketBuffer buf, BlockPos value) {
            buf.func_179255_a(value);
        }

        public BlockPos func_187159_a(PacketBuffer buf) {
            return buf.func_179259_c();
        }

        public BlockPos func_192717_a(BlockPos value) {
            return value;
        }
    };
    public static final IDataSerializer<Optional<BlockPos>> field_187201_k = new IDataSerializer<Optional<BlockPos>>(){

        public void func_187160_a(PacketBuffer buf, Optional<BlockPos> value) {
            buf.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                buf.func_179255_a(value.get());
            }
        }

        public Optional<BlockPos> func_187159_a(PacketBuffer buf) {
            return !buf.readBoolean() ? Optional.empty() : Optional.of(buf.func_179259_c());
        }

        public Optional<BlockPos> func_192717_a(Optional<BlockPos> value) {
            return value;
        }
    };
    public static final IDataSerializer<Direction> field_187202_l = new IDataSerializer<Direction>(){

        public void func_187160_a(PacketBuffer buf, Direction value) {
            buf.func_179249_a(value);
        }

        public Direction func_187159_a(PacketBuffer buf) {
            return buf.func_179257_a(Direction.class);
        }

        public Direction func_192717_a(Direction value) {
            return value;
        }
    };
    public static final IDataSerializer<Optional<UUID>> field_187203_m = new IDataSerializer<Optional<UUID>>(){

        public void func_187160_a(PacketBuffer buf, Optional<UUID> value) {
            buf.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                buf.func_179252_a(value.get());
            }
        }

        public Optional<UUID> func_187159_a(PacketBuffer buf) {
            return !buf.readBoolean() ? Optional.empty() : Optional.of(buf.func_179253_g());
        }

        public Optional<UUID> func_192717_a(Optional<UUID> value) {
            return value;
        }
    };
    public static final IDataSerializer<CompoundNBT> field_192734_n = new IDataSerializer<CompoundNBT>(){

        public void func_187160_a(PacketBuffer buf, CompoundNBT value) {
            buf.func_150786_a(value);
        }

        public CompoundNBT func_187159_a(PacketBuffer buf) {
            return buf.func_150793_b();
        }

        public CompoundNBT func_192717_a(CompoundNBT value) {
            return value.func_74737_b();
        }
    };
    public static final IDataSerializer<VillagerData> field_218813_q = new IDataSerializer<VillagerData>(){

        public void func_187160_a(PacketBuffer buf, VillagerData value) {
            buf.func_150787_b(Registry.field_218369_K.func_148757_b((Object)value.func_221129_a()));
            buf.func_150787_b(Registry.field_218370_L.func_148757_b((Object)value.func_221130_b()));
            buf.func_150787_b(value.func_221132_c());
        }

        public VillagerData func_187159_a(PacketBuffer buf) {
            return new VillagerData((IVillagerType)Registry.field_218369_K.func_148745_a(buf.func_150792_a()), (VillagerProfession)((Object)Registry.field_218370_L.func_148745_a(buf.func_150792_a())), buf.func_150792_a());
        }

        public VillagerData func_192717_a(VillagerData value) {
            return value;
        }
    };
    public static final IDataSerializer<OptionalInt> field_218814_r = new IDataSerializer<OptionalInt>(){

        public void func_187160_a(PacketBuffer buf, OptionalInt value) {
            buf.func_150787_b(value.orElse(-1) + 1);
        }

        public OptionalInt func_187159_a(PacketBuffer buf) {
            int i = buf.func_150792_a();
            return i == 0 ? OptionalInt.empty() : OptionalInt.of(i - 1);
        }

        public OptionalInt func_192717_a(OptionalInt value) {
            return value;
        }
    };
    public static final IDataSerializer<Pose> field_218815_s = new IDataSerializer<Pose>(){

        public void func_187160_a(PacketBuffer buf, Pose value) {
            buf.func_179249_a((Enum<?>)value);
        }

        public Pose func_187159_a(PacketBuffer buf) {
            return buf.func_179257_a(Pose.class);
        }

        public Pose func_192717_a(Pose value) {
            return value;
        }
    };

    public static void func_187189_a(IDataSerializer<?> serializer) {
        if (field_187204_n.func_186808_c(serializer) >= 256) {
            throw new RuntimeException("Vanilla DataSerializer ID limit exceeded");
        }
    }

    @Nullable
    public static IDataSerializer<?> func_187190_a(int id) {
        return ForgeHooks.getSerializer((int)id, field_187204_n);
    }

    public static int func_187188_b(IDataSerializer<?> serializer) {
        return ForgeHooks.getSerializerId(serializer, field_187204_n);
    }

    static {
        DataSerializers.func_187189_a(field_187191_a);
        DataSerializers.func_187189_a(field_187192_b);
        DataSerializers.func_187189_a(field_187193_c);
        DataSerializers.func_187189_a(field_187194_d);
        DataSerializers.func_187189_a(field_187195_e);
        DataSerializers.func_187189_a(field_200544_f);
        DataSerializers.func_187189_a(field_187196_f);
        DataSerializers.func_187189_a(field_187198_h);
        DataSerializers.func_187189_a(field_187199_i);
        DataSerializers.func_187189_a(field_187200_j);
        DataSerializers.func_187189_a(field_187201_k);
        DataSerializers.func_187189_a(field_187202_l);
        DataSerializers.func_187189_a(field_187203_m);
        DataSerializers.func_187189_a(field_187197_g);
        DataSerializers.func_187189_a(field_192734_n);
        DataSerializers.func_187189_a(field_198166_i);
        DataSerializers.func_187189_a(field_218813_q);
        DataSerializers.func_187189_a(field_218814_r);
        DataSerializers.func_187189_a(field_218815_s);
    }
}

