/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FallbackResourceManager
implements IResourceManager {
    private static final Logger field_199024_b = LogManager.getLogger();
    public final List<IResourcePack> field_199023_a = Lists.newArrayList();
    private final ResourcePackType field_199025_c;
    private final String field_230027_d;

    public FallbackResourceManager(ResourcePackType p_i226096_1_, String p_i226096_2_) {
        this.field_199025_c = p_i226096_1_;
        this.field_230027_d = p_i226096_2_;
    }

    public void func_199021_a(IResourcePack resourcePack) {
        this.field_199023_a.add(resourcePack);
    }

    @Override
    public Set<String> func_199001_a() {
        return ImmutableSet.of((Object)this.field_230027_d);
    }

    @Override
    public IResource func_199002_a(ResourceLocation resourceLocationIn) throws IOException {
        this.func_199022_d(resourceLocationIn);
        IResourcePack iresourcepack = null;
        ResourceLocation resourcelocation = FallbackResourceManager.func_199020_c(resourceLocationIn);
        for (int i = this.field_199023_a.size() - 1; i >= 0; --i) {
            IResourcePack iresourcepack1 = this.field_199023_a.get(i);
            if (iresourcepack == null && iresourcepack1.func_195764_b(this.field_199025_c, resourcelocation)) {
                iresourcepack = iresourcepack1;
            }
            if (!iresourcepack1.func_195764_b(this.field_199025_c, resourceLocationIn)) continue;
            InputStream inputstream = null;
            if (iresourcepack != null) {
                inputstream = this.func_199019_a(resourcelocation, iresourcepack);
            }
            return new SimpleResource(iresourcepack1.func_195762_a(), resourceLocationIn, this.func_199019_a(resourceLocationIn, iresourcepack1), inputstream);
        }
        throw new FileNotFoundException(resourceLocationIn.toString());
    }

    @Override
    public boolean func_219533_b(ResourceLocation p_219533_1_) {
        if (!this.func_219541_f(p_219533_1_)) {
            return false;
        }
        for (int i = this.field_199023_a.size() - 1; i >= 0; --i) {
            IResourcePack iresourcepack = this.field_199023_a.get(i);
            if (!iresourcepack.func_195764_b(this.field_199025_c, p_219533_1_)) continue;
            return true;
        }
        return false;
    }

    protected InputStream func_199019_a(ResourceLocation location, IResourcePack resourcePack) throws IOException {
        InputStream inputstream = resourcePack.func_195761_a(this.field_199025_c, location);
        return field_199024_b.isDebugEnabled() ? new LeakComplainerInputStream(inputstream, location, resourcePack.func_195762_a()) : inputstream;
    }

    private void func_199022_d(ResourceLocation location) throws IOException {
        if (!this.func_219541_f(location)) {
            throw new IOException("Invalid relative path to resource: " + location);
        }
    }

    private boolean func_219541_f(ResourceLocation p_219541_1_) {
        return !p_219541_1_.func_110623_a().contains("..");
    }

    @Override
    public List<IResource> func_199004_b(ResourceLocation resourceLocationIn) throws IOException {
        this.func_199022_d(resourceLocationIn);
        ArrayList list = Lists.newArrayList();
        ResourceLocation resourcelocation = FallbackResourceManager.func_199020_c(resourceLocationIn);
        for (IResourcePack iresourcepack : this.field_199023_a) {
            if (!iresourcepack.func_195764_b(this.field_199025_c, resourceLocationIn)) continue;
            InputStream inputstream = iresourcepack.func_195764_b(this.field_199025_c, resourcelocation) ? this.func_199019_a(resourcelocation, iresourcepack) : null;
            list.add(new SimpleResource(iresourcepack.func_195762_a(), resourceLocationIn, this.func_199019_a(resourceLocationIn, iresourcepack), inputstream));
        }
        if (list.isEmpty()) {
            throw new FileNotFoundException(resourceLocationIn.toString());
        }
        return list;
    }

    @Override
    public Collection<ResourceLocation> func_230231_a_(ResourceLocation p_230231_1_, Predicate<String> p_230231_2_) {
        return Objects.equals(p_230231_1_.func_110624_b(), this.field_230027_d) ? this.func_199003_a(p_230231_1_.func_110623_a(), p_230231_2_) : ImmutableSet.of();
    }

    @Override
    public Collection<ResourceLocation> func_199003_a(String pathIn, Predicate<String> filter) {
        ArrayList list = Lists.newArrayList();
        for (IResourcePack iresourcepack : this.field_199023_a) {
            list.addAll(iresourcepack.func_225637_a_(this.field_199025_c, this.field_230027_d, pathIn, Integer.MAX_VALUE, filter));
        }
        Collections.sort(list);
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Stream<IResourcePack> func_230232_b_() {
        return this.field_199023_a.stream();
    }

    static ResourceLocation func_199020_c(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".mcmeta");
    }

    static class LeakComplainerInputStream
    extends FilterInputStream {
        private final String field_198999_b;
        private boolean field_199000_c;

        public LeakComplainerInputStream(InputStream inputStreamIn, ResourceLocation location, String resourcePack) {
            super(inputStreamIn);
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(bytearrayoutputstream));
            this.field_198999_b = "Leaked resource: '" + location + "' loaded from pack: '" + resourcePack + "'\n" + bytearrayoutputstream;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.field_199000_c = true;
        }

        protected void finalize() throws Throwable {
            if (!this.field_199000_c) {
                field_199024_b.warn(this.field_198999_b);
            }
            super.finalize();
        }
    }
}

