/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.data.IOptionalTagEntry;

public interface ITag<T> {
    public static <T> Codec<ITag<T>> func_232947_a_(Supplier<TagCollection<T>> p_232947_0_) {
        return ResourceLocation.field_240908_a_.flatXmap(p_232949_1_ -> Optional.ofNullable(((TagCollection)p_232947_0_.get()).func_199910_a((ResourceLocation)p_232949_1_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + p_232949_1_))), p_232948_1_ -> Optional.ofNullable(((TagCollection)p_232947_0_.get()).func_232973_a_(p_232948_1_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + p_232948_1_))));
    }

    public boolean func_230235_a_(T var1);

    public List<T> func_230236_b_();

    default public T func_205596_a(Random random) {
        List<T> list = this.func_230236_b_();
        return list.get(random.nextInt(list.size()));
    }

    public static <T> ITag<T> func_232946_a_(Set<T> p_232946_0_) {
        return Tag.func_241286_a_(p_232946_0_);
    }

    public static class TagEntry
    implements ITagEntry {
        private final ResourceLocation field_200163_a;

        public TagEntry(ResourceLocation resourceLocationIn) {
            this.field_200163_a = resourceLocationIn;
        }

        @Override
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> p_230238_1_, Function<ResourceLocation, T> p_230238_2_, Consumer<T> p_230238_3_) {
            ITag<T> itag = p_230238_1_.apply(this.field_200163_a);
            if (itag == null) {
                return false;
            }
            itag.func_230236_b_().forEach(p_230238_3_);
            return true;
        }

        @Override
        public void func_230237_a_(JsonArray p_230237_1_) {
            p_230237_1_.add("#" + this.field_200163_a);
        }

        public String toString() {
            return "#" + this.field_200163_a;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof TagEntry && Objects.equals(this.field_200163_a, ((TagEntry)o).field_200163_a);
        }
    }

    public static class Proxy {
        private final ITagEntry field_232966_a_;
        private final String field_232967_b_;

        private Proxy(ITagEntry p_i231433_1_, String p_i231433_2_) {
            this.field_232966_a_ = p_i231433_1_;
            this.field_232967_b_ = p_i231433_2_;
        }

        public ITagEntry func_232968_a_() {
            return this.field_232966_a_;
        }

        public String toString() {
            return this.field_232966_a_.toString() + " (from " + this.field_232967_b_ + ")";
        }
    }

    public static class ItemEntry
    implements ITagEntry {
        private final ResourceLocation field_232969_a_;

        public ItemEntry(ResourceLocation p_i231435_1_) {
            this.field_232969_a_ = p_i231435_1_;
        }

        @Override
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> p_230238_1_, Function<ResourceLocation, T> p_230238_2_, Consumer<T> p_230238_3_) {
            T t = p_230238_2_.apply(this.field_232969_a_);
            if (t == null) {
                return false;
            }
            p_230238_3_.accept(t);
            return true;
        }

        @Override
        public void func_230237_a_(JsonArray p_230237_1_) {
            p_230237_1_.add(this.field_232969_a_.toString());
        }

        public String toString() {
            return this.field_232969_a_.toString();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ItemEntry && Objects.equals(this.field_232969_a_, ((ItemEntry)o).field_232969_a_);
        }
    }

    public static interface ITagEntry {
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> var1, Function<ResourceLocation, T> var2, Consumer<T> var3);

        public void func_230237_a_(JsonArray var1);
    }

    public static interface INamedTag<T>
    extends ITag<T> {
        public ResourceLocation func_230234_a_();
    }

    public static class Builder {
        private final List<Proxy> field_232953_a_ = Lists.newArrayList();
        private boolean replace = false;

        public static Builder func_200047_a() {
            return new Builder();
        }

        public Builder func_232954_a_(Proxy p_232954_1_) {
            this.field_232953_a_.add(p_232954_1_);
            return this;
        }

        public Builder func_232955_a_(ITagEntry p_232955_1_, String p_232955_2_) {
            return this.func_232954_a_(new Proxy(p_232955_1_, p_232955_2_));
        }

        public Builder func_232961_a_(ResourceLocation p_232961_1_, String p_232961_2_) {
            return this.func_232955_a_(new ItemEntry(p_232961_1_), p_232961_2_);
        }

        public Builder func_232964_b_(ResourceLocation p_232964_1_, String p_232964_2_) {
            return this.func_232955_a_(new TagEntry(p_232964_1_), p_232964_2_);
        }

        public Builder replace(boolean value) {
            this.replace = value;
            return this;
        }

        public Builder replace() {
            return this.replace(true);
        }

        public <T> Optional<ITag<T>> func_232959_a_(Function<ResourceLocation, ITag<T>> p_232959_1_, Function<ResourceLocation, T> p_232959_2_) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Proxy itag$proxy : this.field_232953_a_) {
                if (itag$proxy.func_232968_a_().func_230238_a_(p_232959_1_, p_232959_2_, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0))) continue;
                return Optional.empty();
            }
            return Optional.of(ITag.func_232946_a_(builder.build()));
        }

        public Stream<Proxy> func_232962_b_() {
            return this.field_232953_a_.stream();
        }

        public <T> Stream<Proxy> func_232963_b_(Function<ResourceLocation, ITag<T>> p_232963_1_, Function<ResourceLocation, T> p_232963_2_) {
            return this.func_232962_b_().filter(p_232960_2_ -> !p_232960_2_.func_232968_a_().func_230238_a_(p_232963_1_, p_232963_2_, p_232957_0_ -> {}));
        }

        public Builder func_232956_a_(JsonObject p_232956_1_, String p_232956_2_) {
            JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)p_232956_1_, (String)"values");
            ArrayList list = Lists.newArrayList();
            for (JsonElement jsonelement : jsonarray) {
                String s = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)"value");
                if (s.startsWith("#")) {
                    list.add(new TagEntry(new ResourceLocation(s.substring(1))));
                    continue;
                }
                list.add(new ItemEntry(new ResourceLocation(s)));
            }
            if (JSONUtils.func_151209_a((JsonObject)p_232956_1_, (String)"replace", (boolean)false)) {
                this.field_232953_a_.clear();
            }
            ForgeHooks.deserializeTagAdditions((List)list, (JsonObject)p_232956_1_, this.field_232953_a_);
            list.forEach(p_232958_2_ -> this.field_232953_a_.add(new Proxy((ITagEntry)p_232958_2_, p_232956_2_)));
            return this;
        }

        public JsonObject func_232965_c_() {
            JsonObject jsonobject = new JsonObject();
            JsonArray jsonarray = new JsonArray();
            for (Proxy itag$proxy : this.field_232953_a_) {
                if (itag$proxy.field_232966_a_ instanceof IOptionalTagEntry) continue;
                itag$proxy.func_232968_a_().func_230237_a_(jsonarray);
            }
            JsonArray optopnals = new JsonArray();
            this.func_232962_b_().map(e -> ((Proxy)e).field_232966_a_).filter(e -> e instanceof IOptionalTagEntry).forEach(e -> e.func_230237_a_(optopnals));
            jsonobject.addProperty("replace", Boolean.valueOf(this.replace));
            jsonobject.add("values", (JsonElement)jsonarray);
            if (optopnals.size() > 0) {
                jsonobject.add("optional", (JsonElement)optopnals);
            }
            return jsonobject;
        }
    }
}

