/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagCollection<T> {
    private static final Logger field_199918_a = LogManager.getLogger();
    private static final Gson field_199919_b = new Gson();
    private static final int field_199920_c = ".json".length();
    private final ITag<T> field_232970_d_ = Tag.func_241284_a_();
    private volatile BiMap<ResourceLocation, ITag<T>> field_199921_d = HashBiMap.create();
    private final Function<ResourceLocation, Optional<T>> field_200040_e;
    private final String field_199923_f;
    private final String field_200157_i;

    public TagCollection(Function<ResourceLocation, Optional<T>> p_i231436_1_, String p_i231436_2_, String p_i231436_3_) {
        this.field_200040_e = p_i231436_1_;
        this.field_199923_f = p_i231436_2_;
        this.field_200157_i = p_i231436_3_;
    }

    @Nullable
    public ITag<T> func_199910_a(ResourceLocation resourceLocationIn) {
        return (ITag)this.field_199921_d.get((Object)resourceLocationIn);
    }

    public ITag<T> func_199915_b(ResourceLocation resourceLocationIn) {
        return (ITag)this.field_199921_d.getOrDefault((Object)resourceLocationIn, this.field_232970_d_);
    }

    @Nullable
    public ResourceLocation func_232973_a_(ITag<T> p_232973_1_) {
        return p_232973_1_ instanceof ITag.INamedTag ? ((ITag.INamedTag)p_232973_1_).func_230234_a_() : (ResourceLocation)this.field_199921_d.inverse().get(p_232973_1_);
    }

    public ResourceLocation func_232975_b_(ITag<T> p_232975_1_) {
        ResourceLocation resourcelocation = this.func_232973_a_(p_232975_1_);
        if (resourcelocation == null) {
            throw new IllegalStateException("Unrecognized tag");
        }
        return resourcelocation;
    }

    public Collection<ResourceLocation> func_199908_a() {
        return this.field_199921_d.keySet();
    }

    public Collection<ResourceLocation> func_199913_a(T itemIn) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry entry : this.field_199921_d.entrySet()) {
            if (!((ITag)entry.getValue()).func_230235_a_(itemIn)) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    public CompletableFuture<Map<ResourceLocation, ITag.Builder>> func_219781_a(IResourceManager p_219781_1_, Executor p_219781_2_) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap map = Maps.newHashMap();
            for (ResourceLocation resourcelocation : p_219781_1_.func_199003_a(this.field_199923_f, p_199916_0_ -> p_199916_0_.endsWith(".json"))) {
                String s = resourcelocation.func_110623_a();
                ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), s.substring(this.field_199923_f.length() + 1, s.length() - field_199920_c));
                try {
                    for (IResource iresource : p_219781_1_.func_199004_b(resourcelocation)) {
                        try {
                            InputStream inputstream = iresource.func_199027_b();
                            Throwable throwable = null;
                            try {
                                BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                                Throwable throwable2 = null;
                                try {
                                    JsonObject jsonobject = (JsonObject)JSONUtils.func_193839_a((Gson)field_199919_b, (Reader)reader, JsonObject.class);
                                    if (jsonobject == null) {
                                        field_199918_a.error("Couldn't load {} tag list {} from {} in data pack {} as it is empty or null", (Object)this.field_200157_i, (Object)resourcelocation1, (Object)resourcelocation, (Object)iresource.func_199026_d());
                                        continue;
                                    }
                                    map.computeIfAbsent(resourcelocation1, p_232977_0_ -> ITag.Builder.func_200047_a()).func_232956_a_(jsonobject, iresource.func_199026_d());
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (reader == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            ((Reader)reader).close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    ((Reader)reader).close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (inputstream == null) continue;
                                if (throwable != null) {
                                    try {
                                        inputstream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                inputstream.close();
                            }
                        }
                        catch (IOException | RuntimeException ioexception) {
                            field_199918_a.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)this.field_200157_i, (Object)resourcelocation1, (Object)resourcelocation, (Object)iresource.func_199026_d(), (Object)ioexception);
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)iresource);
                        }
                    }
                }
                catch (IOException ioexception1) {
                    field_199918_a.error("Couldn't read {} tag list {} from {}", (Object)this.field_200157_i, (Object)resourcelocation1, (Object)resourcelocation, (Object)ioexception1);
                }
            }
            return map;
        }, p_219781_2_);
    }

    public void func_219779_a(Map<ResourceLocation, ITag.Builder> p_219779_1_) {
        HashMap map = Maps.newHashMap();
        Function function = map::get;
        Function<ResourceLocation, Object> function1 = p_232976_1_ -> this.field_200040_e.apply((ResourceLocation)p_232976_1_).orElse(null);
        while (!p_219779_1_.isEmpty()) {
            boolean flag = false;
            Iterator<Map.Entry<ResourceLocation, ITag.Builder>> iterator = p_219779_1_.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, ITag.Builder> entry = iterator.next();
                Optional<ITag<Object>> optional = entry.getValue().func_232959_a_(function, function1);
                if (!optional.isPresent()) continue;
                map.put(entry.getKey(), optional.get());
                iterator.remove();
                flag = true;
            }
            if (flag) continue;
            break;
        }
        p_219779_1_.forEach((p_223505_3_, p_223505_4_) -> field_199918_a.error("Couldn't load {} tag {} as it is missing following references: {}", (Object)this.field_200157_i, p_223505_3_, (Object)p_223505_4_.func_232963_b_(function, function1).map(Objects::toString).collect(Collectors.joining(","))));
        this.func_223507_b(map);
    }

    protected void func_223507_b(Map<ResourceLocation, ITag<T>> p_223507_1_) {
        this.field_199921_d = ImmutableBiMap.copyOf(p_223507_1_);
    }

    public Map<ResourceLocation, ITag<T>> func_200039_c() {
        return this.field_199921_d;
    }

    public Function<ResourceLocation, Optional<T>> getEntryLookup() {
        return this.field_200040_e;
    }
}

