/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.server.LanguageHook;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LanguageMap {
    private static final Logger field_201045_a = LogManager.getLogger();
    private static final Gson field_240591_b_ = new Gson();
    private static final Pattern field_111053_a = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");
    private static volatile LanguageMap field_240592_d_ = LanguageMap.func_240595_c_();

    private static LanguageMap func_240595_c_() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BiConsumer<String, String> biconsumer = (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1);
        try (InputStream inputstream = LanguageMap.class.getResourceAsStream("/assets/minecraft/lang/en_us.json");){
            LanguageMap.func_240593_a_(inputstream, biconsumer);
        }
        catch (JsonParseException | IOException ioexception) {
            field_201045_a.error("Couldn't read strings from /assets/minecraft/lang/en_us.json", ioexception);
        }
        final HashMap map = new HashMap(builder.build());
        LanguageHook.captureLanguageMap(map);
        return new LanguageMap(){

            @Override
            public String func_230503_a_(String p_230503_1_) {
                return map.getOrDefault(p_230503_1_, p_230503_1_);
            }

            @Override
            public boolean func_230506_b_(String p_230506_1_) {
                return map.containsKey(p_230506_1_);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public boolean func_230505_b_() {
                return false;
            }

            @Override
            public String func_230504_a_(String p_230504_1_, boolean p_230504_2_) {
                return p_230504_1_;
            }

            @Override
            public Map<String, String> getLanguageData() {
                return map;
            }
        };
    }

    public static void func_240593_a_(InputStream p_240593_0_, BiConsumer<String, String> p_240593_1_) {
        JsonObject jsonobject = (JsonObject)field_240591_b_.fromJson((Reader)new InputStreamReader(p_240593_0_, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry entry : jsonobject.entrySet()) {
            String s = field_111053_a.matcher(JSONUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()))).replaceAll("%$1s");
            p_240593_1_.accept((String)entry.getKey(), s);
        }
    }

    public static LanguageMap func_74808_a() {
        return field_240592_d_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_240594_a_(LanguageMap p_240594_0_) {
        field_240592_d_ = p_240594_0_;
    }

    public abstract String func_230503_a_(String var1);

    public abstract boolean func_230506_b_(String var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract boolean func_230505_b_();

    public abstract String func_230504_a_(String var1, boolean var2);

    public Map<String, String> getLanguageData() {
        return ImmutableMap.of();
    }
}

