/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Biome
extends ForgeRegistryEntry<Biome> {
    public static final Logger field_150586_aC = LogManager.getLogger();
    public static final Codec<Biome> field_235051_b_ = RecordCodecBuilder.create(p_235064_0_ -> p_235064_0_.group((App)RainType.field_235121_d_.fieldOf("precipitation").forGetter(p_235088_0_ -> p_235088_0_.field_201878_av), (App)Category.field_235102_r_.fieldOf("category").forGetter(p_235087_0_ -> p_235087_0_.field_201877_au), (App)Codec.FLOAT.fieldOf("depth").forGetter(p_235086_0_ -> Float.valueOf(p_235086_0_.field_76748_D)), (App)Codec.FLOAT.fieldOf("scale").forGetter(p_235085_0_ -> Float.valueOf(p_235085_0_.field_76749_E)), (App)Codec.FLOAT.fieldOf("temperature").forGetter(p_235084_0_ -> Float.valueOf(p_235084_0_.field_76750_F)), (App)Codec.FLOAT.fieldOf("downfall").forGetter(p_235083_0_ -> Float.valueOf(p_235083_0_.field_76751_G)), (App)BiomeAmbience.field_235204_a_.fieldOf("effects").forGetter(p_235082_0_ -> p_235082_0_.field_235052_p_), (App)Codec.INT.fieldOf("sky_color").forGetter(p_235081_0_ -> p_235081_0_.field_229978_u_), (App)ConfiguredSurfaceBuilder.field_237168_a_.fieldOf("surface_builder").forGetter(p_235079_0_ -> p_235079_0_.field_201875_ar), (App)Codec.simpleMap((Codec)GenerationStage.Carving.field_236074_c_, (Codec)ConfiguredCarver.field_236235_a_.listOf().promotePartial(Util.func_240982_a_((String)"Carver: ", arg_0 -> ((Logger)field_150586_aC).error(arg_0))), (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])GenerationStage.Carving.values())).fieldOf("carvers").forGetter(p_235078_0_ -> p_235078_0_.field_201871_ag), (App)Codec.simpleMap((Codec)GenerationStage.Decoration.field_236076_k_, (Codec)ConfiguredFeature.field_236264_b_.listOf().promotePartial(Util.func_240982_a_((String)"Feature: ", arg_0 -> ((Logger)field_150586_aC).error(arg_0))), (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])GenerationStage.Decoration.values())).fieldOf("features").forGetter(p_235076_0_ -> p_235076_0_.field_201872_ah), (App)StructureFeature.field_236267_a_.listOf().promotePartial(Util.func_240982_a_((String)"Structure start: ", arg_0 -> ((Logger)field_150586_aC).error(arg_0))).fieldOf("starts").forGetter(p_235075_0_ -> p_235075_0_.field_201874_aj.values().stream().sorted(Comparator.comparing(p_235074_0_ -> Registry.field_218361_B.func_177774_c(p_235074_0_.field_236268_b_))).collect(Collectors.toList())), (App)Codec.simpleMap(EntityClassification.field_233667_g_, (Codec)SpawnListEntry.field_235123_b_.listOf().promotePartial(Util.func_240982_a_((String)"Spawn data: ", arg_0 -> ((Logger)field_150586_aC).error(arg_0))), (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])EntityClassification.values())).fieldOf("spawners").forGetter(p_235073_0_ -> p_235073_0_.field_201880_ax), (App)Attributes.field_235104_a_.listOf().fieldOf("climate_parameters").forGetter(p_235070_0_ -> p_235070_0_.field_235054_x_), (App)Codec.STRING.optionalFieldOf("parent").forGetter(p_235065_0_ -> Optional.ofNullable(p_235065_0_.field_185364_H))).apply((Applicative)p_235064_0_, Biome::new));
    public static final Set<Biome> field_201870_ab = Sets.newHashSet();
    public static final ObjectIntIdentityMap<Biome> field_185373_j = new ObjectIntIdentityMap();
    protected static final PerlinNoiseGenerator field_150605_ac = new PerlinNoiseGenerator(new SharedSeedRandom(1234L), (List)ImmutableList.of((Object)0));
    public static final PerlinNoiseGenerator field_180281_af = new PerlinNoiseGenerator(new SharedSeedRandom(2345L), (List)ImmutableList.of((Object)0));
    @Nullable
    protected String field_205405_aL;
    protected final float field_76748_D;
    protected final float field_76749_E;
    protected final float field_76750_F;
    protected final float field_76751_G;
    private final int field_229978_u_;
    @Nullable
    protected final String field_185364_H;
    protected final ConfiguredSurfaceBuilder<?> field_201875_ar;
    protected final Category field_201877_au;
    protected final RainType field_201878_av;
    protected final BiomeAmbience field_235052_p_;
    protected final Map<GenerationStage.Carving, List<ConfiguredCarver<?>>> field_201871_ag;
    protected final Map<GenerationStage.Decoration, List<ConfiguredFeature<?, ?>>> field_201872_ah;
    protected final List<ConfiguredFeature<?, ?>> field_201873_ai = Lists.newArrayList();
    private final Map<Structure<?>, StructureFeature<?, ?>> field_201874_aj;
    private final Map<EntityClassification, List<SpawnListEntry>> field_201880_ax;
    private final Map<EntityType<?>, EntityDensity> field_235053_w_ = Maps.newHashMap();
    private final List<Attributes> field_235054_x_;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> field_225488_v = ThreadLocal.withInitial(() -> (Long2FloatLinkedOpenHashMap)Util.func_199748_a(() -> {
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int p_rehash_1_) {
            }
        };
        long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
        return long2floatlinkedopenhashmap;
    }));

    @Nullable
    public static Biome func_185356_b(Biome biome) {
        return (Biome)((Object)field_185373_j.func_148745_a(Registry.field_212624_m.func_148757_b(biome)));
    }

    public static <C extends ICarverConfig> ConfiguredCarver<C> func_203606_a(WorldCarver<C> carver, C config) {
        return new ConfiguredCarver(carver, config);
    }

    protected Biome(Builder biomeBuilder) {
        if (biomeBuilder.field_205422_a != null && biomeBuilder.field_205423_b != null && biomeBuilder.field_205424_c != null && biomeBuilder.field_205425_d != null && biomeBuilder.field_205426_e != null && biomeBuilder.field_205427_f != null && biomeBuilder.field_205428_g != null && biomeBuilder.field_235096_j_ != null) {
            this.field_201875_ar = biomeBuilder.field_205422_a;
            this.field_201878_av = biomeBuilder.field_205423_b;
            this.field_201877_au = biomeBuilder.field_205424_c;
            this.field_76748_D = biomeBuilder.field_205425_d.floatValue();
            this.field_76749_E = biomeBuilder.field_205426_e.floatValue();
            this.field_76750_F = biomeBuilder.field_205427_f.floatValue();
            this.field_76751_G = biomeBuilder.field_205428_g.floatValue();
            this.field_229978_u_ = this.func_229979_u_();
            this.field_185364_H = biomeBuilder.field_205431_j;
            this.field_235054_x_ = biomeBuilder.field_235095_i_ != null ? biomeBuilder.field_235095_i_ : ImmutableList.of();
            this.field_235052_p_ = biomeBuilder.field_235096_j_;
            this.field_201871_ag = Maps.newHashMap();
            this.field_201874_aj = Maps.newHashMap();
            this.field_201872_ah = Maps.newHashMap();
            for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
                this.field_201872_ah.put(decoration, Lists.newArrayList());
            }
            this.field_201880_ax = Maps.newHashMap();
            for (EntityClassification entityClassification : EntityClassification.values()) {
                this.field_201880_ax.put(entityClassification, Lists.newArrayList());
            }
        } else {
            throw new IllegalStateException("You are missing parameters to build a proper biome for " + ((Object)((Object)this)).getClass().getSimpleName() + "\n" + biomeBuilder);
        }
    }

    private Biome(RainType p_i231631_1_, Category p_i231631_2_, float p_i231631_3_, float p_i231631_4_, float p_i231631_5_, float p_i231631_6_, BiomeAmbience p_i231631_7_, int p_i231631_8_, ConfiguredSurfaceBuilder<?> p_i231631_9_, Map<GenerationStage.Carving, List<ConfiguredCarver<?>>> p_i231631_10_, Map<GenerationStage.Decoration, List<ConfiguredFeature<?, ?>>> p_i231631_11_, List<StructureFeature<?, ?>> p_i231631_12_, Map<EntityClassification, List<SpawnListEntry>> p_i231631_13_, List<Attributes> p_i231631_14_, Optional<String> p_i231631_15_) {
        this.field_201878_av = p_i231631_1_;
        this.field_201877_au = p_i231631_2_;
        this.field_76748_D = p_i231631_3_;
        this.field_76749_E = p_i231631_4_;
        this.field_76750_F = p_i231631_5_;
        this.field_76751_G = p_i231631_6_;
        this.field_235052_p_ = p_i231631_7_;
        this.field_229978_u_ = p_i231631_8_;
        this.field_201875_ar = p_i231631_9_;
        this.field_201871_ag = p_i231631_10_;
        this.field_201872_ah = p_i231631_11_;
        this.field_201874_aj = p_i231631_12_.stream().collect(Collectors.toMap(p_235072_0_ -> p_235072_0_.field_236268_b_, Function.identity()));
        this.field_201880_ax = p_i231631_13_;
        this.field_235054_x_ = p_i231631_14_;
        this.field_185364_H = p_i231631_15_.orElse(null);
        p_i231631_11_.values().stream().flatMap(Collection::stream).filter(p_235067_0_ -> p_235067_0_.field_222737_a == Feature.field_214484_aL).forEach(this.field_201873_ai::add);
    }

    public boolean func_185363_b() {
        return this.field_185364_H != null;
    }

    private int func_229979_u_() {
        float f = this.field_76750_F;
        f /= 3.0f;
        f = MathHelper.func_76131_a((float)f, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225529_c_() {
        return this.field_229978_u_;
    }

    protected void func_201866_a(EntityClassification type, SpawnListEntry spawnListEntry) {
        this.field_201880_ax.computeIfAbsent(type, k -> Lists.newArrayList()).add(spawnListEntry);
    }

    protected void func_235059_a_(EntityType<?> p_235059_1_, double p_235059_2_, double p_235059_4_) {
        this.field_235053_w_.put(p_235059_1_, new EntityDensity(p_235059_4_, p_235059_2_));
    }

    public List<SpawnListEntry> func_76747_a(EntityClassification creatureType) {
        return this.field_201880_ax.computeIfAbsent(creatureType, k -> Lists.newArrayList());
    }

    @Nullable
    public EntityDensity func_235058_a_(EntityType<?> p_235058_1_) {
        return this.field_235053_w_.get(p_235058_1_);
    }

    public RainType func_201851_b() {
        return this.field_201878_av;
    }

    public boolean func_76736_e() {
        return this.func_76727_i() > 0.85f;
    }

    public float func_76741_f() {
        return 0.1f;
    }

    public float func_180626_a(BlockPos pos) {
        if (pos.func_177956_o() > 64) {
            float f = (float)(field_150605_ac.func_215464_a((double)((float)pos.func_177958_n() / 8.0f), (double)((float)pos.func_177952_p() / 8.0f), false) * 4.0);
            return this.func_185353_n() - (f + (float)pos.func_177956_o() - 64.0f) * 0.05f / 30.0f;
        }
        return this.func_185353_n();
    }

    public final float func_225486_c(BlockPos pos) {
        long i = pos.func_218275_a();
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = this.field_225488_v.get();
        float f = long2floatlinkedopenhashmap.get(i);
        if (!Float.isNaN(f)) {
            return f;
        }
        float f1 = this.func_180626_a(pos);
        if (long2floatlinkedopenhashmap.size() == 1024) {
            long2floatlinkedopenhashmap.removeFirstFloat();
        }
        long2floatlinkedopenhashmap.put(i, f1);
        return f1;
    }

    public boolean func_201848_a(IWorldReader worldIn, BlockPos pos) {
        return this.func_201854_a(worldIn, pos, true);
    }

    public boolean func_201854_a(IWorldReader worldIn, BlockPos water, boolean mustBeAtEdge) {
        if (this.func_225486_c(water) >= 0.15f) {
            return false;
        }
        if (water.func_177956_o() >= 0 && water.func_177956_o() < 256 && worldIn.func_226658_a_(LightType.BLOCK, water) < 10) {
            BlockState blockstate = worldIn.func_180495_p(water);
            FluidState fluidstate = worldIn.func_204610_c(water);
            if (fluidstate.func_206886_c() == Fluids.field_204546_a && blockstate.func_177230_c() instanceof FlowingFluidBlock) {
                boolean flag;
                if (!mustBeAtEdge) {
                    return true;
                }
                boolean bl = flag = worldIn.func_201671_F(water.func_177976_e()) && worldIn.func_201671_F(water.func_177974_f()) && worldIn.func_201671_F(water.func_177978_c()) && worldIn.func_201671_F(water.func_177968_d());
                if (!flag) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_201850_b(IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate;
        if (this.func_225486_c(pos) >= 0.15f) {
            return false;
        }
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && worldIn.func_226658_a_(LightType.BLOCK, pos) < 10 && (blockstate = worldIn.func_180495_p(pos)).isAir((IBlockReader)((Object)worldIn), pos) && Blocks.field_150433_aE.func_176223_P().func_196955_c(worldIn, pos);
    }

    public void func_203611_a(GenerationStage.Decoration decorationStage, ConfiguredFeature<?, ?> featureIn) {
        if (featureIn.field_222737_a == Feature.field_214484_aL) {
            this.field_201873_ai.add(featureIn);
        }
        this.field_201872_ah.get(decorationStage).add(featureIn);
    }

    public <C extends ICarverConfig> void func_203609_a(GenerationStage.Carving stage, ConfiguredCarver<C> carver) {
        this.field_201871_ag.computeIfAbsent(stage, p_235071_0_ -> Lists.newArrayList()).add(carver);
    }

    public List<ConfiguredCarver<?>> func_203603_a(GenerationStage.Carving stage) {
        return this.field_201871_ag.computeIfAbsent(stage, p_235066_0_ -> Lists.newArrayList());
    }

    public void func_235063_a_(StructureFeature<?, ?> p_235063_1_) {
        this.field_201874_aj.put(p_235063_1_.field_236268_b_, p_235063_1_);
    }

    public boolean func_201858_a(Structure<?> structureIn) {
        return this.field_201874_aj.containsKey(structureIn);
    }

    public Iterable<StructureFeature<?, ?>> func_235077_g_() {
        return this.field_201874_aj.values();
    }

    public StructureFeature<?, ?> func_235068_b_(StructureFeature<?, ?> p_235068_1_) {
        return this.field_201874_aj.getOrDefault((Object)p_235068_1_.field_236268_b_, p_235068_1_);
    }

    public List<ConfiguredFeature<?, ?>> func_201853_g() {
        return this.field_201873_ai;
    }

    public List<ConfiguredFeature<?, ?>> func_203607_a(GenerationStage.Decoration decorationStage) {
        return this.field_201872_ah.get(decorationStage);
    }

    public void func_235061_a_(GenerationStage.Decoration p_235061_1_, StructureManager p_235061_2_, ChunkGenerator p_235061_3_, ISeedReader p_235061_4_, long p_235061_5_, SharedSeedRandom p_235061_7_, BlockPos p_235061_8_) {
        int i = 0;
        if (p_235061_2_.func_235005_a_()) {
            Iterator<ConfiguredFeature<?, ?>> iterator = Registry.field_218361_B.iterator();
            while (iterator.hasNext()) {
                Structure structure = (Structure)iterator.next();
                if (structure.func_236396_f_() != p_235061_1_) continue;
                p_235061_7_.func_202426_b(p_235061_5_, i, p_235061_1_.ordinal());
                int j = p_235061_8_.func_177958_n() >> 4;
                int k = p_235061_8_.func_177952_p() >> 4;
                int l = j << 4;
                int i1 = k << 4;
                try {
                    p_235061_2_.func_235011_a_(SectionPos.func_218167_a((BlockPos)p_235061_8_), structure).forEach(p_235060_8_ -> p_235060_8_.func_230366_a_(p_235061_4_, p_235061_2_, p_235061_3_, (Random)p_235061_7_, new MutableBoundingBox(l, i1, l + 15, i1 + 15), new ChunkPos(j, k)));
                }
                catch (Exception exception1) {
                    CrashReport crashreport = CrashReport.func_85055_a(exception1, "Feature placement");
                    crashreport.func_85058_a("Feature").func_71507_a("Id", Registry.field_218361_B.func_177774_c(structure)).func_189529_a("Description", (ICrashReportDetail<String>)((ICrashReportDetail)() -> ((Object)((Object)structure)).toString()));
                    throw new ReportedException(crashreport);
                }
                ++i;
            }
        }
        for (ConfiguredFeature<?, ?> configuredfeature : this.field_201872_ah.get(p_235061_1_)) {
            p_235061_7_.func_202426_b(p_235061_5_, i, p_235061_1_.ordinal());
            try {
                configuredfeature.func_236265_a_(p_235061_4_, p_235061_2_, p_235061_3_, (Random)p_235061_7_, p_235061_8_);
            }
            catch (Exception exception) {
                CrashReport crashreport1 = CrashReport.func_85055_a(exception, "Feature placement");
                crashreport1.func_85058_a("Feature").func_71507_a("Id", Registry.field_218379_q.func_177774_c(configuredfeature.field_222737_a)).func_71507_a("Config", configuredfeature.field_222738_b).func_189529_a("Description", (ICrashReportDetail<String>)((ICrashReportDetail)() -> ((Object)((Object)configuredfeature.field_222737_a)).toString()));
                throw new ReportedException(crashreport1);
            }
            ++i;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_235080_i_() {
        return this.field_235052_p_.func_235213_a_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225528_a_(double posX, double posZ) {
        double d0 = MathHelper.func_76131_a((float)this.func_185353_n(), (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return GrassColors.func_77480_a((double)d0, (double)d1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225527_a_() {
        double d0 = MathHelper.func_76131_a((float)this.func_185353_n(), (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return FoliageColors.func_77470_a((double)d0, (double)d1);
    }

    public void func_206854_a(Random random, IChunk chunkIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed) {
        this.field_201875_ar.func_215451_a(seed);
        this.field_201875_ar.func_215450_a(random, chunkIn, this, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed);
    }

    public TempCategory func_150561_m() {
        if (this.field_201877_au == Category.OCEAN) {
            return TempCategory.OCEAN;
        }
        if ((double)this.func_185353_n() < 0.2) {
            return TempCategory.COLD;
        }
        return (double)this.func_185353_n() < 1.0 ? TempCategory.MEDIUM : TempCategory.WARM;
    }

    public final float func_185355_j() {
        return this.field_76748_D;
    }

    public final float func_76727_i() {
        return this.field_76751_G;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_205403_k() {
        return new TranslationTextComponent(this.func_210773_k());
    }

    public String func_210773_k() {
        if (this.field_205405_aL == null) {
            this.field_205405_aL = Util.func_200697_a((String)"biome", (ResourceLocation)Registry.field_212624_m.func_177774_c(this));
        }
        return this.field_205405_aL;
    }

    public final float func_185360_m() {
        return this.field_76749_E;
    }

    public final float func_185353_n() {
        return this.field_76750_F;
    }

    public BiomeAmbience func_235089_q_() {
        return this.field_235052_p_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final int func_185361_o() {
        return this.field_235052_p_.func_235216_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public final int func_204274_p() {
        return this.field_235052_p_.func_235218_c_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<ParticleEffectAmbience> func_235090_t_() {
        return this.field_235052_p_.func_235220_d_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<SoundEvent> func_235091_u_() {
        return this.field_235052_p_.func_235222_e_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<MoodSoundAmbience> func_235092_v_() {
        return this.field_235052_p_.func_235224_f_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<SoundAdditionsAmbience> func_235093_w_() {
        return this.field_235052_p_.func_235226_g_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<BackgroundMusicSelector> func_235094_x_() {
        return this.field_235052_p_.func_235228_h_();
    }

    public final Category func_201856_r() {
        return this.field_201877_au;
    }

    public ConfiguredSurfaceBuilder<?> func_205401_q() {
        return this.field_201875_ar;
    }

    public ISurfaceBuilderConfig func_203944_q() {
        return this.field_201875_ar.func_215452_a();
    }

    public Stream<Attributes> func_235055_B_() {
        return this.field_235054_x_.stream();
    }

    @Nullable
    public String func_205402_s() {
        return this.field_185364_H;
    }

    public Biome getRiver() {
        if (this == Biomes.field_76774_n) {
            return Biomes.field_76777_m;
        }
        if (this == Biomes.field_76789_p || this == Biomes.field_76788_q) {
            return Biomes.field_76788_q;
        }
        return Biomes.field_76781_i;
    }

    @Nullable
    public Biome getHill(INoiseRandom rand) {
        return null;
    }

    @Nullable
    public Biome getEdge(INoiseRandom rand, Biome northBiome, Biome westBiome, Biome southBiome, Biome eastBiome) {
        return null;
    }

    public static enum TempCategory {
        OCEAN("ocean"),
        COLD("cold"),
        MEDIUM("medium"),
        WARM("warm");

        private static final Map<String, TempCategory> field_222358_e;
        private final String field_222359_f;

        private TempCategory(String nameIn) {
            this.field_222359_f = nameIn;
        }

        public String func_222357_a() {
            return this.field_222359_f;
        }

        static {
            field_222358_e = Arrays.stream(TempCategory.values()).collect(Collectors.toMap(TempCategory::func_222357_a, p_222356_0_ -> p_222356_0_));
        }
    }

    public static class SpawnListEntry
    extends WeightedRandom.Item {
        public static final Codec<SpawnListEntry> field_235123_b_ = RecordCodecBuilder.create(p_235125_0_ -> p_235125_0_.group((App)Registry.field_212629_r.fieldOf("type").forGetter(p_235128_0_ -> p_235128_0_.field_200702_b), (App)Codec.INT.fieldOf("weight").forGetter(p_235127_0_ -> p_235127_0_.field_76292_a), (App)Codec.INT.fieldOf("minCount").forGetter(p_235126_0_ -> p_235126_0_.field_76301_c), (App)Codec.INT.fieldOf("maxCount").forGetter(p_235124_0_ -> p_235124_0_.field_76299_d)).apply((Applicative)p_235125_0_, SpawnListEntry::new));
        public final EntityType<?> field_200702_b;
        public final int field_76301_c;
        public final int field_76299_d;

        public SpawnListEntry(EntityType<?> entityTypeIn, int weight, int minGroupCountIn, int maxGroupCountIn) {
            super(weight);
            this.field_200702_b = entityTypeIn.func_220339_d() == EntityClassification.MISC ? EntityType.field_200784_X : entityTypeIn;
            this.field_76301_c = minGroupCountIn;
            this.field_76299_d = maxGroupCountIn;
        }

        public String toString() {
            return EntityType.func_200718_a(this.field_200702_b) + "*(" + this.field_76301_c + "-" + this.field_76299_d + "):" + this.field_76292_a;
        }
    }

    public static enum RainType implements IStringSerializable
    {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        public static final Codec<RainType> field_235121_d_;
        private static final Map<String, RainType> field_222362_d;
        private final String field_222363_e;

        private RainType(String name) {
            this.field_222363_e = name;
        }

        public String func_222361_a() {
            return this.field_222363_e;
        }

        public static RainType func_235122_a_(String p_235122_0_) {
            return field_222362_d.get(p_235122_0_);
        }

        public String func_176610_l() {
            return this.field_222363_e;
        }

        static {
            field_235121_d_ = IStringSerializable.func_233023_a_(RainType::values, RainType::func_235122_a_);
            field_222362_d = Arrays.stream(RainType.values()).collect(Collectors.toMap(RainType::func_222361_a, p_222360_0_ -> p_222360_0_));
        }
    }

    public static class EntityDensity {
        private final double field_235117_a_;
        private final double field_235118_b_;

        public EntityDensity(double p_i231633_1_, double p_i231633_3_) {
            this.field_235117_a_ = p_i231633_1_;
            this.field_235118_b_ = p_i231633_3_;
        }

        public double func_235119_a_() {
            return this.field_235117_a_;
        }

        public double func_235120_b_() {
            return this.field_235118_b_;
        }
    }

    public static enum Category implements IStringSerializable
    {
        NONE("none"),
        TAIGA("taiga"),
        EXTREME_HILLS("extreme_hills"),
        JUNGLE("jungle"),
        MESA("mesa"),
        PLAINS("plains"),
        SAVANNA("savanna"),
        ICY("icy"),
        THEEND("the_end"),
        BEACH("beach"),
        FOREST("forest"),
        OCEAN("ocean"),
        DESERT("desert"),
        RIVER("river"),
        SWAMP("swamp"),
        MUSHROOM("mushroom"),
        NETHER("nether");

        public static final Codec<Category> field_235102_r_;
        private static final Map<String, Category> field_222354_r;
        private final String field_222355_s;

        private Category(String name) {
            this.field_222355_s = name;
        }

        public String func_222352_a() {
            return this.field_222355_s;
        }

        public static Category func_235103_a_(String p_235103_0_) {
            return field_222354_r.get(p_235103_0_);
        }

        public String func_176610_l() {
            return this.field_222355_s;
        }

        static {
            field_235102_r_ = IStringSerializable.func_233023_a_(Category::values, Category::func_235103_a_);
            field_222354_r = Arrays.stream(Category.values()).collect(Collectors.toMap(Category::func_222352_a, p_222353_0_ -> p_222353_0_));
        }
    }

    public static class Builder {
        @Nullable
        private ConfiguredSurfaceBuilder<?> field_205422_a;
        @Nullable
        private RainType field_205423_b;
        @Nullable
        private Category field_205424_c;
        @Nullable
        private Float field_205425_d;
        @Nullable
        private Float field_205426_e;
        @Nullable
        private Float field_205427_f;
        @Nullable
        private Float field_205428_g;
        @Nullable
        private String field_205431_j;
        @Nullable
        private List<Attributes> field_235095_i_;
        @Nullable
        private BiomeAmbience field_235096_j_;

        public <SC extends ISurfaceBuilderConfig> Builder func_222351_a(SurfaceBuilder<SC> surfaceBuilderIn, SC surfaceBuilderConfigIn) {
            this.field_205422_a = new ConfiguredSurfaceBuilder(surfaceBuilderIn, surfaceBuilderConfigIn);
            return this;
        }

        public Builder func_205416_a(ConfiguredSurfaceBuilder<?> surfaceBuilderIn) {
            this.field_205422_a = surfaceBuilderIn;
            return this;
        }

        public Builder func_205415_a(RainType precipitationIn) {
            this.field_205423_b = precipitationIn;
            return this;
        }

        public Builder func_205419_a(Category biomeCategory) {
            this.field_205424_c = biomeCategory;
            return this;
        }

        public Builder func_205421_a(float depthIn) {
            this.field_205425_d = Float.valueOf(depthIn);
            return this;
        }

        public Builder func_205420_b(float scaleIn) {
            this.field_205426_e = Float.valueOf(scaleIn);
            return this;
        }

        public Builder func_205414_c(float temperatureIn) {
            this.field_205427_f = Float.valueOf(temperatureIn);
            return this;
        }

        public Builder func_205417_d(float downfallIn) {
            this.field_205428_g = Float.valueOf(downfallIn);
            return this;
        }

        public Builder func_205418_a(@Nullable String parentIn) {
            this.field_205431_j = parentIn;
            return this;
        }

        public Builder func_235098_a_(List<Attributes> p_235098_1_) {
            this.field_235095_i_ = p_235098_1_;
            return this;
        }

        public Builder func_235097_a_(BiomeAmbience p_235097_1_) {
            this.field_235096_j_ = p_235097_1_;
            return this;
        }

        public String toString() {
            return "BiomeBuilder{\nsurfaceBuilder=" + this.field_205422_a + ",\nprecipitation=" + (Object)((Object)this.field_205423_b) + ",\nbiomeCategory=" + (Object)((Object)this.field_205424_c) + ",\ndepth=" + this.field_205425_d + ",\nscale=" + this.field_205426_e + ",\ntemperature=" + this.field_205427_f + ",\ndownfall=" + this.field_205428_g + ",\nspecialEffects=" + this.field_235096_j_ + ",\nparent='" + this.field_205431_j + '\'' + "\n" + '}';
        }
    }

    public static class Attributes {
        public static final Codec<Attributes> field_235104_a_ = RecordCodecBuilder.create(p_235111_0_ -> p_235111_0_.group((App)Codec.FLOAT.fieldOf("temperature").forGetter(p_235116_0_ -> Float.valueOf(p_235116_0_.field_235105_b_)), (App)Codec.FLOAT.fieldOf("humidity").forGetter(p_235115_0_ -> Float.valueOf(p_235115_0_.field_235106_c_)), (App)Codec.FLOAT.fieldOf("altitude").forGetter(p_235114_0_ -> Float.valueOf(p_235114_0_.field_235107_d_)), (App)Codec.FLOAT.fieldOf("weirdness").forGetter(p_235113_0_ -> Float.valueOf(p_235113_0_.field_235108_e_)), (App)Codec.FLOAT.fieldOf("offset").forGetter(p_235112_0_ -> Float.valueOf(p_235112_0_.field_235109_f_))).apply((Applicative)p_235111_0_, Attributes::new));
        private final float field_235105_b_;
        private final float field_235106_c_;
        private final float field_235107_d_;
        private final float field_235108_e_;
        private final float field_235109_f_;

        public Attributes(float p_i231632_1_, float p_i231632_2_, float p_i231632_3_, float p_i231632_4_, float p_i231632_5_) {
            this.field_235105_b_ = p_i231632_1_;
            this.field_235106_c_ = p_i231632_2_;
            this.field_235107_d_ = p_i231632_3_;
            this.field_235108_e_ = p_i231632_4_;
            this.field_235109_f_ = p_i231632_5_;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
                Attributes biome$attributes = (Attributes)p_equals_1_;
                if (Float.compare(biome$attributes.field_235105_b_, this.field_235105_b_) != 0) {
                    return false;
                }
                if (Float.compare(biome$attributes.field_235106_c_, this.field_235106_c_) != 0) {
                    return false;
                }
                if (Float.compare(biome$attributes.field_235107_d_, this.field_235107_d_) != 0) {
                    return false;
                }
                return Float.compare(biome$attributes.field_235108_e_, this.field_235108_e_) == 0;
            }
            return false;
        }

        public int hashCode() {
            int i = this.field_235105_b_ != 0.0f ? Float.floatToIntBits(this.field_235105_b_) : 0;
            i = 31 * i + (this.field_235106_c_ != 0.0f ? Float.floatToIntBits(this.field_235106_c_) : 0);
            i = 31 * i + (this.field_235107_d_ != 0.0f ? Float.floatToIntBits(this.field_235107_d_) : 0);
            return 31 * i + (this.field_235108_e_ != 0.0f ? Float.floatToIntBits(this.field_235108_e_) : 0);
        }

        public float func_235110_a_(Attributes p_235110_1_) {
            return (this.field_235105_b_ - p_235110_1_.field_235105_b_) * (this.field_235105_b_ - p_235110_1_.field_235105_b_) + (this.field_235106_c_ - p_235110_1_.field_235106_c_) * (this.field_235106_c_ - p_235110_1_.field_235106_c_) + (this.field_235107_d_ - p_235110_1_.field_235107_d_) * (this.field_235107_d_ - p_235110_1_.field_235107_d_) + (this.field_235108_e_ - p_235110_1_.field_235108_e_) * (this.field_235108_e_ - p_235110_1_.field_235108_e_) + (this.field_235109_f_ - p_235110_1_.field_235109_f_) * (this.field_235109_f_ - p_235110_1_.field_235109_f_);
        }
    }
}

