/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformingClassLoader;
import cpw.mods.modlauncher.api.ITransformingClassLoaderBuilder;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LibraryFinder;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModJarURLHandler;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FMLCommonLaunchHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<String> SKIPPACKAGES = Arrays.asList("joptsimple.", "org.lwjgl.", "com.mojang.guava.", "com.google.", "org.apache.commons.", "io.netty.", "org.apache.logging.log4j.", "org.apache.http.", "org.apache.maven.", "org.objectweb.asm.", "paulscode.sound.", "com.ibm.icu.", "sun.", "javax.", "gnu.trove.", "com.electronwill.nightconfig.", "net.minecraftforge.fml.loading.", "net.minecraftforge.fml.language.", "net.minecraftforge.eventbus.", "net.minecraftforge.api.", "com.mojang.util.QueueLogAppender");
    private final List<Path> additionalLibraries = new ArrayList<Path>();

    protected Predicate<String> getPackagePredicate() {
        return cn -> SKIPPACKAGES.stream().noneMatch(cn::startsWith);
    }

    public Path getForgePath(String mcVersion, String forgeVersion, String forgeGroup) {
        return LibraryFinder.getForgeLibraryPath(mcVersion, forgeVersion, forgeGroup);
    }

    public Path[] getMCPaths(String mcVersion, String mcpVersion, String forgeVersion, String forgeGroup) {
        return LibraryFinder.getMCPaths(mcVersion, mcpVersion, forgeVersion, forgeGroup, this.getDist().isClient() ? "client" : "server");
    }

    public void configureTransformationClassLoader(ITransformingClassLoaderBuilder builder) {
        builder.addTransformationPath(FMLLoader.getForgePath());
        Arrays.stream(FMLLoader.getMCPaths()).forEach(arg_0 -> ((ITransformingClassLoaderBuilder)builder).addTransformationPath(arg_0));
        this.additionalLibraries.forEach(arg_0 -> ((ITransformingClassLoaderBuilder)builder).addTransformationPath(arg_0));
        FMLLoader.getLanguageLoadingProvider().getLibraries().forEach(arg_0 -> ((ITransformingClassLoaderBuilder)builder).addTransformationPath(arg_0));
        builder.setClassBytesLocator(this.getClassLoaderLocatorFunction());
        builder.setManifestLocator(this.getClassLoaderManifestLocatorFunction());
    }

    public void setup(IEnvironment environment, Map<String, ?> arguments) {
    }

    public abstract Dist getDist();

    protected void beforeStart(ITransformingClassLoader launchClassLoader) {
        FMLLoader.beforeStart(launchClassLoader);
    }

    protected void processModClassesEnvironmentVariable(Map<String, List<Pair<Path, List<Path>>>> arguments) {
        String modClasses = Optional.ofNullable(System.getenv("MOD_CLASSES")).orElse("");
        LOGGER.debug(LogMarkers.CORE, "Got mod coordinates {} from env", (Object)modClasses);
        Map modClassPaths = Arrays.stream(modClasses.split(File.pathSeparator)).map(inp -> inp.split("%%", 2)).map(this::buildModPair).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        LOGGER.debug(LogMarkers.CORE, "Found supplied mod coordinates [{}]", modClassPaths);
        List explodedTargets = arguments.computeIfAbsent("explodedTargets", a -> new ArrayList());
        modClassPaths.forEach((modlabel, paths) -> explodedTargets.add(Pair.of(paths.get(0), paths.subList(1, paths.size()))));
    }

    private Pair<String, Path> buildModPair(String[] splitString) {
        String modid = splitString.length == 1 ? "defaultmodid" : splitString[0];
        Path path = Paths.get(splitString[splitString.length - 1], new String[0]);
        return Pair.of((Object)modid, (Object)path);
    }

    protected void validatePaths(Path forgePath, Path[] mcPaths, String forgeVersion, String mcVersion, String mcpVersion) {
        if (!Files.exists(forgePath, new LinkOption[0])) {
            LOGGER.fatal(LogMarkers.CORE, "Failed to find forge version {} for MC {} at {}", (Object)forgeVersion, (Object)mcVersion, (Object)forgePath);
            throw new RuntimeException("Missing forge!");
        }
        Stream.of(mcPaths).forEach(p -> {
            if (!Files.exists(p, new LinkOption[0])) {
                LOGGER.fatal(LogMarkers.CORE, "Failed to find Minecraft resource version {} at {}", (Object)(mcVersion + "-" + mcpVersion), p);
                throw new RuntimeException("Missing minecraft resource!");
            }
        });
    }

    protected Function<String, Optional<URL>> getClassLoaderLocatorFunction() {
        return input -> Optional.ofNullable(FMLLoader.getLoadingModList().findURLForResource((String)input));
    }

    protected Function<URLConnection, Optional<Manifest>> getClassLoaderManifestLocatorFunction() {
        return input -> {
            if (input instanceof ModJarURLHandler.ModJarURLConnection) {
                return ((ModJarURLHandler.ModJarURLConnection)input).getManifest();
            }
            return Optional.empty();
        };
    }

    protected abstract String getNaming();

    void addLibraries(List<ModFile> libraries) {
        libraries.stream().map(ModFile::getFilePath).peek(p -> LOGGER.debug(LogMarkers.LOADING, "Adding {} as a library to the transforming classloader", p)).forEach(this.additionalLibraries::add);
    }

    public boolean isProduction() {
        return false;
    }

    public boolean isData() {
        return false;
    }
}

