/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoadingException;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.logging.ModelLoaderErrorMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModelLoader
extends ModelBakery {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, Exception> loadingExceptions = Maps.newHashMap();
    private IUnbakedModel missingModel = null;
    private boolean isLoading = false;
    private static ModelLoader instance;
    private static Set<ResourceLocation> specialModels;
    private static final Function<ResourceLocation, IUnbakedModel> DEFAULT_MODEL_GETTER;

    @Nullable
    public static ModelLoader instance() {
        return instance;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public ModelLoader(IResourceManager manager, BlockColors colours, IProfiler profiler, int maxMipmapLevel) {
        super(manager, colours, false);
        instance = this;
        this.processLoading(profiler, maxMipmapLevel);
    }

    public static void addSpecialModel(ResourceLocation rl) {
        specialModels.add(rl);
    }

    public Set<ResourceLocation> getSpecialModels() {
        return specialModels;
    }

    public static ModelResourceLocation getInventoryVariant(String s) {
        if (s.contains("#")) {
            return new ModelResourceLocation(s);
        }
        return new ModelResourceLocation(s, "inventory");
    }

    protected ResourceLocation getModelLocation(ResourceLocation model) {
        return new ResourceLocation(model.func_110624_b(), model.func_110623_a() + ".json");
    }

    protected IUnbakedModel getMissingModel() {
        if (this.missingModel == null) {
            try {
                this.missingModel = this.func_209597_a((ResourceLocation)field_177604_a);
            }
            catch (Exception e) {
                throw new RuntimeException("Missing the missing model, this should never happen");
            }
        }
        return this.missingModel;
    }

    public IUnbakedModel getModelOrMissing(ResourceLocation location) {
        try {
            return this.func_209597_a(location);
        }
        catch (Exception e) {
            return this.getMissingModel();
        }
    }

    public IUnbakedModel getModelOrLogError(ResourceLocation location, String error) {
        try {
            return this.func_209597_a(location);
        }
        catch (Exception e) {
            LOGGER.error(error, (Throwable)e);
            return this.getMissingModel();
        }
    }

    public void onPostBakeEvent(Map<ResourceLocation, IBakedModel> modelRegistry) {
        IBakedModel missingModel = modelRegistry.get(field_177604_a);
        for (Map.Entry<ResourceLocation, Exception> entry : this.loadingExceptions.entrySet()) {
            if (!(entry.getKey() instanceof ModelResourceLocation)) continue;
            LOGGER.debug(Logging.MODELLOADING, () -> new ModelLoaderErrorMessage((ModelResourceLocation)entry.getKey(), (Exception)entry.getValue()));
            ModelResourceLocation location = (ModelResourceLocation)entry.getKey();
            IBakedModel model = modelRegistry.get(location);
            if (model != null) continue;
            modelRegistry.put((ResourceLocation)location, missingModel);
        }
        this.loadingExceptions.clear();
        this.isLoading = false;
    }

    public static Function<RenderMaterial, TextureAtlasSprite> defaultTextureGetter() {
        return RenderMaterial::func_229314_c_;
    }

    public static Function<ResourceLocation, IUnbakedModel> defaultModelGetter() {
        return DEFAULT_MODEL_GETTER;
    }

    static {
        specialModels = new HashSet<ResourceLocation>();
        DEFAULT_MODEL_GETTER = rl -> ModelLoader.instance().getModelOrMissing((ResourceLocation)rl);
    }

    public static class ItemLoadingException
    extends ModelLoadingException {
        private final Exception normalException;
        private final Exception blockstateException;

        public ItemLoadingException(String message, Exception normalException, Exception blockstateException) {
            super(message);
            this.normalException = normalException;
            this.blockstateException = blockstateException;
        }
    }

    public static final class White {
        public static final ResourceLocation LOCATION = new ResourceLocation("white");
        private static TextureAtlasSprite instance = null;

        public static final TextureAtlasSprite instance() {
            if (instance == null) {
                instance = new RenderMaterial(AtlasTexture.field_110575_b, LOCATION).func_229314_c_();
            }
            return instance;
        }
    }
}

