/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.EntitySize;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class PortalSize {
    private static final AbstractBlock.IPositionPredicate field_242962_a = (blockState, iBlockReader, blockPos) -> blockState.func_203425_a(Blocks.field_150343_Z);
    private final IWorld field_150867_a;
    private final Direction.Axis field_150865_b;
    private final Direction field_150866_c;
    private int field_150864_e;
    @Nullable
    private BlockPos field_150861_f;
    private int field_150862_g;
    private int field_150868_h;

    public static Optional<PortalSize> func_242964_a(IWorld iWorld, BlockPos blockPos, Direction.Axis axis) {
        return PortalSize.func_242965_a(iWorld, blockPos, portalSize -> portalSize.func_150860_b() && portalSize.field_150864_e == 0, axis);
    }

    public static Optional<PortalSize> func_242965_a(IWorld iWorld, BlockPos blockPos, Predicate<PortalSize> predicate, Direction.Axis axis) {
        Optional<PortalSize> optional = Optional.of(new PortalSize(iWorld, blockPos, axis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis \u26032 = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(new PortalSize(iWorld, blockPos, \u26032)).filter(predicate);
    }

    public PortalSize(IWorld iWorld, BlockPos blockPos, Direction.Axis axis) {
        this.field_150867_a = iWorld;
        this.field_150865_b = axis;
        this.field_150866_c = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        this.field_150861_f = this.func_242971_a(blockPos);
        if (this.field_150861_f == null) {
            this.field_150861_f = blockPos;
            this.field_150868_h = 1;
            this.field_150862_g = 1;
        } else {
            this.field_150868_h = this.func_242974_d();
            if (this.field_150868_h > 0) {
                this.field_150862_g = this.func_242975_e();
            }
        }
    }

    @Nullable
    private BlockPos func_242971_a(BlockPos blockPos2) {
        int n = Math.max(0, blockPos2.func_177956_o() - 21);
        while (blockPos2.func_177956_o() > n && PortalSize.func_196900_a(this.field_150867_a.func_180495_p(blockPos2.func_177977_b()))) {
            BlockPos blockPos2 = blockPos2.func_177977_b();
        }
        Direction direction = this.field_150866_c.func_176734_d();
        int \u26032 = this.func_242972_a(blockPos2, direction) - 1;
        if (\u26032 < 0) {
            return null;
        }
        return blockPos2.func_177967_a(direction, \u26032);
    }

    private int func_242974_d() {
        int n = this.func_242972_a(this.field_150861_f, this.field_150866_c);
        if (n < 2 || n > 21) {
            return 0;
        }
        return n;
    }

    private int func_242972_a(BlockPos blockPos, Direction direction) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int i = 0; i <= 21; ++i) {
            mutable.func_189533_g(blockPos).func_189534_c(direction, i);
            BlockState blockState = this.field_150867_a.func_180495_p(mutable);
            if (!PortalSize.func_196900_a(blockState)) {
                if (!field_242962_a.test(blockState, this.field_150867_a, mutable)) break;
                return i;
            }
            \u2603 = this.field_150867_a.func_180495_p(mutable.func_189536_c(Direction.DOWN));
            if (!field_242962_a.test(\u2603, this.field_150867_a, mutable)) break;
        }
        return 0;
    }

    private int func_242975_e() {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int \u26032 = this.func_242969_a(mutable);
        if (\u26032 < 3 || \u26032 > 21 || !this.func_242970_a(mutable, \u26032)) {
            return 0;
        }
        return \u26032;
    }

    private boolean func_242970_a(BlockPos.Mutable mutable, int n) {
        for (\u2603 = 0; \u2603 < this.field_150868_h; ++\u2603) {
            BlockPos.Mutable mutable2 = mutable.func_189533_g(this.field_150861_f).func_189534_c(Direction.UP, n).func_189534_c(this.field_150866_c, \u2603);
            if (field_242962_a.test(this.field_150867_a.func_180495_p(mutable2), this.field_150867_a, mutable2)) continue;
            return false;
        }
        return true;
    }

    private int func_242969_a(BlockPos.Mutable mutable) {
        for (int i = 0; i < 21; ++i) {
            mutable.func_189533_g(this.field_150861_f).func_189534_c(Direction.UP, i).func_189534_c(this.field_150866_c, -1);
            if (!field_242962_a.test(this.field_150867_a.func_180495_p(mutable), this.field_150867_a, mutable)) {
                return i;
            }
            mutable.func_189533_g(this.field_150861_f).func_189534_c(Direction.UP, i).func_189534_c(this.field_150866_c, this.field_150868_h);
            if (!field_242962_a.test(this.field_150867_a.func_180495_p(mutable), this.field_150867_a, mutable)) {
                return i;
            }
            for (\u2603 = 0; \u2603 < this.field_150868_h; ++\u2603) {
                mutable.func_189533_g(this.field_150861_f).func_189534_c(Direction.UP, i).func_189534_c(this.field_150866_c, \u2603);
                BlockState blockState = this.field_150867_a.func_180495_p(mutable);
                if (!PortalSize.func_196900_a(blockState)) {
                    return i;
                }
                if (!blockState.func_203425_a(Blocks.field_150427_aO)) continue;
                ++this.field_150864_e;
            }
        }
        return 21;
    }

    private static boolean func_196900_a(BlockState blockState) {
        return blockState.func_196958_f() || blockState.func_235714_a_(BlockTags.field_232872_am_) || blockState.func_203425_a(Blocks.field_150427_aO);
    }

    public boolean func_150860_b() {
        return this.field_150861_f != null && this.field_150868_h >= 2 && this.field_150868_h <= 21 && this.field_150862_g >= 3 && this.field_150862_g <= 21;
    }

    public void func_150859_c() {
        BlockState blockState = (BlockState)Blocks.field_150427_aO.func_176223_P().func_206870_a(NetherPortalBlock.field_176550_a, this.field_150865_b);
        BlockPos.func_218278_a(this.field_150861_f, this.field_150861_f.func_177967_a(Direction.UP, this.field_150862_g - 1).func_177967_a(this.field_150866_c, this.field_150868_h - 1)).forEach(blockPos -> this.field_150867_a.func_180501_a((BlockPos)blockPos, blockState, 18));
    }

    public boolean func_208508_f() {
        return this.func_150860_b() && this.field_150864_e == this.field_150868_h * this.field_150862_g;
    }

    public static Vector3d func_242973_a(TeleportationRepositioner.Result result, Direction.Axis axis, Vector3d vector3d, EntitySize entitySize) {
        double \u26035;
        Direction.Axis \u26034;
        double \u26033;
        double d = (double)result.field_243680_b - (double)entitySize.field_220315_a;
        \u2603 = (double)result.field_243681_c - (double)entitySize.field_220316_b;
        BlockPos \u26032 = result.field_243679_a;
        if (d > 0.0) {
            float f = (float)\u26032.func_243648_a(axis) + entitySize.field_220315_a / 2.0f;
            \u26033 = MathHelper.func_151237_a(MathHelper.func_233020_c_(vector3d.func_216370_a(axis) - (double)f, 0.0, d), 0.0, 1.0);
        } else {
            \u26033 = 0.5;
        }
        if (\u2603 > 0.0) {
            \u26034 = Direction.Axis.Y;
            \u26035 = MathHelper.func_151237_a(MathHelper.func_233020_c_(vector3d.func_216370_a(\u26034) - (double)\u26032.func_243648_a(\u26034), 0.0, \u2603), 0.0, 1.0);
        } else {
            \u26035 = 0.0;
        }
        \u26034 = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        double d2 = vector3d.func_216370_a(\u26034) - ((double)\u26032.func_243648_a(\u26034) + 0.5);
        return new Vector3d(\u26033, \u26035, d2);
    }

    public static PortalInfo func_242963_a(ServerWorld serverWorld, TeleportationRepositioner.Result result, Direction.Axis axis, Vector3d vector3d, EntitySize entitySize, Vector3d vector3d2, float f, float f2) {
        BlockPos blockPos = result.field_243679_a;
        BlockState \u26032 = serverWorld.func_180495_p(blockPos);
        Direction.Axis \u26033 = \u26032.func_177229_b(BlockStateProperties.field_208199_z);
        double \u26034 = result.field_243680_b;
        double \u26035 = result.field_243681_c;
        int \u26036 = axis == \u26033 ? 0 : 90;
        Vector3d \u26037 = axis == \u26033 ? vector3d2 : new Vector3d(vector3d2.field_72449_c, vector3d2.field_72448_b, -vector3d2.field_72450_a);
        double \u26038 = (double)entitySize.field_220315_a / 2.0 + (\u26034 - (double)entitySize.field_220315_a) * vector3d.func_82615_a();
        double \u26039 = (\u26035 - (double)entitySize.field_220316_b) * vector3d.func_82617_b();
        double \u260310 = 0.5 + vector3d.func_82616_c();
        boolean \u260311 = \u26033 == Direction.Axis.X;
        Vector3d \u260312 = new Vector3d((double)blockPos.func_177958_n() + (\u260311 ? \u26038 : \u260310), (double)blockPos.func_177956_o() + \u26039, (double)blockPos.func_177952_p() + (\u260311 ? \u260310 : \u26038));
        return new PortalInfo(\u260312, \u26037, f + (float)\u26036, f2);
    }
}

