/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.Vec2Argument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class SpreadPlayersCommand {
    private static final Dynamic4CommandExceptionType field_198723_a = new Dynamic4CommandExceptionType((object, object2, object3, object4) -> new TranslationTextComponent("commands.spreadplayers.failed.teams", object, object2, object3, object4));
    private static final Dynamic4CommandExceptionType field_198724_b = new Dynamic4CommandExceptionType((object, object2, object3, object4) -> new TranslationTextComponent("commands.spreadplayers.failed.entities", object, object2, object3, object4));

    public static void func_198716_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("spreadplayers").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197056_a("center", Vec2Argument.func_197296_a()).then(Commands.func_197056_a("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)Commands.func_197056_a("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(Commands.func_197056_a("respectTeams", BoolArgumentType.bool()).then(Commands.func_197056_a("targets", EntityArgument.func_197093_b()).executes(commandContext -> SpreadPlayersCommand.func_241070_a_((CommandSource)commandContext.getSource(), Vec2Argument.func_197295_a((CommandContext<CommandSource>)commandContext, "center"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"maxRange"), 256, BoolArgumentType.getBool((CommandContext)commandContext, (String)"respectTeams"), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets")))))).then(Commands.func_197057_a("under").then(Commands.func_197056_a("maxHeight", IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a("respectTeams", BoolArgumentType.bool()).then(Commands.func_197056_a("targets", EntityArgument.func_197093_b()).executes(commandContext -> SpreadPlayersCommand.func_241070_a_((CommandSource)commandContext.getSource(), Vec2Argument.func_197295_a((CommandContext<CommandSource>)commandContext, "center"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"maxRange"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"maxHeight"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"respectTeams"), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets")))))))))));
    }

    private static int func_241070_a_(CommandSource commandSource, Vector2f vector2f, float f, float f2, int n, boolean bl, Collection<? extends Entity> collection) throws CommandSyntaxException {
        Random random = new Random();
        double \u26032 = vector2f.field_189982_i - f2;
        double \u26033 = vector2f.field_189983_j - f2;
        double \u26034 = vector2f.field_189982_i + f2;
        double \u26035 = vector2f.field_189983_j + f2;
        Position[] \u26036 = SpreadPlayersCommand.func_198720_a(random, bl ? SpreadPlayersCommand.func_198715_a(collection) : collection.size(), \u26032, \u26033, \u26034, \u26035);
        SpreadPlayersCommand.func_241071_a_(vector2f, f, commandSource.func_197023_e(), random, \u26032, \u26033, \u26034, \u26035, n, \u26036, bl);
        double \u26037 = SpreadPlayersCommand.func_241072_a_(collection, commandSource.func_197023_e(), \u26036, n, bl);
        commandSource.func_197030_a(new TranslationTextComponent("commands.spreadplayers.success." + (bl ? "teams" : "entities"), \u26036.length, Float.valueOf(vector2f.field_189982_i), Float.valueOf(vector2f.field_189983_j), String.format(Locale.ROOT, "%.2f", \u26037)), true);
        return \u26036.length;
    }

    private static int func_198715_a(Collection<? extends Entity> collection) {
        HashSet hashSet = Sets.newHashSet();
        for (Entity entity : collection) {
            if (entity instanceof PlayerEntity) {
                hashSet.add(entity.func_96124_cp());
                continue;
            }
            hashSet.add(null);
        }
        return hashSet.size();
    }

    private static void func_241071_a_(Vector2f vector2f, double d, ServerWorld serverWorld, Random random, double d2, double d3, double d4, double d5, int n, Position[] positionArray, boolean bl) throws CommandSyntaxException {
        int n2;
        \u26035 = true;
        double \u26032 = 3.4028234663852886E38;
        for (n2 = 0; n2 < 10000 && \u26035; ++n2) {
            boolean \u26035 = false;
            \u26032 = 3.4028234663852886E38;
            for (int i = 0; i < positionArray.length; ++i) {
                Position position = positionArray[i];
                int \u26033 = 0;
                position = new Position();
                for (int j = 0; j < positionArray.length; ++j) {
                    if (i == j) continue;
                    Position position2 = positionArray[j];
                    double \u26034 = position.func_198708_a(position2);
                    \u26032 = Math.min(\u26034, \u26032);
                    if (!(\u26034 < d)) continue;
                    ++\u26033;
                    position.field_198713_a = position.field_198713_a + (position2.field_198713_a - position.field_198713_a);
                    position.field_198714_b = position.field_198714_b + (position2.field_198714_b - position.field_198714_b);
                }
                if (\u26033 > 0) {
                    position.field_198713_a = position.field_198713_a / (double)\u26033;
                    position.field_198714_b = position.field_198714_b / (double)\u26033;
                    double d6 = position.func_198712_b();
                    if (d6 > 0.0) {
                        position.func_198707_a();
                        position.func_198705_b(position);
                    } else {
                        position.func_198711_a(random, d2, d3, d4, d5);
                    }
                    \u26035 = true;
                }
                if (!position.func_198709_a(d2, d3, d4, d5)) continue;
                \u26035 = true;
            }
            if (\u26035) continue;
            for (Position position : positionArray) {
                if (position.func_241074_b_(serverWorld, n)) continue;
                position.func_198711_a(random, d2, d3, d4, d5);
                \u26035 = true;
            }
        }
        if (\u26032 == 3.4028234663852886E38) {
            \u26032 = 0.0;
        }
        if (n2 >= 10000) {
            if (bl) {
                throw field_198723_a.create((Object)positionArray.length, (Object)Float.valueOf(vector2f.field_189982_i), (Object)Float.valueOf(vector2f.field_189983_j), (Object)String.format(Locale.ROOT, "%.2f", \u26032));
            }
            throw field_198724_b.create((Object)positionArray.length, (Object)Float.valueOf(vector2f.field_189982_i), (Object)Float.valueOf(vector2f.field_189983_j), (Object)String.format(Locale.ROOT, "%.2f", \u26032));
        }
    }

    private static double func_241072_a_(Collection<? extends Entity> collection2, ServerWorld serverWorld, Position[] positionArray2, int n, boolean bl) {
        double d = 0.0;
        int \u26032 = 0;
        HashMap \u26033 = Maps.newHashMap();
        for (Entity entity : collection2) {
            Position \u26034;
            if (bl) {
                Team team;
                Team team2 = team = entity instanceof PlayerEntity ? entity.func_96124_cp() : null;
                if (!\u26033.containsKey(team)) {
                    \u26033.put(team, positionArray2[\u26032++]);
                }
                Position \u26035 = (Position)\u26033.get(team);
            } else {
                \u26034 = positionArray2[\u26032++];
            }
            entity.func_223102_j((double)MathHelper.func_76128_c(\u26034.field_198713_a) + 0.5, \u26034.func_198710_a(serverWorld, n), (double)MathHelper.func_76128_c(\u26034.field_198714_b) + 0.5);
            double d2 = Double.MAX_VALUE;
            for (Position position : positionArray2) {
                if (\u26034 == position) continue;
                double d3 = \u26034.func_198708_a(position);
                d2 = Math.min(d3, d2);
            }
            d += d2;
        }
        if (collection2.size() < 2) {
            return 0.0;
        }
        return d /= (double)collection2.size();
    }

    private static Position[] func_198720_a(Random random, int n, double d, double d2, double d3, double d4) {
        Position[] positionArray = new Position[n];
        for (int i = 0; i < positionArray.length; ++i) {
            Position position = new Position();
            position.func_198711_a(random, d, d2, d3, d4);
            positionArray[i] = position;
        }
        return positionArray;
    }

    static class Position {
        private double field_198713_a;
        private double field_198714_b;

        Position() {
        }

        double func_198708_a(Position position) {
            double d = this.field_198713_a - position.field_198713_a;
            \u2603 = this.field_198714_b - position.field_198714_b;
            return Math.sqrt(d * d + \u2603 * \u2603);
        }

        void func_198707_a() {
            double d = this.func_198712_b();
            this.field_198713_a /= d;
            this.field_198714_b /= d;
        }

        float func_198712_b() {
            return MathHelper.func_76133_a(this.field_198713_a * this.field_198713_a + this.field_198714_b * this.field_198714_b);
        }

        public void func_198705_b(Position position) {
            this.field_198713_a -= position.field_198713_a;
            this.field_198714_b -= position.field_198714_b;
        }

        public boolean func_198709_a(double d, double d2, double d3, double d4) {
            boolean bl = false;
            if (this.field_198713_a < d) {
                this.field_198713_a = d;
                bl = true;
            } else if (this.field_198713_a > d3) {
                this.field_198713_a = d3;
                bl = true;
            }
            if (this.field_198714_b < d2) {
                this.field_198714_b = d2;
                bl = true;
            } else if (this.field_198714_b > d4) {
                this.field_198714_b = d4;
                bl = true;
            }
            return bl;
        }

        public int func_198710_a(IBlockReader iBlockReader, int n2) {
            int n2;
            BlockPos.Mutable mutable = new BlockPos.Mutable(this.field_198713_a, (double)(n2 + 1), this.field_198714_b);
            boolean \u26032 = iBlockReader.func_180495_p(mutable).func_196958_f();
            mutable.func_189536_c(Direction.DOWN);
            boolean \u26033 = iBlockReader.func_180495_p(mutable).func_196958_f();
            while (mutable.func_177956_o() > 0) {
                mutable.func_189536_c(Direction.DOWN);
                boolean bl = iBlockReader.func_180495_p(mutable).func_196958_f();
                if (!bl && \u26033 && \u26032) {
                    return mutable.func_177956_o() + 1;
                }
                \u26032 = \u26033;
                \u26033 = bl;
            }
            return n2 + 1;
        }

        public boolean func_241074_b_(IBlockReader iBlockReader, int n) {
            BlockPos blockPos = new BlockPos(this.field_198713_a, (double)(this.func_198710_a(iBlockReader, n) - 1), this.field_198714_b);
            BlockState \u26032 = iBlockReader.func_180495_p(blockPos);
            Material \u26033 = \u26032.func_185904_a();
            return blockPos.func_177956_o() < n && !\u26033.func_76224_d() && \u26033 != Material.field_151581_o;
        }

        public void func_198711_a(Random random, double d, double d2, double d3, double d4) {
            this.field_198713_a = MathHelper.func_82716_a(random, d, d3);
            this.field_198714_b = MathHelper.func_82716_a(random, d2, d4);
        }
    }
}

