/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.DefendVillageTargetGoal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PatrolVillageGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.ReturnToVillageGoal;
import net.minecraft.entity.ai.goal.ShowVillagerFlowerGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class IronGolemEntity
extends GolemEntity
implements IAngerable {
    protected static final DataParameter<Byte> field_184750_a = EntityDataManager.func_187226_a(IronGolemEntity.class, DataSerializers.field_187191_a);
    private int field_70855_f;
    private int field_70856_g;
    private static final RangedInteger field_234196_bu_ = TickRangeConverter.func_233037_a_(20, 39);
    private int field_234197_bv_;
    private UUID field_234198_bw_;

    public IronGolemEntity(EntityType<? extends IronGolemEntity> entityType, World world) {
        super((EntityType<? extends GolemEntity>)entityType, world);
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new MeleeAttackGoal(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, new MoveTowardsTargetGoal(this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(2, new ReturnToVillageGoal((CreatureEntity)this, 0.6, false));
        this.field_70714_bg.func_75776_a(4, new PatrolVillageGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(5, new ShowVillagerFlowerGoal(this));
        this.field_70714_bg.func_75776_a(7, new LookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new DefendVillageTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, new HurtByTargetGoal(this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, 10, true, false, this::func_233680_b_));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<MobEntity>(this, MobEntity.class, 5, false, false, livingEntity -> livingEntity instanceof IMob && !(livingEntity instanceof CreeperEntity)));
        this.field_70715_bh.func_75776_a(4, new ResetAngerGoal<IronGolemEntity>(this, false));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184750_a, (byte)0);
    }

    public static AttributeModifierMap.MutableAttribute func_234200_m_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 15.0);
    }

    @Override
    protected int func_70682_h(int n) {
        return n;
    }

    @Override
    protected void func_82167_n(Entity entity) {
        if (entity instanceof IMob && !(entity instanceof CreeperEntity) && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((LivingEntity)entity);
        }
        super.func_82167_n(entity);
    }

    @Override
    public void func_70636_d() {
        BlockState blockState;
        super.func_70636_d();
        if (this.field_70855_f > 0) {
            --this.field_70855_f;
        }
        if (this.field_70856_g > 0) {
            --this.field_70856_g;
        }
        if (IronGolemEntity.func_213296_b(this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && !(blockState = this.field_70170_p.func_180495_p(new BlockPos(\u2603 = MathHelper.func_76128_c(this.func_226277_ct_()), \u2603 = MathHelper.func_76128_c(this.func_226278_cu_() - (double)0.2f), \u2603 = MathHelper.func_76128_c(this.func_226281_cx_())))).func_196958_f()) {
            this.field_70170_p.func_195594_a(new BlockParticleData(ParticleTypes.field_197611_d, blockState), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
    }

    @Override
    public boolean func_213358_a(EntityType<?> entityType) {
        if (this.func_70850_q() && entityType == EntityType.field_200729_aH) {
            return false;
        }
        if (entityType == EntityType.field_200797_k) {
            return false;
        }
        return super.func_213358_a(entityType);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74757_a("PlayerCreated", this.func_70850_q());
        this.func_233682_c_(compoundNBT);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_70849_f(compoundNBT.func_74767_n("PlayerCreated"));
        this.func_241358_a_((ServerWorld)this.field_70170_p, compoundNBT);
    }

    @Override
    public void func_230258_H__() {
        this.func_230260_a__(field_234196_bu_.func_233018_a_(this.field_70146_Z));
    }

    @Override
    public void func_230260_a__(int n) {
        this.field_234197_bv_ = n;
    }

    @Override
    public int func_230256_F__() {
        return this.field_234197_bv_;
    }

    @Override
    public void func_230259_a_(@Nullable UUID uUID) {
        this.field_234198_bw_ = uUID;
    }

    @Override
    public UUID func_230257_G__() {
        return this.field_234198_bw_;
    }

    private float func_226511_et_() {
        return (float)this.func_233637_b_(Attributes.field_233823_f_);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        this.field_70855_f = 10;
        this.field_70170_p.func_72960_a(this, (byte)4);
        float f = this.func_226511_et_();
        \u2603 = (int)f > 0 ? f / 2.0f + (float)this.field_70146_Z.nextInt((int)f) : f;
        boolean \u26032 = entity.func_70097_a(DamageSource.func_76358_a(this), \u2603);
        if (\u26032) {
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, 0.4f, 0.0));
            this.func_174815_a(this, entity);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return \u26032;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        Cracks cracks = this.func_226512_l_();
        boolean \u26032 = super.func_70097_a(damageSource, f);
        if (\u26032 && this.func_226512_l_() != cracks) {
            this.func_184185_a(SoundEvents.field_226142_fM_, 1.0f, 1.0f);
        }
        return \u26032;
    }

    public Cracks func_226512_l_() {
        return Cracks.func_226515_a_(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_70851_e(boolean bl) {
        if (bl) {
            this.field_70856_g = 400;
            this.field_70170_p.func_72960_a(this, (byte)11);
        } else {
            this.field_70856_g = 0;
            this.field_70170_p.func_72960_a(this, (byte)34);
        }
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187602_cF;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        Item \u26032 = itemStack.func_77973_b();
        if (\u26032 != Items.field_151042_j) {
            return ActionResultType.PASS;
        }
        float \u26033 = this.func_110143_aJ();
        this.func_70691_i(25.0f);
        if (this.func_110143_aJ() == \u26033) {
            return ActionResultType.PASS;
        }
        float \u26034 = 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
        this.func_184185_a(SoundEvents.field_226143_fP_, 1.0f, \u26034);
        if (!playerEntity.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    public boolean func_70850_q() {
        return (this.field_70180_af.func_187225_a(field_184750_a) & 1) != 0;
    }

    public void func_70849_f(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184750_a);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184750_a, (byte)(by | 1));
        } else {
            this.field_70180_af.func_187227_b(field_184750_a, (byte)(by & 0xFFFFFFFE));
        }
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
    }

    @Override
    public boolean func_205019_a(IWorldReader iWorldReader2) {
        BlockPos blockPos = this.func_233580_cy_();
        \u2603 = blockPos.func_177977_b();
        BlockState \u26032 = iWorldReader2.func_180495_p(\u2603);
        if (\u26032.func_235719_a_(iWorldReader2, \u2603, this)) {
            IWorldReader iWorldReader2;
            for (int i = 1; i < 3; ++i) {
                BlockPos blockPos2 = blockPos.func_177981_b(i);
                if (WorldEntitySpawner.func_234968_a_(iWorldReader2, blockPos2, \u2603 = iWorldReader2.func_180495_p(blockPos2), \u2603.func_204520_s(), EntityType.field_200757_aw)) continue;
                return false;
            }
            return WorldEntitySpawner.func_234968_a_(iWorldReader2, blockPos, iWorldReader2.func_180495_p(blockPos), Fluids.field_204541_a.func_207188_f(), EntityType.field_200757_aw) && iWorldReader2.func_226668_i_(this);
        }
        return false;
    }

    public static enum Cracks {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Cracks> field_226513_e_;
        private final float field_226514_f_;

        private Cracks(float f) {
            this.field_226514_f_ = f;
        }

        public static Cracks func_226515_a_(float f) {
            for (Cracks cracks : field_226513_e_) {
                if (!(f < cracks.field_226514_f_)) continue;
                return cracks;
            }
            return NONE;
        }

        static {
            field_226513_e_ = (List)Stream.of(Cracks.values()).sorted(Comparator.comparingDouble(cracks -> cracks.field_226514_f_)).collect(ImmutableList.toImmutableList());
        }
    }
}

