/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ItemPredicate {
    private static final Map<ResourceLocation, Function<JsonObject, ItemPredicate>> custom_predicates = new HashMap<ResourceLocation, Function<JsonObject, ItemPredicate>>();
    private static final Map<ResourceLocation, Function<JsonObject, ItemPredicate>> unmod_predicates = Collections.unmodifiableMap(custom_predicates);
    public static final ItemPredicate field_192495_a = new ItemPredicate();
    @Nullable
    private final ITag<Item> field_200018_b;
    @Nullable
    private final Item field_192496_b;
    private final MinMaxBounds.IntBound field_192498_d;
    private final MinMaxBounds.IntBound field_193444_e;
    private final EnchantmentPredicate[] field_192499_e;
    private final EnchantmentPredicate[] field_226656_g_;
    @Nullable
    private final Potion field_192500_f;
    private final NBTPredicate field_193445_h;

    public ItemPredicate() {
        this.field_200018_b = null;
        this.field_192496_b = null;
        this.field_192500_f = null;
        this.field_192498_d = MinMaxBounds.IntBound.field_211347_e;
        this.field_193444_e = MinMaxBounds.IntBound.field_211347_e;
        this.field_192499_e = EnchantmentPredicate.field_226534_b_;
        this.field_226656_g_ = EnchantmentPredicate.field_226534_b_;
        this.field_193445_h = NBTPredicate.field_193479_a;
    }

    public ItemPredicate(@Nullable ITag<Item> p_i225740_1_, @Nullable Item p_i225740_2_, MinMaxBounds.IntBound p_i225740_3_, MinMaxBounds.IntBound p_i225740_4_, EnchantmentPredicate[] p_i225740_5_, EnchantmentPredicate[] p_i225740_6_, @Nullable Potion p_i225740_7_, NBTPredicate p_i225740_8_) {
        this.field_200018_b = p_i225740_1_;
        this.field_192496_b = p_i225740_2_;
        this.field_192498_d = p_i225740_3_;
        this.field_193444_e = p_i225740_4_;
        this.field_192499_e = p_i225740_5_;
        this.field_226656_g_ = p_i225740_6_;
        this.field_192500_f = p_i225740_7_;
        this.field_193445_h = p_i225740_8_;
    }

    public boolean func_192493_a(ItemStack item) {
        if (this == field_192495_a) {
            return true;
        }
        if (this.field_200018_b != null && !this.field_200018_b.func_230235_a_(item.func_77973_b())) {
            return false;
        }
        if (this.field_192496_b != null && item.func_77973_b() != this.field_192496_b) {
            return false;
        }
        if (!this.field_192498_d.func_211339_d(item.func_190916_E())) {
            return false;
        }
        if (!this.field_193444_e.func_211335_c() && !item.func_77984_f()) {
            return false;
        }
        if (!this.field_193444_e.func_211339_d(item.func_77958_k() - item.func_77952_i())) {
            return false;
        }
        if (!this.field_193445_h.func_193478_a(item)) {
            return false;
        }
        if (this.field_192499_e.length > 0) {
            Map<Enchantment, Integer> map = EnchantmentHelper.func_226652_a_(item.func_77986_q());
            for (EnchantmentPredicate enchantmentpredicate : this.field_192499_e) {
                if (enchantmentpredicate.func_192463_a(map)) continue;
                return false;
            }
        }
        if (this.field_226656_g_.length > 0) {
            Map<Enchantment, Integer> map1 = EnchantmentHelper.func_226652_a_(EnchantedBookItem.func_92110_g((ItemStack)item));
            for (EnchantmentPredicate enchantmentpredicate1 : this.field_226656_g_) {
                if (enchantmentpredicate1.func_192463_a(map1)) continue;
                return false;
            }
        }
        Potion potion = PotionUtils.func_185191_c((ItemStack)item);
        return this.field_192500_f == null || this.field_192500_f == potion;
    }

    public static ItemPredicate func_192492_a(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)element, (String)"item");
            if (jsonobject.has("type")) {
                ResourceLocation rl = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"type"));
                if (custom_predicates.containsKey(rl)) {
                    return custom_predicates.get(rl).apply(jsonobject);
                }
                throw new JsonSyntaxException("There is no ItemPredicate of type " + rl);
            }
            MinMaxBounds.IntBound minmaxbounds$intbound = MinMaxBounds.IntBound.func_211344_a((JsonElement)jsonobject.get("count"));
            MinMaxBounds.IntBound minmaxbounds$intbound1 = MinMaxBounds.IntBound.func_211344_a((JsonElement)jsonobject.get("durability"));
            if (jsonobject.has("data")) {
                throw new JsonParseException("Disallowed data tag found");
            }
            NBTPredicate nbtpredicate = NBTPredicate.func_193476_a((JsonElement)jsonobject.get("nbt"));
            Item item = null;
            if (jsonobject.has("item")) {
                ResourceLocation resourcelocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"item"));
                item = (Item)((Object)Registry.field_212630_s.func_241873_b(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown item id '" + resourcelocation + "'")));
            }
            ITag<Item> itag = null;
            if (jsonobject.has("tag")) {
                ResourceLocation resourcelocation1 = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"tag"));
                itag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(resourcelocation1);
                if (itag == null) {
                    throw new JsonSyntaxException("Unknown item tag '" + resourcelocation1 + "'");
                }
            }
            Potion potion = null;
            if (jsonobject.has("potion")) {
                ResourceLocation resourcelocation2 = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"potion"));
                potion = (Potion)((Object)Registry.field_212621_j.func_241873_b(resourcelocation2).orElseThrow(() -> new JsonSyntaxException("Unknown potion '" + resourcelocation2 + "'")));
            }
            EnchantmentPredicate[] aenchantmentpredicate1 = EnchantmentPredicate.func_192465_b((JsonElement)jsonobject.get("enchantments"));
            EnchantmentPredicate[] aenchantmentpredicate = EnchantmentPredicate.func_192465_b((JsonElement)jsonobject.get("stored_enchantments"));
            return new ItemPredicate(itag, item, minmaxbounds$intbound, minmaxbounds$intbound1, aenchantmentpredicate1, aenchantmentpredicate, potion, nbtpredicate);
        }
        return field_192495_a;
    }

    public JsonElement func_200319_a() {
        if (this == field_192495_a) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        if (this.field_192496_b != null) {
            jsonobject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.field_192496_b).toString());
        }
        if (this.field_200018_b != null) {
            jsonobject.addProperty("tag", TagCollectionManager.func_242178_a().func_241836_b().func_232975_b_(this.field_200018_b).toString());
        }
        jsonobject.add("count", this.field_192498_d.func_200321_c());
        jsonobject.add("durability", this.field_193444_e.func_200321_c());
        jsonobject.add("nbt", this.field_193445_h.func_200322_a());
        if (this.field_192499_e.length > 0) {
            JsonArray jsonarray = new JsonArray();
            for (EnchantmentPredicate enchantmentpredicate : this.field_192499_e) {
                jsonarray.add(enchantmentpredicate.func_200306_a());
            }
            jsonobject.add("enchantments", (JsonElement)jsonarray);
        }
        if (this.field_226656_g_.length > 0) {
            JsonArray jsonarray1 = new JsonArray();
            for (EnchantmentPredicate enchantmentpredicate1 : this.field_226656_g_) {
                jsonarray1.add(enchantmentpredicate1.func_200306_a());
            }
            jsonobject.add("stored_enchantments", (JsonElement)jsonarray1);
        }
        if (this.field_192500_f != null) {
            jsonobject.addProperty("potion", Registry.field_212621_j.func_177774_c((Object)this.field_192500_f).toString());
        }
        return jsonobject;
    }

    public static ItemPredicate[] func_192494_b(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonArray jsonarray = JSONUtils.func_151207_m((JsonElement)element, (String)"items");
            ItemPredicate[] aitempredicate = new ItemPredicate[jsonarray.size()];
            for (int i = 0; i < aitempredicate.length; ++i) {
                aitempredicate[i] = ItemPredicate.func_192492_a(jsonarray.get(i));
            }
            return aitempredicate;
        }
        return new ItemPredicate[0];
    }

    public static void register(ResourceLocation name, Function<JsonObject, ItemPredicate> deserializer) {
        custom_predicates.put(name, deserializer);
    }

    public static Map<ResourceLocation, Function<JsonObject, ItemPredicate>> getPredicates() {
        return unmod_predicates;
    }

    public static class Builder {
        private final List<EnchantmentPredicate> field_200312_a = Lists.newArrayList();
        private final List<EnchantmentPredicate> field_226657_b_ = Lists.newArrayList();
        @Nullable
        private Item field_200313_b;
        @Nullable
        private ITag<Item> field_200314_c;
        private MinMaxBounds.IntBound field_200315_d = MinMaxBounds.IntBound.field_211347_e;
        private MinMaxBounds.IntBound field_200316_e = MinMaxBounds.IntBound.field_211347_e;
        @Nullable
        private Potion field_200317_f;
        private NBTPredicate field_200318_g = NBTPredicate.field_193479_a;

        private Builder() {
        }

        public static Builder func_200309_a() {
            return new Builder();
        }

        public Builder func_200308_a(IItemProvider provider) {
            this.field_200313_b = provider.func_199767_j();
            return this;
        }

        public Builder func_200307_a(ITag<Item> tag) {
            this.field_200314_c = tag;
            return this;
        }

        public Builder func_218002_a(CompoundNBT p_218002_1_) {
            this.field_200318_g = new NBTPredicate(p_218002_1_);
            return this;
        }

        public Builder func_218003_a(EnchantmentPredicate p_218003_1_) {
            this.field_200312_a.add(p_218003_1_);
            return this;
        }

        public ItemPredicate func_200310_b() {
            return new ItemPredicate(this.field_200314_c, this.field_200313_b, this.field_200315_d, this.field_200316_e, this.field_200312_a.toArray(EnchantmentPredicate.field_226534_b_), this.field_226657_b_.toArray(EnchantmentPredicate.field_226534_b_), this.field_200317_f, this.field_200318_g);
        }
    }
}

