/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PandaEntity
extends AnimalEntity {
    private static final DataParameter<Integer> field_213609_bA = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_213593_bB = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_213594_bD = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Byte> field_213595_bE = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Byte> field_213596_bF = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Byte> field_213597_bG = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187191_a);
    private static final EntityPredicate field_229963_bD_ = new EntityPredicate().func_221013_a(8.0).func_221011_b().func_221008_a();
    private boolean field_213598_bH;
    private boolean field_213599_bI;
    public int field_213608_bz;
    private Vector3d field_213600_bJ;
    private float field_213601_bK;
    private float field_213602_bL;
    private float field_213603_bM;
    private float field_213604_bN;
    private float field_213605_bO;
    private float field_213606_bP;
    private WatchGoal field_229964_bN_;
    private static final Predicate<ItemEntity> field_213607_bQ = p_213575_0_ -> {
        Item item = p_213575_0_.func_92059_d().func_77973_b();
        return (item == Blocks.field_222405_kQ.func_199767_j() || item == Blocks.field_150414_aQ.func_199767_j()) && p_213575_0_.func_70089_S() && !p_213575_0_.func_174874_s();
    };

    public PandaEntity(EntityType<? extends PandaEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        if (!this.func_70631_g_()) {
            this.func_98053_h(true);
        }
    }

    public boolean func_213365_e(ItemStack itemstackIn) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(itemstackIn);
        if (!this.func_184582_a(equipmentslottype).func_190926_b()) {
            return false;
        }
        return equipmentslottype == EquipmentSlotType.MAINHAND && super.func_213365_e(itemstackIn);
    }

    public int func_213544_dV() {
        return this.field_70180_af.func_187225_a(field_213609_bA);
    }

    public void func_213588_r(int p_213588_1_) {
        this.field_70180_af.func_187227_b(field_213609_bA, p_213588_1_);
    }

    public boolean func_213539_dW() {
        return this.func_213547_u(2);
    }

    public boolean func_213556_dX() {
        return this.func_213547_u(8);
    }

    public void func_213553_r(boolean p_213553_1_) {
        this.func_213587_d(8, p_213553_1_);
    }

    public boolean func_213567_dY() {
        return this.func_213547_u(16);
    }

    public void func_213542_s(boolean p_213542_1_) {
        this.func_213587_d(16, p_213542_1_);
    }

    public boolean func_213578_dZ() {
        return this.field_70180_af.func_187225_a(field_213594_bD) > 0;
    }

    public void func_213534_t(boolean p_213534_1_) {
        this.field_70180_af.func_187227_b(field_213594_bD, p_213534_1_ ? 1 : 0);
    }

    private int func_213559_es() {
        return this.field_70180_af.func_187225_a(field_213594_bD);
    }

    private void func_213571_t(int p_213571_1_) {
        this.field_70180_af.func_187227_b(field_213594_bD, p_213571_1_);
    }

    public void func_213581_u(boolean p_213581_1_) {
        this.func_213587_d(2, p_213581_1_);
        if (!p_213581_1_) {
            this.func_213562_s(0);
        }
    }

    public int func_213585_ee() {
        return this.field_70180_af.func_187225_a(field_213593_bB);
    }

    public void func_213562_s(int p_213562_1_) {
        this.field_70180_af.func_187227_b(field_213593_bB, p_213562_1_);
    }

    public Gene func_213549_ef() {
        return Gene.func_221105_a(this.field_70180_af.func_187225_a(field_213595_bE).byteValue());
    }

    public void func_213589_a(Gene pandaType) {
        if (pandaType.func_221106_a() > 6) {
            pandaType = Gene.func_221104_a(this.field_70146_Z);
        }
        this.field_70180_af.func_187227_b(field_213595_bE, (byte)pandaType.func_221106_a());
    }

    public Gene func_213536_eg() {
        return Gene.func_221105_a(this.field_70180_af.func_187225_a(field_213596_bF).byteValue());
    }

    public void func_213541_b(Gene pandaType) {
        if (pandaType.func_221106_a() > 6) {
            pandaType = Gene.func_221104_a(this.field_70146_Z);
        }
        this.field_70180_af.func_187227_b(field_213596_bF, (byte)pandaType.func_221106_a());
    }

    public boolean func_213564_eh() {
        return this.func_213547_u(4);
    }

    public void func_213576_v(boolean p_213576_1_) {
        this.func_213587_d(4, p_213576_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213609_bA, 0);
        this.field_70180_af.func_187214_a(field_213593_bB, 0);
        this.field_70180_af.func_187214_a(field_213595_bE, (byte)0);
        this.field_70180_af.func_187214_a(field_213596_bF, (byte)0);
        this.field_70180_af.func_187214_a(field_213597_bG, (byte)0);
        this.field_70180_af.func_187214_a(field_213594_bD, 0);
    }

    private boolean func_213547_u(int flagId) {
        return (this.field_70180_af.func_187225_a(field_213597_bG) & flagId) != 0;
    }

    private void func_213587_d(int flagId, boolean p_213587_2_) {
        byte b0 = this.field_70180_af.func_187225_a(field_213597_bG);
        if (p_213587_2_) {
            this.field_70180_af.func_187227_b(field_213597_bG, (byte)(b0 | flagId));
        } else {
            this.field_70180_af.func_187227_b(field_213597_bG, (byte)(b0 & ~flagId));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("MainGene", this.func_213549_ef().func_221100_b());
        compound.func_74778_a("HiddenGene", this.func_213536_eg().func_221100_b());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_213589_a(Gene.func_221108_a(compound.func_74779_i("MainGene")));
        this.func_213541_b(Gene.func_221108_a(compound.func_74779_i("HiddenGene")));
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        PandaEntity pandaentity = EntityType.field_220353_aa.func_200721_a(p_241840_1_);
        if (p_241840_2_ instanceof PandaEntity) {
            pandaentity.func_213545_a(this, (PandaEntity)p_241840_2_);
        }
        pandaentity.func_213554_ep();
        return pandaentity;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal(this, 2.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackGoal(this, (double)1.2f, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a(Blocks.field_222405_kQ.func_199767_j()), false));
        this.field_70714_bg.func_75776_a(6, new AvoidGoal<PlayerEntity>(this, PlayerEntity.class, 8.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(6, new AvoidGoal<MonsterEntity>(this, MonsterEntity.class, 4.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new SitGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new LieBackGoal(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new ChildPlayGoal(this));
        this.field_229964_bN_ = new WatchGoal(this, PlayerEntity.class, 6.0f);
        this.field_70714_bg.func_75776_a(9, (Goal)this.field_229964_bN_);
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(12, (Goal)new RollGoal(this));
        this.field_70714_bg.func_75776_a(13, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(14, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new RevengeGoal(this, new Class[0]).func_220794_a(new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute func_234204_eW_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.15f).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    public Gene func_213590_ei() {
        return Gene.func_221101_b(this.func_213549_ef(), this.func_213536_eg());
    }

    public boolean func_213584_ej() {
        return this.func_213590_ei() == Gene.LAZY;
    }

    public boolean func_213569_ek() {
        return this.func_213590_ei() == Gene.WORRIED;
    }

    public boolean func_213557_el() {
        return this.func_213590_ei() == Gene.PLAYFUL;
    }

    public boolean func_213582_en() {
        return this.func_213590_ei() == Gene.WEAK;
    }

    public boolean func_213398_dR() {
        return this.func_213590_ei() == Gene.AGGRESSIVE;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.func_184185_a(SoundEvents.field_219680_ht, 1.0f, 1.0f);
        if (!this.func_213398_dR()) {
            this.field_213599_bI = true;
        }
        return super.func_70652_k(entityIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_213569_ek()) {
            if (this.field_70170_p.func_72911_I() && !this.func_70090_H()) {
                this.func_213553_r(true);
                this.func_213534_t(false);
            } else if (!this.func_213578_dZ()) {
                this.func_213553_r(false);
            }
        }
        if (this.func_70638_az() == null) {
            this.field_213598_bH = false;
            this.field_213599_bI = false;
        }
        if (this.func_213544_dV() > 0) {
            if (this.func_70638_az() != null) {
                this.func_70625_a(this.func_70638_az(), 90.0f, 90.0f);
            }
            if (this.func_213544_dV() == 29 || this.func_213544_dV() == 14) {
                this.func_184185_a(SoundEvents.field_219676_hp, 1.0f, 1.0f);
            }
            this.func_213588_r(this.func_213544_dV() - 1);
        }
        if (this.func_213539_dW()) {
            this.func_213562_s(this.func_213585_ee() + 1);
            if (this.func_213585_ee() > 20) {
                this.func_213581_u(false);
                this.func_213577_ez();
            } else if (this.func_213585_ee() == 1) {
                this.func_184185_a(SoundEvents.field_219669_hj, 1.0f, 1.0f);
            }
        }
        if (this.func_213564_eh()) {
            this.func_213535_ey();
        } else {
            this.field_213608_bz = 0;
        }
        if (this.func_213556_dX()) {
            this.field_70125_A = 0.0f;
        }
        this.func_213574_ev();
        this.func_213546_et();
        this.func_213563_ew();
        this.func_213550_ex();
    }

    public boolean func_213566_eo() {
        return this.func_213569_ek() && this.field_70170_p.func_72911_I();
    }

    private void func_213546_et() {
        if (!this.func_213578_dZ() && this.func_213556_dX() && !this.func_213566_eo() && !this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && this.field_70146_Z.nextInt(80) == 1) {
            this.func_213534_t(true);
        } else if (this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() || !this.func_213556_dX()) {
            this.func_213534_t(false);
        }
        if (this.func_213578_dZ()) {
            this.func_213533_eu();
            if (!this.field_70170_p.field_72995_K && this.func_213559_es() > 80 && this.field_70146_Z.nextInt(20) == 1) {
                if (this.func_213559_es() > 100 && this.func_213548_j(this.func_184582_a(EquipmentSlotType.MAINHAND))) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                    }
                    this.func_213553_r(false);
                }
                this.func_213534_t(false);
                return;
            }
            this.func_213571_t(this.func_213559_es() + 1);
        }
    }

    private void func_213533_eu() {
        if (this.func_213559_es() % 5 == 0) {
            this.func_184185_a(SoundEvents.field_219674_hn, 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            for (int i = 0; i < 6; ++i) {
                Vector3d vector3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1);
                vector3d = vector3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                vector3d = vector3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                double d0 = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
                Vector3d vector3d1 = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.8, d0, 1.0 + ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.4);
                vector3d1 = vector3d1.func_178785_b(-this.field_70761_aq * ((float)Math.PI / 180));
                vector3d1 = vector3d1.func_72441_c(this.func_226277_ct_(), this.func_226280_cw_() + 1.0, this.func_226281_cx_());
                this.field_70170_p.func_195594_a(new ItemParticleData(ParticleTypes.field_197591_B, this.func_184582_a(EquipmentSlotType.MAINHAND)), vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
            }
        }
    }

    private void func_213574_ev() {
        this.field_213602_bL = this.field_213601_bK;
        this.field_213601_bK = this.func_213556_dX() ? Math.min(1.0f, this.field_213601_bK + 0.15f) : Math.max(0.0f, this.field_213601_bK - 0.19f);
    }

    private void func_213563_ew() {
        this.field_213604_bN = this.field_213603_bM;
        this.field_213603_bM = this.func_213567_dY() ? Math.min(1.0f, this.field_213603_bM + 0.15f) : Math.max(0.0f, this.field_213603_bM - 0.19f);
    }

    private void func_213550_ex() {
        this.field_213606_bP = this.field_213605_bO;
        this.field_213605_bO = this.func_213564_eh() ? Math.min(1.0f, this.field_213605_bO + 0.15f) : Math.max(0.0f, this.field_213605_bO - 0.19f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213561_v(float p_213561_1_) {
        return MathHelper.func_219799_g((float)p_213561_1_, (float)this.field_213602_bL, (float)this.field_213601_bK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213583_w(float p_213583_1_) {
        return MathHelper.func_219799_g((float)p_213583_1_, (float)this.field_213604_bN, (float)this.field_213603_bM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213591_x(float p_213591_1_) {
        return MathHelper.func_219799_g((float)p_213591_1_, (float)this.field_213606_bP, (float)this.field_213605_bO);
    }

    private void func_213535_ey() {
        ++this.field_213608_bz;
        if (this.field_213608_bz > 32) {
            this.func_213576_v(false);
        } else if (!this.field_70170_p.field_72995_K) {
            Vector3d vector3d = this.func_213322_ci();
            if (this.field_213608_bz == 1) {
                float f = this.field_70177_z * ((float)Math.PI / 180);
                float f1 = this.func_70631_g_() ? 0.1f : 0.2f;
                this.field_213600_bJ = new Vector3d(vector3d.field_72450_a + (double)(-MathHelper.func_76126_a((float)f) * f1), 0.0, vector3d.field_72449_c + (double)(MathHelper.func_76134_b((float)f) * f1));
                this.func_213317_d(this.field_213600_bJ.func_72441_c(0.0, 0.27, 0.0));
            } else if ((float)this.field_213608_bz != 7.0f && (float)this.field_213608_bz != 15.0f && (float)this.field_213608_bz != 23.0f) {
                this.func_213293_j(this.field_213600_bJ.field_72450_a, vector3d.field_72448_b, this.field_213600_bJ.field_72449_c);
            } else {
                this.func_213293_j(0.0, this.field_70122_E ? 0.27 : vector3d.field_72448_b, 0.0);
            }
        }
    }

    private void func_213577_ez() {
        Vector3d vector3d = this.func_213322_ci();
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218421_R, this.func_226277_ct_() - (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180))), this.func_226280_cw_() - (double)0.1f, this.func_226281_cx_() + (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))), vector3d.field_72450_a, 0.0, vector3d.field_72449_c);
        this.func_184185_a(SoundEvents.field_219670_hk, 1.0f, 1.0f);
        for (PandaEntity pandaentity : this.field_70170_p.func_217357_a(PandaEntity.class, this.func_174813_aQ().func_186662_g(10.0))) {
            if (pandaentity.func_70631_g_() || !pandaentity.field_70122_E || pandaentity.func_70090_H() || !pandaentity.func_213537_eq()) continue;
            pandaentity.func_70664_aZ();
        }
        if (!this.field_70170_p.func_201670_d() && this.field_70146_Z.nextInt(700) == 0 && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.func_199703_a(Items.field_151123_aH);
        }
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        if (this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && field_213607_bQ.test(itemEntity)) {
            this.func_233630_a_(itemEntity);
            ItemStack itemstack = itemEntity.func_92059_d();
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack);
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a(itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        this.func_213553_r(false);
        return super.func_70097_a(source, amount);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_213589_a(Gene.func_221104_a(this.field_70146_Z));
        this.func_213541_b(Gene.func_221104_a(this.field_70146_Z));
        this.func_213554_ep();
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableEntity.AgeableData(0.2f);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_213545_a(PandaEntity father, @Nullable PandaEntity mother) {
        if (mother == null) {
            if (this.field_70146_Z.nextBoolean()) {
                this.func_213589_a(father.func_213568_eA());
                this.func_213541_b(Gene.func_221104_a(this.field_70146_Z));
            } else {
                this.func_213589_a(Gene.func_221104_a(this.field_70146_Z));
                this.func_213541_b(father.func_213568_eA());
            }
        } else if (this.field_70146_Z.nextBoolean()) {
            this.func_213589_a(father.func_213568_eA());
            this.func_213541_b(mother.func_213568_eA());
        } else {
            this.func_213589_a(mother.func_213568_eA());
            this.func_213541_b(father.func_213568_eA());
        }
        if (this.field_70146_Z.nextInt(32) == 0) {
            this.func_213589_a(Gene.func_221104_a(this.field_70146_Z));
        }
        if (this.field_70146_Z.nextInt(32) == 0) {
            this.func_213541_b(Gene.func_221104_a(this.field_70146_Z));
        }
    }

    private Gene func_213568_eA() {
        return this.field_70146_Z.nextBoolean() ? this.func_213549_ef() : this.func_213536_eg();
    }

    public void func_213554_ep() {
        if (this.func_213582_en()) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(10.0);
        }
        if (this.func_213584_ej()) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.07f);
        }
    }

    private void func_213586_eB() {
        if (!this.func_70090_H()) {
            this.func_191989_p(0.0f);
            this.func_70661_as().func_75499_g();
            this.func_213553_r(true);
        }
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (this.func_213566_eo()) {
            return ActionResultType.PASS;
        }
        if (this.func_213567_dY()) {
            this.func_213542_s(false);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (this.func_70877_b(itemstack)) {
            if (this.func_70638_az() != null) {
                this.field_213598_bH = true;
            }
            if (this.func_70631_g_()) {
                this.func_175505_a(p_230254_1_, itemstack);
                this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.1f), true);
            } else if (!this.field_70170_p.field_72995_K && this.func_70874_b() == 0 && this.func_204701_dC()) {
                this.func_175505_a(p_230254_1_, itemstack);
                this.func_146082_f(p_230254_1_);
            } else {
                if (this.field_70170_p.field_72995_K || this.func_213556_dX() || this.func_70090_H()) {
                    return ActionResultType.PASS;
                }
                this.func_213586_eB();
                this.func_213534_t(true);
                ItemStack itemstack1 = this.func_184582_a(EquipmentSlotType.MAINHAND);
                if (!itemstack1.func_190926_b() && !p_230254_1_.field_71075_bZ.field_75098_d) {
                    this.func_199701_a_(itemstack1);
                }
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(itemstack.func_77973_b(), 1));
                this.func_175505_a(p_230254_1_, itemstack);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_213398_dR()) {
            return SoundEvents.field_219677_hq;
        }
        return this.func_213569_ek() ? SoundEvents.field_219678_hr : SoundEvents.field_219672_hl;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_219675_ho, 0.15f, 1.0f);
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Blocks.field_222405_kQ.func_199767_j();
    }

    private boolean func_213548_j(ItemStack stack) {
        return this.func_70877_b(stack) || stack.func_77973_b() == Blocks.field_150414_aQ.func_199767_j();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219673_hm;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_219679_hs;
    }

    public boolean func_213537_eq() {
        return !this.func_213567_dY() && !this.func_213566_eo() && !this.func_213578_dZ() && !this.func_213564_eh() && !this.func_213556_dX();
    }

    static class WatchGoal
    extends LookAtGoal {
        private final PandaEntity field_220718_f;

        public WatchGoal(PandaEntity p_i51458_1_, Class<? extends LivingEntity> p_i51458_2_, float p_i51458_3_) {
            super((MobEntity)((Object)p_i51458_1_), p_i51458_2_, p_i51458_3_);
            this.field_220718_f = p_i51458_1_;
        }

        public void func_229975_a_(LivingEntity p_229975_1_) {
            this.field_75334_a = p_229975_1_;
        }

        public boolean func_75253_b() {
            return this.field_75334_a != null && super.func_75253_b();
        }

        public boolean func_75250_a() {
            if (this.field_75332_b.func_70681_au().nextFloat() >= this.field_75331_e) {
                return false;
            }
            if (this.field_75334_a == null) {
                this.field_75334_a = this.field_75329_f == PlayerEntity.class ? this.field_75332_b.field_70170_p.func_217372_a(this.field_220716_e, this.field_75332_b, this.field_75332_b.func_226277_ct_(), this.field_75332_b.func_226280_cw_(), this.field_75332_b.func_226281_cx_()) : this.field_75332_b.field_70170_p.func_225318_b(this.field_75329_f, this.field_220716_e, this.field_75332_b, this.field_75332_b.func_226277_ct_(), this.field_75332_b.func_226280_cw_(), this.field_75332_b.func_226281_cx_(), this.field_75332_b.func_174813_aQ().func_72314_b((double)this.field_75333_c, 3.0, (double)this.field_75333_c));
            }
            return this.field_220718_f.func_213537_eq() && this.field_75334_a != null;
        }

        public void func_75246_d() {
            if (this.field_75334_a != null) {
                super.func_75246_d();
            }
        }
    }

    class SitGoal
    extends Goal {
        private int field_220832_b;

        public SitGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.field_220832_b <= PandaEntity.this.field_70173_aa && !PandaEntity.this.func_70631_g_() && !PandaEntity.this.func_70090_H() && PandaEntity.this.func_213537_eq() && PandaEntity.this.func_213544_dV() <= 0) {
                List<ItemEntity> list = PandaEntity.this.field_70170_p.func_175647_a(ItemEntity.class, PandaEntity.this.func_174813_aQ().func_72314_b(6.0, 6.0, 6.0), field_213607_bQ);
                return !list.isEmpty() || !PandaEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
            }
            return false;
        }

        public boolean func_75253_b() {
            if (!PandaEntity.this.func_70090_H() && (PandaEntity.this.func_213584_ej() || PandaEntity.this.field_70146_Z.nextInt(600) != 1)) {
                return PandaEntity.this.field_70146_Z.nextInt(2000) != 1;
            }
            return false;
        }

        public void func_75246_d() {
            if (!PandaEntity.this.func_213556_dX() && !PandaEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                PandaEntity.this.func_213586_eB();
            }
        }

        public void func_75249_e() {
            List<ItemEntity> list = PandaEntity.this.field_70170_p.func_175647_a(ItemEntity.class, PandaEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_213607_bQ);
            if (!list.isEmpty() && PandaEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                PandaEntity.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            } else if (!PandaEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                PandaEntity.this.func_213586_eB();
            }
            this.field_220832_b = 0;
        }

        public void func_75251_c() {
            ItemStack itemstack = PandaEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                PandaEntity.this.func_199701_a_(itemstack);
                PandaEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                int i = PandaEntity.this.func_213584_ej() ? PandaEntity.this.field_70146_Z.nextInt(50) + 10 : PandaEntity.this.field_70146_Z.nextInt(150) + 10;
                this.field_220832_b = PandaEntity.this.field_70173_aa + i * 20;
            }
            PandaEntity.this.func_213553_r(false);
        }
    }

    static class RollGoal
    extends Goal {
        private final PandaEntity field_220830_a;

        public RollGoal(PandaEntity pandaIn) {
            this.field_220830_a = pandaIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            if ((this.field_220830_a.func_70631_g_() || this.field_220830_a.func_213557_el()) && this.field_220830_a.field_70122_E) {
                if (!this.field_220830_a.func_213537_eq()) {
                    return false;
                }
                float f = this.field_220830_a.field_70177_z * ((float)Math.PI / 180);
                int i = 0;
                int j = 0;
                float f1 = -MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                if ((double)Math.abs(f1) > 0.5) {
                    i = (int)((float)i + f1 / Math.abs(f1));
                }
                if ((double)Math.abs(f2) > 0.5) {
                    j = (int)((float)j + f2 / Math.abs(f2));
                }
                if (this.field_220830_a.field_70170_p.func_180495_p(this.field_220830_a.func_233580_cy_().func_177982_a(i, -1, j)).func_196958_f()) {
                    return true;
                }
                if (this.field_220830_a.func_213557_el() && this.field_220830_a.field_70146_Z.nextInt(60) == 1) {
                    return true;
                }
                return this.field_220830_a.field_70146_Z.nextInt(500) == 1;
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.field_220830_a.func_213576_v(true);
        }

        public boolean func_220685_C_() {
            return false;
        }
    }

    static class RevengeGoal
    extends HurtByTargetGoal {
        private final PandaEntity field_220798_a;

        public RevengeGoal(PandaEntity pandaIn, Class<?> ... p_i51462_2_) {
            super((CreatureEntity)pandaIn, (Class[])p_i51462_2_);
            this.field_220798_a = pandaIn;
        }

        public boolean func_75253_b() {
            if (!this.field_220798_a.field_213598_bH && !this.field_220798_a.field_213599_bI) {
                return super.func_75253_b();
            }
            this.field_220798_a.func_70624_b(null);
            return false;
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof PandaEntity && ((PandaEntity)((Object)mobIn)).func_213398_dR()) {
                mobIn.func_70624_b(targetIn);
            }
        }
    }

    static class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        private final PandaEntity field_220740_f;

        public PanicGoal(PandaEntity pandaIn, double speedIn) {
            super((CreatureEntity)pandaIn, speedIn);
            this.field_220740_f = pandaIn;
        }

        public boolean func_75250_a() {
            if (!this.field_220740_f.func_70027_ad()) {
                return false;
            }
            BlockPos blockpos = this.func_188497_a((IBlockReader)((Object)this.field_75267_a.field_70170_p), (Entity)this.field_75267_a, 5, 4);
            if (blockpos != null) {
                this.field_75266_c = blockpos.func_177958_n();
                this.field_75263_d = blockpos.func_177956_o();
                this.field_75264_e = blockpos.func_177952_p();
                return true;
            }
            return this.func_190863_f();
        }

        public boolean func_75253_b() {
            if (this.field_220740_f.func_213556_dX()) {
                this.field_220740_f.func_70661_as().func_75499_g();
                return false;
            }
            return super.func_75253_b();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final PandaEntity field_220672_i;

        public MoveHelperController(PandaEntity pandaIn) {
            super((MobEntity)((Object)pandaIn));
            this.field_220672_i = pandaIn;
        }

        public void func_75641_c() {
            if (this.field_220672_i.func_213537_eq()) {
                super.func_75641_c();
            }
        }
    }

    class MateGoal
    extends BreedGoal {
        private final PandaEntity field_220693_e;
        private int field_220694_f;

        public MateGoal(PandaEntity pandaIn, double speedIn) {
            super((AnimalEntity)pandaIn, speedIn);
            this.field_220693_e = pandaIn;
        }

        public boolean func_75250_a() {
            if (super.func_75250_a() && this.field_220693_e.func_213544_dV() == 0) {
                if (!this.func_220691_h()) {
                    if (this.field_220694_f <= this.field_220693_e.field_70173_aa) {
                        this.field_220693_e.func_213588_r(32);
                        this.field_220694_f = this.field_220693_e.field_70173_aa + 600;
                        if (this.field_220693_e.func_70613_aW()) {
                            PlayerEntity playerentity = this.field_75394_a.func_217370_a(field_229963_bD_, (LivingEntity)((Object)this.field_220693_e));
                            this.field_220693_e.field_229964_bN_.func_229975_a_(playerentity);
                        }
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean func_220691_h() {
            BlockPos blockpos = this.field_220693_e.func_233580_cy_();
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 8; ++j) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            blockpos$mutable.func_239621_a_((Vector3i)blockpos, k, i, l);
                            if (this.field_75394_a.func_180495_p((BlockPos)blockpos$mutable).func_203425_a(Blocks.field_222405_kQ)) {
                                return true;
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                }
            }
            return false;
        }
    }

    static class LieBackGoal
    extends Goal {
        private final PandaEntity field_220828_a;
        private int field_220829_b;

        public LieBackGoal(PandaEntity pandaIn) {
            this.field_220828_a = pandaIn;
        }

        public boolean func_75250_a() {
            return this.field_220829_b < this.field_220828_a.field_70173_aa && this.field_220828_a.func_213584_ej() && this.field_220828_a.func_213537_eq() && this.field_220828_a.field_70146_Z.nextInt(400) == 1;
        }

        public boolean func_75253_b() {
            if (!this.field_220828_a.func_70090_H() && (this.field_220828_a.func_213584_ej() || this.field_220828_a.field_70146_Z.nextInt(600) != 1)) {
                return this.field_220828_a.field_70146_Z.nextInt(2000) != 1;
            }
            return false;
        }

        public void func_75249_e() {
            this.field_220828_a.func_213542_s(true);
            this.field_220829_b = 0;
        }

        public void func_75251_c() {
            this.field_220828_a.func_213542_s(false);
            this.field_220829_b = this.field_220828_a.field_70173_aa + 200;
        }
    }

    public static enum Gene {
        NORMAL(0, "normal", false),
        LAZY(1, "lazy", false),
        WORRIED(2, "worried", false),
        PLAYFUL(3, "playful", false),
        BROWN(4, "brown", true),
        WEAK(5, "weak", true),
        AGGRESSIVE(6, "aggressive", false);

        private static final Gene[] field_221109_h;
        private final int field_221110_i;
        private final String field_221111_j;
        private final boolean field_221112_k;

        private Gene(int p_i51468_3_, String p_i51468_4_, boolean p_i51468_5_) {
            this.field_221110_i = p_i51468_3_;
            this.field_221111_j = p_i51468_4_;
            this.field_221112_k = p_i51468_5_;
        }

        public int func_221106_a() {
            return this.field_221110_i;
        }

        public String func_221100_b() {
            return this.field_221111_j;
        }

        public boolean func_221107_c() {
            return this.field_221112_k;
        }

        private static Gene func_221101_b(Gene mainGene, Gene hiddenGene) {
            if (mainGene.func_221107_c()) {
                return mainGene == hiddenGene ? mainGene : NORMAL;
            }
            return mainGene;
        }

        public static Gene func_221105_a(int indexIn) {
            if (indexIn < 0 || indexIn >= field_221109_h.length) {
                indexIn = 0;
            }
            return field_221109_h[indexIn];
        }

        public static Gene func_221108_a(String p_221108_0_) {
            for (Gene pandaentity$gene : Gene.values()) {
                if (!pandaentity$gene.field_221111_j.equals(p_221108_0_)) continue;
                return pandaentity$gene;
            }
            return NORMAL;
        }

        public static Gene func_221104_a(Random randIn) {
            int i = randIn.nextInt(16);
            if (i == 0) {
                return LAZY;
            }
            if (i == 1) {
                return WORRIED;
            }
            if (i == 2) {
                return PLAYFUL;
            }
            if (i == 4) {
                return AGGRESSIVE;
            }
            if (i < 9) {
                return WEAK;
            }
            return i < 11 ? BROWN : NORMAL;
        }

        static {
            field_221109_h = (Gene[])Arrays.stream(Gene.values()).sorted(Comparator.comparingInt(Gene::func_221106_a)).toArray(Gene[]::new);
        }
    }

    static class ChildPlayGoal
    extends Goal {
        private final PandaEntity field_220833_a;

        public ChildPlayGoal(PandaEntity pandaIn) {
            this.field_220833_a = pandaIn;
        }

        public boolean func_75250_a() {
            if (this.field_220833_a.func_70631_g_() && this.field_220833_a.func_213537_eq()) {
                if (this.field_220833_a.func_213582_en() && this.field_220833_a.field_70146_Z.nextInt(500) == 1) {
                    return true;
                }
                return this.field_220833_a.field_70146_Z.nextInt(6000) == 1;
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.field_220833_a.func_213581_u(true);
        }
    }

    static class AvoidGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final PandaEntity field_220875_i;

        public AvoidGoal(PandaEntity pandaIn, Class<T> entityClassToAvoidIn, float distance, double nearSpeedIn, double farSpeedIn) {
            super((CreatureEntity)pandaIn, entityClassToAvoidIn, distance, nearSpeedIn, farSpeedIn, EntityPredicates.field_180132_d::test);
            this.field_220875_i = pandaIn;
        }

        public boolean func_75250_a() {
            return this.field_220875_i.func_213569_ek() && this.field_220875_i.func_213537_eq() && super.func_75250_a();
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        private final PandaEntity field_220722_d;

        public AttackGoal(PandaEntity pandaIn, double speedIn, boolean useLongMemory) {
            super((CreatureEntity)pandaIn, speedIn, useLongMemory);
            this.field_220722_d = pandaIn;
        }

        @Override
        public boolean func_75250_a() {
            return this.field_220722_d.func_213537_eq() && super.func_75250_a();
        }
    }
}

